<?php

namespace App\Http\Controllers;

use App\Models\Packages;
use App\Models\Page;
use Illuminate\Http\Request;

class HomeController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Contracts\Support\Renderable
     */
    public function index()
    {
//        $products    = Product::where('status',1)->get();
        $pageContent = Page::where('title','Home')->first();
        $pkg_ids = unserialize($pageContent->package_ids);
        $packages = Packages::whereIn('id', $pkg_ids)->get();

        return view('templates.home',compact('pageContent','packages'));
    }
}
