<?php

namespace App\Http\Controllers;

use App\Models\ClientsInformation;
use App\Models\LeadsToClient;
use App\Models\User;
use App\Models\UserToComment;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Gate;

class LeadController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }

    public function index(){
        return view('leads.index');
    }

    public function showAllLeads(Request $request)
    {
        $columns_list = [
            'id',
            'name',
            'email',
//            'phone',
            'sale_type',
            'status_id',
            'change_status',
            'options',
        ];

        $baseQuery = User::select('users.*')
            ->join('leads_to_clients', 'users.id', '=', 'leads_to_clients.user_id')
            ->where('leads_to_clients.client_type', 'Lead');

        $totalDataRecord = $baseQuery->count();
        $totalFilteredRecord = $totalDataRecord;

        $limit_val = $request->input('length', 10);
        $start_val = $request->input('start', 0);
//        $orderColumn = $columns_list[$request->input('order.0.column')] ?? 'id';
//        $dir_val = $request->input('order.0.dir', 'desc');

        $query = $baseQuery->orderBy('id','DESC');

        if ($searchText = $request->input('search.value')) {
            if ($searchText == 'Active' || $searchText == 'In-Active') {
                $searchText = ($searchText == 'Active') ? '1' : '0';
            }

            $query->where(function($q) use ($searchText) {
                $q->where('users.id', 'LIKE', "%{$searchText}%")
                    ->orWhere('users.name', 'LIKE', "%{$searchText}%")
                    ->orWhere('users.email', 'LIKE', "%{$searchText}%")
                    ->orWhere('users.join_date', 'LIKE', "%{$searchText}%")
                    ->orWhere('users.status_id', 'LIKE', "%{$searchText}%");
            });
//            ->orWhere('users.phone', 'LIKE', "%{$searchText}%")

            $totalFilteredRecord = $query->count();
        }

        $post_data = $query->offset($start_val)
            ->limit($limit_val)
            ->orderBy('id','DESC')
            ->get();
//        dd($post_data);
        $data_val = [];
        if ($post_data->isNotEmpty()) {
            foreach ($post_data as $index => $post_val) {
                if ($post_val->findLead->client_status == 'Connected') {
                    $color_class = 'badge-primary';
                }elseif ($post_val->findLead->client_status == 'New'){
                    $color_class = 'badge-primary';
                }elseif ($post_val->findLead->client_status == 'Not Connected'){
                    $color_class = 'badge-warning';
                }elseif ($post_val->findLead->client_status == 'Paid'){
                    $color_class = 'badge-success';
                }elseif ($post_val->findLead->client_status == 'Invalid'){
                    $color_class = 'badge-danger';
                }elseif ($post_val->findLead->client_status == 'Not Interested'){
                    $color_class = 'badge-info';
                }else{
                    $color_class = 'badge-danger';
                }
                $id = base64_encode($post_val->id);
                $status = "<span class='badge {$color_class}'>{$post_val->findLead->client_status}</span>";

                $status_button = '<select name="client_status" class="form-control change-status" id="client_status" required>
                                            <option value=" " selected disabled>Select Status</option>
                                            <optgroup label="Lead">
                                                <option value="New" data-id="'.($post_val->id).'"  '.($post_val->findLead->client_status == 'New' ? 'selected' : '').'>New</option>
                                                <option value="Connected" data-id="'.($post_val->id).'"  '.($post_val->findLead->client_status == 'Connected' ? 'selected' : '').'>Connected</option>
                                                <option value="Not Connected" data-id="'.($post_val->id).'"  '.($post_val->findLead->client_status == 'Not Connected' ? 'selected' : '').'>Not Connected</option>
                                                <option value="Not Interested" data-id="'.($post_val->id).'"  '.($post_val->findLead->client_status == 'Not Interested' ? 'selected' : '').'>Not Interested</option>
                                                <option value="Invalid" data-id="'.($post_val->id).'"  '.($post_val->findLead->client_status == 'Invalid' ? 'selected' : '').'>Invalid</option>
                                                <option value="DNC" data-id="'.($post_val->id).'"  '.($post_val->findLead->client_status == 'DNC' ? 'selected' : '').'>Do not call</option>
                                            </optgroup>
                                            <optgroup label="Client">
                                                <option value="Sale" data-id="'.($post_val->id).'"  '.($post_val->findLead->client_status == 'Sale' ? 'selected' : '').'>Sale</option>
                                            </optgroup>
                                       </select>';
//                                                                  <option value="Paid" data-id="'.($post_val->id).'"  '.($post_val->findLead->client_status == 'Paid' ? 'selected' : '').'>Paid</option>
//                                                                  <option value="Upsell" data-id="'.($post_val->id).'"  '.($post_val->findLead->client_status == 'Upsell' ? 'selected' : '').'>Upsell</option>
//                                                                  <option value="Recurring" data-id="'.($post_val->id).'"  '.($post_val->findLead->client_status == 'Recurring' ? 'selected' : '').'>Recurring</option>
//                                                                  <option value="Returning" data-id="'.($post_val->id).'"  '.($post_val->findLead->client_status == 'Returning' ? 'selected' : '').'>Returning</option>
//                                                                  <option value="Referral" data-id="'.($post_val->id).'"  '.($post_val->findLead->client_status == 'Referral' ? 'selected' : '').'>Referral</option>
//                                                                  <option value="Angry" data-id="'.($post_val->id).'"  '.($post_val->findLead->client_status == 'Angry' ? 'selected' : '').'>Angry</option>

                $data_val[] = [
                    'id'            => $index + 1 + $start_val,
                    'name'          => $post_val->name,
                    'email'         => $post_val->email,
//                    'phone'         => $post_val->phone ?? 'N/A',
                    'sale_type'     => ($post_val->findLead->sale_type) ?? 'N/A',
                    'status_id'     => $status,
                    'change_status' => $status_button,
                    'options'       => "<div class='btn-group'>
                                      " . (Gate::allows("view.clients") ? "<a class='btn btn-primary btn-style' href='" . route('view.clients', ['id' => $id]) . "'><i class='fa fa-eye'></i></a>" : "") . "
                                    </div>",
//                          agr delete ka bola tou upper div mein paste krna ha
//                    " . (Gate::allows("delete.client") ? "<button class='btn btn-danger delete-btn' data-id='{$id}' title='Delete'><i class='fa fa-trash'></i></button>" : "") . "
//                                      " . (Gate::allows("view-info.leads") ? "<a class='btn btn-success btn-style' href='" . route('view-info.leads', ['id' => $id]) . "' title='View'><i class='fa fa-eye'></i> View Details</a>" : "") . "
                ];
            }
        }

        return response()->json([
            "draw" => intval($request->input('draw')),
            "recordsTotal" => intval($totalDataRecord),
            "recordsFiltered" => intval($totalFilteredRecord),
            "data" => $data_val
        ]);
    }

    public function leadInformation($id){
        $client = User::where('id',base64_decode($id))->first();

        if (!$client){
            return redirect()->back()->with('error', 'Client not found');
        }
        $client_info = ClientsInformation::where('user_id', $client->id)->first();
        if (!$client_info){
            return redirect()->back()->with('error', 'Lead information not exist');
        }
        if ($client_info->product_type == 'LOGO') {
            $logo_refrence_material = unserialize($client_info->logo_refrence_material);
        }else{
            $logo_refrence_material = '';
        }

        return view('leads.lead_information', compact('client', 'client_info','logo_refrence_material'));
    }

    public function updateStatus(Request $request) {
        $client_status =  LeadsToClient::where(['user_id'=>$request->get_id])->update([
            'client_type'           =>    $request->get_client_type,
            'client_status'         =>    $request->get_status,
        ]);

        if ($client_status){
//            dd('test');
            $mesg_html = "User status changed to " . $request->get_status ." by " . auth()->user()->name . ".";

            $comments = UserToComment::create([
                'user_id'   => $request->get_id,
                'comments'  => $mesg_html,
            ]);
//            dd($comments);

            echo json_encode('success');
        }else{
            echo json_encode('failed');
        }
    }
}
