<?php

namespace App\Http\Controllers;

use App\Models\LeaveType;
use Carbon\Carbon;
use Illuminate\Http\Request;

class LeaveTypeController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }

    public function index(){
        $leave_types = LeaveType::all();
        return view('leavetypes.index',compact('leave_types'));
    }

    public function create(){
        return view('leavetypes.create');
    }

    public function store(Request $request){
        $request->validate([
            'title'         => 'required',
            'no_of_leaves'  => 'required',
            'status'        => 'required',
        ]);

        LeaveType::create($request->all());
        return redirect()->route('leave')->with('mesg','Leave type created successfully.');

    }

    public function edit($id){
        $id = base64_decode($id);
        $leave = LeaveType::find($id);
        if ($leave){
            return view('leavetypes.edit',compact('leave'));
        }else{
            return redirect()->back()->with('error','Leave Type not found.');
        }

    }

    public function update(Request $request){
        $request->validate([
            'title'         => 'required',
            'no_of_leaves'  => 'required',
            'status'        => 'required',
        ]);

        $request->merge([
            'id' => base64_decode($request->id),
            'updated_at' => Carbon::now(),
        ]);

        $leave = LeaveType::find($request->id);
        if ($leave){
            $leave->update($request->all());
            return redirect()->route('leave')->with('mesg','Leave type updated successfully.');
        }
    }

    public function delete($id){
        $id = base64_decode($id);
        $leave = LeaveType::find($id);
        if ($leave){
            $leave->delete();
            return response('Leave Type deleted successfully.');
        }else{
            return response('Leave Type not found..');
        }
    }
}
