<?php

namespace App\Http\Controllers;

use App\Models\Packages;
use Illuminate\Http\Request;

class PackageController extends Controller
{
    public function index()
    {
        $packages = Packages::orderBy('id', 'desc')->get();

        return view('packages.index',compact('packages'));
    }

    public function createPackage()
    {

        return view('packages.create');
    }

    public function postCreate(Request $request)
    {

        Packages::create($request->all());
        return redirect()->route('package')->with('mesg', 'Packages Created Successfully!');
    }

    public function editPackage($id){
        $package = Packages::find($id);

        return view('packages.edit',compact('package'));
    }

    public function updatePackage(Request $request){


        Packages::find($request->id)->update($request->all());

        return redirect()->route('package')->with('mesg', 'Packages Updated Successfully!');
    }

    public function deletePackage(Request $request)
    {
        $ids = $request->input('ids');

        if (empty($ids)) {
            return response()->json(['success' => false, 'message' => 'No packages selected']);
        }

        Packages::whereIn('id', $ids)->delete();

        return response()->json(['success' => true]);
    }

}
