<?php

namespace App\Http\Controllers;
use App\Http\Controllers\Controller;
use App\Models\Packages;
use App\Models\Page;
use Facade\Ignition\Support\Packagist\Package;
use Illuminate\Http\Request;
use App\Models\GetTemplates;
use Illuminate\Support\Facades\Auth;

use Cviebrock\EloquentSluggable\Services\SlugService;
use Illuminate\Support\Str;


class PageController extends Controller {

    public function index()
    {
        if(auth()->user()->role_id == 1)
        {
            $pages = Page::all();
        }
        else{
            $pages = Page::where('user_id',auth()->user()->id)->get();
        }

        return view('page.index',compact('pages'));
    }

    public function createPage()
    {
        $template = new GetTemplates();
        $templates = $template->getTemplates();
        $image_fields = ['image', 'banner_image'];
        $packages  = Packages::all();


        return view('page.create', compact('image_fields', 'templates','packages'));
    }

    public function postCreate(Request $request)
    {
        if(isset($request->package_ids) && count($request->package_ids) > 0){
            $package_ids = serialize(array_filter($request->package_ids));
            $request->request->add(['package_ids' => $package_ids]);
        }

        $request->request->add(['user_id' => Auth::id()]);
        $myslug =  Str::slug($request->title);
        $request->request->add(['slug' => $myslug]);
//        $request->request->add(['slug' => SlugService::createSlug(Page::class, 'slug', $request->title)]);


        Page::create($request->all());

        return redirect()->route('page')->with('mesg', 'Page Created Successfully!');
    }

    public function deletePage(Request $request)
    {
        $ids = $request->input('ids');

        if (empty($ids)) {
            return response()->json(['success' => false, 'message' => 'No pages selected']);
        }

        Page::whereIn('id', $ids)->delete();

        return response()->json(['success' => true]);
    }

    public function editPage($id){
        $page = Page::find($id);
        $template = new GetTemplates();
        $templates = $template->getTemplates();
        $packages  = Packages::all();

        $pkg    =   unserialize($page->package_ids);

        return view('page.edit',compact('page','pkg', 'templates','packages'));
    }

    public function updatePage(Request $request){

        if(isset($request->package_ids) && count($request->package_ids) > 0){
            $package_ids = serialize(array_filter($request->package_ids));
            $request->request->add(['package_ids' => $package_ids]);
        }

//        dd($request->id);
        $request->validate([
            'slug' => 'required|unique:pages,slug,'.$request->id,
        ]);

//        dd($request->all());


        Page::find($request->id)->update($request->all());

        return redirect()->route('page')->with('mesg', 'Page Updated Successfully!');
    }

}
