<?php

namespace App\Http\Controllers;

use App\Models\Permission;
use Illuminate\Http\Request;
use \Illuminate\Support\Facades\Route;

class PermissionController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }

    public function index(){
        $permissions = Permission::orderby('id','desc')->get();
        return view('permissions.index',compact('permissions'));
    }

    public function create(){
        $routes = Route::getRoutes();
        $permissions = Permission::all('name')->toArray();
        $permissions = $this->merge_array($permissions);
        $groupRoutes = [];

        foreach ($routes as $route)
        {
            if(strpos($route->getPrefix(), 'site') !== false)
            {
                $prefix = explode('site/',$route->getPrefix());
                $groupRoutes[$prefix[1]][] = $route->getName();
            }
        }
        return view('permissions.create',compact('groupRoutes','permissions'));
    }

    public function store(Request $request){
        $request->validate([
            'permissions' => 'required',
        ]);
        $permissions = $request->permissions;
        foreach($permissions as $permission){
            Permission::create(['name' => $permission]);
        }
        return redirect()->route('permission')->with('mesg', 'Permissions created successfully');
    }

    public function delete($id){
        $permission = Permission::find($id);
        if($permission){
            $permission->delete();
            return response('Permission deleted successfully');
        }else{
            return response('No such permission');
        }
    }

    private function merge_array($array){
        $temp = [];
        foreach ($array as $value){
            foreach ($value as $val){
                $temp[] = $val;
            }
        }
        return $temp;
    }
}
