<?php

namespace App\Http\Controllers;

use App\Models\Rank;
use Carbon\Carbon;
use Illuminate\Http\Request;

class RankController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }

    public function index(){
        $ranks = Rank::all();
        return view('ranks.index',compact('ranks'));
    }

    public function create(){
        return view('ranks.create');
    }

    public function store(Request $request){
        $request->validate([
            'title'  => 'required|string',
            'status' => 'required',
        ]);

        Rank::create($request->all());

        return redirect()->route('rank')->with('mesg','Rank created successfully.');
    }

    public function edit($id){
        $id = base64_decode($id);
        $rank = Rank::find($id);
        if (!$rank->isEmpty){
            return view('ranks.edit',compact('rank'));
        }else{
            return redirect()->back()->with('error','Rank not found.');
        }
    }

    public function update(Request $request){
        $request->validate([
            'title'  => 'required|string',
            'status' => 'required',
        ]);

        $request->merge([
            'id' => base64_decode($request->id),
            'updated_at' => Carbon::now(),
        ]);

        $rank = Rank::find($request->id);
        if(!$rank->isEmpty){
            $rank->update($request->all());
        }
        return redirect()->route('rank')->with('mesg','Rank updated successfully.');
    }

    public function delete($id){
        $id = base64_decode($id);
        $rank = Rank::find($id);
        if ($rank){
            $rank->delete();
            return response('Rank deleted successfully.');
        }else{
            return response('Rank not found.');
        }
    }

}
