<?php

namespace App\Http\Controllers\Website;

use App\Http\Controllers\Controller;
use App\Models\Packages;
use Illuminate\Http\Request;
use App\Models\Page;
use Illuminate\Support\Facades\Artisan;
class MainController extends Controller
{

    public function showFrontEndView($name=null,$end=null){
        $pageContent = Page::where('slug', 'service/'.$name)->first();

        $name = isset($pageContent->template) && !empty($pageContent->template) ? $pageContent->template : '404';

        return view('templates/'.$name, compact('pageContent'));
    }

    public function index($name=null,$end=null){
        $pageContent = Page::where('slug', $name)->first();
        $pkg_ids = unserialize($pageContent->package_ids);
        $packages = Packages::whereIn('id', $pkg_ids)->get();
//        dd($packages);

        $name = isset($pageContent->template) && !empty($pageContent->template) ? $pageContent->template : '404';

        return view('templates/'.$name, compact('pageContent','packages'));
    }
}
