<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Interview extends Model
{
    use HasFactory;

    protected $guarded = [
        '_token',
    ];

    public function findDepartment(){
        return $this->belongsTo(UserDesignation::class, 'department_id');
    }

    public function findJobTitle(){
        return $this->belongsTo(JobTitle::class, 'job_title_id');
    }

    public function statusValueColor($post_status){
        $status_html = '';
        foreach ($post_status as $post_status_value) {

            $color_class = '';
            switch ($post_status_value ?? '') {
                case 'Test Cleared':
                case 'Called For Interview':
                case 'Interview Cleared':
                    $color_class = "badge-success";
                    break;
                case 'Selected':
                    $color_class = "badge-primary";
                    break;
                case 'Called For Test':
                    $color_class = "badge-info";
                    break;
                case 'Rejected':
                case 'Pending':
                    $color_class = "badge-danger";
                    break;
                default:
                    break;
            }
            $status_html .= "<span class='badge ".$color_class." mr-1'>$post_status_value</span>";
        }
        return $status_html;
    }
}
