<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Page extends Model
{
    use HasFactory;
    protected $table = 'pages';
    protected $guarded = ['deleted_at','_token'];

    protected $sluggable = [

        'build_from' => 'title',

        'save_to'    => 'slug',

    ];

    public function sluggable():array
    {
        return [
            'slug' => [
                'source' => 'title'
            ]
        ];
    }

    public function findUser(){
        return $this->belongsTo('App\Models\User', 'user_id');
    }

}
