<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\DB;

class TeamToMember extends Model
{
    use HasFactory;
    protected $guarded = ['_token'];

    public function findMember(){
        return $this->belongsTo(User::class,'user_id');
    }

    public function createTeamMembers($team_id,$team_member_ids){
        foreach ($team_member_ids as $member_id) {
            TeamToMember::create([
                'team_id' => $team_id,
                'user_id' => $member_id,
            ]);
        }
        return true;
    }

    public function deleteTeamMembers($team_id){
        $team_members = TeamToMember::where('team_id',$team_id)->get();
        foreach ($team_members as $team_member){
            $team_member->forceDelete();
        }
    }

    public function getTeamMembers($team_id){
        $team_users = DB::table('users')
            ->leftJoin('team_to_members','users.id','=','team_to_members.user_id')
            ->where('team_to_members.team_id','=',$team_id)
            ->get();
        return $team_users;
    }

    public function getTeamMembersNotification(array $team_id){

        $team_users = DB::table('users')
            ->leftJoin('team_to_members','users.id','=','team_to_members.user_id')
            ->whereIn('team_to_members.team_id',$team_id)
            ->get();
        return $team_users;
    }

    public function getMembersByTeamId($team_ids){
        return TeamToMember::whereIn('team_id',$team_ids)->get();
    }


    public function findTeam(){
        return $this->belongsTo(Team::class,'team_id');
    }

}
