<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;

class User extends Authenticatable
{
    use Notifiable, SoftDeletes;

    protected $guarded = [
        '_token',
    ];

    public function teams(){
        return $this->belongsToMany(Team::class,'team_to_members','user_id','team_id');
    }

    public function isSuperAdmin(){
        return  $this->id == 1;
    }

    public function findRole(){
        return $this->belongsTo(Role::class,'role_id');
    }

    public function findShift(){
        return $this->belongsTo(Shift::class,'shift_id');
    }

    public function findRank(){
        return $this->belongsTo(Rank::class,'rank_id');
    }

    public function findAllowances(){
        return $this->hasMany(UserAllowanceInfo::class);
    }

    public function findActiveAllowances(){
        return $this->hasMany(UserAllowanceInfo::class)->whereHas('findAllowance', function ($query) {
            $query->where('status', 1);
        });
    }

    public function findTeams(){
        return $this->hasMany(TeamToMember::class,'user_id');
    }

    public function isTeamLead(){
        return $this->hasMany(Team::class,'team_head_user_id');
    }

    public function findDesignation(){
        return $this->belongsTo(UserDesignation::class, 'designation_id');
    }

    public function findJobTitle(){
        return $this->belongsTo(JobTitle::class, 'job_title_id');
    }

    public function findStatus(){
        return $this->belongsTo(UserStatus::class, 'status_id');
    }
    public function findLead(){
        return $this->belongsTo(LeadsToClient::class, 'id','user_id');
    }

}
