<?php

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Auth;

class UserLoginDetails extends Model
{
    use HasFactory;
    protected $table = 'users_login_details';
    protected $guarded = [
        '_token',
    ];

    public function storeLoginDetails(Request $request){
        date_default_timezone_set('Asia/Karachi');
        $user = auth()->user();
        $date = Carbon::now();
        $user_shift = $user->findShift;
        $login_details = [
            'user_id' => $user->id,
            'user_login_ip' => $request->ip(),
            'user_attendance_date' => $date->toDateString(),
            'login_date_time' => $date->toDateTimeString(),
            'shift_status' => $request->shift_status,
            'marked_as_late' => 0,
        ];

        if ($user_shift){
            $shift_start = explode(':',$user_shift->start_time);

            //Late-in Calculation
            $login_details['marked_as_late'] = $this->difference($shift_start);
        }

        UserLoginDetails::create($login_details);

        $log_id = UserLoginDetails::where('user_id', $user->id)
            ->where('user_attendance_date', date('Y-m-d'))
            ->latest()
            ->first();

        return ($log_id)?($log_id):('');
    }

    public function verify_check_in($user){

        date_default_timezone_set('Asia/Karachi');

        $t = now()->format('h:i:s a');
        $check_time = substr($t,9,2);

        if($check_time == "am") {

            $now = now();
            $day_attendance = $now->yesterday()->format('Y-m-d');

            $log_id = UserLoginDetails::where('user_id', $user->user_id)
                ->where('user_attendance_date', $day_attendance)
                ->latest()
                ->first();

            if ($log_id && !$log_id->logout_date_time){
                return ($log_id)?$log_id:'';
            }
            return $log_id;
        }else{

            $log_id = UserLoginDetails::where('user_id', $user->user_id)
                ->where('user_attendance_date', date('Y-m-d'))
                ->latest()
                ->first();

            return ($log_id)?$log_id:'';

        }
    }

    public function verify_check($user){
//        dd($user);
        date_default_timezone_set('Asia/Karachi');

        $t = now()->format('h:i:s a');
        $check_time = substr($t,9,2);

        if($check_time == "am") {

           $now = now();
           $day_attendance = $now->yesterday()->format('Y-m-d');
            $log_id = UserLoginDetails::where('user_id', $user->id)
                ->where('user_attendance_date', $day_attendance)
                ->latest()
                ->first();

            if ($log_id && !$log_id->logout_date_time){
                return ($log_id)?$log_id:'';
            }
            return $log_id;
        }else{
//            dd($user);
            $log_id = UserLoginDetails::where('user_id', $user->id)
                ->where('user_attendance_date', date('Y-m-d'))
                ->latest()
                ->first();

            return ($log_id)?$log_id:'';

        }

    }

    public function difference($start_time){

        $now = Carbon::now();
        //Expected arrival = 23:50 08-24-2021 to 00:05 08-25-2021
        $h = $start_time[0]; //Shift start hour
        $i = $start_time[1]; //Shift start minute
        $s = 00; //Shift start second
        $is_late = 0;
        $start  = mktime($h, $i,$s);
        $start2 = mktime($h, $i+15,$s);
        $arrive = mktime($now->hour, $now->minute,$now->second, $now->month, $now->day, $now->year);

        if(date("d",$start2) > date("d",$start) && date("H",$arrive) == 0){ // Shift starts at next day after 15 minutes increment
            $start  = mktime($h, $i,$s, $now->month, $now->day-1, $now->year);
            if (date('d',$arrive) == date('d',$start)){ //Mean user has arrived before date change
                $is_late = 0;
            }elseif (date('d',$arrive) > date('d',$start)){ //Mean user has arrived after date change
                if ((date('H',$arrive) == date('H',$start2)) && (date('i',$arrive) <= date('i',$start2))){
                    $is_late = 0;
                }else{
                    $is_late = 1;
                }
            }// inner if ends

        }elseif(date("d",$start2) > date("d",$start) && date("H",$arrive) != 0 /*It could be greater than 12 */){
            $start  = mktime($h, $i,$s, $now->month, $now->day, $now->year);
            if ((date('H',$arrive) == date('H',$start)) && (date('i',$arrive) <= date('i',$start))){
                $is_late = 0;
            }else{
                $is_late = 1;
            }
        }else{ // Shift starts on same day after 15 minutes increment
            if (date('d',$arrive) == date('d',$start)){
                if ((date('H',$arrive) < date('H',$start2)) ){
                    $is_late = 0; //Within same day but on time
                }elseif((date('H',$arrive) == date('H',$start2)) && (date('i',$arrive) <= date('i',$start2))){
                    $is_late = 0; //Within same day but on time
                }
                else{
                    $is_late = 1; // Within same day but late
                }
            }else{
                $is_late = 1; // Invalid day
            }
        }// Outer if end

        return $is_late;
    }

    public function logout_details($log_id){
        date_default_timezone_set('Asia/Karachi');

        $log = UserLoginDetails::find($log_id);

        $user = auth()->user();
        $user_shift = $user->findShift;

        $date = Carbon::now();
        $log->logout_date_time = $date->toDateTimeString();

        //Calculate Login & Logout Time
        $startTime = new Carbon($log->login_date_time);
        $endTime = new  Carbon($log->logout_date_time);
        $log->working_hours = $startTime->diffInSeconds($endTime);

        if ($user_shift){
            $is_early_out = $this->calculateWorkingHours($log->login_date_time,$date->toDateTimeString(),$user_shift->total_hours);
            if ($is_early_out){
                $log->marked_as_early_out = 1;
            }else{
                $log->marked_as_early_out = 0;
                $over_time = $this->overtimeStore($user_shift->total_hours,$log->working_hours);

                $find_colon = strpos($over_time,':');
                if($find_colon > 0){

                    $time = $over_time;
                    [$hours, $minutes] = explode(':', $time);

                    $overTime  = ((int)$hours * 60 + (int)$minutes)*60;
                    $log->working_hours -= $overTime; //Need to verify after putting real data of month
                    $log->overtime = $overTime;

                }else if ($over_time && (Auth::user()->id > 0)){

                    $log->working_hours -= $over_time; //Need to verify after putting real data of month
                    $log->overtime = $over_time;
                }
            }
        }

        $log->save();
        return true;
    }

    public function calculateWorkingHours($shift_start, $shift_end,$total_hours){
        $shift_start = explode(' ',$shift_start);
        $shift_start = explode(':',$shift_start[1]);
        $shift_start_string = $shift_start[0].':'.$shift_start[1];

        $shift_end = explode(' ',$shift_end);
        $shift_end = explode(':',$shift_end[1]);
        $shift_end_string = $shift_end[0].':'.$shift_end[1];

        $working_hours = date("H:i", strtotime("00:00") + strtotime($shift_end_string) - strtotime($shift_start_string));

        $working_hours = explode(':',$working_hours);
        $total_hours = explode(':',$total_hours);

        if ($working_hours[0] < $total_hours[0]){
            //user is early_out
            return true;
        }elseif ($working_hours[0] == $total_hours[0] && $working_hours[1] < $total_hours[1]){
            //user is early_out
            return true;
        }else{
            //user left on time
            return false;
        }
    }

    public  function getMonthWorkingDays($month_year) {

        // month_year i-e 2022-11
        $year = substr($month_year, 0, 3);
        $month = substr($month_year, 5, 6);

        $myTime = strtotime($month_year);  // Use whatever date format you want
        $daysInMonth = cal_days_in_month(CAL_GREGORIAN, $month, $year); // 31
        $workDays = 0;

        while($daysInMonth > 0)
        {
            $day = date("D", $myTime); // Sun - Sat
            if($day != "Sun" && $day != "Sat")
                $workDays++;

            $daysInMonth--;
            $myTime += 86400; // 86,400 seconds = 24 hrs.
        }

        return $workDays;
    }

    public function getEmployeeWorkingDays($user_id,$date){

        return UserLoginDetails::where('user_id',$user_id)
            ->where('login_date_time', 'LIKE',"%{$date}%")
            ->distinct('user_attendance_date')
            ->count();
    }

    public function getEmployeeWorkingHour($user_id,$date)
    {
        return UserLoginDetails::where('user_id', $user_id)
            ->where('user_attendance_date', 'LIKE', "$date%")
            ->sum('working_hours');
    }

    public function secondsToTime($seconds_time)
    {
        if ($seconds_time < 24 * 60 * 60) {
            return gmdate('H:i', $seconds_time);
        } else {
            $hours = floor($seconds_time / 3600);
            $minutes = floor(($seconds_time - $hours * 3600) / 60);
            $seconds = floor($seconds_time - ($hours * 3600) - ($minutes * 60));
            return "$hours:$minutes";
        }
    }

    function timeToSeconds(string $time)
    {
        $arr = explode(':', $time);
        if (count($arr) === 2) {
            return $arr[0] * 3600 + $arr[1] * 60;
        }
        return $arr[0] * 60 + $arr[1];
    }

    public function overtimeStore($shift_hours,$working_hour_avaliable){
        $shift_time_in_second = $this->timeToSeconds($shift_hours);
        if ($working_hour_avaliable > $shift_time_in_second) {
            $time = $working_hour_avaliable - $shift_time_in_second;
            $over_time = $this->secondsToTime($time);
            return $over_time;
        }
        else{
            return 0;
        }
    }

    //Month Wise OverTime
    public function overtime($user_id,$month_year){
        $getovertime = UserLoginDetails::where('user_id', $user_id)
            ->where('user_attendance_date', 'LIKE', "%{$month_year}%")
            ->sum('overtime');
        return  $getovertime;
    }

    //Date Wise OverTime
    public function overtimeDate($user_id,$month_year_date){
        $getovertimeDate = UserLoginDetails::where('user_id', $user_id)
            ->where('user_attendance_date', 'LIKE', "%{$month_year_date}%")
            ->sum('overtime');

        return  $getovertimeDate;
    }

    public function loginCount($user_id,$date){

        $getLoginActivityCount = UserLoginDetails::where('user_id',$user_id)
            ->where('login_date_time', 'LIKE',"%{$date}%")
            ->count();
        return $getLoginActivityCount;
    }

    public function findUserDetail(){
        return $this->belongsTo(User::class, 'user_id','id');
    }

    public function check_in_time_update($arr){

        date_default_timezone_set('Asia/Karachi');

        $userId     = $arr['user_id'];
        $attendance = $arr['user_attendance']??'null';
        $checkAttendance = UserLoginDetails::where("user_id",$userId)
            ->where('user_attendance_date',$attendance)
            ->first();

        if (!$checkAttendance && $attendance != 'null'){

            $check_in_out_details = [
                'user_id' => $userId,
                'user_login_ip' => $_SERVER['REMOTE_ADDR'],
                'user_attendance_date' => $attendance,
                'login_date_time' =>$arr['check_in_date'],
                'logout_date_time' =>$arr['check_out_date'],
                'shift_status' =>  'Shift Login',
                'marked_as_late' => 0,
            ];
            $res = UserLoginDetails::create($check_in_out_details);
            $log = UserLoginDetails::find($res->id);
            $user = User::find($userId);

        }else{

            $log = UserLoginDetails::find($arr['log_id']);
            $user = User::find($arr['user_id']);
        }


        $user_shift = $user->findShift;

        $startTime = new Carbon($log->login_date_time);
        $endTime = new  Carbon($log->logout_date_time);

        $log->working_hours = $startTime->diffInSeconds($endTime);

       if ($user_shift){
            $shift_start = explode(':',$user_shift->start_time);
            //Late-in Calculation
           $log->marked_as_late = $this->check_in_out_difference($shift_start,$log->login_date_time);
        }

        if ($user_shift){
            $is_early_out = $this->calculateWorkingHours($log->login_date_time,$log->logout_date_time,$user_shift->total_hours);
            if ($is_early_out){
                $log->marked_as_early_out = 1;
            }else{
                $log->marked_as_early_out = 0;
                $over_time = $this->overtimeStore($user_shift->total_hours,$log->working_hours);

                $find_colon = strpos($over_time,':');
                if($find_colon > 0){

                    $time = $over_time;
                    [$hours, $minutes] = explode(':', $time);

                    $overTime  = ((int)$hours * 60 + (int)$minutes)*60;
                    $log->working_hours -= $overTime; //Need to verify after putting real data of month
                    $log->overtime = $overTime;

                }else if ($over_time && (Auth::user()->id > 0)){

                    $log->working_hours -= $over_time; //Need to verify after putting real data of month
                    $log->overtime = $over_time;
                }
            }
        }

        $log->save();
//        dd('work');
        return true;
    }

    public  function getTotalMonthWorkingDays($month_year) {

        $year = substr($month_year, 0, 3);
        $month = substr($month_year, 5, 6);

        $myTime = strtotime($month_year);  // Use whatever date format you want
        $daysInMonth = cal_days_in_month(CAL_GREGORIAN, $month, $year); // 31
        $workDays = 0;
        $workingDayMonth = [];

        while($daysInMonth > 0)
        {
            $day = date("D", $myTime); // Sun - Sat
            $work_days = date("d-m-Y", $myTime);;
            if($day != "Sun" && $day != "Sat"){
                $workDays++;
                $workingDayMonth[] = $work_days;
            }

            $daysInMonth--;
            $myTime += 86400; // 86,400 seconds = 24 hrs.
        }
        return $workingDayMonth;
    }

    public function check_in_out_difference($start_time,$login_time){

        $now =new Carbon($login_time);
        //Expected arrival = 23:50 08-24-2021 to 00:05 08-25-2021
        $h = $start_time[0]; //Shift start hour
        $i = $start_time[1]; //Shift start minute
        $s = 00; //Shift start second
        $is_late = 0;
        $start  = mktime($h, $i,$s);
        $start2 = mktime($h, $i+15,$s);
        $arrive = mktime($now->hour, $now->minute,$now->second, $now->month, $now->day, $now->year);

        if(date("d",$start2) > date("d",$start) && date("H",$arrive) == 0){ // Shift starts at next day after 15 minutes increment
            $start  = mktime($h, $i,$s, $now->month, $now->day-1, $now->year);
            if (date('d',$arrive) == date('d',$start)){ //Mean user has arrived before date change
                $is_late = 0;
            }elseif (date('d',$arrive) > date('d',$start)){ //Mean user has arrived after date change
                if ((date('H',$arrive) == date('H',$start2)) && (date('i',$arrive) <= date('i',$start2))){
                    $is_late = 0;
                }else{
                    $is_late = 1;
                }
            }// inner if ends

        }elseif(date("d",$start2) > date("d",$start) && date("H",$arrive) != 0 /*It could be greater than 12 */){
            $start  = mktime($h, $i,$s, $now->month, $now->day, $now->year);
            if ((date('H',$arrive) == date('H',$start)) && (date('i',$arrive) <= date('i',$start))){
                $is_late = 0;
            }else{
                $is_late = 1;
            }
        }else{ // Shift starts on same day after 15 minutes increment
            if (date('d',$arrive) == date('d',$start)){
                if ((date('H',$arrive) < date('H',$start2)) ){
                    $is_late = 0; //Within same day but on time
                }elseif((date('H',$arrive) == date('H',$start2)) && (date('i',$arrive) <= date('i',$start2))){
                    $is_late = 0; //Within same day but on time
                }
                else{
                    $is_late = 1; // Within same day but late
                }
            }else{
                $is_late = 1; // Invalid day
            }
        }// Outer if end

        return $is_late;

    }

}
