<?php

namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use App\Models\UserLoginDetails;
use Illuminate\Http\JsonResponse;
use \Illuminate\Http\Request;
use Illuminate\Foundation\Auth\AuthenticatesUsers;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Validator;

class LoginController extends Controller
{
    /*
    |--------------------------------------------------------------------------
    | Login Controller
    |--------------------------------------------------------------------------
    |
    | This controller handles authenticating users for the application and
    | redirecting them to your home screen. The controller uses a trait
    | to conveniently provide its functionality to your applications.
    |
    */

    use AuthenticatesUsers;

    /**
     * Where to redirect users after login.
     *
     * @return mixed|string
     * @var string
     */
    protected $redirectTo = '/dashboard';

    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('guest')->except('logout');
    }

    public function login(Request $request){
        $rules = [
            'email' => 'required|string',
            'password' => 'required'
        ];

        if (! $request->email == 'admin@admin.com'){
            $rules['shift_status'] = 'required';
        }

        $validated = Validator::make($request->all(), $rules);

        if ($validated->fails())
            return back()->withErrors($validated->errors())->withInput($request->all());

        if(auth()->attempt($request->only('email','password'))){
            $user = \auth()->user();

//            if($user->is_admin){
//
//                return redirect()->intended('/dashboard')->with('mesg', 'Login Success.');
//
//            }elseif(isset($user->findStatus) && $user->findStatus->has_access){
//                $loginDetailsModel = new UserLoginDetails();
//                $log_id = $loginDetailsModel->storeLoginDetails($request);
//                $request->session()->put('log_id', $log_id);
//
//                return redirect()->intended('/dashboard')->with('mesg', 'Login Success.');
//
//            }else{
//                Auth::logout();
//                return redirect()->back()->withErrors(["error" => "You are not authorized to access this site."]);
//            }

            if($user->is_admin){

                return redirect()->intended('/dashboard')->with('mesg', 'Login Success.');

            }elseif(isset($user->findStatus) && $user->findStatus->has_access){

                return redirect()->intended('/dashboard')->with('mesg', 'Login Success.');

            }else{
                Auth::logout();
                return redirect()->back()->withErrors(["error" => "You are not authorized to access this site."]);
            }
        }else{
            return redirect()->back()->withErrors(["error" => "Invalid credentials."]);
        }
    }

    public function logout(Request $request)
    {
//
//        if (session()->has('log_id')){
//            $loginDetails = new UserLoginDetails();
//            if ($request->logout_type){
//                $loginDetails->logout_details(session()->get('log_id'), $request->logout_type);
//            }else{
//                $loginDetails->logout_details(session()->get('log_id'));
//            }
//        }
        $this->guard()->logout();

        $request->session()->invalidate();

        $request->session()->regenerateToken();

        if ($response = $this->loggedOut($request)) {
            return $response;
        }

        return $request->wantsJson()
            ? new JsonResponse([], 204)
            : redirect('/');
    }
}
