<?php

namespace App\Http\Controllers;

use App\Models\IP;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Gate;

class IPController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }

    public function index(){
        return view('ip.index');
    }
    public function showAllIps(Request $request){

        $columns_list = array(
            0 =>'id',
            2 =>'ip_address',
            1=> 'created_by_user_id',
            3=> 'status',
        );

        $totalDataRecord = IP::count();

        $totalFilteredRecord = $totalDataRecord;

        $limit_val = $request->input('length');
        $start_val = $request->input('start');
        $order = 'ip_addresses.'.$columns_list[$request->input('order.0.column')];
        $dir_val = 'desc';

        if(empty($request->input('search.value')))
        {
            $post_data = IP::offset($start_val)
                ->limit($limit_val)
                ->orderBy($order,$dir_val)
                ->get();
        }
        else {
            $search_text = $request->input('search.value');
            if ($search_text == 'Active' || $search_text == 'In-Active'){
                $search_text = ($search_text == 'Active')?'1':'0';
            }

            $post_data =  IP::where('id','LIKE',"%{$search_text}%")
                ->orWhere('ip_address', 'LIKE',"%{$search_text}%")
                ->orWhere('status', $search_text)
                ->offset($start_val)
                ->limit($limit_val)
                ->orderBy($order,$dir_val)
                ->get();

            $totalFilteredRecord = IP::where('id','LIKE',"%{$search_text}%")
                ->orWhere('ip_address', 'LIKE',"%{$search_text}%")
                ->orWhere('status',$search_text)
                ->count();
        }

        $data_val = array();
        if(!empty($post_data))
        {
            $i=0;
            foreach ($post_data as $post_val)
            {
                $i++;

                $deletedata = $post_val->id;
                $id = base64_encode($deletedata);
                $dataedit = route('edit.ip',['id'=>$id]);
                $status = ($post_val->status == 1)?"<span class='badge badge-success'>Active</span>":"<span class='badge badge-danger'>In-Active</span>";

                $delete_ip = Gate::allows("delete.ip")?"<button class='btn btn-danger delete-btn' data-id='{$id}' title='Delete'><i class='fa fa-trash'></i> </button>":"";
                $edit_ip = Gate::allows("edit.ip")?"<a class='btn btn-primary btn-style' href='{$dataedit}' title='Edit'><i class='fa fa-edit'></i> </a>":"";

                $postnestedData['id'] = $i;
                $postnestedData['ip_address'] = $post_val->ip_address;
                $postnestedData['created_by_user_id'] = $post_val->findUser->name??'N/A';
                $postnestedData['status'] = $status;
                $postnestedData['options'] = " <div class='btn-group'> {$edit_ip}  {$delete_ip}  </div>";
                $data_val[] = $postnestedData;
            }
        }
        $draw_val = $request->input('draw');
        $get_json_data = array(
            "draw"            => intval($draw_val),
            "recordsTotal"    => intval($totalDataRecord),
            "recordsFiltered" => intval($totalFilteredRecord),
            "data"            => $data_val
        );

        echo json_encode($get_json_data);

    }

    public function create(){
        return view('ip.create');
    }

    public function store(Request $request){
        $request->validate([
            'ip_address'    => 'required|unique:ip_addresses',
            'status'        => 'required'
        ]);
        $request->merge(['created_by_user_id' => auth()->id()]);

        IP::create($request->all());
        return redirect()->route('ip')->with('mesg','IP created successfully.');
    }

    public function edit($id){
        $id = base64_decode($id);
        $ip = IP::find($id);
        if ($ip){
            return view('ip.edit',compact('ip'));
        }else{
            return redirect()->back()->with('error','IP not found.');
        }
    }

    public function update(Request $request){
        $request->validate([
            'ip_address'    => 'required',
            'status'        => 'required'
        ]);

        $request->merge([
            'id' => base64_decode($request->id),
            'updated_at' => Carbon::now(),
        ]);

        $ip = IP::find($request->id);
        if ($ip){
            $ip->update($request->all());
            return redirect()->route('ip')->with('mesg','IP updated successfully.');
        }
    }

    public function delete($id){
        $id = base64_decode($id);
        $ip = IP::find($id);
        if ($ip){
            $ip->delete();
            return response('IP deleted successfully.');
        }else{
            return response('IP not found.');
        }
    }
}
