<?php

namespace App\Http\Controllers;

use App\Models\Notification;
use App\Models\NotificationSend;
use App\Models\Role;
use App\Models\TeamToMember;
use App\Models\User;
use App\Traits\EmailTrait;
use Illuminate\Http\Request;
use App\Models\Team;
use App\Models\UserStatus;

class NotificationController extends Controller
{
    use EmailTrait;
    public function __construct()
    {
        $this->middleware('auth');
    }

    public function index(){
        $generalNotifications = NotificationSend::where('to_send',auth()->id())->get();
        $other_notifications = Notification::where('to_user_id',auth()->id())->orderby('id','desc')->get();

        return view('notifications.index',compact('other_notifications','generalNotifications'));
    }
    public function create(){
        $teams = Team::where('status',1)->get();
        $hr = Role::where('name','HR')->where('status',1)->first();
        $user_status = UserStatus::where('has_access' ,1)->pluck('id');
        $users = User::where('role_id','<>', $hr->id)
            ->where('user_type_id',1)
            ->whereIn('status_id',$user_status)
            ->orderBy('name')
            ->get();

        return view('notifications.create',compact('teams','users'));
    }

    public function sentNotification(){
        $notification_send = Notification::where('from_user_id', auth()->id())->orderby("id",'desc')->get();
        return view('notifications.notification_send',compact('notification_send'));
    }

    public function receivedNotification(){
        $received_notifications = NotificationSend::where('to_send', auth()->id())
            ->with('gnotification')
            ->get();
//        dd($received_notifications[0]->gnotification->subject);
//        $notification_send = Notification::where('notification_type','General Notification')->orderby("id",'desc')->get();
        return view('notifications.notification_received',compact('received_notifications'));
    }

    public function show_send_notification($id){
        $notification_send = NotificationSend::where('notification_id',$id)->get();
        $data = '';
        foreach ($notification_send as $notification){
            if($notification->is_read == 1){
                $status ='<span class="badge badge-success">Seen</span>';
            }else{
                $status ='<span class="badge badge-warning">Not Seen</span>';
            }
            $data.='<div class="col-md-6">';
            $data.='<span>'.($notification->findUser->name??'').'</span>';
            $data.='</div><div class="col-md-6">';
            $data.=$status;
            $data.='</div>';
        }
        return $data;
    }

    public function store(Request $request){
        $mail_users = [];

        // Notification to Teams
        if ($request->send_to == "teams"){
            $users = new TeamToMember();
            $data =  $users->getTeamMembersNotification($request->team_id);

            $notification = [
                'subject' => $request->subject,
                'description' => $request->description,
                'from_user_id' => auth()->user()->id,
                'notification_type' => 'General Notification',
                'route'=> 'site/notification/received',
            ];

            $notification = Notification::create($notification);
            foreach ($data as $user){
                $mail_users[] = $user->user_id;
                $general_notification = [
                    'notification_id'=>$notification->id,
                    'to_send'=>$user->user_id,
                    'is_read' =>0,
                ];
                $send_to = NotificationSend::create($general_notification);
            }
        }

        // Notification to Customs
        if ($request->send_to == "custom"){
            $notification = [
                'subject'=>$request->subject,
                'description'=>$request->description,
                'from_user_id' =>auth()->user()->id,
                'notification_type'=>'General Notification',
                'route'=> 'site/notification/received',
            ];

            $notification = Notification::create($notification);
            foreach ($request->user_id as $id){
                $mail_users[] = $id;
                $general_notification = [
                    'notification_id'=>$notification->id,
                    'to_send'=>$id,
                    'is_read' =>0,
                ];
                $send_to = NotificationSend::create($general_notification);
            }
        }

        // Notification to All
        if ($request->send_to == "all"){
            $user_status = UserStatus::where('has_access' ,1)->pluck('id');
            $all = User::where('id', '<>', auth()->id())
                ->where('user_type_id',1)
                ->whereIn('status_id',$user_status)
                ->orderBy('name')
                ->get();

            $notification = [
                'subject'=>$request->subject,
                'description'=>$request->description,
                'from_user_id' =>auth()->user()->id,
                'notification_type'=>'General Notification',
                'route'=> 'site/notification/received',
            ];
            $notification = Notification::create($notification);
            foreach ($all as $user){
                $mail_users[] = $user->id;
                $general_notification = [
                    'notification_id'=>$notification->id,
                    'to_send'=>$user->id,
                    'is_read' =>0,
                ];
                $send_to = NotificationSend::create($general_notification);
            }
        }

        if (count($mail_users) > 0){
            $this->sendNotificationMail($mail_users, $notification);
        }

        if($send_to){
            return redirect()->route('sent.notification')
                ->with('mesg','Notification Sent Successfully.');
        }
    }

    public function markAsRead($id){
        /*Notification::find($id)->update([
            'is_read' => 1,
        ]);*/
       $mark_as_read = NotificationSend::where('id',$id)->where('to_send',auth()->user()->id)->update([
            'is_read' => 1,
        ]);
        return response(['response' => $mark_as_read]);
    }

    public function markAsReadGeneralNotification($id){
        NotificationSend::find($id)->update([
            'is_read' => 1,
        ]);
        return response(['notification' => NotificationSend::find($id)->gnotification]);
    }

    public function markAsReadAndRedirect($id){
        $notification = NotificationSend::find(base64_decode($id));
        if (!$notification){
            abort(404);
        }

        $notification->is_read = 1;
        $notification->save();
        return redirect()->to($notification->gnotification->route);
    }
}
