<?php

namespace App\Http\Controllers;

use App\Models\ProjectType;
use Illuminate\Http\Request;

class ProjectTypeController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }

    public function index(){
        $project_types = ProjectType::orderBy('title')->get();
        return view('project-type.index', compact('project_types'));
    }

    public function create(){
        return view('project-type.create');
    }

    public function store(Request $request){
        $request->validate([
            'title'         => 'required',
            'status'        => 'required',
        ]);

        ProjectType::create($request->all());
        return redirect()->route('project-type')->with('mesg', 'Project type created successfully');
    }

    public function edit($id){
        $project_type = ProjectType::find(base64_decode($id));
        if ($project_type){
            return view('project-type.edit', compact('project_type'));
        }else{
            return redirect()->back()->with('error','Project type not found.');
        }
    }

    public function update(Request $request){
        $request->validate([
            'title'         => 'required',
            'status'        => 'required',
        ]);

        $project_type = ProjectType::find($request->id);
        if ($project_type){
            $res = $project_type->update($request->all());
            if ($res){
                return redirect()->route('project-type')->with('mesg','Project type updated successfully.');
            }
        }
    }

    public function delete($id){
        $project_type = ProjectType::find(base64_decode($id));
        if($project_type){
            $project_type->delete();
            return response('Project type deleted successfully');
        }else{
            return response('Project type not found');
        }
    }
}
