<?php

namespace App\Http\Controllers;

use App\Models\Permission;
use App\Models\Role;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;

class RoleController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }

    public function index(){
        $roles = Role::all();
        return view('roles.index',compact('roles'));
    }

    public function create(){

        $routes = Route::getRoutes();
        $groupRoutes = [];
        $permissions = Permission::all('name')->toArray();
        $permissions = $this->merge_array($permissions);

        foreach ($routes as $route)
        {
            if(strpos($route->getPrefix(), 'site') !== false)
            {
                $prefix = explode('site/',$route->getPrefix());
                $groupRoutes[$prefix[1]][] = $route->getName();
            }
        }

        return view('roles.create',compact('groupRoutes','permissions'));
    }

    public function store(Request $request){

        $request->validate([
            'name'          => 'required|string',
            'status'        => 'required',
            'permissions'   => 'required',
        ]);

        Role::create([
            'name'          => $request->name,
            'status'        => $request->status,
            'permissions'   => json_encode($request->permissions)
        ]);

        return redirect()->route('role')->with('mesg','Role created successfully.');
    }

    public function show($id){
        $id = base64_decode($id);
        dd($id);
    }

    public function edit($id){
        $id = base64_decode($id);
        $role = Role::where('id',$id)->first();
        if($role){

            $allowed_permissions = Permission::all('name')->toArray();
            $allowed_permissions = $this->merge_array($allowed_permissions);

            $routes = Route::getRoutes();
            $groupRoutes = [];

            foreach ($routes as $route)
            {
                if(strpos($route->getPrefix(), 'site') !== false)
                {
                    $prefix = explode('site/',$route->getPrefix());
                    $groupRoutes[$prefix[1]][] = $route->getName();
                }
            }


            return view('roles.edit',compact('role','groupRoutes','allowed_permissions'));
        }else{
            return redirect()->back()->with('error','Role not found.');
        }
    }

    public function update(Request $request){

        $request->validate([
            'name'          => 'required|string',
            'status'        => 'required',
            'permissions'   => 'required',
        ]);

        $request->merge([
            'id' => base64_decode($request->id),

        ]);
        $role = Role::find($request->id);

        $role->update([
            'name'          => $request->name,
            'status'        => $request->status,
            'permissions'   => json_encode($request->permissions),
            'updated_at'    => Carbon::now(),
        ]);

        return redirect()->route('role')->with('mesg','Role updated successfully.');
    }

    public function delete($id){
        $id = base64_decode($id);
        $role = Role::find($id);
        if($role){
            $role->delete();
            return response('Role deleted successfully.');
        }else{
            return response('Role not found..');
        }
    }

    private function merge_array($array){
        $temp = [];
        foreach ($array as $value){
            foreach ($value as $val){
                $temp[] = $val;
            }
        }
        return $temp;
    }

}
