<?php

namespace App\Http\Controllers;

use App\Models\Shift;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Gate;

class ShiftController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }

    public function index(){
        return view('shifts.index');
    }

    public function showAllShifts(Request $request){

        $columns_list = array(
            0 =>'id',
            1 =>'title',
            2=> 'start_time',
            3=> 'end_time',
            4=> 'total_hours',
            5=> 'status',
        );

        $totalDataRecord = Shift::count();

        $totalFilteredRecord = $totalDataRecord;

        $limit_val = $request->input('length');
        $start_val = $request->input('start');
        $order = 'shifts.'.$columns_list[$request->input('order.0.column')];
        $dir_val = 'desc';

        if(empty($request->input('search.value')))
        {
            $post_data = Shift::offset($start_val)
                ->limit($limit_val)
                ->orderBy($order,$dir_val)
                ->get();
        }
        else {
            $search_text = $request->input('search.value');
            if ($search_text == 'Active' || $search_text == 'In-Active'){
                $search_text = ($search_text == 'Active')?'1':'0';
            }

            $post_data =  Shift::where('id','LIKE',"%{$search_text}%")
                ->orWhere('title', 'LIKE',"%{$search_text}%")
                ->orWhere('status', $search_text)
                ->offset($start_val)
                ->limit($limit_val)
                ->orderBy($order,$dir_val)
                ->get();

            $totalFilteredRecord = Shift::where('id','LIKE',"%{$search_text}%")
                ->orWhere('title', 'LIKE',"%{$search_text}%")
                ->orWhere('status',$search_text)
                ->count();
        }

        $data_val = array();
        if(!empty($post_data))
        {
            foreach ($post_data as $post_val)
            {
                $deletedata = $post_val->id;
                $id = base64_encode($deletedata);
                $dataedit =  route('edit.shift',['id'=>$id]);
                $status = ($post_val->status == 1)?"<span class='badge badge-success'>Active</span>":"<span class='badge badge-danger'>In-Active</span>";

                $delete_shift = Gate::allows("delete.shift")?"<button class='btn btn-danger delete-btn' data-id='{$id}' title='Delete'><i class='fa fa-trash'></i> </button>":"";
                $edit_shift = Gate::allows("edit.shift")?"<a class='btn btn-primary btn-style' href='{$dataedit}' title='Edit'><i class='fa fa-edit'></i> </a>":"";

                $postnestedData['id'] = $post_val->id;
                $postnestedData['title'] = $post_val->title;
                $postnestedData['start_time'] = date('h:i A', strtotime($post_val->start_time));
                $postnestedData['end_time'] = date('h:i A', strtotime($post_val->end_time));
                $postnestedData['total_hours'] = $post_val->total_hours;
                $postnestedData['status'] = $status;
                $postnestedData['options'] = " <div class='btn-group'> {$edit_shift}  {$delete_shift}  </div>";
                $data_val[] = $postnestedData;
            }
        }
        $draw_val = $request->input('draw');
        $get_json_data = array(
            "draw"            => intval($draw_val),
            "recordsTotal"    => intval($totalDataRecord),
            "recordsFiltered" => intval($totalFilteredRecord),
            "data"            => $data_val
        );

        echo json_encode($get_json_data);

    }

    public function create(){
        return view('shifts.create');
    }

    public function store(Request $request){
        $request->validate([
            'title'         => 'required',
            'start_time'    => 'required',
            'end_time'      => 'required',
            'status'        => 'required',
        ]);

        $start = $request->start_time;
        $end = $request->end_time;

        $request->merge([
            'total_hours' => date("H:i", strtotime("00:00") + strtotime($end) - strtotime($start))
        ]);

        Shift::create($request->all());
        return redirect()->route('shift')->with('mesg','Shift created successfully.');
    }

    public function edit($id){
        $id = base64_decode($id);
        $shift = Shift::find($id);
        if (!$shift->isEmpty){
            return view('shifts.edit',compact('shift'));
        }else{
            return redirect()->back()->with('error','Shift not found.');
        }
    }

    public function update(Request $request){
        $request->validate([
            'title'         => 'required',
            'start_time'    => 'required',
            'end_time'      => 'required',
            'status'        => 'required',
        ]);

        $start = $request->start_time;
        $end = $request->end_time;

        $request->merge([
            'id' => base64_decode($request->id),
            'updated_at' => Carbon::now(),
            'total_hours' => date("H:i", strtotime("00:00") + strtotime($end) - strtotime($start))
        ]);

        $shift = Shift::find($request->id);
        if(!$shift->isEmpty){
            $shift->update($request->all());
        }
        return redirect()->route('shift')->with('mesg','Shift updated successfully.');
    }

    public function delete($id){
        $id = base64_decode($id);
        $shift = Shift::find($id);
        if ($shift){
            $shift->delete();
            return response('Shift deleted successfully.');
        }else{
            return response('Shift not found.');
        }
    }
}
