<?php

namespace App\Http\Controllers;

use App\Models\TaxSlab;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Gate;

class TaxSlabController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }

    public function index(){
        return view('taxslabs.index');
    }

    public function showAllTaxSlabs(Request $request){

        $columns_list = array(
            0 =>'id',
            1 =>'title',
            2 =>'min_amount',
            3 =>'max_amount',
            4 =>'fixed_deduction',
            5 =>'tax_percentage',
            6 =>'description',
            7 =>'status',
        );

        $totalDataRecord = TaxSlab::count();

        $totalFilteredRecord = $totalDataRecord;

        $limit_val = $request->input('length');
        $start_val = $request->input('start');
        $order = 'tax_slabs.'.$columns_list[$request->input('order.0.column')];
        $dir_val = 'desc';

        if(empty($request->input('search.value')))
        {
            $post_data = TaxSlab::offset($start_val)
                ->limit($limit_val)
                ->orderBy($order,$dir_val)
                ->get();
        }
        else {
            $search_text = $request->input('search.value');
            if ($search_text == 'Active' || $search_text == 'In-Active'){
                $search_text = ($search_text == 'Active')?'1':'0';
            }

            $post_data =  TaxSlab::where('id','LIKE',"%{$search_text}%")
                ->orWhere('title', 'LIKE',"%{$search_text}%")
                ->orWhere('description', 'LIKE',"%{$search_text}%")
                ->orWhere('status', $search_text)
                ->offset($start_val)
                ->limit($limit_val)
                ->orderBy($order,$dir_val)
                ->get();

            $totalFilteredRecord = TaxSlab::where('id','LIKE',"%{$search_text}%")
                ->orWhere('title', 'LIKE',"%{$search_text}%")
                ->orWhere('description', 'LIKE',"%{$search_text}%")
                ->orWhere('status',$search_text)
                ->count();
        }

        $data_val = array();
        if(!empty($post_data))
        {
            foreach ($post_data as $post_val)
            {
                $deletedata = $post_val->id;
                $id = base64_encode($deletedata);
                $dataedit =  route('edit.taxslab',['id'=>$id]);
                $status = ($post_val->status == 1)?"<span class='badge badge-success'>Active</span>":"<span class='badge badge-danger'>In-Active</span>";
                $desc = (strlen($post_val->description) >50 )?substr($post_val->description,0,100)." ...":$post_val->description;

                $delete_taxslab = Gate::allows("delete.taxslab")?"<button class='btn btn-danger delete-btn' data-id='{$id}' title='Delete'><i class='fa fa-trash'></i> </button>":"";
                $edit_taxslab = Gate::allows("edit.taxslab")?"<a class='btn btn-primary btn-style' href='{$dataedit}' title='Edit'><i class='fa fa-edit'></i> </a>":"";

                $postnestedData['id'] = $post_val->id;
                $postnestedData['title'] = $post_val->title;
                $postnestedData['min_amount'] = $post_val->min_amount;
                $postnestedData['max_amount'] = $post_val->max_amount;
                $postnestedData['fixed_deduction'] = $post_val->fixed_deduction;
                $postnestedData['tax_percentage'] = $post_val->tax_percentage;
                $postnestedData['description'] = $desc;
                $postnestedData['status'] = $status;
                $postnestedData['options'] = " <div class='btn-group'> {$edit_taxslab}  {$delete_taxslab}  </div>";
                $data_val[] = $postnestedData;
            }
        }
        $draw_val = $request->input('draw');
        $get_json_data = array(
            "draw"            => intval($draw_val),
            "recordsTotal"    => intval($totalDataRecord),
            "recordsFiltered" => intval($totalFilteredRecord),
            "data"            => $data_val
        );

        echo json_encode($get_json_data);

    }

    public function create(){
        return view('taxslabs.create');
    }

    public function store(Request $request){
        $request->validate([
            'title'          => 'required|string',
            'min_amount'     => 'required',
            'max_amount'     => 'required',
            'tax_percentage' => 'required',
            'fixed_deduction'      => 'required',
            'status'         => 'required',
        ]);

        TaxSlab::create($request->all());

        return redirect()->route('taxslab')->with('mesg','Tax Slab created successfully.');
    }

    public function edit($id){
        $id = base64_decode($id);
        $taxslab = TaxSlab::find($id);
        if ($taxslab){
            return view('taxslabs.edit',compact('taxslab'));
        }else{
            return redirect()->back()->with('error','Tax Slab not found.');
        }
    }

    public function update(Request $request){
        $request->validate([
            'title'          => 'required|string',
            'min_amount'     => 'required',
            'max_amount'     => 'required',
            'tax_percentage' => 'required',
            'fixed_deduction'      => 'required',
            'status'         => 'required',
        ]);

        $request->merge([
            'id' => base64_decode($request->id),
            'updated_at' => Carbon::now(),
        ]);

        $taxslab = TaxSlab::find($request->id);
        if ($taxslab){
            $taxslab->update($request->all());
            return redirect()->route('taxslab')->with('mesg','Tax Slab updated successfully.');
        }else{
            return redirect()->back()->with('error','Tax Slab not found.');
        }
    }

    public function delete($id){
        $id = base64_decode($id);
        $taxslab = TaxSlab::find($id);
        if ($taxslab){
            $taxslab->delete();
            return response('Tax Slab deleted successfully.');
        }else{
            return response('Tax Slab not found.');
        }
    }
}
