<?php

namespace App\Http\Middleware;

use App\Models\IP;
use Closure;
use Illuminate\Http\Request;

class IsValidIp
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @return mixed
     */
    public function handle(Request $request, Closure $next)
    {
        $valid_ip = IP::where('ip_address',$request->ip())
            ->get();
        if($valid_ip->isEmpty()){
            return redirect()->route('error')->with('error_mesg','Unauthorized System...!')->with('status',401);
        }
        return $next($request);
    }
}
