<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Notification extends Model
{
    use HasFactory;

    protected $guarded = [
        '_token',
    ];

    public function findUser(){
        return $this->belongsTo(User::class,'from_user_id');
    }

    public function sentNotification(){
        return $this->hasMany(NotificationSend::class);
    }

    public function createNotification($details){
        $to_users = $details['to_user_id'];

        foreach ($to_users as $user){
            $details['to_user_id'] = $user;
            Notification::create($details);
        }
    }
}
