<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Support\Facades\DB;

class Team extends Model
{
    use HasFactory,SoftDeletes;
    protected $guarded = ['_token'];

    public function findUser(){
        return $this->belongsTo(User::class,'team_head_user_id');
    }

    public function users(){
//        return $this->belongsToMany(User::class,'team_to_members','team_member_id');
        return $this->belongsToMany(User::class,'team_to_members');
    }

    public function availableUsers(){
        return DB::table('users')
            ->leftJoin('team_to_members','users.id','=','team_to_members.user_id')
            ->select('users.id','users.name')
            ->where('team_to_members.user_id',null)
            ->where('users.is_admin',0)
            ->get();
    }

}
