<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class UserAllowanceInfo extends Model
{
    use HasFactory;
    protected $table = 'user_allowance_info';
    protected $guarded = ['_token'];

    public function findAllowance(){
        return $this->belongsTo(Allowance::class,'allowance_id');
    }

    public function storeUserAllowances($user_id,$allowances){
        foreach ($allowances as $key => $allowance){
            UserAllowanceInfo::create([
                'user_id' => $user_id,
                'allowance_id' => $key,
                'amount' => $allowance,
            ]);
        }
        return true;
    }

    public function deleteUserAllowances($user_id){
        $user_allowances = UserAllowanceInfo::where('user_id',$user_id)->get();
        if ($user_allowances){
            foreach ($user_allowances as $allowance){
                $allowance->delete();
            }
        }
        return true;
    }
}
