<?php

namespace App\Traits;

use App\Models\User;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Mail;

trait EmailTrait {

    public function sendMail(){
        $email = "awesome@yopmail.com";
        $template = "thankyou";

        $data['name'] = "Awesome";
        $data['subject'] = "This is email from portal";
        $data['message'] = "You have been added to the Test Project";

        $to = $email;
        $from = config('app.mail_from_address');
        $subject = $data['subject'];

        try {
            Mail::send('layouts.email_templates.'.$template, compact('data'), function ($message) use ($to,$from,$subject){
                $message->to($to)
                    ->subject($subject)
                    ->from($from, $from);
            });

            return response()->json(['status' => true]);
        }catch (\Swift_SwiftException $e) {
            Log::channel('email_log')->info("Email Error : ".$e->getMessage());
            return response()->json(['status' => false, 'error', $e->getMessage()]);
        }
    }

    public function sendNewProjectMail($project_users, $project){
        $from = config('app.mail_from_address');
        $subject = "New project assigned (".$project->project_name.")";
        foreach ($project_users as $user){
            $user = User::find($user);
            if ($user && ($user->email != Auth::user()->email)){
                try{
                    $data = [
                        'from'          =>  $from,
                        'email'         =>  $user->email,
                        'uname'         =>  Auth::user()->name,
                        'subject'       =>  $subject,
                        'description'   =>  $project->description,
                        'created_date'  =>  date('M d, Y'),
                        'created_time'  =>  date('h:i A'),
                        'project_id'    =>  $project->id,
                        'project_name'  =>  $project->project_name
                    ];

                    Mail::send('projects.new_project', ['data' => $data],
                        function ($message) use ($data)
                        {
                            $message
                                ->from($data['from'])
                                ->to($data['email'])
                                ->subject($data['subject']);
                        });
                }catch (\Swift_SwiftException $e){
                    Log::channel('email_log')->info("Project Email Error : ".$e->getMessage());
                }
            }
        }
    }

    public function sendCommentMail($project_users, $project, $comment){
        $from = config('app.mail_from_address');
        $subject = Auth::user()->name." has new commented on ".$project->project_name;
        foreach ($project_users as $user){
            $user = User::find($user);
            if ($user && ($user->email != Auth::user()->email)){
                try{
                    $data = [
                        'from'          =>  $from,
                        'email'         =>  $user->email,
                        'uname'         =>  Auth::user()->name,
                        'subject'       =>  $subject,
                        'description'   =>  $project->description,
                        'created_date'  =>  date('M d, Y'),
                        'created_time'  =>  date('h:i A'),
                        'project_id'    =>  $project->id,
                        'project_name'  =>  $project->project_name,
                        'comment_id'    =>  $comment->id,
                        'comment_desc'  =>  $comment->description
                    ];

                    Mail::send('projects.project_comment', ['data' => $data],
                        function ($message) use ($data)
                        {
                            $message
                                ->from($data['from'])
                                ->to($data['email'])
                                ->subject($data['subject']);
                        });
                }catch (\Swift_SwiftException $e){
                    Log::channel('email_log')->info("Comment Email Error : ".$e->getMessage());
                }
            }
        }
    }

    public function sendNotificationMail($users, $notification){

        $from = config('app.mail_from_address');
        $subject = "New Notification";
        foreach ($users as $user){
            $user = User::find($user);
            if ($user){
                try{
                    $data = [
                        'from'          =>  $from,
                        'email'         =>  $user->email,
                        'uname'         =>  Auth::user()->name,
                        'subject'       =>  $subject,
                        'created_date'  =>  date('M d, Y'),
                        'created_time'  =>  date('h:i A')
                    ];

                    Mail::send('notifications.new_notification', ['data' => $data],
                        function ($message) use ($data)
                        {
                            $message
                                ->from($data['from'])
                                ->to($data['email'])
                                ->subject($data['subject']);
                        });
                }catch (\Swift_SwiftException $e){
                    Log::channel('email_log')->info("Notification Email Error : ".$e->getMessage());
                }
            }
        }
    }

}
