<?php require_once("include/constants.php") ?>
<!DOCTYPE html>
<head>
<meta charset="utf-8">
<meta http-equiv="X-UA-Compatible" content="IE=edge">
<link rel="icon" href="favicon.png">
<meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1">
<title>World's Leading Custom Logo Design Company</title>
<meta name="keywords" content="">
<meta name="description" content="">
<link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Poppins:300,400,500,600,700"> 
<!-- <link href="assets/css/style.css" rel="stylesheet"> -->
<!-- <link rel="stylesheet" type="text/css" href="assets/css/order-css.css"> -->
<!-- <link rel="stylesheet" type="text/css" href="assets/css/custom.css"> -->
<link rel="shortcut icon" href="assets/images/favicon.png">
<link rel="stylesheet" type="text/css" href="assets/css/billing.css">

<style>
	.checkout label { display: block; margin: 0 0 5px; font-weight: 500; }
	.checkout select { width: 48%; } 
	.checkout select.month-dropdown { margin: 0 3% 0 0; }
</style>

</head>


<body>
	
    <section class="order_new">
        <div class="container">
			
			<a class="logo" href="/"><img src="/assets/images/logo-black.png" alt="logo"></a>
			
			<div class="oder_col">
                <h2>Customer Details</h2>
                <table>
                    <tbody>
                        <tr>
                            <td>Name</td>
                            <td id="name">Processing</td>
                        </tr>
                        <tr>
                            <td>Email</td>
                            <td id="email">Processing</td>
                        </tr>
                        <tr>
                            <td>Phone</td>
                            <td id="phone">Processing</td>
                        </tr>
                    </tbody>
                </table>
            </div>

            <div class="oder_col">
                <h2>Billing Information</h2>
                <div>
                    <table>
                        <tbody>
                            <tr>
                                <td>Logo name</td>
                                <td id="logo_name_exact">Processing</td>
                            </tr>
                            <tr>
                                <td>Package</td>
                                <td>
                                    <select id="available_package">
                                        <?php require_once("include/packages_dropdown_options.php") ?>
                                    </select>
                                </td>
                            </tr>
                            <tr>
                                <td>Amount</td>
                                <td id="pkg_price">Processing</td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            </div>

            <div class="oder_col">
                <h2>Package details</h2>
                <div class="package_details">
                    <?php require_once("include/package_details.php") ?>
                </div>
            </div>

            <form class="checkout" action="https://www.anaxdesigns.com/code/post-billing" method="post">
				
				<h2><span class="pkg_name">Custom Logo Design</span> <span class="price_span">Processing</span></h2>
				
				<table>
					<tbody>
						<tr>
							<td>
								<label>Cardholder Name</label>
								<input required="" type="text" class="checkout-input checkout-name" autofocus="" name="name-on-credit-card">
								<?php
									$months = [ "",
									'January', 'February', 'March', 'April', 'May',
									'June', 'July', 'August', 'September',
									'October', 'November', 'December'
									];
								?>
							</td>
							<td>
								<label>Card Number</label>
								<input required="" minlength="16" maxlength="16" pattern="[0-9]{16}" type="text" class="checkout-input checkout-card" placeholder="" name="credit-card-number">
							</td>
							<td>
								<label>CVC</label>
								<input required="" type="text" minlength="3" maxlength="3" pattern="[0-9]{3}" class="cvc_check checkout-input checkout-cvc" placeholder="CVC" name="credit-card-cvc">
							</td>
						</tr>
						<tr>
							<td colspan="2">
								<label>Expiry Date</label>
								<select class="checkout-input checkout-exp month-dropdown" name="credit-card-expiry-month">
									<?php $starting_moth = (int)date("m", time()); ?>
									<?php for($i = $starting_moth; $i <= 12; $i++ ) : ?>
										<option value="<?= $i ?>" ><?= $i ?></option>
									<?php endfor ?>
								</select>
								<select class="checkout-input checkout-exp year-dropdown" name="credit-card-expiry-year" required>
									<?php $starting_year = (int)date("Y", time()); ?>
									<?php for($i = $starting_year; $i < $starting_year+10; $i++ ) : ?>
										<option value="<?= $i ?>" ><?= $i ?></option>
									<?php endfor ?>
								</select>
							</td>
							<td>
								<label>Zip Code</label>
								<input required="" type="text" minlength="5" maxlength="5" pattern="[0-9]{5}" class="checkout-input checkout-cvc" placeholder="Zip Code" name="credit-card-zip">
							</td>
						</tr>
					</tbody>
				</table>
                <div class="paywith">
					<p><label for="confirm"><input type="checkbox" id="confirm" required> I confirm, By purchasing this Plan, I agree <a href="/terms-and-conditions/">Terms & Conditions</a> </label></p>
					<p> Pay with your credit card</p> 
					<p><i class="payment_icon"></i></p>
				</div>
                <input type="hidden" name="final-pkg" id="final-pkg" value="" />
                <input type="hidden" name="final-pkg-price" id="final-pkg-price" value="" />
                <p><input type="submit" value="Start Now!" class="checkout-btn" name="send"> </p>
            </form>


        </div>
    </section>

    <?php include_once('common-footer.php') ?>


<script src="https://code.jquery.com/jquery-3.3.1.min.js" integrity="sha256-FgpCb/KJQlLNfOu91ta32o/NMZxltwRo8QtmkMRdAu8=" crossorigin="anonymous"></script>
<script>
    $(".year-dropdown").on("change", function(e)
    {
        var months = [ "",
            'January', 'February', 'March', 'April', 'May',
            'June', 'July', 'August', 'September',
            'October', 'November', 'December'
            ];

        var current_year = <?= $starting_year ?>;
        var target_year  = e.target.value;
        var starting_index = 1;
        var inner_html = ""
        if(current_year == target_year)
        {
            current_date = new Date();
            starting_index = current_date.getMonth() +1;
        }
        
        for(i=starting_index; i <= 12; i++)
            inner_html += "<option value='" + i + "'>" + i + "</option>";
        $(".month-dropdown").html(inner_html);
    });
</script>
<?php require("./include/javascript_functions.php") ?>
<script>
    $(document).ready(function()
    {
        $.get( "https://www.anaxdesigns.com/code/get_user_session", { }, function(data){
            $.each( data["data"], function (index, value){
                 index = index.replace("order-step-2-", "");
                 index = index.split("-").join("_");
                 if(index == "pkg_price")
                    $("#"+index).html("$" + value);
                 else
                    $("#"+index).html(value);
                }
            );
        });

        $("#available_package").on("change", function(e){
            var pkg = $("#available_package").val();
            changePackage(pkg);
			$('.pkg_name').text(pkg);
        });

        setTimeout(function(){
            var pkg = $("#available_package").val();
            changePackage(pkg);
			$('.pkg_name').text(pkg);
        }, 3000);
		
		 $(".cvc_check, .checkout-card").on("keypress keyup blur",function (event) {
			$(this).val($(this).val().replace(/[^0-9\.]/g,''));
            if ((event.which != 46 || $(this).val().indexOf('.') != -1) && (event.which < 48 || event.which > 57)) {
                event.preventDefault();
            }
        });

    });
</script>

<?php require("./include/chat.php") ?>

</body>