@extends('layouts.app')
@section('page-title','Show Interview')

@push('css')
    <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
@endpush

@section('content')

    <div id="content" class="pmd-content admin section">

        <!-- Title -->
        <h1>@yield('page-title')</h1>
        <!-- End Title -->
        <!--breadcrumb start-->
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb pmd-breadcrumb">
                <li class="breadcrumb-item">
                    <a href="{{route('dashboard')}}">Dashboard</a>
                </li>
                <li class="breadcrumb-item">Interview</li>
                <li class="breadcrumb-item active" aria-current="page">@yield('page-title')</li>
            </ol>
        </nav>
        <!-- Basic Information -->
        <div class="row">
            <div class="col-12">
                <!-- Tab panes -->
                <div class="tab-content">
                    <!-- About Tab -->
                    <div role="tabpanel" class="tab-pane active" id="about">
                        <div class="card pmd-card">
                            <div class="card-body">
                                <div class="details-tab">
                                    <div class="d-flex flex-row align-items-center mb-2">
                                        <h3 class="card-title media-body">Basic Information</h3>
                                    </div>
                                    <div class="row view-basic-card">

                                        <div class="col-12 col-md-6 col-lg-3">
                                            <label class="pmd-list-subtitle">Canidate Name</label>
                                            <p class="pmd-list-title">{{$particular_record->name ?? 'N/A'}}</p>
                                        </div>
                                        <div class="col-12 col-md-6 col-lg-3">
                                            <label class="pmd-list-subtitle">Father Name</label>
                                            <p class="pmd-list-title">{{$particular_record->fathername ?? 'N/A'}}</p>
                                        </div>
                                        <div class="col-12 col-md-6 col-lg-3">
                                            <label class="pmd-list-subtitle">Email</label>
                                            <p class="pmd-list-title"><a href="mailto: {{$particular_record->email}}" title="{{$particular_record->email}}">{{$particular_record->email}}</a></p>
                                        </div>
                                        <div class="col-12 col-md-6 col-lg-3">
                                            <label class="pmd-list-subtitle">Phone</label>
                                            <p class="pmd-list-title">{{$particular_record->phone ?? 'N/A'}}</p>
                                        </div>
                                        <div class="col-12 col-md-6 col-lg-3">
                                            <label class="pmd-list-subtitle">Cnic</label>
                                            <p class="pmd-list-title">{{$particular_record->cnic_no ?? 'Continue'}} </p>
                                        </div>
                                        <div class="col-12 col-md-6 col-lg-3">
                                            <label class="pmd-list-subtitle">Gender</label>
                                            <p class="pmd-list-title">{{$particular_record->gender ?? 'N/A'}}</p>
                                        </div>
                                        <div class="col-12 col-md-6 col-lg-3">
                                            <label class="pmd-list-subtitle">Marital Status</label>
                                            <p class="pmd-list-title">{{$particular_record->marital_status ?? 'N/A'}}</p>
                                        </div>

                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="demo">

            <div class="row">
                @foreach($interview as $value)
                <div class="col-md-3 col-sm-8 card-detail-view" data-id="{{$value->id}}">
                    <div class="pricingTable">
                        <div class="pricingTable-header">
                            <h4 class="heading">{{$value->findJobTitle->title}}</h4>
                            <div class="price-value">{{$value->findDepartment->title}}
                            </div>
                        </div>
                        <div class="row">
                            {{--<div class="col-sm-6">
                                <span>Date Applied</span>
                            </div>--}}
                            <div class="col-sm-12">
                                <span><b>Date Applied : </b>{{\Carbon\Carbon::make($value->created_at)->diffForHumans()}}</span>
                            </div>
                            <div class="col-sm-12">
                                    @php $count_array = array_count_values(json_decode($value->status)); @endphp
                                    @foreach(json_decode($value->status) as $key=>$status_value)
                                       <span class="badge badge-primary">{{$status_value}}</span>
                                        @if (!$loop->last)
                                            ->
                                        @endif
                                    @endforeach
                            </div>
                        </div>

                    </div>
                </div>
                @endforeach
                </div>

        </div>

    </div>

@endsection

@push('js')
    <script src="{{asset('js/jquery-mask/src/jquery.mask.js')}}"></script>
    <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
    <script>
        $(document).ready(function () {
           $(document).on('click','.card-detail-view',function (e) {
               id = $(this).attr('data-id');
               interviewDetail(id);

           })

        });

        function interviewDetail(id) {
            $.ajax({
                url: '{{route('detail.interview')}}',
                type: 'post',
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                },
                data:{id:id},
                success: function(response){
                    console.log(response);
                }
            });
        }
    </script>

@endpush
