@extends('layouts.app')
@section('page-title','Update Interview')

@push('css')
    <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
    <link rel="stylesheet" href="//cdnjs.cloudflare.com/ajax/libs/timepicker/1.3.5/jquery.timepicker.min.css">
    <link rel="stylesheet" type="text/css" href="{{ asset('plugins/jQuery-ClockTimePicker/dist/bootstrap-clockpicker.min.css') }}">
@endpush

@section('content')

    <div id="content" class="pmd-content admin section">
        <!-- Title -->
        <h1>@yield('page-title')</h1>
        <!-- End Title -->
        <!--breadcrumb start-->
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb pmd-breadcrumb">
                <li class="breadcrumb-item">
                    <a href="{{route('dashboard')}}">Dashboard</a>
                </li>
                <li class="breadcrumb-item">Interview</li>
                <li class="breadcrumb-item active" aria-current="page">@yield('page-title')</li>
            </ol>
        </nav>
        <!--breadcrumb end-->

        <div class="row">
            <div class="col-md-12">
                <div class="card pmd-card" style="padding-left: 2%;">

                    <form method="post" autocomplete="off" action="{{route('update.interview')}}" id="user_form" enctype="multipart/form-data">
                        @csrf
                        <input type="hidden" name="id" value="{{base64_encode($interview->id)}}">
                            <!-- Basic Information -->
                            <div class="details-tab">
                                <h3 class="card-title">Interview</h3>
                                <div class="row">
                                    <div class="col-12 col-sm-6 col-md-3">
                                        <div class="form-group pmd-textfield pmd-textfield-floating-label ">
                                            <label for="fn" class="col-form-label control-label">Name</label>
                                            <input type="text" class="form-control" name="name"
                                                   aria-describedby="emailHelp" id="name" value="{{$interview->name ?? old('name')}}" required>
                                            @error('name')
                                            <p>
                                                <strong class="text-danger">{{$message}}</strong>
                                            </p>
                                            @enderror()
                                        </div>
                                    </div>
                                    <div class="col-12 col-sm-6 col-md-3">
                                        <div class="form-group pmd-textfield pmd-textfield-floating-label ">
                                            <label for="ln" class="col-form-label control-label">Father's Name</label>
                                            <input type="text" class="form-control" name="fathername" id="fn"
                                                   aria-describedby="emailHelp" value="{{$interview->fathername ?? old('fathername')}}" required>
                                            @error('fathername')
                                            <p>
                                                <strong class="text-danger">{{$message}}</strong>
                                            </p>
                                            @enderror()
                                        </div>
                                    </div>
                                    <div class="col-12 col-sm-6 col-md-3">
                                        <div class="form-group pmd-textfield pmd-textfield-floating-label ">
                                            <label for="personal-email" class="col-form-label control-label">Email</label>
                                            <input type="email" class="form-control" name="email" id="personal-email"
                                                   aria-describedby="emailHelp" value="{{$interview->email ?? old('email')}}" required>

                                            @error('email')
                                            <p>
                                                <strong class="text-danger">{{$message}}</strong>
                                            </p>
                                            @enderror()
                                        </div>
                                    </div>

                                    <div class="col-12 col-sm-6 col-md-3">
                                        <div class="form-group pmd-textfield pmd-textfield-floating-label ">
                                            <label for="phone" class="col-form-label control-label">Phone</label>
                                            <input type="text" class="form-control" name="phone"
                                                   aria-describedby="emailHelp" id="phone" value="{{$interview->phone ?? old('phone')}}">
                                            @error('phone')
                                            <p>
                                                <strong class="text-danger">{{$message}}</strong>
                                            </p>
                                            @enderror()
                                        </div>
                                    </div>
                                    <div class="col-12 col-sm-6 col-md-3">
                                        <div class="form-group pmd-textfield pmd-textfield-floating-label ">
                                            <label for="personal-email" class="col-form-label control-label">Cnic No</label>
                                            <input type="text" class="form-control" name="cnic_no" id="personal-cnic"
                                                   aria-describedby="emailHelp" value="{{$interview->cnic_no ?? old('cnic_no')}}"maxlength="13">

                                            @error('cnic_no')
                                            <p>
                                                <strong class="text-danger">{{$message}}</strong>
                                            </p>
                                            @enderror()
                                        </div>
                                    </div>
                                    <div class="col-12 col-sm-6 col-md-3">
                                        <label for="email" class="d-block title-label">Gender</label>
                                        <div class="custom-control custom-radio pmd-radio custom-control-inline">
                                            <input type="radio" id="male" name="gender" class="custom-control-input" value="Male"
                                                   @if($interview->gender == 'Male') checked @endif required>
                                            <label class="custom-control-label pmd-radio-ripple-effect" for="male">Male</label>
                                        </div>
                                        <div class="custom-control custom-radio pmd-radio custom-control-inline">
                                            <input type="radio" id="female" name="gender" class="custom-control-input" value="Female"
                                                   @if($interview->gender == 'Female') checked @endif>
                                            <label class="custom-control-label pmd-radio-ripple-effect" for="female">Female</label>
                                        </div>
                                    </div>
                                    <div class="col-12 col-sm-6 col-md-3">
                                        <label for="marital" class="d-block title-label">Marital Status</label>
                                        <div class="custom-control custom-radio pmd-radio custom-control-inline">
                                            <input type="radio" id="married" name="marital_status" class="custom-control-input" value="Married"
                                                   @if($interview->marital_status == 'Married') checked @endif>
                                            <label class="custom-control-label pmd-radio-ripple-effect" for="married">Married</label>
                                        </div>
                                        <div class="custom-control custom-radio pmd-radio custom-control-inline">
                                            <input type="radio" id="unmarried" name="marital_status" class="custom-control-input" value="Unmarried"
                                                   @if($interview->marital_status == 'Unmarried') checked @endif>
                                            <label class="custom-control-label pmd-radio-ripple-effect" for="unmarried">Unmarried</label>
                                        </div>
                                    </div>

                                    <div class="col-12 col-sm-6 col-md-3">
                                        <div class="form-group pmd-textfield pmd-textfield-floating-label ">
                                            <label for="office_timing_id" class="col-form-label control-label">Office Timing</label>
                                            <input type="text" class="form-control timepicker " name="office_timing" id="office_timing"
                                                   aria-describedby="emailHelp" value="{{$interview->office_timing ?? old('office_timing')}}" >

                                            @error('office_timing')
                                            <p>
                                                <strong class="text-danger">{{$message}}</strong>
                                            </p>
                                            @enderror()
                                        </div>
                                    </div>
                                    <div class="col-12 col-sm-6 col-md-3">
                                        <div class="form-group pmd-textfield pmd-textfield-floating-label">
                                            <label for="datepickerjoin" class="col-form-label control-label">Interview Schedule</label>
                                            <input type="text" class="form-control" name="interview_schedule" min="0"
                                                   aria-describedby="emailHelp" id="datetimepickerinterview" value="{{$interview->interview_schedule ?? old('interview_schedule')}}" >
                                            @error('interview_schedule')
                                            <p><strong class="text-danger">{{$message}}</strong></p>
                                            @enderror()
                                        </div>
                                    </div>

                                    <div class="col-12 col-sm-6 col-md-3">
                                        <label for="email" class="d-block title-label">Currently Employed</label>
                                        <div class="custom-control custom-radio pmd-radio custom-control-inline">
                                            <input type="radio" id="yes" name="currently_employed" class="custom-control-input" value="1"@if($interview->currently_employed == '1') checked @endif required>
                                            <label class="custom-control-label pmd-radio-ripple-effect" for="yes">Yes</label>
                                        </div>
                                        <div class="custom-control custom-radio pmd-radio custom-control-inline">
                                            <input type="radio" id="no" name="currently_employed" class="custom-control-input" value="0" @if($interview->currently_employed == '0') checked @endif>
                                            <label class="custom-control-label pmd-radio-ripple-effect" for="no">No</label>
                                        </div>
                                    </div>

                                    <div class="col-12 col-sm-6 col-md-3">
                                        <div class="form-group pmd-textfield pmd-textfield-floating-label ">
                                            <label for="current_company">Current Company</label>
                                            <input type="text" class="form-control" name="current_company"
                                                   aria-describedby="emailHelp" id="current_company" value="{{$interview->current_company ?? old('current_company')}}">
                                            @error('current_company')
                                            <p>
                                                <strong class="text-danger">{{$message}}</strong>
                                            </p>
                                            @enderror()
                                        </div>
                                    </div>
                                    <div class="col-12 col-sm-6 col-md-3">
                                        <div class="form-group pmd-textfield pmd-textfield-floating-label ">
                                            <label for="designation_id" class="col-form-label control-label">Current Designation</label>
                                            <input type="text" class="form-control" name="designation"
                                                   aria-describedby="emailHelp" id="designation" value="{{$interview->designation ?? old('designation')}}">
                                            @error('designation')
                                            <p>
                                                <strong class="text-danger">{{$message}}</strong>
                                            </p>
                                            @enderror()
                                        </div>
                                    </div>
                                    <div class="col-12 col-sm-6 col-md-3">
                                        <div class="form-group  pmd-textfield pmd-textfield-floating-label">
                                            <label for="exp_id">Experience</label>
                                            <input type="text" class="form-control" name="experience"
                                                   aria-describedby="emailHelp" id="experience_id" value="{{$interview->experience ?? old('experience')}}">
                                            @error('experience')
                                            <p>
                                                <strong class="text-danger">{{$message}}</strong>
                                            </p>
                                            @enderror()
                                        </div>
                                    </div>
                                    <div class="col-12 col-sm-6 col-md-3">
                                        <div class="form-group pmd-textfield pmd-textfield-floating-label ">
                                            <label for="current_timing_id" class="col-form-label control-label">Current Timing</label>
                                            <input type="text" class="form-control timepicker" name="current_timing" id="current_timing"
                                                   aria-describedby="emailHelp" value="{{$interview->current_timing ?? old('current_timing')}}">
                                            @error('current_timing')
                                            <p>
                                                <strong class="text-danger">{{$message}}</strong>
                                            </p>
                                            @enderror()
                                        </div>
                                    </div>
                                    <div class="col-12 col-sm-6 col-md-3">
                                        <div class="form-group pmd-textfield pmd-textfield-floating-label ">
                                            <label for="current_salary">Current Salary</label>
                                            <input type="number" class="form-control" name="current_salary" min="0"
                                                   aria-describedby="emailHelp" id="current_salary" value="{{$interview->current_salary ?? old('current_salary')}}">
                                            @error('current_salary')
                                            <p>
                                                <strong class="text-danger">{{$message}}</strong>
                                            </p>
                                            @enderror()
                                        </div>
                                    </div>
                                    <div class="col-12 col-sm-6 col-md-3">
                                        <div class="form-group pmd-textfield pmd-textfield-floating-label ">
                                            <label for="excepted_salary">Excepted Salary</label>
                                            <input type="number" class="form-control" name="expected_salary" min="0"
                                                   aria-describedby="emailHelp" id="expected_salary_id" value="{{$interview->expected_salary ?? old('expected_salary')}}">
                                            @error('excepted_salary')
                                            <p>
                                                <strong class="text-danger">{{$message}}</strong>
                                            </p>
                                            @enderror()
                                        </div>
                                    </div>
                                    <div class="col-12 col-sm-6 col-md-3">
                                        <div class="form-group pmd-textfield pmd-textfield-floating-label ">
                                            <label for="joining_date" class="col-form-label control-label">Joining Date</label>
                                            <input type="text" class="form-control" name="joining_date"
                                                   aria-describedby="emailHelp" id="datepickerjoin" value="{{$interview->joining_date??old('joining_date')}}">
                                            @error('joining_date')
                                            <p>
                                                <strong class="text-danger">{{$message}}</strong>
                                            </p>
                                            @enderror()
                                        </div>
                                    </div>

                                </div>

                                <!-- Address Details -->
                                <div class="details-tab">
                                    <h3 class="card-title">Address Detail</h3>
                                    <div class="row">

                                        <div class="col-12 col-sm-6 col-md-3">
                                            <div class="form-group pmd-textfield pmd-textfield-floating-label ">
                                                <label for="city_id" class="col-form-label control-label">City</label>
                                                <input type="text" class="form-control" name="city"
                                                       aria-describedby="emailHelp" id="city_id" value="{{$interview->city ??old('city')}}">
                                                @error('city')
                                                <p>
                                                    <strong class="text-danger">{{$message}}</strong>
                                                </p>
                                                @enderror()
                                            </div>
                                        </div>

                                        <div class="col-12 col-sm-6 col-md-3">
                                            <div class="form-group pmd-textfield pmd-textfield-floating-label ">
                                                <label for="present_address_id" class="col-form-label control-label">Present Address</label>
                                                <input type="text" class="form-control" name="present_address"
                                                       aria-describedby="emailHelp" id="present_address_id" value="{{$interview->present_address ??old('present_address')}}">
                                                @error('present_address')
                                                <p>
                                                    <strong class="text-danger">{{$message}}</strong>
                                                </p>
                                                @enderror()
                                            </div>
                                        </div>

                                        <div class="col-12 col-sm-6 col-md-3">
                                            <div class="form-group pmd-textfield pmd-textfield-floating-label ">
                                                <label for="permanent_address_id" class="col-form-label control-label">Permanent Address</label>
                                                <input type="text" class="form-control" name="permanent_address"
                                                       aria-describedby="emailHelp" id="permanent_address_id" value="{{$interview->permanent_address ??old('permanent_address')}}">
                                                @error('permanent_address')
                                                <p>
                                                    <strong class="text-danger">{{$message}}</strong>
                                                </p>
                                                @enderror()
                                            </div>
                                        </div>

                                        <div class="col-12 col-sm-6 col-md-3">
                                            <div class="form-group pmd-textfield pmd-textfield-floating-label ">
                                                <label for="postal_code_id" class="col-form-label control-label">Postal Code</label>
                                                <input type="number" class="form-control" name="postal_code"
                                                       aria-describedby="emailHelp" id="postal_code_id" value="{{$interview->postal_code ??old('postal_code')}}">
                                                @error('postal_code')
                                                <p>
                                                    <strong class="text-danger">{{$message}}</strong>
                                                </p>
                                                @enderror()
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <!-- Applied For -->
                                <div class="details-tab">
                                    <h3 class="card-title">Applied For</h3>
                                    <div class="row">
                                        <div class="col-3 col-md-3 col-md-3">
                                            <div class="form-group pmd-textfield pmd-textfield-floating-label">
                                                <label for="department">Department</label>
                                                <select name="department_id" id="department_id" class="form-control ">
                                                    <option value="" hidden></option>
                                                    @forelse($department as $dpt)
                                                        <option value="{{$dpt->id}}" @if($interview->department_id == $dpt->id) selected @endif >{{$dpt->title}}</option>

{{--                                                        <option {{ old('department') == $dpt->title ? "selected" : "" }} value="{{$dpt->title}}" @if($dpt->title == $dpt ) selected @endif>{{$dpt->title}}</option>--}}
                                                    @empty
                                                    @endforelse
                                                </select>
                                                @error('department_id')
                                                <p>
                                                    <strong class="text-danger">{{$message}}</strong>
                                                </p>
                                                @enderror()
                                            </div>
                                        </div>
                                        <div class="col-3 col-md-3 col-md-3">
                                            <div class="form-group pmd-textfield pmd-textfield-floating-label">
                                                <label for="job_title">Job Title</label>
                                                <select name="job_title_id" id="job_title_id" class="form-control ">
                                                    <option value="" hidden></option>
                                                    @forelse($job_titles as $jt)
                                                        <option value="{{$jt->id}}" @if($interview->job_title_id == $jt->id) selected @endif >{{$jt->title}}</option>

                                                    @empty
                                                    @endforelse
                                                </select>
                                                @error('job_title_id')
                                                <p>
                                                    <strong class="text-danger">{{$message}}</strong>
                                                </p>
                                                @enderror()
                                            </div>
                                        </div>

                                    </div>
                                </div>



                                <!-- Referance Details -->
                            <div class="details-tab">
                                <h3 class="card-title">Referance</h3>
                                <div class="row">
                                    <div class="col-12 refernace-add">
                                        @if(is_array($referance))
                                            @foreach($referance as $value)
                                        <div class="row">
                                            <div class="col-2 ">
                                                <div class="form-group pmd-textfield pmd-textfield-floating-label">
                                                    <label for="r_name_id">Name</label>
                                                    <input type="text" class="form-control" name="r_name[]"
                                                           aria-describedby="emailHelp" id="r_name_id" value="{{$value['r_name']}}">
                                                    @error('r_name')
                                                    <p>
                                                        <strong class="text-danger">{{$message}}</strong>
                                                    </p>
                                                    @enderror()
                                                </div>
                                            </div>
                                            <div class="col-2">
                                                <div class="form-group pmd-textfield pmd-textfield-floating-label">
                                                    <label for="r_contact_id">Contact</label>
                                                    <input type="text" class="form-control" name="r_contact[]"
                                                           aria-describedby="emailHelp" id="r_contact_id" value="{{$value['r_contact']}}">
                                                    @error('r_contact')
                                                    <p>
                                                        <strong class="text-danger">{{$message}}</strong>
                                                    </p>
                                                    @enderror()
                                                </div>
                                            </div>
                                            <div class="col-2">
                                                <div class="form-group pmd-textfield pmd-textfield-floating-label">
                                                    <label for="r_relation_id">Relation</label>
                                                    <input type="text" class="form-control" name="r_relation[]"
                                                           aria-describedby="emailHelp" id="r_relation_id" value="{{$value['r_relation']}}">
                                                    @error('r_relation')
                                                    <p>
                                                        <strong class="text-danger">{{$message}}</strong>
                                                    </p>
                                                    @enderror()
                                                </div>
                                            </div>
                                            <div class="col-2">
                                                <div class="form-group pmd-textfield pmd-textfield-floating-label">
                                                    <label for="r_company_id">Company</label>
                                                    <input type="text" class="form-control" name="r_company[]"
                                                           aria-describedby="emailHelp" id="r_company_id" value="{{$value['r_company']}}">
                                                    @error('r_company')
                                                    <p>
                                                        <strong class="text-danger">{{$message}}</strong>
                                                    </p>
                                                    @enderror()
                                                </div>
                                            </div>
                                            <div class="col-2">
                                                <div class="form-group pmd-textfield pmd-textfield-floating-label">
                                                    <label for="r_position_id">Designation</label>
                                                    <input type="text" class="form-control" name="r_position[]"
                                                           aria-describedby="emailHelp" id="r_position_id" value="{{$value['r_position']}}">
                                                    @error('r_position')
                                                    <p>
                                                        <strong class="text-danger">{{$message}}</strong>
                                                    </p>
                                                    @enderror()
                                                </div>
                                            </div>
                                            <div class="col-2">
                                                <p class="add-more-p">
                                                    <a href="javascript:void(0)" class="remove-stops btn btn-danger"  onclick="$(this).parent().parent().parent().remove();" >Remove</a>
                                                </p>
                                            </div>
                                        </div>
                                        @endforeach
                                        @endif

                                    </div>
                                    <div class="col-12">
                                        <p class="add-more-p">
                                            <a  class="btn btn-primary text-white add-more-referance float-right">Add More</a>
                                        </p>
                                    </div>
                                </div>

                                <!-- Comment Details -->
                                <div class="details-tab">
                                    <h3 class="card-title">Comments</h3>
                                    <div class="row">
                                        <div class="col-12 col-sm-6 col-md-6">
                                            <div class="form-group pmd-textfield pmd-textfield-floating-label">
                                                <textarea id="comment" class="form-control" rows="5" name="comment"> {{$interview->comment}}</textarea>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <!-- Attachments -->
                                <div class="details-tab">
                                    <h3 class="card-title">Other Details & Attachments</h3>
                                    <div class="row align-items-center">
                                        <div class="col-2 col-md-2 col-md-2">
                                            <div class="form-group pmd-textfield pmd-textfield-floating-label">
                                                <label for="status_id">Status</label>
                                                <select name="status[]" id="status_id" class="form-control select2 select2-hidden-accessible " multiple=""  style="width: 100%;">

                                                    @forelse($status as $value)
                                                        @if(in_array($value,json_decode($interview->status)))
                                                            <option value="{{$value}}" selected >{{$value}}</option>
                                                        @else
                                                            <option value="{{$value}}">{{$value}}</option>
                                                        @endif
                                                    @empty
                                                    @endforelse

                                                </select>
                                                @error('status')
                                                <p>
                                                    <strong class="text-danger">{{$message}}</strong>
                                                </p>
                                                @enderror()
                                            </div>
                                        </div>
                                        <div class="col-2 col-md-2 col-md-2">
                                            <div class="form-group mb-0">
                                                <label for="resume_cv" class="custom-file-upload mb-0">
                                                    <i class="fa fa-cloud-upload"></i> Upload Resume
                                                </label>
                                                <input type="file" class="form-control" name="resume_cv" id="resume_cv"
                                                       aria-describedby="emailHelp" value="{{$interview->resume ?? old('resume_cv')}}" accept=".doc, .docx,.pdf" style="display: none">

                                                @error('resume_cv')
                                                <p>
                                                    <strong class="text-danger">{{$message}}</strong>
                                                </p>
                                                @enderror()
                                            </div>
                                        </div>

                                        <div class="col-2 col-md-2 col-md-2">
                                            <div class="form-group mb-0">
                                                <label for="cover_attachment" class="custom-file-upload mb-0">
                                                    <i class="fa fa-cloud-upload"></i> Upload Cover Letter
                                                </label>
                                                <input type="file" class="form-control" name="cover_attachment" id="cover_attachment"
                                                       aria-describedby="emailHelp" value="{{$interview->cover_letter ?? old('cover_attachment')}}" accept=".doc, .docx,.pdf" style="display: none">
                                                @error('cover_attachment')
                                                <p>
                                                    <strong class="text-danger">{{$message}}</strong>
                                                </p>
                                                @enderror()
                                            </div>
                                        </div>
                                        <div class="col-2 col-md-2 col-md-2">
                                            <div class="form-group mb-0">
                                                <label for="" class="offer-label mb-0">
                                                     Offer Letter
                                                </label>
                                                <select name="offer_accept_reject" id="offer_Accetp_reject" class="form-control">
                                                    <option value="" selected>Select Type</option>
                                                    <option value="1" @if($interview->offer_accept_reject == 1) selected @endif>Offer Accepted</option>
                                                    <option value="2" @if($interview->offer_accept_reject == 2) selected @endif>Offer Rejected</option>
                                                    <option value="0" @if($interview->offer_accept_reject == 0) selected @endif>UnConfirmed</option>
                                                </select>

                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            </div>
                        <div class="card-footer pmd-card-border">
                            <button class="btn pmd-ripple-effect btn-primary pmd-btn-raised " type="submit">Update</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection

@push('js')
    <script src="{{asset('js/jquery-mask/src/jquery.mask.js')}}"></script>
    <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
    <script src="//cdnjs.cloudflare.com/ajax/libs/timepicker/1.3.5/jquery.timepicker.min.js"></script>
    <script type="text/javascript" src="{{ asset('plugins/jQuery-ClockTimePicker/dist/bootstrap-clockpicker.min.js') }}"></script>

    <script>
        let global_sum = 0;
        $(document).ready(function () {
            $('#status_id').select2();
            $(document).on('change','#resume_cv', function(){
                var i = $(this).prev('label').clone();
                var file = $('#resume_cv')[0].files[0].name;
                $(this).prev('label').text(file);
            });

            $(document).on('change','#cover_attachment', function(){
                var i = $(this).prev('label').clone();
                var file = $('#cover_attachment')[0].files[0].name;
                $(this).prev('label').text(file);
            });

            $('#phone').mask("00000000000");
            $('#personal-cnic').mask("0000000000000");

            // $('.timepicker').timepicker({
            //     timeFormat: 'h:mm p',
            //     interval: 60,
            //     dropdown: true,
            //     scrollbar: true
            // });
            $('.timepicker').clockpicker({
                autoclose: true
            });

            $('#datetimepickerinterview').datetimepicker({
                format:'DD/MM/YYYY h:m a',
            });

            var dateToday = new Date();
            // Add start date date and time picker
            $('#datepickerjoin').datetimepicker({
                minDate: dateToday,
                format: 'DD-MM-YYYY'
            });

            $(document).on('click','.add-more-referance', function(e){
                var html = '<div class="row">';
                html += '<div class="col-2">';
                html += '<div class="form-group pmd-textfield pmd-textfield-floating-label">';
                html += '<label for="r_name_id">Name</label>';
                html += '<input type="text" class="form-control" name="r_name[]" aria-describedby="emailHelp" id="r_name_id">';
                html += '</div>';
                html += '</div>   ';
                html += '<div class="col-2">';
                html += '<div class="form-group pmd-textfield pmd-textfield-floating-label">';
                html += '<label for="r_contact_id">Contact</label>';
                html += '<input type="text" class="form-control" name="r_contact[]" aria-describedby="emailHelp" id="r_contact_id">';
                html += '</div>';
                html += '</div>   ';
                html += '<div class="col-2">';
                html += '<div class="form-group pmd-textfield pmd-textfield-floating-label">';
                html += '<label for="r_relation_id">Relation</label>';
                html += '<input type="text" class="form-control" name="r_relation[]" aria-describedby="emailHelp" id="r_relation_id">';
                html += '</div>';
                html += '</div>   ';
                html += '<div class="col-2">';
                html += '<div class="form-group pmd-textfield pmd-textfield-floating-label">';
                html += '<label for="r_company_id">Company</label>';
                html += '<input type="text" class="form-control" name="r_company[]" aria-describedby="emailHelp" id="r_company_id">';
                html += '</div>';
                html += '</div>   ';
                html += '<div class="col-2">';
                html += '<div class="form-group pmd-textfield pmd-textfield-floating-label">';
                html += '<label for="r_position_id">Position</label>';
                html += '<input type="text" class="form-control" name="r_position[]" aria-describedby="emailHelp" id="r_position_id">';
                html += '</div>';
                html += '</div>   ';
                html += '<div class="col-2">';
                html += '<p class="add-more-p">';
                html += '<a href="javascript:void(0)" class="remove-time btn btn-danger" onclick="$(this).parent().parent().parent().remove();">Remove</a>';
                html += ' </p>';
                html += '</div>';

                html += '    </div>';
                html += '    </div>';

                $('.refernace-add').append(html);

            });

            $('.remove-time').click(function () {
                $(this).parent().parent().parent().remove();
            });
        });

    </script>
@endpush
