@extends('layouts.app')
@section('page-title','Show Interview')

@push('css')
    <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/@fancyapps/ui@4.0/dist/fancybox.css"/>
@endpush

@section('content')

    <div id="content" class="pmd-content admin section">

        <!-- Title -->
        <h1>@yield('page-title')</h1>
        <!-- End Title -->
        <!--breadcrumb start-->
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb pmd-breadcrumb">
                <li class="breadcrumb-item">
                    <a href="{{route('dashboard')}}">Dashboard</a>
                </li>
                <li class="breadcrumb-item">Interview</li>
                <li class="breadcrumb-item active" aria-current="page">@yield('page-title')</li>
            </ol>
        </nav>
        <!-- Basic Information -->
        <div class="row">
            <div class="col-12">
                <!-- Tab panes -->
                <div class="tab-content">
                    <!-- About Tab -->
                    <div role="tabpanel" class="tab-pane active" id="about">
                        <div class="card pmd-card">
                            <div class="card-body">
                                <div class="details-tab">
                                    <div class="d-flex flex-row align-items-center mb-2">
                                        <h3 class="card-title media-body">Basic Information</h3>
                                    </div>
                                    <div class="row view-basic-card">

                                        <div class="col-12 col-md-6 col-lg-3">
                                            <label class="pmd-list-subtitle">Canidate Name</label>
                                            <p class="pmd-list-title">{{$particular_record->name ?? 'N/A'}}</p>
                                        </div>
                                        <div class="col-12 col-md-6 col-lg-3">
                                            <label class="pmd-list-subtitle">Father Name</label>
                                            <p class="pmd-list-title">{{$particular_record->fathername ?? 'N/A'}}</p>
                                        </div>
                                        <div class="col-12 col-md-6 col-lg-3">
                                            <label class="pmd-list-subtitle">Email</label>
                                            <p class="pmd-list-title"><a href="mailto: {{$particular_record->email??'N/A'}}" title="{{$particular_record->email??'N/A'}}">{{$particular_record->email??'N/A'}}</a></p>
                                        </div>
                                        <div class="col-12 col-md-6 col-lg-3">
                                            <label class="pmd-list-subtitle">Phone</label>
                                            <p class="pmd-list-title">{{$particular_record->phone ?? 'N/A'}}</p>
                                        </div>
                                        <div class="col-12 col-md-6 col-lg-3">
                                            <label class="pmd-list-subtitle">Cnic</label>
                                            <p class="pmd-list-title">{{$particular_record->cnic_no ?? 'N/A'}} </p>
                                        </div>
                                        <div class="col-12 col-md-6 col-lg-3">
                                            <label class="pmd-list-subtitle">Gender</label>
                                            <p class="pmd-list-title">{{$particular_record->gender ?? 'N/A'}}</p>
                                        </div>
                                        <div class="col-12 col-md-6 col-lg-3">
                                            <label class="pmd-list-subtitle">Marital Status</label>
                                            <p class="pmd-list-title">{{$particular_record->marital_status ?? 'N/A'}}</p>
                                        </div>

                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="demo">

            <div class="row">
                @foreach($interview as $value)
                <div class="col-md-3 col-sm-8 card-detail-view" data-id="{{$value->id}}">
                    <div class="pricingTable">
                        <div class="pricingTable-header">
                            <h4 class="heading">{{$value->findJobTitle->title??'N/A'}}</h4>
                            <div class="price-value">{{$value->findDepartment->title??'N/A'}}
                            </div>
                        </div>
                        <div class="row">
                            {{--<div class="col-sm-6">
                                <span>Date Applied</span>
                            </div>--}}
                            <div class="col-sm-12">
                                <span><b>Date : </b>{{\Carbon\Carbon::make($value->created_at)->diffForHumans()}}</span>
                            </div>
                            <div class="col-sm-12">
                                    @php $count_array = array_count_values(json_decode($value->status)); @endphp
                                    @foreach(json_decode($value->status) as $key=>$status_value)
                                       <span class="badge badge-primary">{{$status_value}}</span>
                                        @if (!$loop->last)
                                            ->
                                        @endif
                                    @endforeach
                            </div>
                        </div>

                    </div>
                </div>
                @endforeach
            </div>
        </div>

        <div class="card-body">

            <!-- Interview Information -->
            <div class="details-tab">
                <div class="d-flex flex-row align-items-center mb-2">
                    <h3 class="card-title media-body">Interview Detail</h3>
                    <input type="hidden" id="id" name="id" value="{{$particular_record->id?? 'N/A'}}">
                    @if(!empty($particular_record->id))
                        <div class="dropdown pmd-dropdown pmd-user-info ml-auto">
                            <a href="#" class="pmd-btn-fab btn-outline-dark pmd-btn-flat btn btn-sm" data-toggle="dropdown" aria-expanded="true"><i class="material-icons pmd-icon-sm">more_vert</i></a>

                            <div class="dropdown-menu dropdown-menu-right" style="clip: rect(0px, 93.8667px, 0px, 93.8667px); transform: translate3d(-53.8667px, 0px, 0px);">
                                @can('edit.interview')
                                    <a class="dropdown-item d-flex flex-row" id="edit-basic-info" ><i class="material-icons md-dark pmd-icon-xs mr-3">edit</i><span class="media-body">Edit</span></a>
                                @endcan
                                @can('delete.interview')
                                        <a class="dropdown-item d-flex flex-row" id="delete-basic-info" ><i class="material-icons md-dark pmd-icon-xs mr-3">delete</i><span class="media-body">Delete</span></a>
                                @endcan

                            </div>
                        </div>
                    @endif
                </div>
                <div class="row view-basic-card">
                    <div class="col-12 col-md-6 col-lg-3">
                        <label class="pmd-list-subtitle">Office Timing</label>
                        <p class="pmd-list-title" id="office_timing" >{{$particular_record->office_timing?? 'N/A'}}</p>
                    </div>
                    <div class="col-12 col-md-6 col-lg-3">
                        <label class="pmd-list-subtitle">Interview Schedule</label>
                        <p class="pmd-list-title" id="interview_schedule" >{{$particular_record->interview_schedule?? 'N/A'}}</p>
                    </div>
                    <div class="col-12 col-md-6 col-lg-3">
                        <label class="pmd-list-subtitle">Current/Last Company</label>
                        <p class="pmd-list-title" id="current_company">{{$particular_record->current_company??'N/A'}}</p>
                    </div>
                    <div class="col-12 col-md-6 col-lg-3">
                        <label class="pmd-list-subtitle">Current/Last Designation</label>
                        <p class="pmd-list-title" id="current_designation">{{$particular_record->designation??'N/A'}}</p>
                    </div>
                    <div class="col-12 col-md-6 col-lg-3">
                        <label class="pmd-list-subtitle">Experience</label>
                        <p class="pmd-list-title" id="experience">{{$particular_record->experience??'N/A'}}</p>
                    </div>
                    <div class="col-12 col-md-6 col-lg-3">
                        <label class="pmd-list-subtitle"> Current/Last Timing</label>
                        <p class="pmd-list-title" id="current_timing">{{$particular_record->current_timing??'N/A'}}</p>
                    </div>
                    <div class="col-12 col-md-6 col-lg-3">
                        <label class="pmd-list-subtitle">Current/Last Salary</label>
                        <p class="pmd-list-title" id="current_salary">{{$particular_record->current_salary??'N/A'}}</p>
                    </div>
                    <div class="col-12 col-md-6 col-lg-3">
                        <label class="pmd-list-subtitle">Expected Salary</label>
                        <p class="pmd-list-title" id="expected_salary">{{$particular_record->expected_salary??'N/A'}}</p>
                    </div>
                    <div class="col-12 col-md-6 col-lg-3">
                        <label class="pmd-list-subtitle">Joining Date</label>
                        <p class="pmd-list-title" id="joining_date">{{$particular_record->joining_date??'N/A'}}</p>
                    </div>
                </div>
            </div>

            <div class="details-tab">
                <div class="d-flex flex-row align-items-center mb-2">
                    <h3 class="card-title media-body">Address Detail</h3>
                </div>
                <div class="row view-basic-card">
                    <div class="col-12 col-md-6 col-lg-3">
                        <label class="pmd-list-subtitle">City</label>
                        <p class="pmd-list-title" id="city" >{{$particular_record->city??'N/A'}}</p>
                    </div>
                    <div class="col-12 col-md-6 col-lg-3">
                        <label class="pmd-list-subtitle">Present Address</label>
                        <p class="pmd-list-title" id="present_address" >{{$particular_record->present_address??'N/A'}}</p>
                    </div>
                    <div class="col-12 col-md-6 col-lg-3">
                        <label class="pmd-list-subtitle">Permanent Address</label>
                        <p class="pmd-list-title" id="permanent_address">{{$particular_record->permanent_address?? 'N/A'}}</p>
                    </div>
                    <div class="col-12 col-md-6 col-lg-3">
                        <label class="pmd-list-subtitle">Postal Address</label>
                        <p class="pmd-list-title" id="postal_code">{{$particular_record->postal_code??'N/A'}}</p>
                    </div>
                </div>
            </div>

            <!-- Applied For -->
            <div class="details-tab">
                <div class="d-flex flex-row align-items-center mb-2">
                    <h3 class="card-title media-body">Applied For</h3>
                </div>
                <div class="row">
                    <div class="col-3 col-md-3 col-md-3">
                        <label class="pmd-list-subtitle">Department</label>
                        <p class="pmd-list-title" id="department">{{$particular_record->findDepartment->title??'N/A'}}</p>
                    </div>
                    <div class="col-3 col-md-3 col-md-3">
                        <label class="pmd-list-subtitle">Job Title</label>
                        <p class="pmd-list-title" id="job_title">{{$particular_record->findJobTitle->title??'N/A'}}</p>
                    </div>

                </div>
            </div>
            <!-- Comments -->
            <div class="details-tab">
                <div class="d-flex flex-row align-items-center mb-2">
                    <h3 class="card-title media-body">Comments</h3>
                </div>
                <div class="row view-basic-card">
                    <div class="col-12 col-md-6 col-lg-6">
                        <p class="pmd-list-title" id="comment" >{{$particular_record->comment??'N/A'}}</p>
                    </div>
                </div>
            </div>

            <!-- Other Detail And Attachments -->
            <div class="details-tab">
                <div class="d-flex flex-row align-items-center mb-2">
                    <h3 class="card-title media-body">Other Detail And Attachments</h3>
                </div>
                <div class="row view-basic-card">
                    <div class="col-12 col-md-6 col-lg-3">
                        <label class="pmd-list-subtitle">Status<br></label>

                        <p class="pmd-list-title" id="status" >
                            {!!html_entity_decode($status_html)!!}
                        </p>
                    </div>
                    <div class="col-12 col-md-6 col-lg-3">
                        <label class="pmd-list-subtitle">Cv</label>
                            <p id="cv_path">
                                @if($file_type_cv == 'docx' || $file_type_cv == 'DOCX' || $file_type_cv == 'doc')
                                    <a class='btn btn-success text-white fancybox' href="https://view.officeapps.live.com/op/embed.aspx?src={{asset('/interview/resume/'.$particular_record->resume)}}"  data-fancybox data-type='iframe' data-preload='false'>View Cv</a>
                                @elseif($file_type_cv == 'pdf')
                                    <a class='btn btn-success text-white fancybox' href="{{asset('/interview/resume/'.$particular_record->resume)}}"  data-fancybox data-type='iframe' data-preload='false'>View Cv</a>
                                @else
                                    N/A
                                @endif
                            </p>
                    </div>
                    <div class="col-12 col-md-6 col-lg-3">
                        <label class="pmd-list-subtitle">Cover Letter</label>
                        <p id="cover_letter">
                            @if($file_type_cover == 'docx' || $file_type_cover == 'DOCX' || $file_type_cover == 'doc')
                                <a class='btn btn-success text-white fancybox' href="https://view.officeapps.live.com/op/embed.aspx?src={{asset('/interview/coverLetter/'.$particular_record->cover_letter)}}"  data-fancybox data-type='iframe' data-preload='false'>Cover Letter</a>
                            @elseif($file_type_cover == 'pdf')
                                <a class='btn btn-success text-white fancybox' href="{{asset('/interview/coverLetter/'.$particular_record->cover_letter)}}"  data-fancybox data-type='iframe' data-preload='false'>Cover Letter</a>
                            @else
                                N/A
                            @endif
                        </p>
                    </div>
                    <div class="col-2 col-md-2 col-md-2">
                        <div class="form-group mb-0">
                            <label for="" class="offer-label mb-0 d-block">
                                Offer Letter
                            </label>
                            @if($particular_record->offer_accept_reject == 1)
                                <span class="badge badge-success"> Offer Accepted </span>
                            @elseif($particular_record->offer_accept_reject == 2)
                                <span class="badge badge-danger"> Offer Rejected </span>
                            @elseif($particular_record->offer_accept_reject == 0)
                                <span class="badge badge-warning"> UnConfirmed </span>
                            @endif

                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

@endsection

@push('js')
    <script src="{{asset('js/jquery-mask/src/jquery.mask.js')}}"></script>
    <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/@fancyapps/ui@4.0/dist/fancybox.umd.js"></script>
    <script>
        $(document).ready(function () {

           $(document).on('click','.card-detail-view',function (e) {
               id = $(this).attr('data-id');
               interviewDetail(id);
           })

            $(document).on('click','#edit-basic-info',function () {
              id = $('#id').val();
              var interview_id =   btoa(id);
                if(interview_id != ''){
                    window.location.href = '{{URL::to('site/interview/edit')}}' +"/"+ interview_id
                }
            })
            var interview_id = $('#id').val();

            $(document).on('click','#delete-basic-info',function(){
                 interview_id = $('#id').val();
                var id =   btoa(interview_id);
                if(id != ''){
                    Swal.fire({
                        title: 'Are you sure?',
                        text: "You won't be able to revert this!",
                        icon: 'warning',
                        showCancelButton: true,
                        confirmButtonColor: '#3085d6',
                        cancelButtonColor: '#d33',
                        confirmButtonText: 'Yes, delete it!'
                    }).then((result) => {
                        if (result.isConfirmed) {
                            $.ajax({
                                url: '{{URL::to('site/interview/delete')}}' +"/"+ id,
                                type: 'get',
                                success: function(response){
                                    Swal.fire(
                                        'Deleted!',
                                        response,
                                        'success'
                                    );
                                    location.reload();
                                }
                            });
                        }
                    });
                }

            });
        });
        function interviewDetail(id) {
            $.ajax({
                url: '{{route('detail.interview')}}',
                dataType: "json",
                type: 'post',
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                },
                data:{id:id},
                success: function(response){
                    console.log(response.item_data)
                    // var status = JSON.parse(response.status);
                    var cv = (response.item_data.resume);
                    var cover_letter = (response.item_data.cover_letter);
                    $('#id').val(response.item_data.id);
                    $('#office_timing').html(response.item_data.office_timing??'N/A');
                    $('#interview_schedule').html(response.item_data.interview_schedule??'N/A');
                    $('#current_company').html(response.item_data.current_company??'N/A');
                    $('#current_designation').html(response.item_data.designation??'N/A');
                    $('#experience').html(response.item_data.experience??'N/A');
                    $('#current_timing').html(response.item_data.current_timing??'N/A');
                    $('#current_salary').html(response.item_data.current_salary??'N/A');
                    $('#expected_salary').html(response.item_data.expected_salary??'N/A');
                    $('#joining_date').html(response.item_data.joining_date??'N/A');
                    $('#city').html(response.item_data.city??'N/A');
                    $('#present_address').html(response.item_data.present_address??'N/A');
                    $('#permanent_address').html(response.item_data.permanent_address??'N/A');
                    $('#postal_code').html(response.item_data.postal_code??'N/A');
                    $('#department').html(response.department??'N/A');
                    $('#job_title').html(response.job_title??'N/A');
                    $('#comment').html(response.item_data.comment??'N/A');

                    $('#status').html(response.status_data??'N/A');

                    var split ='';
                    var split_letter = '';

                    if (cv != null){

                         split = cv.split(".")['1'];

                        if (split == 'docx' || split == 'DOCX' || split == 'doc') {
                            var urlPath = '{{"https://view.officeapps.live.com/op/embed.aspx?src=".asset("/interview/resume")}}/'+response.resume;
                        }
                        else{
                            var urlPath = '{{asset("/interview/resume")}}/'+response.resume;
                        }

                        var cv_path = (cv !== "")?"<a class='btn btn-success text-white' href='"+ urlPath +"' class='fancybox' data-fancybox data-type='iframe' data-preload='false' >View Cv</a>":"N/A";

                        $("#cv_path").html(cv_path);
                    }

                    if (cover_letter != null){

                         split_letter = cover_letter.split(".")['1'];

                        if (split_letter == 'docx' || split_letter == 'DOCX' || split_letter == 'doc') {
                            var urlPathLeter = '{{"https://view.officeapps.live.com/op/embed.aspx?src=".asset("/interview/coverLetter")}}/'+response.cover_letter;
                        }
                        else{
                            var urlPathLeter = '{{asset("/interview/coverLetter")}}/'+response.cover_letter;
                        }
                        var cover_letter = (cover_letter !== "")?"<a class='btn btn-success text-white' href='"+ urlPathLeter +"' class='fancybox' data-fancybox data-type='iframe' data-preload='false' >Cover Letter</a>":"N/A";

                        $("#cover_letter").html(cover_letter);

                    }
                }
            });
        }
    </script>

@endpush
