@extends('layouts.app')
@section('page-title','Create Lead')

@push('css')
    <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
@endpush

@section('content')

    <div id="content" class="pmd-content admin section">
        <!-- Title -->
        <h1>@yield('page-title')</h1>
        <!-- End Title -->
        <!--breadcrumb start-->
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb pmd-breadcrumb">
                <li class="breadcrumb-item">
                    <a href="{{route('dashboard')}}">Dashboard</a>
                </li>
                <li class="breadcrumb-item">Leads</li>
                <li class="breadcrumb-item active" aria-current="page">@yield('page-title')</li>
            </ol>
        </nav>
        <!--breadcrumb end-->

        <div class="row">
            <div class="col-md-12">
                <div class="card pmd-card">
                    <form method="post" autocomplete="off" action="{{route('insert.client')}}" id="user_form" enctype="multipart/form-data">
                        @csrf
                        <div class="card-body">
                            <!-- Basic Information -->
                            <div class="details-tab">
                                <h3 class="card-title">Lead Information</h3>
                                <div class="row">
                                    <div class="col-12 col-sm-6 col-md-4">
                                        <div class="form-group pmd-textfield pmd-textfield-floating-label ">
                                            <label for="fn" class="col-form-label control-label">First Name</label>
                                            <input type="text" class="form-control" name="firstname"
                                                   aria-describedby="emailHelp" id="fn" value="{{old('firstname')}}" required>
                                            @error('firstname')
                                            <span>
                                                <strong class="text-danger">{{$message}}</strong>
                                            </span>
                                            @enderror()
                                        </div>
                                    </div>
                                    <div class="col-12 col-sm-6 col-md-4">
                                        <div class="form-group pmd-textfield pmd-textfield-floating-label ">
                                            <label for="ln" class="col-form-label control-label">Last Name</label>
                                            <input type="text" class="form-control" name="lastname" id="ln"
                                                   aria-describedby="emailHelp" value="{{old('lastname')}}" required>
                                            @error('lastname')
                                            <span>
                                                <strong class="text-danger">{{$message}}</strong>
                                            </span>
                                            @enderror()
                                        </div>
                                    </div>

                                    <div class="col-12 col-sm-6 col-md-4">
                                        <div class="form-group pmd-textfield pmd-textfield-floating-label ">
                                            <label for="phone" class="col-form-label control-label">Phone</label>
                                            <input type="text" class="form-control" name="phone"
                                                   aria-describedby="emailHelp" id="phone" value="{{old('phone')}}" required>
                                            @error('phone')
                                            <span>
                                                <strong class="text-danger">{{$message}}</strong>
                                            </span>
                                            @enderror()
                                        </div>
                                    </div>
                                    <div class="col-12 col-sm-6 col-md-4">
                                        <div class="form-group pmd-textfield pmd-textfield-floating-label ">
                                            <label for="personal-email" class="col-form-label control-label">Email</label>
                                            <input type="email" class="form-control" name="email" id="personal-email"
                                                   aria-describedby="emailHelp" value="{{old('email')}}" required>

                                            @error('email')
                                            <span>
                                                <strong class="text-danger">{{$message}}</strong>
                                            </span>
                                            @enderror()
                                        </div>
                                    </div>
                                    <div class="col-12 col-sm-6 col-md-4">
                                        <div class="form-group pmd-textfield pmd-textfield-floating-label">
                                            <label for="password" class="col-form-label control-label">Password</label>
                                            <input type="password" class="form-control" name="password"
                                                   aria-describedby="emailHelp" value="{{old('password')}}" required>
                                            @error('password')
                                            <span>
                                                <strong class="text-danger">{{$message}}</strong>
                                            </span>
                                            @enderror()
                                        </div>
                                    </div>

                                    <div class="col-12 col-sm-6 col-md-4">
                                        <div class="form-group pmd-textfield pmd-textfield-floating-label ">
                                            <label for="web_url" class="col-form-label control-label">Web Url</label>
                                            <input type="url" class="form-control" name="web_url" id="web_url"
                                                   aria-describedby="emailHelp" value="{{old('web_url')}}" required>
                                            @error('web_url')
                                            <span>
                                                <strong class="text-danger">{{$message}}</strong>
                                            </span>
                                            @enderror()
                                        </div>
                                    </div>


                                    <div class="col-12 col-sm-6 col-md-12">
                                        <div class="form-group pmd-textfield pmd-textfield-floating-label ">
                                            <label for="web_url" class="col-form-label control-label">Comments</label>
                                            <textarea class="form-control" name="comments" id="comments"
                                                      aria-describedby="emailHelp" value="{{old('comments')}}" required></textarea>
                                            @error('comments')
                                            <span>
                                                <strong class="text-danger">{{$message}}</strong>
                                            </span>
                                            @enderror()
                                        </div>
                                    </div>

                                </div>
                            </div>
                        </div>

                        <div class="card-footer pmd-card-border">
                            <button class="btn pmd-ripple-effect btn-primary pmd-btn-raised form_submit_btn" type="submit">Create</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection

@push('js')
    <script src="{{asset('js/jquery-mask/src/jquery.mask.js')}}"></script>
    <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>

    <script>
        let global_sum = 0;
        $(document).ready(function () {
            $('#phone').mask("00000000000");
            $('.select-two').select2();
        });

        var dateToday = new Date();
        // Add start date date and time picker
        $('#datepickerjoin').datetimepicker({
            minDate: dateToday,
            format: 'DD-MM-YYYY'
        });


    </script>
@endpush
