@extends('layouts.app')
@section('page-title','Leads')

@push('css')
    <!-- DataTables -->
    <link rel="stylesheet" href="{{asset('plugins/datatables-bs4/css/dataTables.bootstrap4.min.css')}}">
    <link rel="stylesheet" href="{{asset('plugins/datatables-responsive/css/responsive.bootstrap4.min.css')}}">
@endpush

@section('content')
    <!--content area start-->
    <div id="content" class="pmd-content inner-page admin">
        <!-- Title -->
        <h1 id="employee" class="text-center">@yield('page-title')</h1>
        <!-- End Title -->
        <!--breadcrumb start-->
{{--        <div class="float-right @cannot('create-new.leads') no-btn @endcan">--}}
{{--            <nav aria-label="breadcrumb">--}}
{{--                <ol class="breadcrumb pmd-breadcrumb mb-0">--}}
{{--                    <li class="breadcrumb-item">--}}
{{--                        <a href="{{route('dashboard')}}">Dashboard</a>--}}
{{--                    </li>--}}
{{--                    <li class="breadcrumb-item active" aria-current="page">@yield('page-title')</li>--}}
{{--                </ol>--}}
{{--            </nav>--}}
{{--        </div>--}}
{{--        <div>--}}
{{--            @can('create.client')--}}
{{--                <a href="{{route('create-new.leads')}}" class="btn btn-primary ">Create</a>--}}
{{--            @endcan--}}
{{--        </div>--}}
        <!--breadcrumb end-->
        <div class="row pt-3">
            <div class="col-12">
                <div class="table-bg">
                    <section class="component-section" id="employee">
                        <table id='roles-datatable' class="table pmd-table table-hover pmd-table-card">
                            <thead class="thead-light">
                            <tr>
                                <th>S No.</th>
{{--                                <th>Image</th>--}}
                                <th>Name</th>
                                <th>Email</th>
{{--                                <th>Phone</th>--}}
                                <th>Sale Type</th>
                                <th>Status</th>
                                <th>Change Status</th>
                                <th>Actions</th>
                            </tr>
                            </thead>
                            <tbody>

                            </tbody>
                        </table>
                    </section>
                </div>
            </div>
        </div>
    </div>
    <!-- content area end -->
@endsection

@push('js')
    <script>
        $(document).ready( function () {

            $('#roles-datatable').DataTable({
                "serverSide": true,
                "processing": true,
                "responsive": true,
                "autoWidth": false,
                "ajax": {
                    "url": "{{ route('show.leads') }}",
                    "dataType": "json",
                    "type": "POST",
                    "data": {_token: "{{csrf_token()}}"}
                },
                "columns": [
                    {"data": "id",sortable:false},
                    // {"data": "image",sortable: false},
                    {"data": "name",sortable: false},
                    {"data": "email",sortable: false},
                    // {"data": "phone",sortable: false},
                    {"data": "sale_type",sortable: false},
                    {"data": "status_id",sortable: false},
                    {"data": "change_status",sortable: false},
                    {"data": "options",sortable: false}
                ]
            });
        } );

        $(document).on('change','.change-status', function (){
            const get_id = $(this).find(":selected").attr('data-id');
            var clientType = 'Lead';
            const get_status = $(this).find(":selected").val();

            if(get_status == 'Sale'){
                var clientType = 'Client';
            }
            // alert(clientType);
            Swal.fire({
                title: 'Are You Sure?',
                showDenyButton: true,
                showCancelButton: false,
                confirmButtonText: 'Yes',
                denyButtonText: `No`,

            }).then((result) => {
                if (result.isConfirmed) {
                    $.ajax({
                        headers: {'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')},
                        type: 'POST',
                        url: "{{route('update-status.leads')}}",
                        dataType: 'json',
                        data: {get_id: get_id,get_client_type: clientType,get_status: get_status},
                        success: function (data) {

                            if (data == 'success') {

                                Swal.fire({
                                    position: 'top-end',
                                    icon: 'success',
                                    title: "Status Changed Successfully",
                                    showConfirmButton: false,
                                    timer: 1500
                                })
                                location.reload();

                            }
                        }
                    });
                }else {
                location.reload();
            }
            })
        })
    </script>
@endpush
