@extends('layouts.app')
@section('page-title','Edit Loan Request')

@section('content')

    <div id="content" class="pmd-content admin section">
        <!-- Title -->
        <h1>@yield('page-title')</h1>
        <!-- End Title -->
        <!--breadcrumb start-->
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb pmd-breadcrumb">
                <li class="breadcrumb-item">
                    <a href="{{route('dashboard')}}">Dashboard</a>
                </li>
                <li class="breadcrumb-item">Loans</li>
                <li class="breadcrumb-item active" aria-current="page">@yield('page-title')</li>
            </ol>
        </nav>
        <!--breadcrumb end-->

        <div class="row">
            <div class="col-md-12">
                <div class="card pmd-card">
                    <form method="post" autocomplete="off" action="{{route('update.loan')}}" enctype="multipart/form-data">
                        @csrf
                        <input type="hidden" name="id" value="{{$loan->id}}">
                        <div class="card-body">

                            <div class="details-tab">
                                <div class="row">
                                    <div class="offset-sm-3 offset-md-3 col-12 col-sm-6 col-md-6">
                                        <div class="form-group pmd-textfield pmd-textfield-floating-label ">
                                            <label for="title" class="col-form-label control-label">Amount Needed</label>
                                            <input type="number" class="form-control" name="amount_requested"
                                                   aria-describedby="emailHelp" id="amount_requested" value="{{$loan->amount_requested??old('amount_requested')}}" required>
                                            @error('amount_requested')
                                            <span><strong class="text-danger">{{$message}}</strong></span>
                                            @enderror()
                                        </div>
                                    </div>
                                </div>

                                <div class="row">
                                    <div class="offset-sm-3 offset-md-3 col-12 col-sm-6 col-md-6">
                                        <div class="form-group pmd-textfield pmd-textfield-floating-label">
                                            <label for="number_of_installments_total" class="col-form-label control-label">No. of Installments</label>
                                            <input type="number" class="form-control" name="number_of_installments_total" min="1"
                                                   aria-describedby="emailHelp" id="number_of_installments_total" value="{{$loan->number_of_installments_total??old('number_of_installments_total')}}" required>
                                            <small>Number of months required to return loan</small>
                                            @error('number_of_installments_total')
                                            <span><strong class="text-danger">{{$message}}</strong></span>
                                            @enderror()
                                        </div>
                                    </div>
                                </div>

                                <div class="row">
                                    <div class="offset-sm-3 offset-md-3 col-12 col-sm-6 col-md-6">
                                        <div class="form-group pmd-textfield pmd-textfield-floating-label ">
                                            <label for="description" class="col-form-label control-label">Description</label>
                                            <textarea id="description" class="form-control" rows="5" name="description">{{unserialize($loan->description)??old('description')}}</textarea>
                                            @error('description')
                                            <span><strong class="text-danger">{{$message}}</strong></span>
                                            @enderror()
                                        </div>
                                    </div>
                                </div>

                            </div>
                        </div>

                        <div class="card-footer pmd-card-border">
                            <button class="btn pmd-ripple-effect btn-primary pmd-btn-raised" type="submit">Update</button>
{{--                            <button class="btn pmd-ripple-effect btn-outline-secondary" type="reset">Reset</button>--}}
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection
