@extends('layouts.app')
@section('page-title','Client Information')
<style>
    .imageview{height: 100px; width: 100px;}
</style>
@section('content')
    <div id="content" class="pmd-content inner-page profile-page">
        <div class="page-content profile-view">
            <div class="row">
                <div class="col-12">
                    <!-- Tab panes -->
                    <div class="tab-content">
                        <!-- About Tab -->
                        <div role="tabpanel" class="tab-pane active" id="about">
                            <div class="card pmd-card">
                                <div class="card-body">

                                    <!-- Basic Information -->
                                    <div class="details-tab">
                                        <div class="d-flex flex-row align-items-center mb-2">
                                            <h3 class="card-title media-body">Basic Information</h3>
                                        </div>
                                        <div class="row view-basic-card">
                                            <div class="col-12 col-md-6 col-lg-12">
                                                @if($client->findLead->client_status == 'Upsell')
                                                    <div class="error-message mb-4 alert alert-secondary"  role="alert">
                                                        Client Status : Upsell
                                                    </div>
                                                @elseif($client->findLead->client_status == 'Sale')
                                                    <div class="error-message mb-4 alert alert-primary"  role="alert">
                                                        Client Status : Sale
                                                    </div>
                                                @elseif($client->findLead->client_status == 'Recurring')
                                                    <div class="error-message mb-4 alert alert-success"  role="alert">
                                                        Client Status : Recurring
                                                    </div>
                                                @elseif($client->findLead->client_status == 'Returning')
                                                    <div class="error-message mb-4 alert alert-warning"  role="alert">
                                                        Client Status : Returning
                                                    </div>
                                                @elseif($client->findLead->client_status == 'Referral')
                                                    <div class="error-message mb-4 alert alert-info"  role="alert">
                                                        Client Status : Referral
                                                    </div>
                                                @elseif($client->findLead->client_status == 'Angry')
                                                    <div class="error-message mb-4 alert alert-danger"  role="alert">
                                                        Client Status : Angry
                                                    </div>
                                                @endif
                                            </div>
{{--                                            <div class="col-12 col-md-6 col-lg-4">--}}
{{--                                                <label class="pmd-list-subtitle">Client Status</label><br>--}}
{{--                                                @if($client->findLead->client_status == 'Upsell')--}}
{{--                                                    <p class="pmd-list-title badge badge-success">Upsell</p>--}}
{{--                                                @elseif($client->findLead->client_status == 'Sale')--}}
{{--                                                    <p class="pmd-list-title badge badge-success">Sale</p>--}}
{{--                                                @elseif($client->findLead->client_status == 'Recurring')--}}
{{--                                                    <p class="pmd-list-title badge badge-dark">Recurring</p>--}}
{{--                                                @elseif($client->findLead->client_status == 'Returning')--}}
{{--                                                    <p class="pmd-list-title badge badge-warning">Returning</p>--}}
{{--                                                @elseif($client->findLead->client_status == 'Referral')--}}
{{--                                                    <p class="pmd-list-title badge badge-info">Referral</p>--}}
{{--                                                @elseif($client->findLead->client_status == 'Angry')--}}
{{--                                                    <p class="pmd-list-title badge badge-danger">Angry</p>--}}
{{--                                                @endif--}}
{{--                                            </div>--}}
                                            <div class="col-12 col-md-6 col-lg-4">
                                                <label class="pmd-list-subtitle">First Name</label>
                                                <p class="pmd-list-title">{{$client_info->firstname ?? 'N/A'}}</p>
                                            </div>
                                            <div class="col-12 col-md-6 col-lg-4">
                                                <label class="pmd-list-subtitle">Last Name</label>
                                                <p class="pmd-list-title">{{$client_info->lastname ?? 'N/A'}}</p>
                                            </div>
                                            <div class="col-12 col-md-6 col-lg-4">
                                                <label class="pmd-list-subtitle">Phone</label>
                                                <p class="pmd-list-title">{{$client_info->phone ?? 'N/A'}}</p>
                                            </div>
                                            <div class="col-12 col-md-6 col-lg-4">
                                                <label class="pmd-list-subtitle">Email</label>
                                                <p class="pmd-list-title"><a href="mailto: {{$client_info->email}}" title="{{$client_info->email}}">{{$client_info->email}}</a></p>
                                            </div>
                                            <div class="col-12 col-md-6 col-lg-4">
                                                <label class="pmd-list-subtitle">Country</label>
                                                <p class="pmd-list-title">{{$client->country ?? 'N/A'}}</p>
                                            </div>
                                            <div class="col-12 col-md-6 col-lg-4">
                                                <label class="pmd-list-subtitle">State</label>
                                                <p class="pmd-list-title">{{$client->state ?? 'N/A'}}</p>
                                            </div>
                                            <div class="col-12 col-md-6 col-lg-4">
                                                <label class="pmd-list-subtitle">City</label>
                                                <p class="pmd-list-title">{{$client->city ?? 'N/A'}}</p>
                                            </div>
                                            <div class="col-12 col-md-6 col-lg-4">
                                                <label class="pmd-list-subtitle">Postal Code</label>
                                                <p class="pmd-list-title">{{$client->postal_code ?? 'N/A'}}</p>
                                            </div>
                                            <div class="col-12 col-md-6 col-lg-4">
                                                <label class="pmd-list-subtitle">Ip address</label>
                                                <p class="pmd-list-title">{{$client->ip_address ?? 'N/A'}}</p>
                                            </div>
                                            <div class="col-12 col-md-6 col-lg-4">
                                                <label class="pmd-list-subtitle">Web Url</label>
                                                <p class="pmd-list-title">{{$client_info->web_url ?? 'N/A'}}</p>
                                            </div>
                                            <div class="col-12 col-md-6 col-lg-4">
                                                <label class="pmd-list-subtitle">Product Type</label>
                                                <p class="pmd-list-title">{{$client_info->product_type ?? 'N/A'}}</p>
                                            </div>
                                            <div class="col-12 col-md-6 col-lg-4">
                                                <label class="pmd-list-subtitle">Package Name</label>
                                                <p class="pmd-list-title">{{$client->findLead->project_type ?? 'Filled by Admin'}}</p>
                                            </div>

                                            @if($client_info->comments)
                                                <div class="col-12 col-sm-6 col-md-12">
                                                    <label for="comments" class="col-form-label control-label">Project /Other Description</label>
                                                    <div class="form-group ">
                                                        <textarea readonly class="form-control" name="comments" id="comments"
                                                                  aria-describedby="emailHelp">{{$client_info->comments}}</textarea>
                                                    </div>
                                                </div>
                                            @endif
                                        </div>
                                    </div>

                                @if($client_info->product_type == 'LOGO')
                                    <!-- Salary Details -->
                                    <div class="details-tab">
                                        <div class="d-flex flex-row align-items-center mb-2">
                                            <h3 class="card-title media-body">LOGO Details</h3>
                                        </div>
                                        <div class="row view-basic-card">
                                            <div class="col-12 col-md-6 col-lg-4">
                                                <label class="pmd-list-subtitle">Exact Name</label>
                                                <p class="pmd-list-title">{{$client_info->logo_exact_name ?? 'N/A'}}</p>
                                            </div>

                                            <div class="col-12 col-md-6 col-lg-4">
                                                <label class="pmd-list-subtitle">Package</label>
                                                <p class="pmd-list-title">{{$client_info->billing_package ?? 'N/A'}}</p>
                                            </div>
                                            <div class="col-12 col-md-6 col-lg-4">
                                                <label class="pmd-list-subtitle">Amount</label>
                                                <p class="pmd-list-title">{{$client_info->billing_amount ?? 'N/A'}}</p>
                                            </div>

                                            <div class="col-12 col-md-6 col-lg-4">
                                                <label class="pmd-list-subtitle">Slogan </label>
                                                <p class="pmd-list-title">{{$client_info->logo_slogan ?? 'N/A'}}</p>
                                            </div>
                                            <div class="col-12 col-md-6 col-lg-4">
                                                <label class="pmd-list-subtitle">Look And Feel</label>
                                                <p class="pmd-list-title">{{$client_info->look_and_feel ?? 'N/A'}}</p>
                                            </div>

                                            <div class="col-12 col-md-6 col-lg-4">
                                                <label class="pmd-list-subtitle">Competitors Reference</label>
                                                <p class="pmd-list-title">{{$client_info->logo_competitor_ref ?? 'N/A'}}</p>
                                            </div>
                                            <div class="col-12 col-md-6 col-lg-4">
                                                <label class="pmd-list-subtitle"> Primary Color </label>
                                                <p class="pmd-list-title">{{$client_info->logo_primary_color ?? 'N/A'}}</p>
                                            </div>

                                            <div class="col-12 col-md-6 col-lg-4">
                                                <label class="pmd-list-subtitle">Secondary Color</label>
                                                <p class="pmd-list-title">{{$client_info->logo_secondary_color ?? 'N/A'}}</p>
                                            </div>
                                            <div class="col-12 col-md-6 col-lg-4">
                                                <label class="pmd-list-subtitle">Industry</label>
                                                <p class="pmd-list-title">{{$client_info->logo_industry ?? 'N/A'}}</p>
                                            </div>

                                            <div class="col-12 col-md-6 col-lg-4">
                                                <label class="pmd-list-subtitle">Target Audience</label>
                                                <p class="pmd-list-title">{{$client_info->logo_targeted_audience ?? 'N/A'}}</p>
                                            </div>
                                            <div class="col-12 col-md-6 col-lg-4">
                                                <label class="pmd-list-subtitle">Typography</label>
                                                <p class="pmd-list-title">{{$client_info->logo_typography ?? 'N/A'}}</p>
                                            </div>

                                            <div class="col-12 col-md-6 col-lg-4">
                                                <label class="pmd-list-subtitle">Logo Type</label>
                                                <p class="pmd-list-title">{{$client_info->logo_type ?? 'N/A'}}</p>
                                            </div>
                                            <div class="col-12 col-md-6 col-lg-12">
                                                <label class="pmd-list-subtitle">Logo Refrence Material</label><br>
                                                <div class="imagessss">
                                                    @if($logo_refrence_material != NULL)
                                                        @foreach($logo_refrence_material as $image)
                                                            @if($image != NULL)
                                                                <a href="{{ asset('client-logo/images/'.$image) }}" target="_blank"><img src="{{ asset('client-logo/images/'.$image) }}" class="imageview"></a>
                                                            @else
                                                                <img src="{{ asset('themes/images/no-image-selected.png') }}" class="imageview">
                                                            @endif
                                                        @endforeach
                                                    @else
                                                        <img src="{{ asset('themes/images/no-image-selected.png') }}" class="imageview">
                                                    @endif
                                                </div>

                                            </div>
                                        </div>
                                    @elseif($client_info->product_type == 'WEBSITE')
                                        <div class="card-body">
                                            <!-- Basic Information -->
                                            <div class="details-tab">
                                                <div class="row">
                                                    <div class="col-12 col-sm-12 col-md-12">
                                                        <label for="domain_purchased" class="col-form-label control-label">Current Web Host</label>
                                                        <div class="form-group pmd-textfield pmd-textfield-floating-label ">
                                                            <input type="text" readonly class="form-control" name="website_current_web_host"
                                                                   aria-describedby="emailHelp"  value="{{$client_info->website_current_web_host ?? 'N/A'}}">
                                                        </div>
                                                    </div>
                                                    <div class="col-12 col-sm-12 col-md-12">
                                                        <label for="domain_purchased" class="col-form-label control-label">Did you already purchase a domain? If yes, who with: (we will need access to that account later on)</label>
                                                        <div class="form-group pmd-textfield pmd-textfield-floating-label ">
                                                            <input type="text" readonly class="form-control" name="website_domain_purchased"
                                                                   aria-describedby="emailHelp"  value="{{$client_info->website_domain_purchased ?? 'N/A'}}">
                                                        </div>
                                                    </div>
                                                    <div class="col-12 col-sm-12 col-md-12">
                                                        <label for="providing_image" class="col-form-label control-label">Will you be providing any images for the website</label>
                                                        <div class="form-group pmd-textfield pmd-textfield-floating-label ">
                                                            <input type="text" readonly class="form-control" name="website_providing_image"
                                                                   aria-describedby="emailHelp"  value="{{$client_info->website_providing_image ?? 'N/A'}}">
                                                        </div>
                                                    </div>

                                                    <div class="col-12 col-sm-12 col-md-12">
                                                        <label for="have_content" class="col-form-label control-label">Do you have all the content (text, info, articles, copy) available for your pages</label>
                                                        <div class="form-group pmd-textfield pmd-textfield-floating-label ">
                                                            <input type="text" readonly class="form-control" name="website_have_content"
                                                                   aria-describedby="emailHelp"  value="{{$client_info->website_have_content ?? 'N/A'}}">
                                                        </div>
                                                    </div>
                                                    <div class="col-12 col-sm-6 col-md-12">
                                                        <label for="company_desc" class="col-form-label control-label">Briefly describe your company</label>
                                                        <div class="form-group ">
                                                    <textarea readonly class="form-control" name="website_company_desc" id="company_desc"
                                                              aria-describedby="emailHelp">{{$client_info->website_company_desc ?? 'N/A'}}</textarea>
                                                        </div>
                                                    </div>

                                                    <div class="col-12 col-sm-6 col-md-12">
                                                        <label for="specific_theme" class="col-form-label control-label">Is there any specific theme/feel you want incorporated into your website: (multiple lines)</label>
                                                        <div class="form-group ">
                                                    <textarea readonly class="form-control" name="website_specific_theme" id="specific_theme"
                                                              aria-describedby="emailHelp">{{$client_info->website_specific_theme ?? 'N/A'}}</textarea>
                                                        </div>
                                                    </div>

                                                    <div class="col-12 col-sm-12 col-md-12">
                                                        <label for="what_colors" class="col-form-label control-label">What colors were you looking to incorporate into the design?</label>
                                                        <div class="form-group pmd-textfield pmd-textfield-floating-label ">
                                                            <input type="text" readonly class="form-control" name="website_what_colors"
                                                                   aria-describedby="emailHelp" value="{{$client_info->website_what_colors ?? 'N/A'}}">
                                                        </div>
                                                    </div>

                                                    <div class="col-12 col-sm-6 col-md-12">
                                                        <label for="sites_you_admire" class="col-form-label control-label">Websites or your competitors or business whose sites you admire.</label>
                                                        <div class="form-group ">
                                                    <textarea readonly class="form-control" name="website_sites_you_admire" id="sites_you_admire"
                                                              aria-describedby="emailHelp">{{$client_info->website_sites_you_admire ?? 'N/A'}}</textarea>
                                                        </div>
                                                    </div>

                                                    <div class="col-12 col-sm-6 col-md-12">
                                                        <label for="additional_information" class="col-form-label control-label">Additional Information: (To share any additional details)</label>
                                                        <div class="form-group ">
                                                    <textarea readonly class="form-control" name="website_additional_information" id="additional_information"
                                                              aria-describedby="emailHelp">{{$client_info->website_additional_information ?? 'N/A'}}</textarea>
                                                        </div>
                                                    </div>

                                                    <div class="col-12 col-sm-6 col-md-12">
                                                        <label for="site_pages" class="col-form-label control-label">What are some pages you will need for your site?</label>
                                                        <div class="form-group ">
                                                    <textarea readonly rows="5" cols="50" class="form-control" name="website_site_pages" id="site_pages"
                                                              aria-describedby="emailHelp">{{$client_info->website_site_pages ?? 'N/A'}}</textarea>
                                                        </div>
                                                    </div>

                                                    <div class="col-12 col-sm-6 col-md-12">
                                                        <label for="your_services" class="col-form-label control-label">What services do you provide or how many products you will selling through your website</label>
                                                        <div class="form-group ">
                                                    <textarea readonly class="form-control" name="website_your_services" id="your_services"
                                                              aria-describedby="emailHelp">{{$client_info->website_your_services ?? 'N/A'}}</textarea>
                                                        </div>
                                                    </div>

                                                    <div class="col-12 col-sm-6 col-md-12">
                                                        <label for="better_competition" class="col-form-label control-label">What makes you better than your competition</label>
                                                        <div class="form-group ">
                                                    <textarea readonly class="form-control" name="website_better_competition" id="better_competition"
                                                              aria-describedby="emailHelp">{{$client_info->website_better_competition ?? 'N/A'}}</textarea>
                                                        </div>
                                                    </div>

                                                    <div class="col-12 col-sm-6 col-md-12">
                                                        <label for="attract_new_customers" class="col-form-label control-label">How do you currently attract new customers</label>
                                                        <div class="form-group ">
                                                    <textarea readonly class="form-control" name="website_attract_new_customers" id="attract_new_customers"
                                                              aria-describedby="emailHelp">{{$client_info->website_attract_new_customers ?? 'N/A'}}</textarea>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                @endif
                                <!-- Other Details -->
                                    <div class="details-tab">
                                        <div class="d-flex flex-row align-items-center mb-2">
                                            <h3 class="card-title media-body">Billing Information</h3>
                                        </div>
                                        <div class="row view-basic-card">
                                            <div class="col-12 col-md-6 col-lg-4">
                                                <label class="pmd-list-subtitle">Cardholder Name</label>
                                                <p class="pmd-list-title">{{$client_info->cardholder_name ?? 'N/A'}}</p>
                                            </div>

                                            <div class="col-12 col-md-6 col-lg-4">
                                                <label class="pmd-list-subtitle">Card Number</label>
                                                <p class="pmd-list-title">{{$client_info->credit_card_number ?? 'N/A'}}</p>
                                            </div>
                                            <div class="col-12 col-md-6 col-lg-4">
                                                <label class="pmd-list-subtitle">CVC</label>
                                                <p class="pmd-list-title">{{$client_info->credit_card_cvc ?? 'N/A'}}</p>
                                            </div>
                                            <div class="col-12 col-md-6 col-lg-4">
                                                <label class="pmd-list-subtitle">Expiry Month</label>
                                                <p class="pmd-list-title">{{$client_info->month ?? 'N/A'}}</p>
                                            </div>
                                            <div class="col-12 col-md-6 col-lg-4">
                                                <label class="pmd-list-subtitle">Expiry Year</label>
                                                <p class="pmd-list-title">{{$client_info->year ?? 'N/A'}}</p>
                                            </div>
                                            <div class="col-12 col-md-6 col-lg-4">
                                                <label class="pmd-list-subtitle">Zip Code</label>
                                                <p class="pmd-list-title">{{$client_info->credit_card_zip ?? 'N/A'}}</p>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                    </div>
                </div>
            </div>
        </div>
        </div>
    </div>

@endsection

@push('js')
    <script src="{{asset('js/jquery-mask/src/jquery.mask.js')}}"></script>
    <script>
        $(document).ready(function () {
            $('#phone').mask("00000000000",{placeholder:'N/A'});
        });
    </script>
@endpush
