@extends('layouts.app')
@section('page-title','Create Client')

@push('css')
    <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
@endpush
<style>
    .exp-wrapper {position: relative;border: 1px solid #aaa;display: flex;width: 300px;justify-content: space-around;height: 36px;line-height: 36px;font-size: 24px;}
    .exp-wrapper:after {content: '/';position: absolute;left: 50%;margin-left: -4px;color: #aaa;}
    input.exp {float: left;font-family: monospace;border: 0;width: 18px;outline: none;appearance: none;font-size: 14px;}
    textarea{ border: solid; }
    .refrence-material{ border: solid; padding: 10px; }
    .client-accord a { display: block; background-color: #3075ba3d; }
    .client-accord a:hover {background-color: #3075ba3d; }
    h3.client-accord-title { display: flex; justify-content: space-between; }
</style>
@section('content')

    <div id="content" class="pmd-content admin section">
        <!-- Title -->
        <h1>@yield('page-title')</h1>
        <!-- End Title -->
        <!--breadcrumb start-->
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb pmd-breadcrumb">
                <li class="breadcrumb-item">
                    <a href="{{route('dashboard')}}">Dashboard</a>
                </li>
                <li class="breadcrumb-item">Clients</li>
                <li class="breadcrumb-item active" aria-current="page">@yield('page-title')</li>
            </ol>
        </nav>
        <!--breadcrumb end-->

        <div class="row">
            <div class="col-md-12">
                <div class="card pmd-card">
                    <form method="post" autocomplete="off" action="{{route('insert-new.clients')}}" id="user_form" enctype="multipart/form-data">
                        @csrf
                        <input type="hidden" name="country_id" value="" id="get-country-id">
                        <input type="hidden" name="state_id" value="" id="get-state-id">
                        <input type="hidden" name="city_id" value="" id="get-city-id">
                        {{--  Customer Details--}}
                        <div id="accordion">
                            <div class="card mt-3 mr-3">
                                <div class="card-header client-accord" id="headingOne">
                                    <a class="btn btn-link" data-toggle="collapse" data-target="#collapseOne" aria-expanded="true" aria-controls="collapseOne">
                                        <h3 class="card-title client-accord-title">Customer Details <i class="fas fa-plus icon-toggle"></i></h3>
                                    </a>
                                </div>
                                <div id="collapseOne" class="collapse show" aria-labelledby="headingOne" data-parent="#accordion">
                                    <div class="card-body">
                                        <!-- Basic Information -->
                                        <div class="details-tab">
                                            <div class="row">
                                                <div class="col-12 col-sm-6 col-md-4">
                                                    <label for="fn" class="col-form-label control-label">First Name</label>
                                                    <div class="form-group pmd-textfield pmd-textfield-floating-label ">
                                                        <input type="text" class="form-control" name="firstname"
                                                               aria-describedby="emailHelp" id="fn" value="{{old('firstname')}}" required>
                                                        @error('firstname')
                                                            <span>
                                                                <strong class="text-danger">{{$message}}</strong>
                                                            </span>
                                                        @enderror()
                                                    </div>
                                                </div>
                                                <div class="col-12 col-sm-6 col-md-4">
                                                    <label for="ln" class="col-form-label control-label">Last Name</label>
                                                    <div class="form-group pmd-textfield pmd-textfield-floating-label ">
                                                        <input type="text" class="form-control" name="lastname" id="ln"
                                                               aria-describedby="emailHelp" value="{{old('lastname')}}" required>
                                                        @error('lastname')
                                                            <span>
                                                                <strong class="text-danger">{{$message}}</strong>
                                                            </span>
                                                        @enderror()
                                                    </div>
                                                </div>

                                                <div class="col-12 col-sm-6 col-md-4">
                                                    <label for="phone" class="col-form-label control-label">Phone</label>
                                                    <div class="form-group pmd-textfield pmd-textfield-floating-label ">
                                                        <input type="tel" class="form-control" name="phone"
                                                               aria-describedby="emailHelp" id="phone" value="{{old('phone')}}" required>
                                                        @error('phone')
                                                            <span>
                                                                <strong class="text-danger">{{$message}}</strong>
                                                            </span>
                                                        @enderror()
                                                    </div>
                                                </div>
                                                <div class="col-12 col-sm-6 col-md-6">
                                                    <label for="personal-email" class="col-form-label control-label">Email</label>
                                                    <div class="form-group pmd-textfield pmd-textfield-floating-label ">
                                                        <input type="email" class="form-control" name="email" id="personal-email"
                                                               aria-describedby="emailHelp" value="{{old('email')}}" required>

                                                        @error('email')
                                                            <span>
                                                                <strong class="text-danger">{{$message}}</strong>
                                                            </span>
                                                        @enderror()
                                                    </div>
                                                </div>
                                                <div class="col-12 col-sm-6 col-md-6">
                                                    <label for="password" class="col-form-label control-label">Password</label>
                                                    <div class="form-group pmd-textfield pmd-textfield-floating-label">
                                                        <input type="password" class="form-control" name="password"
                                                               aria-describedby="emailHelp" value="{{old('password')}}" required>
                                                        @error('password')
                                                            <span>
                                                                <strong class="text-danger">{{$message}}</strong>
                                                            </span>
                                                        @enderror()
                                                    </div>
                                                </div>

                                                <div class="col-12 col-sm-6 col-md-4">
                                                    <label for="password" class="col-form-label control-label">Select Country</label>
                                                    <div class="form-group pmd-textfield pmd-textfield-floating-label">
                                                        <select class="form-control select2 country" id="country_id" name="country">
                                                            <option value="" selected>Select Country</option>
                                                            @foreach($countries as $country)
                                                                <option value="{{$country->name}}" data-getId="{{$country->id}}">{{$country->name}}</option>
                                                            @endforeach
                                                        </select>
                                                    </div>
                                                </div>

                                                <div class="col-12 col-sm-6 col-md-4">
                                                    <label for="password" class="col-form-label control-label">Select State</label>
                                                    <div class="form-group pmd-textfield pmd-textfield-floating-label">
                                                        <select class="form-control state select2" id="state_id" name="state" required
                                                                style="width: 100%;">
                                                        </select>
                                                    </div>
                                                </div>
                                                <div class="col-12 col-sm-6 col-md-4">
                                                    <label for="password" class="col-form-label control-label">Select City</label>
                                                    <div class="form-group pmd-textfield pmd-textfield-floating-label">
                                                        <select class="form-control city select2" id="city_id" name="city" required
                                                                style="width: 100%;">
                                                        </select>
                                                    </div>
                                                </div>

                                                <div class="col-12 col-sm-6 col-md-4">
                                                    <label for="postal_code" class="col-form-label control-label">Postal Code</label>
                                                    <div class="form-group pmd-textfield pmd-textfield-floating-label ">
                                                        <input type="text" class="form-control" name="postal_code"
                                                               aria-describedby="emailHelp" id="fn" value="{{old('postal_code')}}" required>
                                                        @error('postal_code')
                                                            <span>
                                                                <strong class="text-danger">{{$message}}</strong>
                                                            </span>
                                                        @enderror()
                                                    </div>
                                                </div>
                                                <div class="col-12 col-sm-6 col-md-4">
                                                    <label for="postal_code" class="col-form-label control-label">Ip Address</label>
                                                    <div class="form-group pmd-textfield pmd-textfield-floating-label ">
                                                        <input type="text" class="form-control" name="ip_address" ip-mask placeholder=""
                                                               aria-describedby="emailHelp" id="ip_address" value="{{old('ip_address')}}" required>
                                                        @error('ip_address')
                                                            <span><strong class="text-danger">{{$message}}</strong></span>
                                                        @enderror()
                                                    </div>
                                                </div>
                                                <div class="col-12 col-sm-6 col-md-4">
                                                    <label for="web_url" class="col-form-label control-label">Web Url</label>
                                                    <div class="form-group pmd-textfield pmd-textfield-floating-label ">
                                                        <input type="url" class="form-control" name="web_url" id="web_url"
                                                               aria-describedby="emailHelp" value="{{old('web_url')}}">
                                                        @error('web_url')
                                                            <span>
                                                                <strong class="text-danger">{{$message}}</strong>
                                                            </span>
                                                        @enderror()
                                                    </div>
                                                </div>
                                            {{--Update --}}
                                                <div class="col-md-4">
                                                    <label for="fn" class="col-form-label control-label">Package</label>
                                                    <div class="form-group pmd-textfield pmd-textfield-floating-label ">
                                                        <select name="pkg_name" required class="form-control" id="payment-packages">
                                                            <option value="" selected disabled>Select Package</option>
                                                            <optgroup label="Logo Design">
                                                                <option value="Basic Logo" data-getActualPrice="$148" data-getDiscountedPrice="$99">Basic Logo $99</option>
                                                                <option value="Startup Package" data-getActualPrice="$223" data-getDiscountedPrice="$149">Startup Package $149</option>
                                                                <option value="Corporate Package" data-getActualPrice="$298" data-getDiscountedPrice="$199">Corporate Package $199</option>
                                                                <option value="Custom Illustration" data-getActualPrice="$373" data-getDiscountedPrice="$249">Custom Illustration $249</option>
                                                                <option value="Anax Special" data-getActualPrice="$1348" data-getDiscountedPrice="$899">Anax Special $899</option>
                                                                <option value="Platinum Illustration" data-getActualPrice="$598" data-getDiscountedPrice="$399">Platinum Illustration $399</option>
                                                            </optgroup>
                                                            <optgroup label="Website Development">
                                                                <option value="Starter Website" data-getActualPrice="$598" data-getDiscountedPrice="$399">Starter Website $399</option>
                                                                <option value="Advance Website" data-getActualPrice="$1198" data-getDiscountedPrice="$799">Advance Website $799</option>
                                                                <option value="Advanced Professional" data-getActualPrice="$1648" data-getDiscountedPrice="$1099">Advanced Professional $1099</option>
                                                                <option value="E-Commerce Website" data-getActualPrice="$2248" data-getDiscountedPrice="$1499">E-Commerce Website $1499</option>
                                                                <option value="Corporate Commerce Platform" data-getActualPrice="$3748" data-getDiscountedPrice="$2499">Corporate Commerce Platform $2499</option>
                                                                <option value="Platinum Custom Website" data-getActualPrice="$5998" data-getDiscountedPrice="$3999">Platinum Custom Website $3999</option>
                                                            </optgroup>
                                                            <optgroup label="Video Animation">
                                                                <option value="Startup Video" data-getActualPrice="$748" data-getDiscountedPrice="$499">Startup Video $499</option>
                                                                <option value="Premium Video" data-getActualPrice="$2248" data-getDiscountedPrice="$1499">Premium Video $1499</option>
                                                                <option value="Classic Video" data-getActualPrice="$1498" data-getDiscountedPrice="$999">Classic Video $999</option>
                                                            </optgroup>
                                                            <optgroup label="Mobile Application Development">
                                                                <option value="Mobile Application Development" data-getActualPrice="not confirmed" data-getDiscountedPrice="not confirmed">Mobile Application Development</option>
                                                            </optgroup>
                                                            <optgroup label="Digital Marketing Services">
                                                                <option value="Digital Marketing Services" data-getActualPrice="not confirmed" data-getDiscountedPrice="not confirmed">Digital Marketing Services</option>
                                                            </optgroup>
                                                        </select>
                                                    </div>
                                                    @error('pkg_name')
                                                        <span>
                                                            <strong class="text-danger">{{ $message }}</strong>
                                                        </span>
                                                    @enderror
                                                </div>
                                                <div class="col-md-4">
                                                    <label for="fn" class="col-form-label control-label">Product Type</label>
                                                    <div class="form-group pmd-textfield pmd-textfield-floating-label ">
                                                        <input type="text" readonly class="form-control" name="product_type" id="payment-product-type" value="">
                                                    </div>
                                                </div>
                                                <div class="col-md-4">
                                                    <label for="fn" class="col-form-label control-label">Price</label>
                                                    <div class="form-group pmd-textfield pmd-textfield-floating-label ">
                                                        <input type="text" readonly class="form-control" name="actual_pkg_price" id="payment-actual-pkg-price" value="">
                                                    </div>
                                                </div>
                                                <div class="col-md-4">
                                                    <label for="fn" class="col-form-label control-label">Discount Price</label>
                                                    <div class="form-group pmd-textfield pmd-textfield-floating-label ">
                                                        <input type="text" readonly class="form-control" name="discounted_pkg_price" id="payment-discounted-pkg-price" value="">
                                                    </div>
                                                </div>
                                                <div class="col-md-4">
                                                    <label for="fn" class="col-form-label control-label">Actual Amount</label>
                                                    <div class="form-group pmd-textfield pmd-textfield-floating-label ">
                                                        <input type="number" class="form-control amount-input" name="amount" value="{{old('amount')}}" required>

                                                    </div>
                                                    @error('amount')
                                                        <span>
                                                            <strong class="text-danger">{{ $message }}</strong>
                                                        </span>
                                                    @enderror
                                                </div>
                                                <div class="col-md-4">
                                                    <label for="fn" class="col-form-label control-label">Payment Type</label>
                                                    <div class="form-group pmd-textfield pmd-textfield-floating-label ">
                                                        <select name="payment_type" class="form-control" required>
                                                            <option value=" " selected disabled>Select Payment Type</option>
                                                            <option value="One time">One time</option>
                                                            <option value="Monthly">Monthly</option>
                                                            <option value="Quaterly">Quaterly</option>
                                                            <option value="Yearly">Yearly</option>
                                                        </select>
                                                        @error('payment_type')
                                                            <span>
                                                                <strong class="text-danger">{{ $message }}</strong>
                                                            </span>
                                                        @enderror
                                                    </div>
                                                </div>

                                                <div class="col-md-4">
                                                    <label for="fn" class="col-form-label control-label">Source</label>
                                                    <div class="form-group pmd-textfield pmd-textfield-floating-label ">
                                                        <select name="source" class="form-control" required>
                                                            <option value=" " selected disabled>Select Source</option>
                                                            <option value="Form">Form</option>
                                                            <option value="Chat">Chat</option>
                                                            <option value="Call">Call</option>
                                                            <option value="Email">Email</option>
                                                            <option value="Social Media">Social Media</option>
                                                            <option value="Refraral">Refraral</option>
                                                            <option value="Seo">Seo</option>
                                                        </select>
                                                        @error('payment_type')
                                                        <span>
                                                                <strong class="text-danger">{{ $message }}</strong>
                                                            </span>
                                                        @enderror
                                                    </div>
                                                </div>

                                                <div class="col-md-4">
                                                    <label for="fn" class="col-form-label control-label">Brand</label>
                                                    <div class="form-group pmd-textfield pmd-textfield-floating-label ">
                                                        <select name="brand" class="form-control" required>
                                                            <option value=" " selected disabled>Select Brand</option>
                                                            <option value="Anax Designs">Anax Designs</option>
                                                            <option value="LDV">LDV</option>
                                                            <option value="BCM">BCM</option>
                                                            <option value="Publish">Publish</option>
                                                        </select>
                                                        @error('payment_type')
                                                        <span>
                                                                <strong class="text-danger">{{ $message }}</strong>
                                                            </span>
                                                        @enderror
                                                    </div>
                                                </div>
                                            {{--End Update --}}




{{--                                                <div class="col-12 col-sm-6 col-md-4">--}}
{{--                                                    <label for="product_type" class="col-form-label control-label">Select Product Type </label>--}}
{{--                                                    <div class="form-group pmd-textfield pmd-textfield-floating-label">--}}
{{--                                                        <select name="product_type" id="prod_type" class="form-control" required>--}}
{{--                                                            <option value="" selected disabled>Select Type</option>--}}
{{--                                                            <option value="LOGO" > LOGO</option>--}}
{{--                                                            <option value="WEBSITE" > WEBSITE</option>--}}
{{--                                                        </select>--}}
{{--                                                    </div>--}}
{{--                                                </div>--}}
{{--                                                <div class="col-12 col-sm-6 col-md-4">--}}
{{--                                                    <label for="project_type" class="col-form-label control-label">Package Name</label>--}}
{{--                                                    <div class="form-group pmd-textfield pmd-textfield-floating-label ">--}}
{{--                                                        <input type="text" class="form-control" name="project_type"--}}
{{--                                                               aria-describedby="emailHelp" value="{{old('project_type')}}">--}}
{{--                                                    </div>--}}
{{--                                                </div>--}}
                                                {{--Status--}}
                                                <div class="col-12 col-sm-6 col-md-4">
                                                    <label for="client_status" class="col-form-label control-label">Client Status</label>
                                                    <div class="form-group pmd-textfield pmd-textfield-floating-label ">
                                                        <select name="client_status" class="form-control" id="client_status" required>
                                                            <option value=" " selected disabled>Select Status</option>
                                                            <optgroup label="Lead">
                                                                <option value="Connected">Connected</option>
                                                                <option value="Not Connected">Not Connected</option>
                                                                <option value="Not Interested">Not Interested</option>
                                                                <option value="Invalid">Invalid</option>
{{--                                                                <option value="Paid">Paid</option>--}}
                                                                <option value="DNC">Do not call</option>
                                                            </optgroup>
                                                            <optgroup label="Client">
                                                                <option value="Sale">Sale</option>
{{--                                                                <option value="Upsell">Upsell</option>--}}
{{--                                                                <option value="Recurring">Recurring</option>--}}
{{--                                                                <option value="Returning">Returning</option>--}}
{{--                                                                <option value="Referral">Referral</option>--}}
{{--                                                                <option value="Angry">Angry</option>--}}
                                                            </optgroup>
                                                        </select>
                                                        @error('client_status')
                                                            <span>
                                                                <strong class="text-danger">{{$message}}</strong>
                                                            </span>
                                                        @enderror()
                                                    </div>
                                                </div>
                                                {{--  End Status--}}

                                                {{--Getting client type on behalf of status--}}
                                                <div class="col-12 col-sm-6 col-md-4">
                                                    <div class="form-group pmd-textfield pmd-textfield-floating-label ">
                                                        <input type="hidden" class="form-control" name="client_type" value="" id="client_type"
                                                               aria-describedby="emailHelp">
                                                    </div>
                                                </div>
                                                {{--End Getting client type on behalf of status--}}
                                                <div class="col-12 col-sm-6 col-md-12">
                                                    <label for="comments" class="col-form-label control-label">Project /Other Description</label>
                                                    <div class="form-group ">
                                                        <textarea class="form-control" name="comments" id="comments"
                                                                  aria-describedby="emailHelp">{{old('comments')}}</textarea>
                                                        @error('comments')
                                                            <span>
                                                                <strong class="text-danger">{{$message}}</strong>
                                                            </span>
                                                        @enderror()
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div id="accordion" class="logo_design d-none">
                            <div class="card mt-3 mr-3">
                                <div class="card-header client-accord" id="headingTwo">
                                    <a class="btn btn-link" data-toggle="collapse" data-target="#collapseTwo" aria-expanded="true" aria-controls="collapseTwo">
                                        <h3 class="card-title client-accord-title">Product Information <i class="fas fa-plus icon-toggle"></i> </h3>
                                    </a>
                                </div>

                                <div id="collapseTwo" class="collapse show" aria-labelledby="headingTwo" data-parent="#accordion">
                                    <div class="card-body">
                                        <!-- Basic Information -->
                                        <div class="details-tab">
                                            <div class="row">
                                                <div class="col-12 col-sm-6 col-md-6">
                                                    <label for="logo_exact_name" class="col-form-label control-label">Exact Name To Be Appeared On Logo</label>
                                                    <div class="form-group pmd-textfield pmd-textfield-floating-label ">
                                                        <input type="text" class="form-control" name="logo_exact_name" aria-describedby="emailHelp"  value="{{old('logo_exact_name')}}" >
                                                    </div>
                                                </div>
                                                <div class="col-12 col-sm-6 col-md-6 mt-1">
                                                    <label for="package">Package</label>
                                                    <div class="form-group pmd-textfield pmd-textfield-floating-label">
                                                        <select name="billing_package" id="available_package" class="form-control">
                                                            <option value="" selected disabled>Select Package</option>
                                                            <option value="BASIC LOGO" data-price="29" data-value="BASIC LOGO $29">BASIC LOGO $29</option>
                                                            <option value="STARTUP LOGO" data-price="89" data-value="STARTUP LOGO $89">STARTUP LOGO $89</option>
                                                            <option value="PROFESSIONAL LOGO" data-price="119" data-value="PROFESSIONAL LOGO $119">PROFESSIONAL LOGO $119</option>
                                                            <option value="CORPORATE LOGO" data-price="229" data-value="CORPORATE LOGO $229">CORPORATE LOGO $229</option>
                                                            <option value="ELITE LOGO" data-price="499" data-value="ELITE LOGO $499">ELITE LOGO $499</option>
                                                            <option value="ILLUSTRATIVE LOGO" data-price="399" data-value="ILLUSTRATIVE LOGO $399">ILLUSTRATIVE LOGO $399</option>
                                                        </select>
                                                    </div>
                                                </div>

                                                <div class="col-12 col-sm-6 col-md-6">
                                                    <label for="amount" class="col-form-label control-label">Amount</label>
                                                    <div class="form-group pmd-textfield pmd-textfield-floating-label">
                                                        <input type="hidden" name="billing_amount" id="amount" readonly>
                                                        <input type="text" class="form-control" name="price_pack" id="package_amount" aria-describedby="emailHelp" value="{{old('billing_amount')}}" readonly>
                                                    </div>
                                                </div>
                                                <div class="col-12 col-sm-6 col-md-6">
                                                    <label for="logo_slogan" class="col-form-label control-label">Slogan (If Any)</label>
                                                    <div class="form-group pmd-textfield pmd-textfield-floating-label ">
                                                        <input type="text" class="form-control" name="logo_slogan" aria-describedby="emailHelp"  value="{{old('logo_slogan')}}" >
                                                    </div>
                                                </div>
                                                <div class="col-12 col-sm-6 col-md-6 mt-2">
                                                    <label for="look_and_feel">Look And Feel</label>
                                                    <div class="form-group pmd-textfield pmd-textfield-floating-label">
                                                        <select name="look_and_feel" class="form-control" >
                                                            <option value="" disabled selected>Select Style of Logo</option>
                                                            <option id="Modern" value="Modern">Modern</option>
                                                            <option id="Hi-Tec" value="Hi-Tec">Hi-Tec</option>
                                                            <option id="Contemporary" value="Contemporary">Contemporary</option>
                                                            <option id="Funny" value="Funny">Funny</option>
                                                            <option id="Antique" value="Antique">Antique</option>
                                                            <option id="Corporate" value="Corporate">Corporate</option>
                                                            <option id="Other" value="Other">Other</option>
                                                        </select>
                                                    </div>
                                                </div>

                                                <div class="col-12 col-sm-6 col-md-6">
                                                    <label for="logo_competitor_ref" class="col-form-label control-label">Competitors Reference Optional, you can enter multiple Links</label>
                                                    <div class="form-group pmd-textfield pmd-textfield-floating-label ">
                                                        <input type="text" class="form-control" name="logo_competitor_ref" aria-describedby="emailHelp"  value="{{old('logo_competitor_ref')}}" >
                                                    </div>
                                                </div>
                                                <div class="col-12 col-sm-6 col-md-6">
                                                    <label for="logo_primary_color" class="col-form-label control-label">Select Primary Color Write the name Like "Blue" or code Like "#FFFF00"</label>
                                                    <div class="form-group pmd-textfield pmd-textfield-floating-label ">
                                                        <input type="text" class="form-control" name="logo_primary_color" aria-describedby="emailHelp"  value="{{old('logo_primary_color')}}" >
                                                    </div>
                                                </div>
                                                <div class="col-12 col-sm-6 col-md-6">
                                                    <label for="logo_secondary_color" class="col-form-label control-label">Select Secondary Color Write the name Like "Blue" or code Like "#FFFF00"</label>
                                                    <div class="form-group pmd-textfield pmd-textfield-floating-label ">
                                                        <input type="text" class="form-control" name="logo_secondary_color" aria-describedby="emailHelp"  value="{{old('logo_secondary_color')}}" >
                                                    </div>
                                                </div>
                                                <div class="col-12 col-sm-6 col-md-6">
                                                    <label for="logo_industry" class="col-form-label control-label">Industry</label>
                                                    <div class="form-group pmd-textfield pmd-textfield-floating-label ">
                                                        <input type="text" class="form-control" name="logo_industry" aria-describedby="emailHelp"  value="{{old('logo_industry')}}" >
                                                    </div>
                                                </div>
                                                <div class="col-12 col-sm-6 col-md-6">
                                                    <label for="logo_targeted_audience" class="col-form-label control-label">Your Target Audience</label>
                                                    <div class="form-group pmd-textfield pmd-textfield-floating-label ">
                                                        <input type="text" class="form-control" name="logo_targeted_audience" aria-describedby="emailHelp"  value="{{old('logo_targeted_audience')}}" >
                                                    </div>
                                                </div>

                                                <div class="col-12 col-sm-6 col-md-6 mt-2">
                                                    <label for="logo_typography">Select Typography</label>
                                                    <div class="form-group pmd-textfield pmd-textfield-floating-label">
                                                        <select name="logo_typography" class="form-control" id="preferred_style_logo">
                                                            <option value="" disabled selected>Select your prefer typography Style.</option>
                                                            <option value="COMIC">COMIC</option>
                                                            <option value="STENCIL">STENCIL</option>
                                                            <option value="GOTHIC">GOTHIC</option>
                                                            <option value="SCRIPT">SCRIPT</option>
                                                            <option value="HANDWRITTEN">HANDWRITTEN</option>
                                                            <option value="SANS">SANS SERIF</option>
                                                            <option value="SERIF">SERIF</option>
                                                            <option value="RETRO">RETRO</option>
                                                            <option value="TECHNO">TECHNO</option>
                                                            <option value="TYPEWRITER">TYPEWRITER</option>
                                                        </select>
                                                    </div>
                                                </div>

                                                <div class="col-12 col-sm-6 col-md-6 mt-2">
                                                    <label for="logo_type">Select Logo Type</label>
                                                    <div class="form-group pmd-textfield pmd-textfield-floating-label">
                                                        <select name="logo_type" class="form-control" id="preferred_style_logo">
                                                            <option value="" disabled selected>Select your Logo Style.</option>
                                                            <option value="SYMBOL OR ICON">SYMBOL OR ICON</option>
                                                            <option value="WORD MARK">WORD MARK</option>
                                                            <option value="LETTER MARK">LETTER MARK</option>
                                                            <option value="COMBINATION MARK">COMBINATION MARK</option>
                                                            <option value="CHARACTER BASED">CHARACTER BASED</option>
                                                            <option value="EMBLEM">EMBLEM</option>
                                                        </select>
                                                    </div>
                                                </div>
                                                <div class="col-12 col-sm-6 col-md-6">
                                                    <label for="logo_targeted_audience" class="col-form-label control-label">Upload Reference Material</label>
                                                    <div class="form-group pmd-textfield pmd-textfield-floating-label">
                                                        <input type="file" multiple class="refrence-material" name="logo_refrence_material[]" aria-label="Upload Reference Material">
                                                    </div>
                                                </div>

                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        {{-- End Logo Design details--}}

                        {{--Logo Package details--}}
                        <div id="accordion" class="logo_packages d-none">
                            <div class="card mt-3 mr-3">
                                <div class="card-header client-accord" id="headingThree">
                                    <a class="btn btn-link" data-toggle="collapse" data-target="#collapseThree" aria-expanded="true" aria-controls="collapseThree">
                                        <h3 class="card-title client-accord-title">Logo Package Details <i class="fas fa-plus icon-toggle"></i> </h3>
                                    </a>
                                </div>

                                <div id="collapseThree" class="collapse show" aria-labelledby="headingThree" data-parent="#accordion">
                                    <div class="card-body">
                                        <div class="details-tab">
                                            <div class="row">
                                                <div id="select_pack" class="package-details">
                                                    <li>Please select package first.</li>
                                                </div>
                                                <div id="Logo_Basic" class="package-details  d-none">
                                                    <h3>BASIC LOGO</h3>
                                                    <ul>
                                                        <li>2 Original Logo Concepts</li>
                                                        <li>1 Dedicated Logo Designer</li>
                                                        <li>4 Revisions</li>
                                                        <li>With Grey Scale Format</li>
                                                        <li>Free Icon Design</li>
                                                        <li>Formats: JPEG Only</li>
                                                        <li>24 - 48 Hours Turn Around Time</li>
                                                        <li>100% Satisfaction</li>
                                                        <li>100% Ownership Rights</li>
                                                        <li>Money Back Guarantee</li>
                                                        <li>Dedicated Account Manager</li>
                                                    </ul>
                                                </div>

                                                <div id="Logo_Startup" class="package-details d-none">
                                                    <h3>STARTUP LOGO</h3>
                                                    <ul>
                                                        <li>4 Original Logo Concepts</li>
                                                        <li>2 Dedicated Logo Designer</li>
                                                        <li>8 Revisions</li>
                                                        <li>With Grey Scale Format</li>
                                                        <li>Free Icon Design</li>
                                                        <li>Formats: JPEG, PSD, EPS, AI, PNG</li>
                                                        <li>24 - 48 Hours Turn Around Time</li>
                                                        <li>100% Satisfaction</li>
                                                        <li>100% Ownership Rights</li>
                                                        <li>Money Back Guarantee</li>
                                                        <li>Dedicated Account Manager</li>
                                                    </ul>
                                                </div>

                                                <div id="Logo_Professional" class="package-details d-none">
                                                    <h3>PROFESSIONAL LOGO</h3>
                                                    <ul>
                                                        <li>8 Original Logo Concepts</li>
                                                        <li>4 Dedicated Logo Designer (Industry Specific)</li>
                                                        <li>Unlimited Revisions</li>
                                                        <li>Stationery Design</li>
                                                        <li>(Business Card, Letterhead, Envelope)</li>
                                                        <li>Email Signature Design</li>
                                                        <li>With Grey Scale Format</li>
                                                        <li>Free Icon Design</li>
                                                        <li>Formats: JPEG, PSD, EPS, AI, PNG, TIFF, SVG</li>
                                                        <li>24 - 48 Hours Turn Around Time</li>
                                                        <li>100% Satisfaction</li>
                                                        <li>100% Ownership Rights</li>
                                                        <li>Money Back Guarantee</li>
                                                        <li>Dedicated Account Manager</li>
                                                    </ul>
                                                </div>

                                                <div id="Logo_Corporate" class="package-details d-none">
                                                    <h3>CORPORATE LOGO</h3>
                                                    <ul>
                                                        <li>Unlimited Original Logo Concepts</li>
                                                        <li>8 Dedicated Logo Designer (Industry Specific)</li>
                                                        <li>Unlimited Revisions</li>
                                                        <li>Stationery Design</li>
                                                        <li>(Business Card, Letterhead, Envelope)</li>
                                                        <li>Email Signature Design</li>
                                                        <li>Social Media Designs (Facebook, Twitter, Instagram)</li>
                                                        <li>2 Sided Flyer OR Bi-Fold Brochure Design</li>
                                                        <li>With Grey Scale Format</li>
                                                        <li>Free Icon Design</li>
                                                        <li>Formats: JPEG, PSD, EPS, AI, PNG, TIFF, SVG</li>
                                                        <li>24 - 48 Hours Turn Around Time</li>
                                                        <li>100% Satisfaction</li>
                                                        <li>100% Ownership Rights</li>
                                                        <li>Money Back Guarantee</li>
                                                        <li>Dedicated Account Manager</li>
                                                    </ul>
                                                </div>

                                                <div id="Logo_Elite" class="package-details d-none">
                                                    <h3>ELITE LOGO</h3>
                                                    <ul>
                                                        <li>Unlimited Original Logo Concepts</li>
                                                        <li>8 Dedicated Logo Designer (Industry Specific)</li>
                                                        <li>Unlimited Revisions</li>
                                                        <li>Stationery Design</li>
                                                        <li>(Business Card, Letterhead, Envelope)</li>
                                                        <li>Email Signature Design</li>
                                                        <li>Social Media Designs (Facebook, Twitter, Instagram)</li>
                                                        <li>3 Page Custom Website</li>
                                                        <li>Mobile Responsive</li>
                                                        <li>2 Stock Photos</li>
                                                        <li>jQuery Slider</li>
                                                        <li>Formats: JPEG, PSD, EPS, AI, PNG, TIFF, SVG</li>
                                                        <li>24 - 48 Hours Turn Around Time</li>
                                                        <li>100% Satisfaction</li>
                                                        <li>100% Ownership Rights</li>
                                                        <li>Money Back Guarantee</li>
                                                        <li>Dedicated Account Manager</li>
                                                    </ul>
                                                </div>

                                                <div id="Logo_Illustrative" class="package-details d-none">
                                                    <h3>ILLUSTRATIVE LOGO</h3>
                                                    <ul>
                                                        <li>3 Custom Illustrative Logo Design Concepts</li>
                                                        <li>3 Dedicated Logo Designer (Industry Specific)</li>
                                                        <li>Unlimited Revisions</li>
                                                        <li>Stationery Design</li>
                                                        <li>(Business Card, Letterhead, Envelope)</li>
                                                        <li>Email Signature Design</li>
                                                        <li>With Grey Scale Format</li>
                                                        <li>Free Icon Design</li>
                                                        <li>Formats: JPEG, PSD, EPS, AI, PNG, TIFF, SVG</li>
                                                        <li>48 - 72 Hours Turn Around Time</li>
                                                        <li>100% Satisfaction</li>
                                                        <li>100% Ownership Rights</li>
                                                        <li>Money Back Guarantee</li>
                                                        <li>Dedicated Account Manager</li>
                                                    </ul>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        {{-- End Logo Package details--}}

                        {{-- Video Animation details--}}
                        <div id="accordion" class="video_animation d-none">
                            <div class="card mt-3 mr-3">
                                <div class="card-header client-accord" id="headingFive">
                                    <a class="btn btn-link" data-toggle="collapse" data-target="#collapseFive" aria-expanded="true" aria-controls="collapseFive">
                                        <h3 class="card-title client-accord-title">Product Information <i class="fas fa-plus icon-toggle"></i> </h3>
                                    </a>
                                </div>

                                <div id="collapseFive" class="collapse show" aria-labelledby="headingFive" data-parent="#accordion">
                                    <div class="card-body">
                                        <!-- Basic Information -->
                                        <div class="details-tab">
                                            <div class="row">
                                                <div class="col-12 col-sm-6 col-md-6">
                                                    <label for="amount" class="col-form-label control-label">Years of business existence?</label>
                                                    <div class="form-group pmd-textfield pmd-textfield-floating-label">
                                                        <input type="text" class="form-control" name="animation_years_business_existence" aria-describedby="emailHelp"  value="{{old('animation_years_business_existence')}}" >
                                                    </div>
                                                </div>
                                                <div class="col-12 col-sm-6 col-md-6">
                                                    <label for="amount" class="col-form-label control-label">What is the purpose of this video?</label>
                                                    <div class="form-group pmd-textfield pmd-textfield-floating-label">
                                                        <input type="text" class="form-control" name="animation_video_purpose" aria-describedby="emailHelp"  value="{{old('animation_video_purpose')}}" >
                                                    </div>
                                                </div>
                                                <div class="col-12 col-sm-6 col-md-6">
                                                    <label for="amount" class="col-form-label control-label">Who is your target audience?</label>
                                                    <div class="form-group pmd-textfield pmd-textfield-floating-label">
                                                        <input type="text" class="form-control" name="animation_target_audience" aria-describedby="emailHelp"  value="{{old('animation_target_audience')}}" >
                                                    </div>
                                                </div>
                                                <div class="col-12 col-sm-6 col-md-6">
                                                    <label for="amount" class="col-form-label control-label">Please confirm the gender for voiceover?</label>
                                                    <div class="form-group pmd-textfield pmd-textfield-floating-label">
                                                        <input type="text" class="form-control" name="animation_voiceover_gender" aria-describedby="emailHelp"  value="{{old('animation_voiceover_gender')}}" >
                                                    </div>
                                                </div>
                                                <div class="col-12 col-sm-6 col-md-6">
                                                    <label for="amount" class="col-form-label control-label">What accent do you prefer for the voice over?</label>
                                                    <div class="form-group pmd-textfield pmd-textfield-floating-label">
                                                        <input type="text" class="form-control" name="animation_voiceover_accent" aria-describedby="emailHelp"  value="{{old('animation_voiceover_accent')}}" >
                                                    </div>
                                                </div>
                                                <div class="col-12 col-sm-6 col-md-6 mt-1">
                                                    <label for="package">Please select type of the voice over</label>
                                                    <div class="form-group pmd-textfield pmd-textfield-floating-label">
                                                        <select name="animation_voiceover_type" class="form-control">
                                                            <option value="" selected disabled>Select type of the voice over</option>
                                                            <option value="Professional">Professional</option>
                                                            <option value="Functional">Functional</option>
                                                            <option value="Friendly">Friendly</option>
                                                            <option value="Conventional">Conventional</option>
                                                            <option value="Trendy">Trendy</option>
                                                            <option value="Informational">Informational</option>
                                                            <option value="Simple & Easy and Promotional">Simple & Easy and Promotional</option>
                                                        </select>
                                                    </div>
                                                </div>
                                                <div class="col-12 col-sm-6 col-md-12">
                                                    <label for="sites_you_admire" class="col-form-label control-label">Please inform us about your business in detail?</label>
                                                    <div class="form-group ">
                                                        <textarea class="form-control" name="animation_business_detail" aria-describedby="emailHelp">{{old('animation_business_detail')}}</textarea>
                                                    </div>
                                                </div>
                                                <div class="col-12 col-sm-6 col-md-12">
                                                    <label for="sites_you_admire" class="col-form-label control-label">What is the duration of your video? (75 Words is for 30 Sec Video)</label>
                                                    <div class="form-group ">
                                                        <textarea class="form-control" name="animation_video_duration" aria-describedby="emailHelp">{{old('animation_video_duration')}}</textarea>
                                                    </div>
                                                </div>

                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        {{-- End Video Animation details--}}

                        {{-- Website Design details--}}
                        <div id="accordion" class="website_design d-none">
                            <div class="card mt-3 mr-3">
                                <div class="card-header client-accord" id="headingFive">
                                    <a class="btn btn-link" data-toggle="collapse" data-target="#collapseFive" aria-expanded="true" aria-controls="collapseFive">
                                        <h3 class="card-title client-accord-title">Product Information <i class="fas fa-plus icon-toggle"></i> </h3>
                                    </a>
                                </div>

                                <div id="collapseFive" class="collapse show" aria-labelledby="headingFive" data-parent="#accordion">
                                    <div class="card-body">
                                        <!-- Basic Information -->
                                        <div class="details-tab">
                                            <div class="row">
                                                <div class="col-12 col-sm-12 col-md-12">
                                                    <label for="domain_purchased" class="col-form-label control-label">Current Web Host</label>
                                                    <div class="form-group pmd-textfield pmd-textfield-floating-label ">
                                                        <input type="text" class="form-control" name="website_current_web_host"
                                                               aria-describedby="emailHelp"  value="{{old('website_current_web_host')}}">
                                                    </div>
                                                </div>
                                                <div class="col-12 col-sm-12 col-md-12">
                                                    <label for="domain_purchased" class="col-form-label control-label">Did you already purchase a domain? If yes, who with: (we will need access to that account later on)</label>
                                                    <div class="form-group pmd-textfield pmd-textfield-floating-label ">
                                                        <input type="text" class="form-control" name="website_domain_purchased"
                                                               aria-describedby="emailHelp"  value="{{old('domain_purchased')}}">
                                                    </div>
                                                </div>
                                                <div class="col-12 col-sm-12 col-md-12">
                                                    <label for="providing_image" class="col-form-label control-label">Will you be providing any images for the website</label>
                                                    <div class="form-group pmd-textfield pmd-textfield-floating-label ">
                                                        <input type="text" class="form-control" name="website_providing_image"
                                                               aria-describedby="emailHelp"  value="{{old('providing_image')}}">
                                                    </div>
                                                </div>

                                                <div class="col-12 col-sm-12 col-md-12">
                                                    <label for="have_content" class="col-form-label control-label">Do you have all the content (text, info, articles, copy) available for your pages</label>
                                                    <div class="form-group pmd-textfield pmd-textfield-floating-label ">
                                                        <input type="text" class="form-control" name="website_have_content"
                                                               aria-describedby="emailHelp"  value="{{old('have_content')}}">
                                                    </div>
                                                </div>
                                                <div class="col-12 col-sm-6 col-md-12">
                                                    <label for="company_desc" class="col-form-label control-label">Briefly describe your company</label>
                                                    <div class="form-group ">
                                                        <textarea class="form-control" name="website_company_desc" id="company_desc"
                                                                  aria-describedby="emailHelp">{{old('company_desc')}}</textarea>
                                                    </div>
                                                </div>

                                                <div class="col-12 col-sm-6 col-md-12">
                                                    <label for="specific_theme" class="col-form-label control-label">Is there any specific theme/feel you want incorporated into your website: (multiple lines)</label>
                                                    <div class="form-group ">
                                                        <textarea class="form-control" name="website_specific_theme" id="specific_theme"
                                                                  aria-describedby="emailHelp">{{old('specific_theme')}}</textarea>
                                                    </div>
                                                </div>

                                                <div class="col-12 col-sm-12 col-md-12">
                                                    <label for="what_colors" class="col-form-label control-label">What colors were you looking to incorporate into the design?</label>
                                                    <div class="form-group pmd-textfield pmd-textfield-floating-label ">
                                                        <input type="text" class="form-control" name="website_what_colors"
                                                               aria-describedby="emailHelp" value="{{old('what_colors')}}">
                                                    </div>
                                                </div>

                                                <div class="col-12 col-sm-6 col-md-12">
                                                    <label for="sites_you_admire" class="col-form-label control-label">Websites or your competitors or business whose sites you admire.</label>
                                                    <div class="form-group ">
                                                        <textarea class="form-control" name="website_sites_you_admire" id="sites_you_admire"
                                                                  aria-describedby="emailHelp">{{old('website_sites_you_admire')}}</textarea>
                                                    </div>
                                                </div>

                                                <div class="col-12 col-sm-6 col-md-12">
                                                    <label for="additional_information" class="col-form-label control-label">Additional Information: (To share any additional details)</label>
                                                    <div class="form-group ">
                                                        <textarea class="form-control" name="website_additional_information" id="additional_information"
                                                                  aria-describedby="emailHelp">{{old('website_additional_information')}}</textarea>
                                                    </div>
                                                </div>

                                                <div class="col-12 col-sm-6 col-md-12">
                                                    <label for="site_pages" class="col-form-label control-label">What are some pages you will need for your site?</label>
                                                    <div class="form-group ">
                                                        <textarea rows="5" cols="50" class="form-control" name="website_site_pages" id="site_pages"
                                                                  aria-describedby="emailHelp">
Home
About US
FAQ
Services
Contact Info
{{old('website_site_pages')}}
                                                            </textarea>
                                                    </div>
                                                </div>

                                                <div class="col-12 col-sm-6 col-md-12">
                                                    <label for="your_services" class="col-form-label control-label">What services do you provide or how many products you will selling through your website</label>
                                                    <div class="form-group ">
                                                        <textarea class="form-control" name="website_your_services" id="your_services"
                                                                  aria-describedby="emailHelp">{{old('website_your_services')}}</textarea>
                                                    </div>
                                                </div>

                                                <div class="col-12 col-sm-6 col-md-12">
                                                    <label for="better_competition" class="col-form-label control-label">What makes you better than your competition</label>
                                                    <div class="form-group ">
                                                        <textarea class="form-control" name="website_better_competition" id="better_competition"
                                                                  aria-describedby="emailHelp">{{old('website_better_competition')}}</textarea>
                                                    </div>
                                                </div>

                                                <div class="col-12 col-sm-6 col-md-12">
                                                    <label for="attract_new_customers" class="col-form-label control-label">How do you currently attract new customers</label>
                                                    <div class="form-group ">
                                                        <textarea class="form-control" name="website_attract_new_customers" id="attract_new_customers"
                                                                  aria-describedby="emailHelp">{{old('website_attract_new_customers')}}</textarea>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        {{-- End Website Design details--}}

                        {{--   Card details --}}
                        <div id="accordion">
                            <div class="card mt-3 mr-3">
                                <div class="card-header client-accord" id="headingFour">
                                    <a class="btn btn-link" data-toggle="collapse" data-target="#collapseFour" aria-expanded="true" aria-controls="collapseFour">
                                        <h3 class="card-title client-accord-title">BILLING INFORMATION <i class="fas fa-plus icon-toggle"></i> </h3>
                                    </a>
                                </div>

                                <div id="collapseFour" class="collapse show" aria-labelledby="headingFour" data-parent="#accordion">
                                    <div class="card-body">
                                        <!-- Basic Information -->
                                        <div class="details-tab">
                                            <div class="row">

                                                <div class="col-12 col-sm-6 col-md-4">
                                                    <label for="cardholder_name" class="col-form-label control-label">Cardholder Name</label>
                                                    <div class="form-group pmd-textfield pmd-textfield-floating-label">
                                                        <input type="text" class="form-control checkout-input checkout-name" name="cardholder_name"
                                                               id="cardholder_name" value="{{ old('cardholder_name') }}">
                                                        @error('cardholder_name')
                                                            <span>
                                                                <strong class="text-danger">{{ $message }}</strong>
                                                            </span>
                                                        @enderror
                                                    </div>
                                                </div>

                                                <div class="col-12 col-sm-6 col-md-4">
                                                    <label for="credit_card_number" class="col-form-label control-label">Card Number</label>
                                                    <div class="form-group pmd-textfield pmd-textfield-floating-label">
                                                        <input minlength="16" maxlength="16" pattern="[0-9]{16}" type="text"
                                                               class="form-control checkout-input checkout-card" name="credit_card_number" id="credit_card_number" value="{{ old('credit_card_number') }}">
                                                        @error('credit_card_number')
                                                            <span>
                                                                <strong class="text-danger">{{ $message }}</strong>
                                                            </span>
                                                        @enderror
                                                    </div>
                                                </div>

                                                <div class="col-12 col-sm-6 col-md-4">
                                                    <label for="credit_card_cvc" class="col-form-label control-label">CVC</label>
                                                    <div class="form-group pmd-textfield pmd-textfield-floating-label">
                                                        <input minlength="3" maxlength="3" pattern="[0-9]{3}" type="text"
                                                               class="form-control checkout-input checkout-cvc" name="credit_card_cvc" id="credit_card_cvc" value="{{ old('credit_card_cvc') }}">
                                                        @error('credit_card_cvc')
                                                            <span>
                                                                <strong class="text-danger">{{ $message }}</strong>
                                                            </span>
                                                        @enderror
                                                    </div>
                                                </div>
                                                <?php
                                                $months = [
                                                    "", 'January', 'February', 'March', 'April', 'May',
                                                    'June', 'July', 'August', 'September',
                                                    'October', 'November', 'December'
                                                ];
                                                ?>
                                                <div class="col-12 col-sm-6 col-md-4">
                                                    <label  class="col-form-label control-label">Expiry Date</label>
                                                    <select class="checkout-input checkout-exp month-dropdown form-control" name="month">
                                                        <option value=" " disabled selected>Select Month</option>
                                                    <?php $starting_month = (int)date("m", time()); ?>
                                                        <?php for ($i = $starting_month; $i <= 12; $i++): ?>
                                                        <option value="<?= $i ?>"><?= $months[$i] ?></option>
                                                        <?php endfor; ?>
                                                    </select>
                                                    <select class="checkout-input checkout-exp year-dropdown form-control mt-1" name="year">
                                                        <option value=" " disabled selected>Select Year</option>
                                                    <?php $starting_year = (int)date("Y", time()); ?>
                                                        <?php for ($i = $starting_year; $i < $starting_year + 10; $i++): ?>
                                                        <option value="<?= $i ?>"><?= $i ?></option>
                                                        <?php endfor; ?>
                                                    </select>
                                                </div>

                                                <div class="col-12 col-sm-6 col-md-4">
                                                    <label for="credit_card_zip" class="col-form-label control-label">Zip Code</label>
                                                    <div class="form-group pmd-textfield pmd-textfield-floating-label">
                                                        <input type="text" minlength="5" maxlength="5" pattern="[0-9]{5}" class="form-control checkout-input"
                                                               name="credit_card_zip" id="credit_card_zip" value="{{ old('credit_card_zip') }}">
                                                        @error('credit_card_zip')
                                                            <span>
                                                                <strong class="text-danger">{{ $message }}</strong>
                                                            </span>
                                                        @enderror
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                            </div>
                        </div>
                        {{--  End --}}

                        <div class="card-footer pmd-card-border">
                            <button class="btn pmd-ripple-effect btn-primary pmd-btn-raised form_submit_btn" type="submit">Create</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection

@push('js')
    <script src="{{asset('js/jquery-mask/src/jquery.mask.js')}}"></script>
    <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
    <script src="{{asset('js/mask-ip-js/mask.ip-input.js')}}"></script>

    <script>
        let global_sum = 0;
        $(document).ready(function () {
            $('#phone').mask("00000000000");
            $('.select-two').select2();
            $('#country_id').select2({ placeholder: "Select Country", })
            $('#state_id').select2({ placeholder: "Select State", })
            $('#city_id').select2({ placeholder: "Select City", })
            $('#ip_address').focus()
            $('[ip-mask]').ipAddress();
        });

        //For Status
        $("#client_status").on("change", function(e) {
            var clientType = $('#client_status :selected').parent().attr('label');
            $("#client_type").val(clientType);
        });
        //End Status


        $("#payment-packages").on("change", function(e) {
            var productType         = $('#payment-packages :selected').parent().attr('label');
            var paymentActualPrice         = $('#payment-packages :selected').attr('data-getActualPrice');
            var paymentDiscountedPrice     = $('#payment-packages :selected').attr('data-getDiscountedPrice');
            // var productType                 = $('#payment-product-type :selected').parent().attr('label');

            $("#payment-product-type").val(productType);
            $("#payment-actual-pkg-price").val(paymentActualPrice);
            $("#payment-discounted-pkg-price").val(paymentDiscountedPrice);
            changeProductType(productType);
        });

        function changeProductType(productType) {
            if (productType == "Logo Design") {
                $(".logo_design").removeClass('d-none');
                $(".logo_packages").removeClass('d-none');
                $(".website_design").addClass('d-none');
                $(".video_animation").addClass('d-none');
            } else if (productType == "Video Animation") {
                $(".logo_design").addClass('d-none');
                $(".logo_packages").addClass('d-none');
                $(".website_design").addClass('d-none');
                $(".video_animation").removeClass('d-none');
            }else if (productType == "Website Development") {
                $(".logo_design").addClass('d-none');
                $(".logo_packages").addClass('d-none');
                $(".video_animation").addClass('d-none');
                $(".website_design").removeClass('d-none');
            }else{
                $(".logo_design").addClass('d-none');
                $(".logo_packages").addClass('d-none');
                $(".website_design").addClass('d-none');
                $(".video_animation").addClass('d-none');
            }
        }

        // For Package
        $("#available_package").on("change", function(e){
            var pkg = $("#available_package").val();
            changePackage(pkg);
            $('.pkg_name').text(pkg);
        });
        //End  Package

        function changePackage(pkg) {
            if (pkg == "BASIC LOGO") {
                $(".price_span").html("$29");
                $("#Logo_Basic").removeClass('d-none');
                $("#Logo_Startup").addClass('d-none');
                $("#Logo_Professional").addClass('d-none');
                $("#Logo_Corporate").addClass('d-none');
                $("#Logo_Elite").addClass('d-none');
                $("#Logo_Illustrative").addClass('d-none');
                $("#select_pack").addClass('d-none');
            } else if (pkg == "STARTUP LOGO") {
                 $(".price_span").html("$89");
                $("#Logo_Basic").addClass('d-none');
                $("#Logo_Startup").removeClass('d-none');
                $("#Logo_Professional").addClass('d-none');
                $("#Logo_Corporate").addClass('d-none');
                $("#Logo_Elite").addClass('d-none');
                $("#Logo_Illustrative").addClass('d-none');
                $("#select_pack").addClass('d-none');
            } else if (pkg == "PROFESSIONAL LOGO") {
                 $(".price_span").html("$119");
                $("#Logo_Basic").addClass('d-none');
                $("#Logo_Startup").addClass('d-none');
                $("#Logo_Professional").removeClass('d-none');
                $("#Logo_Corporate").addClass('d-none');
                $("#Logo_Elite").addClass('d-none');
                $("#Logo_Illustrative").addClass('d-none');
                $("#select_pack").addClass('d-none');
            } else if (pkg == "CORPORATE LOGO") {
                 $(".price_span").html("$229");
                $("#Logo_Basic").addClass('d-none');
                $("#Logo_Startup").addClass('d-none');
                $("#Logo_Professional").addClass('d-none');
                $("#Logo_Corporate").removeClass('d-none')
                $("#Logo_Elite").addClass('d-none');
                $("#Logo_Illustrative").addClass('d-none');
                $("#select_pack").addClass('d-none');
            } else if (pkg == "ELITE LOGO") {
                 $(".price_span").html("$499");
                $("#Logo_Basic").addClass('d-none');
                $("#Logo_Startup").addClass('d-none');
                $("#Logo_Professional").addClass('d-none');
                $("#Logo_Corporate").addClass('d-none');
                $("#Logo_Elite").removeClass('d-none')
                $("#Logo_Illustrative").addClass('d-none');
                $("#select_pack").addClass('d-none');
            } else if (pkg == "ILLUSTRATIVE LOGO") {
                 $(".price_span").html("$399");
                $("#Logo_Basic").addClass('d-none');
                $("#Logo_Startup").addClass('d-none');
                $("#Logo_Professional").addClass('d-none');
                $("#Logo_Corporate").addClass('d-none');
                $("#Logo_Elite").addClass('d-none');
                $("#Logo_Illustrative").removeClass('d-none')
                $("#select_pack").addClass('d-none')
            }else{
                $("#select_pack").addClass('d-none')
            }
        }


        // for amount
        document.getElementById('available_package').addEventListener('change', function() {
            const selectedOption = this.options[this.selectedIndex];
            const price = selectedOption.getAttribute('data-price');
            const name = selectedOption.getAttribute('data-value');

            document.getElementById('amount').value = price;
            document.getElementById('package_amount').value ="$"+price;
            document.getElementById('pack_name').value = name;
        });
        // End amount


        document.querySelectorAll('input[data-pattern-validate]').forEach(el => el.addEventListener('keypress', e => {
            if (!inputMatchesPattern(e)) {
                e.preventDefault();
            }
        }));

        $(".year-dropdown").on("change", function(e) {
            const months = [
                "", 'January', 'February', 'March', 'April', 'May',
                'June', 'July', 'August', 'September',
                'October', 'November', 'December'
            ];

            const current_year = <?= $starting_year ?>;
            const target_year = e.target.value;
            let starting_index = 1;
            let inner_html = "";

            if (current_year == target_year) {
                const current_date = new Date();
                starting_index = current_date.getMonth() + 1;
            }

            for (let i = starting_index; i <= 12; i++) {
                inner_html += `<option value='${i}'>${months[i]}</option>`;
            }
            $(".month-dropdown").html(inner_html);
        });

        //for state
        $( document ).on('change','.country',function(){
            var country_id=$(this).val();
            if(country_id == '' || country_id == undefined)
            {
                return false;
            }

            $.ajax({
                type: 'get',
                url: "{{route('get-states','')}}/"+country_id,
                success:function(data){
                    var op=" ";
                    op+='<option value="" selected >Select State *</option>';
                    for(var i=0;i<data.states.length;i++){
                        op+='<option value="'+data.states[i].name+'" data-getId ="'+data.states[i].id+'">'+data.states[i].name+'</option>';
                    }
                    $('.state').html(op);


                },
                error:function(){
                }
            });
        });
        // end state
        //for city
        $( document ).on('change','.state',function(){
            var state_id=$(this).val();
            if(state_id == '' || state_id == undefined)
            {
                return false;
            }

            $.ajax({
                type: 'get',
                url: "{{route('get-cities','')}}/"+state_id,
                success:function(data){
                    var op=" ";
                    op+='<option value="" selected >Select City *</option>';
                    for(var i=0;i<data.cities.length;i++){
                        op+='<option value="'+data.cities[i].name+'" data-getId ="'+data.cities[i].id+'">'+data.cities[i].name+'</option>';
                    }
                    $('.city').html(op);
                    // $('.city').empty();
                    // $('.city').select2({
                    //     data: data.cities
                    // });
                },
                error:function(){
                }
            });
        });
        //end city

        //For Country id
        $("#country_id").on("change", function(e) {
            var countryId = $('#country_id :selected').attr('data-getId');
            $("#get-country-id").val(countryId);
        });
        //End Country id

        //For State id
        $("#state_id").on("change", function(e) {
            var stateId = $('#state_id :selected').attr('data-getId');
            $("#get-state-id").val(stateId);
        });
        //End State id

        //For City id
        $("#city_id").on("change", function(e) {
            var cityId = $('#city_id :selected').attr('data-getId');
            $("#get-city-id").val(cityId);
        });
        //End City id

        $(document).ready(function() {
            $('#accordion .btn-link').click(function() {
                const iconToggle = $(this).find('.icon-toggle');
                const isCollapsed = $(this).attr('aria-expanded') === 'false';
                if (isCollapsed) {
                    iconToggle.removeClass('fa-plus').addClass('fa-minus');
                } else {
                    iconToggle.removeClass('fa-minus').addClass('fa-plus');
                }
            });
            $('#accordion .collapse').each(function() {
                const iconToggle = $(this).prev('.card-header').find('.icon-toggle');
                if ($(this).hasClass('show')) {
                    iconToggle.removeClass('fa-plus').addClass('fa-minus');
                }
            });
        });
    </script>
@endpush
