@extends('layouts.app')
@section('page-title','User Details')

@push('css')

    <style>

        .page-content {
            max-width: 100%;
        }
        .label-sec {
            height: 60px;
        }
        .possible-upsell h3 {
            display: flex;
            align-items: center;
            justify-content: space-between;
            padding-bottom: 7px;
        }
        .create-invoice-sec h3 {
            padding-bottom: 20px;
        }
        .possible-upsell, .comment-sec {
            border: 1px solid #ddd;
            padding: 10px 10px;
            height: 303px;
        }
        .payment-sec {
            border: 1px solid #ddd;
            padding: 10px 10px;
            height: 303px;
        }
        .basic-detail-sec{ border: 1px solid #ddd; padding: 10px 10px; height: 365px; }
        table.invoice-table-detail {
            width: 100%;
        }
        .comment-sec {
            height: auto;
            margin-top: 30px;
        }

        table.invoice-table-detail, table.invoice-table-detail th, table.invoice-table-detail td {
            border: 1px solid #ddd;
            padding: 5px 10px;
        }
        .modal-dialog {
            max-width: 50% !important;
        }
        button.btn-close {
            border: unset;
            width: 40px;
            height: 40px;
            font-size: 20px;
        }
        textarea.note_field:focus {
            outline: 0px solid #ddd;
        }
        textarea.note_field {
            width: 100%;
            border: 1px solid #ddd;
            color: #455056;
            height: 100px;
            padding: 10px 10px;
        }
        .comment-desc {
            padding: 10px 6px;
        }

        .comment-desc p {
            display: flex;
            align-items: center;
            justify-content: space-between;
            border-bottom: 1px solid #ddd;
            padding-bottom: 10px;
            word-break: break-all;
        }
        .comment-desc p span {
            margin-left: 50px;
            width: 15%;
            text-align: end;
        }
        .basic_detail{height: 300px; overflow-y: scroll}
        .payment_detail{height: 228px; overflow-y: scroll}
        .possible-upsell-detail{height: 228px; overflow-y: scroll}
        .client-accord a { display: block; background-color: #3075ba3d; }
        .client-accord a:hover {background-color: #3075ba3d; }
        h3.client-accord-title { display: flex; justify-content: space-between; }
        .imageview{height: 100px; width: 100px;}
    </style>
@endpush

@section('content')
    <div id="content" class="pmd-content inner-page profile-page">
        <div class="d-flex flex-row align-items-center text-center mb-4">
            <h1 class="card-title media-body">{{$client->findLead->client_type}}</h1>
        </div>
        <div class="page-content profile-view">
            <div class="row">
                <div class="col-12">
                    <!-- Tab panes -->
                    <div class="tab-content">
                        <!-- About Tab -->
                        <div role="tabpanel" class="tab-pane active" id="about">
                            <div class="card pmd-card">
                                <div class="card-body">

                                    <!-- Basic Information -->
                                    <div class="details-tab">
                                        <div class="row view-basic-card">
                                            <div class="col-md-6"   >
                                                <div class="label-sec">
                                                    @if($client->findLead->client_status == 'Connected')
                                                        <div class="error-message mb-4 alert alert-primary"  role="alert">
                                                            Client Status : Connected
                                                        </div>
                                                    @elseif($client->findLead->client_status == 'New')
                                                        <div class="error-message mb-4 alert alert-primary"  role="alert">
                                                            Client Status : New
                                                        </div>
                                                    @elseif($client->findLead->client_status == 'Not Connected')
                                                        <div class="error-message mb-4 alert alert-warning"  role="alert">
                                                            Client Status : Not Connected
                                                        </div>
                                                    @elseif($client->findLead->client_status == 'Not Interested')
                                                        <div class="error-message mb-4 alert alert-info"  role="alert">
                                                            Client Status : Not Interested
                                                        </div>
                                                    @elseif($client->findLead->client_status == 'Invalid')
                                                        <div class="error-message mb-4 alert alert-secondary"  role="alert">
                                                            Client Status : Invalid
                                                        </div>
                                                    @elseif($client->findLead->client_status == 'Paid')
                                                        <div class="error-message mb-4 alert alert-success"  role="alert">
                                                            Client Status : Paid
                                                        </div>
                                                    @elseif($client->findLead->client_status == 'DNC')
                                                        <div class="error-message mb-4 alert alert-danger"  role="alert">
                                                            Client Status : Do not call
                                                        </div>
                                                    @elseif($client->findLead->client_status == 'Upsell')
                                                        <div class="error-message mb-4 alert alert-secondary"  role="alert">
                                                            Client Status : Upsell
                                                        </div>
                                                    @elseif($client->findLead->client_status == 'Sale')
                                                        <div class="error-message mb-4 alert alert-primary"  role="alert">
                                                            Client Status : Sale
                                                        </div>
                                                    @elseif($client->findLead->client_status == 'Recurring')
                                                        <div class="error-message mb-4 alert alert-success"  role="alert">
                                                            Client Status : Recurring
                                                        </div>
                                                    @elseif($client->findLead->client_status == 'Returning')
                                                        <div class="error-message mb-4 alert alert-warning"  role="alert">
                                                            Client Status : Returning
                                                        </div>
                                                    @elseif($client->findLead->client_status == 'Referral')
                                                        <div class="error-message mb-4 alert alert-info"  role="alert">
                                                            Client Status : Referral
                                                        </div>
                                                    @elseif($client->findLead->client_status == 'Angry')
                                                        <div class="error-message mb-4 alert alert-danger"  role="alert">
                                                            Client Status : Angry
                                                        </div>
                                                    @endif
                                                </div>
                                            </div>
                                            <div class="col-md-6">
                                            <label for="client_status" class="col-form-label control-label">Change Status</label>
                                                <div class="form-group pmd-textfield pmd-textfield-floating-label ">
                                                    <select name="client_status" class="form-control change-status" id="client_status" required>
                                                        <option value="" selected disabled>Select Status</option>
                                                        @if($client->findLead->client_type == 'Lead')
                                                            <optgroup label="Lead">
                                                                <option value="New"  data-id="{{$client->id}}"  {{$client->findLead->client_status == 'New' ? 'selected' : ''}}>New</option>
                                                                <option value="Connected"  data-id="{{$client->id}}"  {{$client->findLead->client_status == 'Connected' ? 'selected' : ''}}>Connected</option>
                                                                <option value="Not Connected"  data-id="{{$client->id}}"  {{$client->findLead->client_status == 'Not Connected' ? 'selected' : ''}}>Not Connected</option>
                                                                <option value="Not Interested"  data-id="{{$client->id}}"  {{$client->findLead->client_status == 'Not Interested' ? 'selected' : ''}}>Not Interested</option>
                                                                <option value="Invalid"  data-id="{{$client->id}}"  {{$client->findLead->client_status == 'Invalid' ? 'selected' : ''}}>Invalid</option>
{{--                                                                <option value="Sale"  data-id="{{$client->id}}"  {{$client->findLead->client_status == 'Sale' ? 'selected' : ''}}>Sale</option>--}}
                                                                <option value="DNC"  data-id="{{$client->id}}"  {{$client->findLead->client_status == 'DNC' ? 'selected' : ''}}>Do not call</option>
                                                            </optgroup>
                                                            <optgroup label="Client">
                                                                <option value="Sale"  data-id="{{$client->id}}"  {{$client->findLead->client_status == 'Sale' ? 'selected' : ''}}>Sale</option>
                                                            </optgroup>
                                                            @else
                                                            <optgroup label="Client">
                                                                <option value="Sale"  data-id="{{$client->id}}"  {{$client->findLead->client_status == 'Sale' ? 'selected' : ''}}>Sale</option>
                                                                <option value="Upsell"  data-id="{{$client->id}}"  {{$client->findLead->client_status == 'Upsell' ? 'selected' : ''}}>Upsell</option>
                                                                <option value="Recurring"  data-id="{{$client->id}}"  {{$client->findLead->client_status == 'Recurring' ? 'selected' : ''}}>Recurring</option>
                                                                <option value="Returning"  data-id="{{$client->id}}"  {{$client->findLead->client_status == 'Returning' ? 'selected' : ''}}>Returning</option>
                                                                <option value="Referral"  data-id="{{$client->id}}"  {{$client->findLead->client_status == 'Referral' ? 'selected' : ''}}>Referral</option>
                                                                <option value="Angry"  data-id="{{$client->id}}" {{$client->findLead->client_status == 'Angry' ? 'selected' : ''}}>Angry</option>
                                                            </optgroup>
                                                        @endif
                                                    </select>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="row view-basic-card">
                                            <div class="col-md-6">
                                                <div class="basic-detail-sec">
                                                    <h3 class="card-title media-body border-bottom mb-2">Client Basic Information</h3>
                                                    <div class="basic_detail">
                                                        <table class="invoice-table-detail">
                                                            <tr><th width="15%">First Name</th> <td>{{$client->firstname ?? 'N/A'}}</td></tr>
                                                            <tr><th width="25%">Last Name</th> <td>{{$client->lastname ?? 'N/A'}}</td></tr>
                                                            <tr><th width="50%">Email</th> <td>{{$client->email ?? 'N/A'}}</td></tr>
                                                            <tr><th width="10%">Phone</th> <td>{{$client->phone ?? 'N/A'}}</td></tr>
                                                            <tr><th width="10%">Country</th> <td>{{$client->country ?? 'N/A'}}</td></tr>
                                                            <tr><th width="10%">State</th> <td>{{$client->state ?? 'N/A'}}</td></tr>
                                                            <tr><th width="10%">City</th> <td>{{$client->city ?? 'N/A'}}</td></tr>
                                                            <tr><th width="10%">Postal Code</th> <td>{{$client->postal_code ?? 'N/A'}}</td></tr>
                                                            <tr><th width="10%">Ip Address</th> <td>{{$client->ip_address ?? 'N/A'}}</td></tr>
                                                            <tr><th width="10%">Web Url</th> <td>{{$client_info->web_url ?? 'N/A'}}</td></tr>
                                                            <tr><th width="10%">Sale Type</th> <td>{{$client->findLead->sale_type ?? 'N/A'}}</td></tr>
                                                            <tr><th width="10%">Package Name</th> <td>{{$client->findLead->project_type ?? 'N/A'}}</td></tr>
                                                            <tr><th width="10%">Source</th> <td>{{$client->findLead->source ?? 'N/A'}}</td></tr>
                                                            <tr><th width="10%">Brand</th> <td>{{$client->findLead->brand ?? 'N/A'}}</td></tr>
                                                            <tr><th width="10%">Project /Other Description</th><td> {{($client_info) ? $client_info->comments : 'N/A'}}</td></tr>
{{--                                                            <tr><th width="10%">Project /Other Description</th><td> <div class="label-sec"><button type="button" class="btn btn-primary view-basic-details" data-bs-toggle="modal" data-bs-target="#basic-details-modal">Project /Other Description </button></div></td></tr>--}}
                                                        </table>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-md-6">
                                                <div class="label-sec">
                                                    <button type="button" class="btn btn-primary create-invoice mt-1" data-bs-toggle="modal" data-bs-target="#invoice-modal">
                                                        Create Payment
                                                    </button>
                                                </div>
                                                <div class="payment-sec">
                                                    <h3 class="card-title media-body border-bottom mb-2">Payments</h3>
                                                    <div class="payment_detail">
                                                        <table class="invoice-table-detail">
                                                            <thead>
                                                            <tr>
                                                                <th width="15%">Date</th>
                                                                <th width="25%">Type</th>
                                                                <th width="10%">Product Type</th>
                                                                <th width="10%">Package</th>
                                                                <th width="10%">Amount</th>
                                                                <th width="50%">Action</th>
                                                            </tr>
                                                            </thead>
                                                            <tbody>
                                                            @if($payments->count() > 0)
                                                                @php $hasPayment = false; @endphp
                                                                @php $hasPayment = false; @endphp
                                                                @foreach($payments as $value)
                                                                    @if($value->status == 'Payment')
                                                                        @php $hasPayment = true; @endphp
                                                                        <tr>
                                                                            <td>{{ date('d-M-Y', strtotime($value->dated)) }}</td>
                                                                            <td>{{ $value->product_type }}</td>
                                                                            <td>{{ $value->pkg_name }}</td>
                                                                            <td>{{ $value->payment_type }}</td>
                                                                            <td>${{ number_format($value->amount, 2) }}</td>
                                                                            <td>
                                                                                <div class='btn-group'>
                                                                                    <a class='btn btn-primary btn-style view-payment-details' data-bs-toggle="modal" data-bs-target="#payment-details-modal" href="#" data-id="{{ $value->id }}" data-amount="{{ $value->amount }}" data-product="{{ $value->product_type }}" data-pkg="{{ $value->pkg_name }}" data-actual-price="{{ $value->actual_pkg_price }}" data-discount-price="{{ $value->discounted_pkg_price }}" data-date="{{ date('d-M-Y', strtotime($value->dated)) }}" data-payment-type="{{ $value->payment_type }}" data-description="{{ $value->description }}"><i class='fa fa-eye'></i></a>
                                                                                </div>
                                                                            </td>
                                                                        </tr>
                                                                    @endif
                                                                @endforeach

                                                                @if(!$hasPayment)
                                                                    <tr>
                                                                        <td colspan="4" style="text-align: center">No matching records found</td>
                                                                    </tr>
                                                                @endif
                                                            @else
                                                                <tr>
                                                                    <td colspan="4" style="text-align: center">No matching records found</td>
                                                                </tr>
                                                            @endif
                                                            </tbody>
                                                        </table>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-md-6">
                                                <div class="possible-upsell mt-3">
                                                    <h3 class="card-title media-body border-bottom mb-2">Possible Upsell
                                                        <button type="button" class="btn btn-primary create-upsell" data-bs-toggle="modal" data-bs-target="#myModal">
                                                            <i class="fa fa-plus"></i>
                                                        </button>
                                                    </h3>

                                                    <div class="possible-upsell-detail">
                                                        <table class="invoice-table-detail">
                                                            <thead>
                                                            <tr>
                                                                <th width="15%">Date</th>
                                                                <th width="25%">Product Type</th>
                                                                <th width="10%">Package</th>
                                                                <th width="10%">Payment Type</th>
                                                                <th width="10%">Amount</th>
                                                                <th width="50%">Action</th>
                                                            </tr>
                                                            </thead>
                                                            <tbody>
                                                            @if($payments->count() > 0)
                                                                @php $hasPayment = false; @endphp
                                                                @foreach($payments as $value)
                                                                    @if($value->status == 'Upsell')
                                                                        @php $hasPayment = true; @endphp
                                                                        <tr>
                                                                            <td>{{ date('d-M-Y', strtotime($value->dated)) }}</td>
                                                                            <td>{{ $value->product_type }}</td>
                                                                            <td>{{ $value->pkg_name }}</td>
                                                                            <td>{{ $value->payment_type }}</td>
                                                                            <td>${{ number_format($value->amount, 2) }}</td>
                                                                            <td>
                                                                                <div class='btn-group'>
                                                                                    <a class='btn btn-primary btn-style view-payment-details' data-bs-toggle="modal" data-bs-target="#payment-details-modal" href="#" data-id="{{ $value->id }}" data-amount="{{ $value->amount }}" data-product="{{ $value->product_type }}" data-pkg="{{ $value->pkg_name }}" data-actual-price="{{ $value->actual_pkg_price }}" data-discount-price="{{ $value->discounted_pkg_price }}" data-date="{{ date('d-M-Y', strtotime($value->dated)) }}" data-payment-type="{{ $value->payment_type }}" data-description="{{ $value->description }}"><i class='fa fa-eye'></i></a>
                                                                                </div>
                                                                            </td>
                                                                    @endif
                                                                @endforeach
                                                                @if(!$hasPayment)
                                                                    <tr>
                                                                        <td colspan="4" style="text-align: center">No matching records found</td>
                                                                    </tr>
                                                                @endif
                                                            @else
                                                                <tr>
                                                                    <td colspan="4" style="text-align: center">No matching records found</td>
                                                                </tr>
                                                            @endif
                                                            </tbody>
                                                        </table>
                                                    </div>
                                                </div>
                                            </div>

                                            <div class="col-md-12">
                                                {{--Logo Details--}}
                                                @if(($client->findLead->sale_type) == 'Logo Design' && $client_info != '')
                                                <!-- Salary Details -->
                                                    <div id="accordion">
                                                        <div class="card mt-3 mr-3">
                                                            <div class="card-header client-accord" id="headingOne">
                                                                <a class="btn btn-link" data-toggle="collapse" data-target="#collapseOne" aria-expanded="true" aria-controls="collapseOne">
                                                                    <h3 class="card-title client-accord-title">Logo Details <i class="fas fa-plus icon-toggle"></i></h3>
                                                                </a>
                                                            </div>
                                                            <div id="collapseOne" class="collapse show" aria-labelledby="headingOne" data-parent="#accordion">
                                                                <div class="card-body">
                                                                    <!-- Basic Information -->
                                                                    <div class="details-tab">
                                                                        <div class="row view-basic-card">
                                                                            <div class="col-12 col-md-6 col-lg-12">
                                                                                <label class="pmd-list-subtitle">Submitted On</label>
                                                                                <p class="pmd-list-title">{{date('d-M-Y h:i A', strtotime($client_info->created_at))}}</p>
                                                                            </div>
                                                                            <div class="col-12 col-md-6 col-lg-4">
                                                                                <label class="pmd-list-subtitle">Exact Name</label>
                                                                                <p class="pmd-list-title">{{$client_info->logo_exact_name ?? 'N/A'}}</p>
                                                                            </div>

                                                                            <div class="col-12 col-md-6 col-lg-4">
                                                                                <label class="pmd-list-subtitle">Package</label>
                                                                                <p class="pmd-list-title">{{$client_info->billing_package ?? 'N/A'}}</p>
                                                                            </div>
                                                                            <div class="col-12 col-md-6 col-lg-4">
                                                                                <label class="pmd-list-subtitle">Amount</label>
                                                                                <p class="pmd-list-title">{{$client_info->billing_amount ?? 'N/A'}}</p>
                                                                            </div>

                                                                            <div class="col-12 col-md-6 col-lg-4">
                                                                                <label class="pmd-list-subtitle">Slogan </label>
                                                                                <p class="pmd-list-title">{{$client_info->logo_slogan ?? 'N/A'}}</p>
                                                                            </div>
                                                                            <div class="col-12 col-md-6 col-lg-4">
                                                                                <label class="pmd-list-subtitle">Look And Feel</label>
                                                                                <p class="pmd-list-title">{{$client_info->look_and_feel ?? 'N/A'}}</p>
                                                                            </div>

                                                                            <div class="col-12 col-md-6 col-lg-4">
                                                                                <label class="pmd-list-subtitle">Competitors Reference</label>
                                                                                <p class="pmd-list-title">{{$client_info->logo_competitor_ref ?? 'N/A'}}</p>
                                                                            </div>
                                                                            <div class="col-12 col-md-6 col-lg-4">
                                                                                <label class="pmd-list-subtitle"> Primary Color </label>
                                                                                <p class="pmd-list-title">{{$client_info->logo_primary_color ?? 'N/A'}}</p>
                                                                            </div>

                                                                            <div class="col-12 col-md-6 col-lg-4">
                                                                                <label class="pmd-list-subtitle">Secondary Color</label>
                                                                                <p class="pmd-list-title">{{$client_info->logo_secondary_color ?? 'N/A'}}</p>
                                                                            </div>
                                                                            <div class="col-12 col-md-6 col-lg-4">
                                                                                <label class="pmd-list-subtitle">Industry</label>
                                                                                <p class="pmd-list-title">{{$client_info->logo_industry ?? 'N/A'}}</p>
                                                                            </div>

                                                                            <div class="col-12 col-md-6 col-lg-4">
                                                                                <label class="pmd-list-subtitle">Target Audience</label>
                                                                                <p class="pmd-list-title">{{$client_info->logo_targeted_audience ?? 'N/A'}}</p>
                                                                            </div>
                                                                            <div class="col-12 col-md-6 col-lg-4">
                                                                                <label class="pmd-list-subtitle">Typography</label>
                                                                                <p class="pmd-list-title">{{$client_info->logo_typography ?? 'N/A'}}</p>
                                                                            </div>

                                                                            <div class="col-12 col-md-6 col-lg-4">
                                                                                <label class="pmd-list-subtitle">Logo Type</label>
                                                                                <p class="pmd-list-title">{{$client_info->logo_type ?? 'N/A'}}</p>
                                                                            </div>
                                                                            <div class="col-12 col-md-6 col-lg-12">
                                                                                <label class="pmd-list-subtitle">Logo Refrence Material</label><br>
                                                                                <div class="imagessss">
                                                                                    @if($logo_refrence_material != NULL)
                                                                                        @foreach($logo_refrence_material as $image)
                                                                                            @if($image != NULL)
                                                                                                <a href="{{ asset('client-logo/images/'.$image) }}" target="_blank"><img src="{{ asset('client-logo/images/'.$image) }}" class="imageview"></a>
                                                                                            @else
                                                                                                <img src="{{ asset('themes/images/no-image-selected.png') }}" class="imageview">
                                                                                            @endif
                                                                                        @endforeach
                                                                                    @else
                                                                                        <img src="{{ asset('themes/images/no-image-selected.png') }}" class="imageview">
                                                                                    @endif
                                                                                </div>
                                                                            </div>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>

                                                    {{--Website Details--}}
                                                @elseif(($client->findLead->sale_type) == 'Website Development' && $client_info != '')
                                                    <div id="accordion">
                                                        <div class="card mt-3 mr-3">
                                                            <div class="card-header client-accord" id="headingOne">
                                                                <a class="btn btn-link" data-toggle="collapse" data-target="#collapseOne" aria-expanded="true" aria-controls="collapseOne">
                                                                    <h3 class="card-title client-accord-title">Website Details <i class="fas fa-plus icon-toggle"></i></h3>
                                                                </a>
                                                            </div>
                                                            <div id="collapseOne" class="collapse show" aria-labelledby="headingOne" data-parent="#accordion">
                                                                <div class="card-body">
                                                                    <!-- Basic Information -->
                                                                    <div class="details-tab">
                                                                        <div class="row">
                                                                            <div class="col-12 col-md-6 col-lg-12">
                                                                                <label class="pmd-list-subtitle">Submitted On</label>
                                                                                <p class="pmd-list-title">{{date('d-M-Y h:i A', strtotime($client_info->created_at))}}</p>
                                                                            </div>
                                                                            <div class="col-12 col-sm-12 col-md-12">
                                                                                <label for="domain_purchased" class="col-form-label control-label">Current Web Host</label>
                                                                                <div class="form-group pmd-textfield pmd-textfield-floating-label ">
                                                                                    <input type="text" readonly class="form-control" name="website_current_web_host"
                                                                                           aria-describedby="emailHelp"  value="{{$client_info->website_current_web_host ?? 'N/A'}}">
                                                                                </div>
                                                                            </div>
                                                                            <div class="col-12 col-sm-12 col-md-12">
                                                                                <label for="domain_purchased" class="col-form-label control-label">Did you already purchase a domain? If yes, who with: (we will need access to that account later on)</label>
                                                                                <div class="form-group pmd-textfield pmd-textfield-floating-label ">
                                                                                    <input type="text" readonly class="form-control" name="website_domain_purchased"
                                                                                           aria-describedby="emailHelp"  value="{{$client_info->website_domain_purchased ?? 'N/A'}}">
                                                                                </div>
                                                                            </div>
                                                                            <div class="col-12 col-sm-12 col-md-12">
                                                                                <label for="providing_image" class="col-form-label control-label">Will you be providing any images for the website</label>
                                                                                <div class="form-group pmd-textfield pmd-textfield-floating-label ">
                                                                                    <input type="text" readonly class="form-control" name="website_providing_image"
                                                                                           aria-describedby="emailHelp"  value="{{$client_info->website_providing_image ?? 'N/A'}}">
                                                                                </div>
                                                                            </div>

                                                                            <div class="col-12 col-sm-12 col-md-12">
                                                                                <label for="have_content" class="col-form-label control-label">Do you have all the content (text, info, articles, copy) available for your pages</label>
                                                                                <div class="form-group pmd-textfield pmd-textfield-floating-label ">
                                                                                    <input type="text" readonly class="form-control" name="website_have_content"
                                                                                           aria-describedby="emailHelp"  value="{{$client_info->website_have_content ?? 'N/A'}}">
                                                                                </div>
                                                                            </div>
                                                                            <div class="col-12 col-sm-6 col-md-12">
                                                                                <label for="company_desc" class="col-form-label control-label">Briefly describe your company</label>
                                                                                <div class="form-group ">
                                                                                    <textarea readonly class="form-control" name="website_company_desc" id="company_desc"
                                                                                              aria-describedby="emailHelp">{{$client_info->website_company_desc ?? 'N/A'}}</textarea>
                                                                                </div>
                                                                            </div>

                                                                            <div class="col-12 col-sm-6 col-md-12">
                                                                                <label for="specific_theme" class="col-form-label control-label">Is there any specific theme/feel you want incorporated into your website: (multiple lines)</label>
                                                                                <div class="form-group ">
                                                                                    <textarea readonly class="form-control" name="website_specific_theme" id="specific_theme"
                                                                                              aria-describedby="emailHelp">{{$client_info->website_specific_theme ?? 'N/A'}}</textarea>
                                                                                </div>
                                                                            </div>

                                                                            <div class="col-12 col-sm-12 col-md-12">
                                                                                <label for="what_colors" class="col-form-label control-label">What colors were you looking to incorporate into the design?</label>
                                                                                <div class="form-group pmd-textfield pmd-textfield-floating-label ">
                                                                                    <input type="text" readonly class="form-control" name="website_what_colors"
                                                                                           aria-describedby="emailHelp" value="{{$client_info->website_what_colors ?? 'N/A'}}">
                                                                                </div>
                                                                            </div>

                                                                            <div class="col-12 col-sm-6 col-md-12">
                                                                                <label for="sites_you_admire" class="col-form-label control-label">Websites or your competitors or business whose sites you admire.</label>
                                                                                <div class="form-group ">
                                                                                    <textarea readonly class="form-control" name="website_sites_you_admire" id="sites_you_admire"
                                                                                              aria-describedby="emailHelp">{{$client_info->website_sites_you_admire ?? 'N/A'}}</textarea>
                                                                                </div>
                                                                            </div>

                                                                            <div class="col-12 col-sm-6 col-md-12">
                                                                                <label for="additional_information" class="col-form-label control-label">Additional Information: (To share any additional details)</label>
                                                                                <div class="form-group ">
                                                                                    <textarea readonly class="form-control" name="website_additional_information" id="additional_information"
                                                                                              aria-describedby="emailHelp">{{$client_info->website_additional_information ?? 'N/A'}}</textarea>
                                                                                </div>
                                                                            </div>

                                                                            <div class="col-12 col-sm-6 col-md-12">
                                                                                <label for="site_pages" class="col-form-label control-label">What are some pages you will need for your site?</label>
                                                                                <div class="form-group ">
                                                                                    <textarea readonly rows="5" cols="50" class="form-control" name="website_site_pages" id="site_pages"
                                                                                              aria-describedby="emailHelp">{{$client_info->website_site_pages ?? 'N/A'}}</textarea>
                                                                                </div>
                                                                            </div>

                                                                            <div class="col-12 col-sm-6 col-md-12">
                                                                                <label for="your_services" class="col-form-label control-label">What services do you provide or how many products you will selling through your website</label>
                                                                                <div class="form-group ">
                                                                                    <textarea readonly class="form-control" name="website_your_services" id="your_services"
                                                                                              aria-describedby="emailHelp">{{$client_info->website_your_services ?? 'N/A'}}</textarea>
                                                                                </div>
                                                                            </div>

                                                                            <div class="col-12 col-sm-6 col-md-12">
                                                                                <label for="better_competition" class="col-form-label control-label">What makes you better than your competition</label>
                                                                                <div class="form-group ">
                                                                                    <textarea readonly class="form-control" name="website_better_competition" id="better_competition"
                                                                                              aria-describedby="emailHelp">{{$client_info->website_better_competition ?? 'N/A'}}</textarea>
                                                                                </div>
                                                                            </div>

                                                                            <div class="col-12 col-sm-6 col-md-12">
                                                                                <label for="attract_new_customers" class="col-form-label control-label">How do you currently attract new customers</label>
                                                                                <div class="form-group ">
                                                                                    <textarea readonly class="form-control" name="website_attract_new_customers" id="attract_new_customers"
                                                                                              aria-describedby="emailHelp">{{$client_info->website_attract_new_customers ?? 'N/A'}}</textarea>
                                                                                </div>
                                                                            </div>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>

                                                    {{--Animation Details--}}
                                                @elseif(($client->findLead->sale_type) == 'Video Animation' && $client_info != '')
                                                    <div id="accordion">
                                                        <div class="card mt-3 mr-3">
                                                            <div class="card-header client-accord" id="headingFive">
                                                                <a class="btn btn-link" data-toggle="collapse" data-target="#collapseFive" aria-expanded="true" aria-controls="collapseFive">
                                                                    <h3 class="card-title client-accord-title">Product Information <i class="fas fa-plus icon-toggle"></i> </h3>
                                                                </a>
                                                            </div>

                                                            <div id="collapseFive" class="collapse show" aria-labelledby="headingFive" data-parent="#accordion">
                                                                <div class="card-body">
                                                                    <!-- Basic Information -->
                                                                    <div class="details-tab">
                                                                        <div class="row">
                                                                            <div class="col-12 col-md-6 col-lg-12">
                                                                                <label class="pmd-list-subtitle">Submitted On</label>
                                                                                <p class="pmd-list-title">{{date('d-M-Y h:i A', strtotime($client_info->created_at))}}</p>
                                                                            </div>
                                                                            <div class="col-12 col-sm-6 col-md-6">
                                                                                <label for="amount" class="col-form-label control-label">Years of business existence?</label>
                                                                                <div class="form-group pmd-textfield pmd-textfield-floating-label">
                                                                                    <p type="text" class="form-control" aria-describedby="emailHelp">{{$client_info->animation_years_business_existence ?? 'N/A'}}</p>
                                                                                </div>
                                                                            </div>
                                                                            <div class="col-12 col-sm-6 col-md-6">
                                                                                <label for="amount" class="col-form-label control-label">What is the purpose of this video?</label>
                                                                                <div class="form-group pmd-textfield pmd-textfield-floating-label">
                                                                                    <p type="text" class="form-control" aria-describedby="emailHelp">{{$client_info->animation_video_purpose ?? 'N/A'}}</p>
                                                                                </div>
                                                                            </div>
                                                                            <div class="col-12 col-sm-6 col-md-6">
                                                                                <label for="amount" class="col-form-label control-label">Who is your target audience?</label>
                                                                                <div class="form-group pmd-textfield pmd-textfield-floating-label">
                                                                                    <p type="text" class="form-control" aria-describedby="emailHelp">{{$client_info->animation_target_audience ?? 'N/A'}}</p>
                                                                                </div>
                                                                            </div>
                                                                            <div class="col-12 col-sm-6 col-md-6">
                                                                                <label for="amount" class="col-form-label control-label">Please confirm the gender for voiceover?</label>
                                                                                <div class="form-group pmd-textfield pmd-textfield-floating-label">
                                                                                    <p type="text" class="form-control" aria-describedby="emailHelp">{{$client_info->animation_voiceover_gender ?? 'N/A'}}</p>
                                                                                </div>
                                                                            </div>
                                                                            <div class="col-12 col-sm-6 col-md-6">
                                                                                <label for="amount" class="col-form-label control-label">What accent do you prefer for the voice over?</label>
                                                                                <div class="form-group pmd-textfield pmd-textfield-floating-label">
                                                                                    <p type="text" class="form-control" aria-describedby="emailHelp">{{$client_info->animation_voiceover_accent ?? 'N/A'}}</p>
                                                                                </div>
                                                                            </div>
                                                                            <div class="col-12 col-sm-6 col-md-6 mt-1">
                                                                                <label for="package">Please select type of the voice over</label>
                                                                                <div class="form-group pmd-textfield pmd-textfield-floating-label">
                                                                                    <p type="text" class="form-control" aria-describedby="emailHelp">{{$client_info->animation_voiceover_type ?? 'N/A'}}</p>
                                                                                </div>
                                                                            </div>
                                                                            <div class="col-12 col-sm-6 col-md-12">
                                                                                <label for="sites_you_admire" class="col-form-label control-label">Please inform us about your business in detail?</label>
                                                                                <div class="form-group ">
                                                                                    <textarea readonly class="form-control" name="animation_business_detail" aria-describedby="emailHelp">{{$client_info->animation_business_detail ?? 'N/A'}}</textarea>
                                                                                </div>
                                                                            </div>
                                                                            <div class="col-12 col-sm-6 col-md-12">
                                                                                <label for="sites_you_admire" class="col-form-label control-label">What is the duration of your video? (75 Words is for 30 Sec Video)</label>
                                                                                <div class="form-group ">
                                                                                    <textarea readonly class="form-control" name="animation_video_duration" aria-describedby="emailHelp">{{$client_info->animation_video_duration ?? 'N/A'}}</textarea>
                                                                                </div>
                                                                            </div>

                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                @endif
                                            </div>
                                            <div class="col-md-12">
                                                <div class="comment-sec">
                                                    <h3 class="card-title media-body border-bottom mb-2">Comments</h3>
                                                    <div class="comments-detail-sec">
                                                        <form id="update-comments" action="{{route('comment.clients')}}" method="post">
                                                            @csrf
                                                            <input type="hidden" name="id" value="{{$client->id}}" class="comment-user-id">
                                                            <div class="comment-desc">
                                                                @if($comments->count() > 0)
                                                                    @foreach($comments as $value)
                                                                        <p>{{$value->comments}} <span>{{date('d-M-Y h:i A',strtotime($value->created_at))}}</span></p>
                                                                    @endforeach
                                                                @endif
                                                            </div>
                                                            <textarea class="note_field" name="comments" placeholder="Enter your comment here..." required></textarea>
                                                            <div class="comments-timestamp mt-2">
                                                            </div>
                                                            <button type="submit" class="btn btn-primary save-comment">
                                                                Save Comment
                                                            </button>
                                                        </form>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- The Modal Basic Details -->
    <div class="modal fade" id="payment-details-modal" tabindex="-1" aria-labelledby="payment-details-modal-label" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="payment-details-modal-label">Payment Details</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"><i class="fa fa-close"></i></button>
                </div>
                <div class="modal-body">
                    <!-- Payment Details -->
                    <div class="details-tab">
                        <div class="row">
                            <div class="col-12 col-sm-12 col-md-4">
                                <label for="domain_purchased" class="col-form-label control-label">Date</label>
                                <div class="form-group pmd-textfield pmd-textfield-floating-label ">
                                    <input type="text" readonly class="form-control" id="modal-payment-date" name="website_current_web_host"
                                           aria-describedby="emailHelp"  value="">
                                </div>
                            </div>
                            <div class="col-12 col-sm-12 col-md-4">
                                <label for="domain_purchased" class="col-form-label control-label">Product Type</label>
                                <div class="form-group pmd-textfield pmd-textfield-floating-label ">
                                    <input type="text" readonly class="form-control" id="modal-product-type" name="modal-product-type"
                                           aria-describedby="emailHelp"  value="">
                                </div>
                            </div>
                            <div class="col-12 col-sm-12 col-md-4">
                                <label for="domain_purchased" class="col-form-label control-label">Package</label>
                                <div class="form-group pmd-textfield pmd-textfield-floating-label ">
                                    <input type="text" readonly class="form-control" id="modal-pkg-name" name="modal-pkg-name"
                                           aria-describedby="emailHelp"  value="">
                                </div>
                            </div>
                            <div class="col-12 col-sm-12 col-md-4">
                                <label for="domain_purchased" class="col-form-label control-label">Price</label>
                                <div class="form-group pmd-textfield pmd-textfield-floating-label ">
                                    <input type="text" readonly class="form-control" id="modal-actual-price" name="modal-actual"
                                           aria-describedby="emailHelp"  value="">
                                </div>
                            </div>
                            <div class="col-12 col-sm-12 col-md-4">
                                <label for="domain_purchased" class="col-form-label control-label">Discount Price</label>
                                <div class="form-group pmd-textfield pmd-textfield-floating-label ">
                                    <input type="text" readonly class="form-control" id="modal-discount-price" name="modal-discount"
                                           aria-describedby="emailHelp"  value="">
                                </div>
                            </div>
                            <div class="col-12 col-sm-12 col-md-4">
                                <label for="providing_image" class="col-form-label control-label">Actual Amount</label>
                                <div class="form-group pmd-textfield pmd-textfield-floating-label ">
                                    <input type="text" readonly class="form-control" id="modal-payment-amount" name="modal-payment-amount"
                                           aria-describedby="emailHelp"  value="">
                                </div>
                            </div>
                            <div class="col-12 col-sm-12 col-md-4">
                                <label for="have_content" class="col-form-label control-label">Payment Type</label>
                                <div class="form-group pmd-textfield pmd-textfield-floating-label ">
                                    <input type="text" readonly class="form-control" id="modal-payment-type" name="modal-payment-type"
                                           aria-describedby="emailHelp"  value="">
                                </div>
                            </div>

                            <div class="col-12 col-sm-6 col-md-12">
                                <label for="company_desc" class="col-form-label control-label">Description</label>
                                <div class="form-group ">
                                    <textarea readonly class="form-control" name="modal-payment-desc" id="modal-payment-desc"
                                              aria-describedby="emailHelp"></textarea>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- The Modal Basic Details -->

    <!-- The Modal Possible Upsell -->
    <div class="modal upsell-modal-sec" id="myModal">
        <div class="modal-dialog">
            <div class="modal-content">

                <!-- Modal Header -->
                <div class="modal-header">
                    <h4 class="modal-title">Create Upsell</h4>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"><i class="fa fa-close"></i></button>
                </div>

                <!-- Modal body -->
                <div class="modal-body">
                    <form method="post" autocomplete="off" action="{{route('store-payment.clients')}}" id="upsell_form" enctype="multipart/form-data">
                        @csrf
                        <input type="hidden" name="form_type" value="Upsell">
                        <input type="hidden" name="user_id" value="{{$client->id}}">
                        <div class="row">
                            <div class="col-md-4">
                                <label for="fn" class="col-form-label control-label">Date</label>
                                <div class="form-group pmd-textfield pmd-textfield-floating-label ">
                                    <input type="date" class="form-control" name="date" id="upsell-date" value="{{old('date')}}" required>
                                </div>
                                @error('date')
                                <span>
                                        <strong class="text-danger">{{ $message }}</strong>
                                    </span>
                                @enderror
                            </div>
                            <div class="col-md-4">
                                <label for="fn" class="col-form-label control-label">Package</label>
                                <div class="form-group pmd-textfield pmd-textfield-floating-label ">
                                    <select name="pkg_name" class="form-control" id="upsell-packages" required>
                                        <option value=" " selected disabled>Select Package</option>
                                        <optgroup label="Logo Design">
                                            <option value="Basic Logo" data-getActualPrice="$148" data-getDiscountedPrice="$99">Basic Logo $99</option>
                                            <option value="Startup Package" data-getActualPrice="$223" data-getDiscountedPrice="$149">Startup Package $149</option>
                                            <option value="Corporate Package" data-getActualPrice="$298" data-getDiscountedPrice="$199">Corporate Package $199</option>
                                            <option value="Custom Illustration" data-getActualPrice="$373" data-getDiscountedPrice="$249">Custom Illustration $249</option>
                                            <option value="Anax Special" data-getActualPrice="$1348" data-getDiscountedPrice="$899">Anax Special $899</option>
                                            <option value="Platinum Illustration" data-getActualPrice="$598" data-getDiscountedPrice="$399">Platinum Illustration $399</option>
                                        </optgroup>
                                        <optgroup label="Website Development">
                                            <option value="Starter Website" data-getActualPrice="$598" data-getDiscountedPrice="$399">Starter Website $399</option>
                                            <option value="Advance Website" data-getActualPrice="$1198" data-getDiscountedPrice="$799">Advance Website $799</option>
                                            <option value="Advanced Professional" data-getActualPrice="$1648" data-getDiscountedPrice="$1099">Advanced Professional $1099</option>
                                            <option value="E-Commerce Website" data-getActualPrice="$2248" data-getDiscountedPrice="$1499">E-Commerce Website $1499</option>
                                            <option value="Corporate Commerce Platform" data-getActualPrice="$3748" data-getDiscountedPrice="$2499">Corporate Commerce Platform $2499</option>
                                            <option value="Platinum Custom Website" data-getActualPrice="$5998" data-getDiscountedPrice="$3999">Platinum Custom Website $3999</option>
                                        </optgroup>
                                        <optgroup label="Animation">
                                            <option value="Startup Video" data-getActualPrice="$748" data-getDiscountedPrice="$499">Startup Video $499</option>
                                            <option value="Premium Video" data-getActualPrice="$2248" data-getDiscountedPrice="$1499">Premium Video $1499</option>
                                            <option value="Classic Video" data-getActualPrice="$1498" data-getDiscountedPrice="$999">Classic Video $999</option>
                                        </optgroup>
                                        <optgroup label="Mobile Application Development">
                                            <option value="Mobile Application Development" data-getActualPrice="not confirmed" data-getDiscountedPrice="not confirmed">Mobile Application Development</option>
                                        </optgroup>
                                        <optgroup label="Digital Marketing Services">
                                            <option value="Digital Marketing Services" data-getActualPrice="not confirmed" data-getDiscountedPrice="not confirmed">Digital Marketing Services</option>
                                        </optgroup>
                                    </select>
                                </div>
                                @error('pkg_name')
                                    <span>
                                        <strong class="text-danger">{{ $message }}</strong>
                                    </span>
                                @enderror
                            </div>
                            <div class="col-md-4">
                                <label for="fn" class="col-form-label control-label">Product Type</label>
                                <div class="form-group pmd-textfield pmd-textfield-floating-label ">
                                    <input type="text" readonly class="form-control" name="product_type" id="upsell-product-type" value="">
                                </div>
                            </div>
                            <div class="col-md-4">
                                <label for="fn" class="col-form-label control-label">Price</label>
                                <div class="form-group pmd-textfield pmd-textfield-floating-label ">
                                    <input type="text" readonly class="form-control" name="actual_pkg_price" id="upsell-actual-pkg-price" value="">
                                </div>
                            </div>
                            <div class="col-md-4">
                                <label for="fn" class="col-form-label control-label">Discount Price</label>
                                <div class="form-group pmd-textfield pmd-textfield-floating-label ">
                                    <input type="text" readonly class="form-control" name="discounted_pkg_price" id="upsell-discounted-pkg-price" value="">
                                </div>
                            </div>
                            <div class="col-md-4">
                                <label for="fn" class="col-form-label control-label">Actual Amount</label>
                                <div class="form-group pmd-textfield pmd-textfield-floating-label ">
                                    <input type="number" class="form-control amount-input" name="amount" id="upsell-type" value="{{old('amount')}}" required>

                                </div>
                                @error('amount')
                                    <span>
                                        <strong class="text-danger">{{ $message }}</strong>
                                    </span>
                                @enderror
                            </div>
                            <div class="col-md-4">
                                <label for="fn" class="col-form-label control-label">Payment Type</label>
                                <div class="form-group pmd-textfield pmd-textfield-floating-label ">
                                    <select name="payment_type" class="form-control" id="invoice-type" required>
                                        <option value=" " selected disabled>Select Payment Type</option>
                                        <option value="One time">One time</option>
                                        <option value="Monthly">Monthly</option>
                                        <option value="Quaterly">Quaterly</option>
                                        <option value="Yearly">Yearly</option>
                                    </select>
                                    @error('payment_type')
                                    <span>
                                            <strong class="text-danger">{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
                            @if($client->findLead->client_type == 'Client')
                                <div class="col-md-4">
                                    <label for="client_status" class="col-form-label control-label">Change Status</label>
                                    <div class="form-group pmd-textfield pmd-textfield-floating-label ">
                                        <select name="client_status" class="form-control" required>
                                            <option value="" selected disabled>Select Status</option>
                                            <optgroup label="Client">
                                                <option value="Sale"  data-id="{{$client->id}}"  {{$client->findLead->client_status == 'Sale' ? 'selected' : ''}}>Sale</option>
                                                <option value="Upsell"  data-id="{{$client->id}}"  {{$client->findLead->client_status == 'Upsell' ? 'selected' : ''}}>Upsell</option>
                                                <option value="Recurring"  data-id="{{$client->id}}"  {{$client->findLead->client_status == 'Recurring' ? 'selected' : ''}}>Recurring</option>
                                                <option value="Returning"  data-id="{{$client->id}}"  {{$client->findLead->client_status == 'Returning' ? 'selected' : ''}}>Returning</option>
                                                <option value="Referral"  data-id="{{$client->id}}"  {{$client->findLead->client_status == 'Referral' ? 'selected' : ''}}>Referral</option>
                                                <option value="Angry"  data-id="{{$client->id}}" {{$client->findLead->client_status == 'Angry' ? 'selected' : ''}}>Angry</option>
                                            </optgroup>
                                        </select>
                                    </div>
                                </div>
                            @else
                                <input type="hidden" name="client_status" value="Sale">
                            @endif
                            <div class="col-md-12">
                                <label for="fn" class="col-form-label control-label">Description</label>
                                <div class="form-group pmd-textfield pmd-textfield-floating-label ">
                                    <textarea type="text" class="form-control" name="desc" id="upsell-desc">{{old('desc')}}</textarea>
                                </div>
                            </div>
                        </div>
                        <!-- Modal footer -->
                        <div class="modal-footer">
                            <button type="button" class="btn btn-danger" data-bs-dismiss="modal">Close</button>
                            <button type="submit" class="btn btn-primary">Save changes</button>
                        </div>
                    </form>
                </div>

            </div>
        </div>
    </div>
    <!-- The Modal Possible Upsell -->

    <!-- The Modal Create Invoice -->
    <div class="modal invoice-modal-sec" id="invoice-modal">
        <div class="modal-dialog">
            <div class="modal-content">

                <!-- Modal Header -->
                <div class="modal-header">
                    <h4 class="modal-title">Create Payment</h4>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"><i class="fa fa-close"></i></button>
                </div>

                <!-- Modal body -->
                <div class="modal-body">
                    <form method="post" autocomplete="off" action="{{route('store-payment.clients')}}" id="invoice_form" enctype="multipart/form-data">
                        @csrf
                        <input type="hidden" name="form_type" value="Payment">
                        <input type="hidden" name="user_id" value="{{$client->id}}">
                        <input type="hidden" name="client_type" value="Client">

                        <div class="row">
                            <div class="col-md-4">
                                <label for="fn" class="col-form-label control-label">Date</label>
                                <div class="form-group pmd-textfield pmd-textfield-floating-label ">
                                    <input type="date" class="form-control" name="date" id="invoice-date" value="{{old('date')}}" required>
                                </div>
                                @error('date')
                                    <span>
                                        <strong class="text-danger">{{ $message }}</strong>
                                    </span>
                                @enderror
                            </div>
                            <div class="col-md-4">
                                <label for="fn" class="col-form-label control-label">Package</label>
                                <div class="form-group pmd-textfield pmd-textfield-floating-label ">
                                    <select name="pkg_name" class="form-control" id="payment-packages" required>
                                        <option value=" " selected disabled>Select Package</option>
                                        <optgroup label="Logo Design">
                                            <option value="Basic Logo" data-getActualPrice="$148" data-getDiscountedPrice="$99">Basic Logo $99</option>
                                            <option value="Startup Package" data-getActualPrice="$223" data-getDiscountedPrice="$149">Startup Package $149</option>
                                            <option value="Corporate Package" data-getActualPrice="$298" data-getDiscountedPrice="$199">Corporate Package $199</option>
                                            <option value="Custom Illustration" data-getActualPrice="$373" data-getDiscountedPrice="$249">Custom Illustration $249</option>
                                            <option value="Anax Special" data-getActualPrice="$1348" data-getDiscountedPrice="$899">Anax Special $899</option>
                                            <option value="Platinum Illustration" data-getActualPrice="$598" data-getDiscountedPrice="$399">Platinum Illustration $399</option>
                                        </optgroup>
                                        <optgroup label="Website Development">
                                            <option value="Starter Website" data-getActualPrice="$598" data-getDiscountedPrice="$399">Starter Website $399</option>
                                            <option value="Advance Website" data-getActualPrice="$1198" data-getDiscountedPrice="$799">Advance Website $799</option>
                                            <option value="Advanced Professional" data-getActualPrice="$1648" data-getDiscountedPrice="$1099">Advanced Professional $1099</option>
                                            <option value="E-Commerce Website" data-getActualPrice="$2248" data-getDiscountedPrice="$1499">E-Commerce Website $1499</option>
                                            <option value="Corporate Commerce Platform" data-getActualPrice="$3748" data-getDiscountedPrice="$2499">Corporate Commerce Platform  $2499</option>
                                            <option value="Platinum Custom Website" data-getActualPrice="$5998" data-getDiscountedPrice="$3999">Platinum Custom Website  $3999</option>
                                        </optgroup>
                                        <optgroup label="Animation">
                                            <option value="Startup Video" data-getActualPrice="$748" data-getDiscountedPrice="$499">Startup Video $499</option>
                                            <option value="Premium Video" data-getActualPrice="$2248" data-getDiscountedPrice="$1499">Premium Video $1499</option>
                                            <option value="Classic Video" data-getActualPrice="$1498" data-getDiscountedPrice="$999">Classic Video $999</option>
                                        </optgroup>
                                        <optgroup label="Mobile Application Development">
                                            <option value="Mobile Application Development" data-getActualPrice="not confirmed" data-getDiscountedPrice="not confirmed">Mobile Application Development</option>
                                        </optgroup>
                                        <optgroup label="Digital Marketing Services">
                                            <option value="Digital Marketing Services" data-getActualPrice="not confirmed" data-getDiscountedPrice="not confirmed">Digital Marketing Services</option>
                                        </optgroup>
                                    </select>
                                </div>
                                @error('pkg_name')
                                <span>
                                        <strong class="text-danger">{{ $message }}</strong>
                                    </span>
                                @enderror
                            </div>
                            <div class="col-md-4">
                                <label for="fn" class="col-form-label control-label">Product Type</label>
                                <div class="form-group pmd-textfield pmd-textfield-floating-label ">
                                    <input type="text" readonly class="form-control" name="product_type" id="payment-product-type" value="">
                                </div>
                            </div>
                            <div class="col-md-4">
                                <label for="fn" class="col-form-label control-label">Price</label>
                                <div class="form-group pmd-textfield pmd-textfield-floating-label ">
                                    <input type="text" readonly class="form-control" name="actual_pkg_price" id="payment-actual-pkg-price" value="">
                                </div>
                            </div>
                            <div class="col-md-4">
                                <label for="fn" class="col-form-label control-label">Discount Price</label>
                                <div class="form-group pmd-textfield pmd-textfield-floating-label ">
                                    <input type="text" readonly class="form-control" name="discounted_pkg_price" id="payment-discounted-pkg-price" value="">
                                </div>
                            </div>
                            <div class="col-md-4">
                                <label for="fn" class="col-form-label control-label">Actual Amount</label>
                                <div class="form-group pmd-textfield pmd-textfield-floating-label ">
                                    <input type="number" class="form-control amount-input" name="amount" id="invoice-type" value="{{old('amount')}}" required>

                                </div>
                                @error('amount')
                                    <span>
                                        <strong class="text-danger">{{ $message }}</strong>
                                    </span>
                                @enderror
                            </div>
                            <div class="col-md-4">
                                <label for="fn" class="col-form-label control-label">Payment Type</label>
                                <div class="form-group pmd-textfield pmd-textfield-floating-label ">
                                    <select name="payment_type" class="form-control" id="invoice-type" required>
                                        <option value=" " selected disabled>Select Payment Type</option>
                                        <option value="One time">One time</option>
                                        <option value="Monthly">Monthly</option>
                                        <option value="Quaterly">Quaterly</option>
                                        <option value="Yearly">Yearly</option>
                                    </select>
                                    @error('payment_type')
                                        <span>
                                            <strong class="text-danger">{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
                            @if($client->findLead->client_type == 'Client')
                                <div class="col-md-4">
                                    <label for="client_status" class="col-form-label control-label">Change Status</label>
                                    <div class="form-group pmd-textfield pmd-textfield-floating-label ">
                                        <select name="client_status" class="form-control" required>
                                            <option value="" selected disabled>Select Status</option>
                                                <optgroup label="Client">
                                                    <option value="Sale"  data-id="{{$client->id}}"  {{$client->findLead->client_status == 'Sale' ? 'selected' : ''}}>Sale</option>
                                                    <option value="Upsell"  data-id="{{$client->id}}"  {{$client->findLead->client_status == 'Upsell' ? 'selected' : ''}}>Upsell</option>
                                                    <option value="Recurring"  data-id="{{$client->id}}"  {{$client->findLead->client_status == 'Recurring' ? 'selected' : ''}}>Recurring</option>
                                                    <option value="Returning"  data-id="{{$client->id}}"  {{$client->findLead->client_status == 'Returning' ? 'selected' : ''}}>Returning</option>
                                                    <option value="Referral"  data-id="{{$client->id}}"  {{$client->findLead->client_status == 'Referral' ? 'selected' : ''}}>Referral</option>
                                                    <option value="Angry"  data-id="{{$client->id}}" {{$client->findLead->client_status == 'Angry' ? 'selected' : ''}}>Angry</option>
                                                </optgroup>
                                        </select>
                                    </div>
                                </div>
                            @else
                                <input type="hidden" name="client_status" value="Sale">
                            @endif
                            <div class="col-md-12">
                                <label for="fn" class="col-form-label control-label">Description</label>
                                <div class="form-group pmd-textfield pmd-textfield-floating-label ">
                                    <textarea type="text" class="form-control" name="desc" id="invoice-desc">{{old('desc')}}</textarea>
                                </div>
                            </div>
                        </div>
                        <!-- Modal footer -->
                        <div class="modal-footer">
                            <button type="button" class="btn btn-danger" data-bs-dismiss="modal">Close</button>
                            <button type="submit" class="btn btn-primary">Save changes</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
    <!-- The Modal Possible Upsell -->

@endsection

@push('css')
    <!-- DataTables -->
    <link rel="stylesheet" href="{{asset('plugins/datatables-bs4/css/dataTables.bootstrap4.min.css')}}">
    <link rel="stylesheet" href="{{asset('plugins/datatables-responsive/css/responsive.bootstrap4.min.css')}}">
    <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />

@endpush

@push('js')
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        $(document).ready(function () {
            $('.datatable-project').DataTable();



            $('#update-comments').submit(function(event) {
                event.preventDefault();
                var formData = $(this).serialize();

                $.ajax({
                    url: $(this).attr('action'),
                    type: 'POST',
                    data: formData,
                    dataType: 'json',
                    success: function(response) {
                        $('.comment-desc').prepend('<p style="border-bottom: 1px solid #ddd; word-break: break-all; padding-bottom: 10px;">' + response.comments + '<span style="margin-left: 50px; width: 15%;text-align: end;">' + response.date + '</span></p>');
                        $('textarea.note_field').val('');
                        Swal.fire({
                            icon: 'success',
                            title: 'Success!',
                            text: response.message,
                            showConfirmButton: false,
                            timer: 1500
                        });
                        location.reload();
                    }
                });
            });
            var numbers = document.getElementsByClassName('amount-input');
// Loop through each element and attach the event listener.
            for (var i = 0; i < numbers.length; i++) {
                numbers[i].onkeydown = function(e) {
                    if (!((e.keyCode >= 96 && e.keyCode <= 105) // Numpad keys
                        || (e.keyCode >= 48 && e.keyCode <= 57) // Number keys
                        || e.keyCode === 8)) { // Backspace
                        e.preventDefault(); // Prevent the default action
                    }
                };
            }
        });
        $(document).on('change','.change-status', function (){
            const get_id = $(this).find(":selected").attr('data-id');
            const clientType = $('#client_status :selected').parent().attr('label');
            const get_status = $(this).find(":selected").val();
            // alert(clientType);
            // alert(get_status);

            Swal.fire({
                title: 'Are You Sure?',
                showDenyButton: true,
                showCancelButton: false,
                confirmButtonText: 'Yes',
                denyButtonText: `No`,

            }).then((result) => {
                if (result.isConfirmed) {
                    $.ajax({
                        headers: {'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')},
                        type: 'POST',
                        url: "{{route('update-status.leads')}}",
                        dataType: 'json',
                        data: {get_id: get_id,get_client_type: clientType,get_status: get_status},
                        success: function (data) {

                            if (data == 'success') {

                                Swal.fire({
                                    position: 'top-end',
                                    icon: 'success',
                                    title: "Status Changed Successfully",
                                    showConfirmButton: false,
                                    timer: 1500
                                })
                                location.reload();

                            }
                        }
                    });
                }else {
                    location.reload();
                }
            })
        })

        $(document).ready(function() {
            $('.view-payment-details').on('click', function() {
                var paymentDate = $(this).data('date');
                var productType = $(this).data('product');
                var pkgName = $(this).data('pkg');
                var actualAmount = $(this).data('actual-price');
                var discountAmount = $(this).data('discount-price');
                var paymentAmount = $(this).data('amount');
                var paymentType = $(this).data('payment-type');
                var paymentDesc = $(this).data('description');

                $('#modal-payment-date').val(paymentDate);
                $('#modal-product-type').val(productType);
                $('#modal-pkg-name').val(pkgName);
                $('#modal-actual-price').val(actualAmount);
                $('#modal-discount-price').val(discountAmount);
                $('#modal-payment-amount').val(paymentAmount);
                $('#modal-payment-type').val(paymentType);
                $('#modal-payment-desc').val(paymentDesc);
            });
        });
        $(document).ready(function() {
            var today = new Date();
            var dd = String(today.getDate()).padStart(2, '0');
            var mm = String(today.getMonth() + 1).padStart(2, '0');
            var yyyy = today.getFullYear();

            today = yyyy + '-' + mm + '-' + dd;

            $('#invoice-date').val(today);
            $('#upsell-date').val(today);
        });
        $(document).ready(function() {
            $('#accordion .btn-link').click(function() {
                const iconToggle = $(this).find('.icon-toggle');
                const isCollapsed = $(this).attr('aria-expanded') === 'false';
                if (isCollapsed) {
                    iconToggle.removeClass('fa-plus').addClass('fa-minus');
                } else {
                    iconToggle.removeClass('fa-minus').addClass('fa-plus');
                }
            });
            $('#accordion .collapse').each(function() {
                const iconToggle = $(this).prev('.card-header').find('.icon-toggle');
                if ($(this).hasClass('show')) {
                    iconToggle.removeClass('fa-plus').addClass('fa-minus');
                }
            });
        });

        //For Upsell Packages
        $("#upsell-packages").on("change", function(e) {
            var packageType         = $('#upsell-packages :selected').parent().attr('label');
            var actualPrice         = $('#upsell-packages :selected').attr('data-getActualPrice');
            var discountedPrice     = $('#upsell-packages :selected').attr('data-getDiscountedPrice');

            $("#upsell-product-type").val(packageType);
            $("#upsell-actual-pkg-price").val(actualPrice);
            $("#upsell-discounted-pkg-price").val(discountedPrice);
        });
        //End Upsell Packages

        // For Payment Packages
        $("#payment-packages").on("change", function(e) {
            var paymentPackageType         = $('#payment-packages :selected').parent().attr('label');
            var paymentActualPrice         = $('#payment-packages :selected').attr('data-getActualPrice');
            var paymentDiscountedPrice     = $('#payment-packages :selected').attr('data-getDiscountedPrice');

            $("#payment-product-type").val(paymentPackageType);
            $("#payment-actual-pkg-price").val(paymentActualPrice);
            $("#payment-discounted-pkg-price").val(paymentDiscountedPrice);
        });
        //End Payment Packages

    </script>
@endpush
