@extends('layouts.app')
@section('page-title','Received Notifications')

@push('css')
    <!-- DataTables -->
    <link rel="stylesheet" href="{{asset('plugins/datatables-bs4/css/dataTables.bootstrap4.min.css')}}">
    <link rel="stylesheet" href="{{asset('plugins/datatables-responsive/css/responsive.bootstrap4.min.css')}}">

@endpush

@section('content')
    <!--content area start-->
    <div id="content" class="pmd-content inner-page admin">
        <!-- Title -->
        <h1 id="employee" class="text-center">@yield('page-title')</h1>
        <!-- End Title -->
        <!--breadcrumb start-->
        <div class="float-right @cannot('create.notification') no-btn @endcannot">
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb pmd-breadcrumb mb-0">
                    <li class="breadcrumb-item">
                        <a href="{{route('dashboard')}}">Dashboard</a>
                    </li>
                    <li class="breadcrumb-item active" aria-current="page">@yield('page-title')</li>
                </ol>
            </nav>
        </div>
        <div>
            @can('create.notification')
                <a href="{{route('create.notification')}}" class="btn btn-primary">Create</a>
            @endcan
        </div>

        <!--breadcrumb end-->
        <div class="row pt-3">
            <div class="col-12">
                <div class="table-bg">
                    <section class="component-section" id="employee">
                        <table id='roles-datatable' class="table pmd-table table-hover pmd-table-card">
                            <thead class="thead-light">
                            <tr>
                                <th>S No.</th>
                                <th>Sender</th>
                                <th>Subject</th>
                                <th>Description</th>
                                <th>Actions</th>
                            </tr>
                            </thead>
                            <tbody>
                            @php $i=1; @endphp
                            @forelse($received_notifications as $notification)
                                <tr>
                                    <td>{{$i++ }}</td>
                                    <td>{{$notification->gnotification->findUser->name??"N/A"}}</td>
                                    <td>{{$notification->gnotification->subject??"N/A"}}</td>
                                    <td>
                                        @if($notification->gnotification->description)
                                            {!! (strlen($notification->gnotification->description) >50 )?substr(json_decode($notification->gnotification->description),0,100)." ...":json_decode($notification->gnotification->description) !!}</td>
                                        @else
                                            {{"N/A"}}
                                        @endif
                                    <td>
                                        @if($notification->is_read)
                                            <span class="badge badge-success">Seen</span>
                                        @else
                                            <div class="btn-html">
                                                <a class="btn btn-primary mark-as-read text-white" data-id="{{ $notification->id }}" {{--data-toggle="modal" data-target="#exampleModalCenter" --}}>Mark as Read</a>
                                            </div>
                                        @endif
                                    </td>
                                </tr>
                            @empty
                                <tr>
                                    <td colspan="4" class="text-center">No Notification</td>
                                </tr>
                            @endforelse
                            </tbody>
                        </table>
                    </section>
                </div>
            </div>
        </div>
    </div>
    <!-- content area end -->

@endsection

@push('js')
    <script>

        $(document).on('click','.mark-as-read',function () {
           let ele = $(this);
           let id = ele.attr('data-id');
            ele.html('<i class="fa fa-spinner fa-spin"></i>')
            $.ajax({
                url: '{{URL::to('site/notification/mark-as-read')}}' +"/"+ id,
                type: 'get',
                success: function(response){
                    if(response.response == true){
                        ele.parent().html('<span class="badge badge-success">Seen</span>')
                    }else{
                        ele.html('')
                        ele.html('Mark as Read')
                    }
                }
            });
        })
    </script>
@endpush


