@extends('layouts.app')
@section('page-title','Sent Notifications')

@push('css')
    <!-- DataTables -->
    <link rel="stylesheet" href="{{asset('plugins/datatables-bs4/css/dataTables.bootstrap4.min.css')}}">
    <link rel="stylesheet" href="{{asset('plugins/datatables-responsive/css/responsive.bootstrap4.min.css')}}">

@endpush

@section('content')
    <!--content area start-->
    <div id="content" class="pmd-content inner-page admin">
        <!-- Title -->
        <h1 id="employee" class="text-center">@yield('page-title')</h1>
        <!-- End Title -->
        <!--breadcrumb start-->
        <div class="float-right @cannot('create.notification') no-btn @endcannot">
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb pmd-breadcrumb mb-0">
                    <li class="breadcrumb-item">
                        <a href="{{route('dashboard')}}">Dashboard</a>
                    </li>
                    <li class="breadcrumb-item active" aria-current="page">@yield('page-title')</li>
                </ol>
            </nav>
        </div>
        <div>
            @can('create.notification')
                <a href="{{route('create.notification')}}" class="btn btn-primary">Create</a>
            @endcan
        </div>

        <!--breadcrumb end-->
        <div class="row pt-3">
            <div class="col-12">
                <div class="table-bg">
                    <section class="component-section" id="employee">
                        <table id='roles-datatable' class="table pmd-table table-hover pmd-table-card">
                            <thead class="thead-light">
                            <tr>
                                <th>S No.</th>
                                <th>Subject</th>
                                <th>Description</th>
                                <th>Actions</th>
                            </tr>
                            </thead>
                            <tbody>
                            @php $i=1; @endphp
                            @forelse($notification_send as $notification)
                                <tr>
                                    <td>{{$i++ }}</td>
                                    <td>{{$notification->subject}}</td>
                                    <td>{!! (strlen($notification->description) >50 )?substr(json_decode($notification->description),0,100)." ...":json_decode($notification->description) !!}</td>
                                    <td>
                                        <a class="btn btn-primary send_notification text-white" data-id="{{ $notification->id }}" data-toggle="modal" data-target="#exampleModalCenter" ><i class="fa fa-eye" title="View"></i></a>
                                    </td>
                                </tr>
                            @empty
                                <tr>
                                    <td colspan="5" class="text-center">No Notification</td>
                                </tr>
                            @endforelse
                            </tbody>
                        </table>
                    </section>
                </div>
            </div>
        </div>
    </div>
    <!-- content area end -->

    <!-- Modal -->
    <div class="modal fade" id="exampleModalCenter" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLongTitle">Notification Status</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body notification-list-scroll">
                    <div class="row mb-2">
                        <div class="col-md-6">
                            <strong>Sent To</strong>
                        </div>
                        <div class="col-md-6">
                            <strong>Status</strong>
                        </div>
                    </div>
                    <div class="row notification-list-view">

                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-dark" data-dismiss="modal">Close</button>
                </div>
            </div>
        </div>
    </div>

@endsection

@push('js')
    <script>

        $(document).on('click','.send_notification',function () {
           var id = $(this).attr('data-id');
            $.ajax({
                url: '{{URL::to('site/notification/show_send_notification')}}' +"/"+ id,
                type: 'get',
                success: function(response){
                    // console.log(response);
                    $(".notification-list-view").html(response);
                    // $(".notification-list-scroll").css({"overflow":"auto","overflow-x":"hidden","max-height":"40vh","width":"100%"});
                }
            });
        })
    </script>
@endpush


