@extends('layouts.app')

@section('page-title', 'Edit Package')

@push('css')
    <link href="https://cdn.jsdelivr.net/npm/summernote@0.8.18/dist/summernote-bs4.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
@endpush

@section('content')

    <div id="content" class="pmd-content admin section">
        <!-- Title -->
        <h1>@yield('page-title')</h1>

        <!-- Breadcrumb -->
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb pmd-breadcrumb">
                <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">Dashboard</a></li>
                <li class="breadcrumb-item">Packages</li>
                <li class="breadcrumb-item active" aria-current="page">@yield('page-title')</li>
            </ol>
        </nav>
        <!-- End breadcrumb -->

        <div class="row">
            <div class="col-md-12">
                <div class="card pmd-card">
                    <form method="post" autocomplete="off" action="{{ route('update.package') }}" enctype="multipart/form-data" id="page_form">
                        @csrf
                        <input type="hidden" name="id" value="{{$package->id}}">
                        <div class="card-body">
                            <!-- Page Title & Subtitle -->
                            <div class="details-tab">
                                <h3 class="card-title">Update Package Information</h3>
                                <div class="row">
                                    <div class="col-12 col-sm-6 col-md-6">
                                        <label for="page-title" class="control-label">Title</label>
                                        <div class="form-group pmd-textfield pmd-textfield-floating-label">
                                            <input type="text" class="form-control" name="title" id="page-title" value="{{ $package->title }}" required>
                                            @error('title')
                                            <span>
                                                <strong class="text-danger">{{ $message }}</strong>
                                            </span>
                                            @enderror
                                        </div>
                                    </div>
                                    <div class="col-12 col-sm-6 col-md-6">
                                        <label for="status" class="control-label">Package Type</label>
                                        <div class="form-group pmd-textfield pmd-textfield-floating-label">
                                            <select class="form-control" name="pkg_type" required>
                                                <option value="" selected disabled>Select</option>
                                                <option @if($package->pkg_type == 'Website Development') selected @endif value="Website Development">Website Development</option>
                                                <option @if($package->pkg_type == 'Logo Design') selected @endif value="Logo Design">Logo Design</option>
                                                <option @if($package->pkg_type == 'Video Animation Services') selected @endif value="Video Animation Services">Video Animation Services</option>
                                                <option @if($package->pkg_type == 'Website Maintenance') selected @endif value="Website Maintenance">Website Maintenance</option>
                                                <option @if($package->pkg_type == 'Mobile Application') selected @endif value="Mobile Application">Mobile Application</option>
                                                <option @if($package->pkg_type == 'Digital Marketing Services') selected @endif value="Digital Marketing Services">Digital Marketing Services</option>
                                            </select>
                                        </div>
                                    </div>

                                    <div class="col-12 col-sm-6 col-md-6">
                                        <label for="status" class="control-label">User Package Display</label>
                                        <div class="form-group pmd-textfield pmd-textfield-floating-label">
                                            <select class="form-control" name="user_package_display" required>
                                                <option value="" selected disabled>Select</option>
                                                <option @if($package->user_package_display == 'website') selected @endif value="website">Website</option>
                                                <option @if($package->user_package_display == 'ads') selected @endif value="ads">Ads</option>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="col-12 col-sm-6 col-md-6">
                                        <label for="page-title" class="control-label">Price</label>
                                        <div class="form-group pmd-textfield pmd-textfield-floating-label">
                                            <input type="text" class="form-control" name="price" value="{{ $package->price }}" required>
                                            @error('price')
                                            <span><strong class="text-danger">{{ $message }}</strong></span>
                                            @enderror
                                        </div>
                                    </div>

                                    <div class="col-12 col-sm-6 col-md-6">
                                        <label for="page-title" class="control-label">Discounted Price</label>
                                        <div class="form-group pmd-textfield pmd-textfield-floating-label">
                                            <input type="text" class="form-control" name="discounted_price" value="{{ $package->discounted_price }}" required>
                                            @error('discounted_price')
                                            <span><strong class="text-danger">{{ $message }}</strong></span>
                                            @enderror
                                        </div>
                                    </div>

                                    <div class="col-12 col-sm-6 col-md-6">
                                        <label for="status" class="control-label">Status</label>
                                        <div class="form-group pmd-textfield pmd-textfield-floating-label">
                                            <select class="form-control" name="status" id="status" required>
                                                <option value="" disabled selected>Select Status</option>
                                                <option @if($package->status == 1) selected @endif value="1">Active</option>
                                                <option @if($package->status == 0) selected @endif value="0">In Active</option>

                                            </select>
                                        </div>
                                    </div>
                                    <div class="col-12 col-sm-6 col-md-6">
                                        <label for="web_type" class="control-label">Website Type(If website Package)</label>
                                        <div class="form-group pmd-textfield pmd-textfield-floating-label">
                                            <select class="form-control" name="web_type" id="web_type">
                                                <option value="" selected disabled>Select Type</option>
                                                <option @if($package->web_type == 'Website Design') selected @endif value="Website Design">Website Design</option>
                                                <option @if($package->web_type == 'E-Commerce Website') selected @endif value="E-Commerce Website">E-Commerce Website</option>
                                            </select>
                                        </div>
                                    </div>
                                    <!-- Page Content -->
                                    <div class="col-12 col-sm-6 col-md-12">
                                        <label class="card-title">Page Content</label>
                                        <div class="mb-3">
                                            <textarea class="textarea form-control" name="description" placeholder="Place some text here" style="width: 100%; height: 200px; font-size: 14px; line-height: 18px; border: 1px solid #dddddd; padding: 10px;">{{ $package->description }}</textarea>
                                        </div>
                                    </div>
                                    <div class="col-12 col-sm-6 col-md-12">
                                        <label class="card-title">Different Style Content</label>
                                        <div class="mb-3">
                                            <textarea class="textarea form-control" name="different_style_desc" placeholder="Place some text here" style="width: 100%; height: 200px; font-size: 14px; line-height: 18px; border: 1px solid #dddddd; padding: 10px;">{{ $package->different_style_desc }}</textarea>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="card-footer pmd-card-border">
                            <button class="btn pmd-ripple-effect btn-primary pmd-btn-raised" type="submit">Update Package</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

@endsection

@push('js')
    <script src="https://cdn.jsdelivr.net/npm/summernote@0.8.18/dist/summernote-bs4.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
    <script>
        $(function () {
            // Initialize Select2 for multiple select dropdown
            $('.select2').select2();
            $('.textarea').summernote({
                height: 280,
                focus: false
            });
        });
        var numbers = document.getElementsByClassName('amount-input');
        // Loop through each element and attach the event listener.
        for (var i = 0; i < numbers.length; i++) {
            numbers[i].onkeydown = function(e) {
                if (!((e.keyCode >= 96 && e.keyCode <= 105) // Numpad keys
                    || (e.keyCode >= 48 && e.keyCode <= 57) // Number keys
                    || e.keyCode === 8)) { // Backspace
                    e.preventDefault(); // Prevent the default action
                }
            };
        }
    </script>
@endpush

