@extends('layouts.app')
@section('page-title', 'Packages')

@push('css')
    <!-- DataTables -->
    <link rel="stylesheet" href="{{asset('plugins/datatables-bs4/css/dataTables.bootstrap4.min.css')}}">
    <link rel="stylesheet" href="{{asset('plugins/datatables-responsive/css/responsive.bootstrap4.min.css')}}">
@endpush

@section('content')
    <!-- Content Wrapper. Contains page content -->
    <div id="content" class="pmd-content inner-page admin">
        <!-- Title -->
        <h1 id="employee" class="text-center">@yield('page-title')</h1>
        <!-- End Title -->
        <!--breadcrumb start-->
        <div class="float-right @cannot('create.client') no-btn @endcan">
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb pmd-breadcrumb mb-0">
                    <li class="breadcrumb-item">
                        <a href="{{route('dashboard')}}">Dashboard</a>
                    </li>
                    <li class="breadcrumb-item active" aria-current="page">@yield('page-title')</li>
                </ol>
            </nav>
        </div>
        <div>
            @can('create.package')
                <a href="{{route('create.package')}}" class="btn btn-primary ">Create Package</a>
            @endcan
        </div>
        <!-- Main content -->
        <div class="row pt-3">
            <div class="col-12">
                <div class="table-bg">
                    <section class="component-section" id="employee">
                        <table id="roles-datatable" class="table pmd-table table-hover pmd-table-card">
                            <thead class="thead-light">
                            <tr>
                                <th>S.no</th>
                                <th>Title</th>
                                <th>Package Display</th>
                                <th>Price</th>
                                <th>Discounted Price</th>
                                <th>Status</th>
{{--                                <th>Website Type</th>--}}
                                {{--                                <th>Created At</th>--}}
                                <th>Actions</th>
                            </tr>
                            </thead>
                            <tbody>
                            @foreach($packages as $index => $package)
                                <tr>
                                    <td>{{ $index + 1 }}</td> <!-- Display sequential number -->
                                    <td>{{$package->title}}</td>
                                    <td>{{$package->user_package_display}}</td>
                                    <td>${{$package->price}}</td>
                                    <td>${{$package->discounted_price}}</td>
                                    <td>
                                        @if($package->status == 1)
                                            <span class="badge badge-success"> Active </span>
                                        @else
                                            <span class="badge badge-danger"> In Active </span>
                                        @endif
                                    </td>
{{--                                    <td>{{$package->web_type ?? 'Not Selected'}}</td>--}}
                                    {{--                                    <td>{{date('d-M-Y h:i A', strtotime($package->created_at))}}</td>--}}
                                    <td>
                                        <div class="btn-group btn-group-sm">
                                            <a href="{{route('edit.package', ['id' => $package->id])}}" class="btn btn-info"><i class="fas fa-edit"></i></a>
                                            <button class="btn btn-danger delete_package" data-id="{{$package->id}}"><i class="fas fa-trash"></i></button>
                                        </div>
                                    </td>
                                </tr>
                            @endforeach
                            </tbody>
                        </table>
                    </section>
                </div>
            </div>
        </div>
    </div>
@endsection

@push('js')
    <script>
        $(function () {
            // Initialize DataTable
            $("#roles-datatable").DataTable({
                "responsive": true,
                "autoWidth": false,
                "columnDefs": [
                    { orderable: false, targets: 0 }  // Disable sorting on the checkbox column
                ]
            });

            // Handle delete single page action
            $(document).on('click', '.delete_package', function(e) {
                var ids = [$(this).attr('data-id')];
                removeByIds(ids);
            });


            // Remove pages by IDs
            function removeByIds(ids) {
                Swal.fire({
                    title: 'Are you sure?',
                    text: 'You will not be able to recover these packages!',
                    icon: 'warning',
                    showCancelButton: true,
                    confirmButtonText: 'Yes, delete it!',
                    cancelButtonText: 'Cancel'
                }).then((result) => {
                    if (result.isConfirmed) {
                        // Make the AJAX request to delete the pages
                        $.ajax({
                            url: '{{ route('delete.package') }}',
                            type: 'POST',
                            data: {
                                _token: '{{ csrf_token() }}',
                                ids: ids
                            },
                            success: function(response) {
                                if (response.success) {
                                    Swal.fire({
                                        icon: 'success',
                                        title: 'Deleted!',
                                        text: 'The selected packages have been deleted.',
                                        // confirmButtonText: 'OK'
                                    }).then(() => {
                                        location.reload();  // Reload the page after successful deletion
                                    });
                                } else {
                                    Swal.fire({
                                        icon: 'error',
                                        title: 'Something went wrong',
                                        text: 'Please try again later.',
                                        confirmButtonText: 'OK'
                                    });
                                }
                            },
                            error: function() {
                                Swal.fire({
                                    icon: 'error',
                                    title: 'An error occurred',
                                    text: 'There was an error while deleting the packages.',
                                    confirmButtonText: 'OK'
                                });
                            }
                        });
                    }
                });
            }
        });
    </script>

@endpush
