@extends('layouts.app')
@section('page-title','Projects')

@push('css')
    <!-- DataTables -->
    <link rel="stylesheet" href="{{asset('plugins/datatables-bs4/css/dataTables.bootstrap4.min.css')}}">
    <link rel="stylesheet" href="{{asset('plugins/datatables-responsive/css/responsive.bootstrap4.min.css')}}">
    <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />

@endpush

@section('content')
    <!--content area start-->
    <div id="content" class="pmd-content inner-page admin">
        <!-- Title -->
        <h1 id="employee" class="text-center">@yield('page-title')</h1>
        <!-- End Title -->
        <!--breadcrumb start-->
        <div class="float-right @cannot('create.project') no-btn @endcan">
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb pmd-breadcrumb mb-0">
                    <li class="breadcrumb-item">
                        <a href="{{route('dashboard')}}">Dashboard</a>
                    </li>
                    <li class="breadcrumb-item active" aria-current="page">@yield('page-title')</li>
                </ol>
            </nav>
        </div>
        <div>
            @can('create.project')
                <a href="{{route('create.project')}}" class="btn btn-primary ">Create</a>
            @endcan
        </div>

        <!--breadcrumb end-->
        <div class="row pt-3">
            <div class="col-12">
                <div class="table-bg">
                    <div id="accordion">
                        @foreach($project_types as $key => $type)
                            <div class="card">
                                <div class="card-header" id="heading{{$type->id}}">
                                    <h5 class="mb-0">
                                        <button class="btn btn-link" data-toggle="collapse" data-target="#collapse{{$type->id}}" aria-expanded="true" aria-controls="collapse{{$type->id}}">
                                            {{$type->title}}
                                        </button>
                                    </h5>
                                </div>

                                <div id="collapse{{$type->id}}" class="collapse" aria-labelledby="heading{{$type->id}}" data-parent="#accordion">
                                    <div class="card-body">
                                        <p>
                                            <a href="{{route('team-work', base64_encode($type->id))}}" target="_blank" class="btn btn-success ">Team Work
                                                <i class="fa fa-external-link"></i>
                                            </a>
                                        </p>
                                        <table class="table pmd-table table-hover pmd-table-card datatable-project" id="TABLE_{{$type->id}}">
                                            <thead class="thead-light">
                                            <tr>
                                                <th>S No.</th>
                                                <th>Title</th>
                                                <th>Start Date</th>
                                                <th>End Date</th>
                                                <th>Account Manager</th>
                                                <th>Project Manager</th>
                                                <th>Client Name</th>
                                                <th>Type</th>
                                                <th>Status</th>
                                                <th>Actions</th>
                                            </tr>
                                            </thead>
                                            <tbody>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        @endforeach
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- content area end -->
@endsection

@push('js')
    <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>

    <script>
        var table;
        $(document).ready( function () {
            $('.select-two').select2();

            /*Ajax Call for Datatable Data Start*/
            var project_types_array = {{$project_types_array}}

            function ajaxRequest (project_types_array) {
                if (project_types_array.length > 0) {
                    var project_type_id = project_types_array.pop();
                    $('#TABLE_'+project_type_id).DataTable({
                        "serverSide": true,
                        "processing": true,
                        "responsive": true,
                        "autoWidth" : false,
                        "ajax": {
                            "url": "{{ route('show.projects.two') }}",
                            "dataType": "json",
                            "type": "POST",
                            "data": {
                                _token: "{{csrf_token()}}",
                                project_type_id: project_type_id,
                            }
                        },
                        "columns": [
                            {"data": "id",sortable:false},
                            {"data": "project_name",sortable: false},
                            {"data": "start_date",sortable: false},
                            {"data": "end_date",sortable: false},
                            {"data": "account_manager_user_id",sortable: false},
                            {"data": "project_manager_user_id",sortable: false},
                            {"data": "client_id",sortable: false},
                            {"data": "project_type_id",sortable: false},
                            {"data": "status_id",sortable: false},
                            {"data": "options",sortable: false}
                        ]
                    });
                    ajaxRequest(project_types_array);
                }
            }

            ajaxRequest(project_types_array);
            /*Ajax Call for Datatable Data End*/

            {{--$('#roles-datatable').DataTable({
                "serverSide": true,
                "processing": true,
                "responsive": true,
                "autoWidth" : false,
                "ajax": {
                    "url": "{{ route('show.projects') }}",
                    "dataType": "json",
                    "type": "POST",
                    "data": {_token: "{{csrf_token()}}"}
                },
                "columns": [
                    {"data": "id",sortable:false},
                    {"data": "project_name",sortable: false},
                    {"data": "start_date",sortable: false},
                    {"data": "end_date",sortable: false},
                    {"data": "account_manager_user_id",sortable: false},
                    {"data": "project_manager_user_id",sortable: false},
                    {"data": "client_id",sortable: false},
                    {"data": "project_type_id",sortable: false},
                    {"data": "status_id",sortable: false},
                    {"data": "options",sortable: false}
                ]
            });--}}
        } );

        $(document).on('click','.delete-btn',function(){
            var id = $(this).attr('data-id');

            Swal.fire({
                title: 'Are you sure?',
                text: "You won't be able to revert this!",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: 'Yes, delete it!'
            }).then((result) => {
                if (result.isConfirmed) {
                    $.ajax({
                        url: '{{URL::to('site/project/delete')}}' +"/"+ id,
                        type: 'get',
                        success: function(response){
                            Swal.fire(
                                'Deleted!',
                                response,
                                'success'
                            );
                            location.reload();
                        }
                    });
                }
            });

        });

    </script>
@endpush
