{{-- * Template Name :Seo Ip * --}}
    <!DOCTYPE html>
<html class="no-js" lang="en-US">

<head>
    <meta charset="utf-8">
    <meta http-equiv="x-ua-compatible" content="ie=edge">
    <title>Top Digital & SEO Marketing Agency in USA - Anax Designs</title>
    <meta name="ROBOTS" content="INDEX, FOLLOW">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <meta name="description" content="If you're looking for a USA-based digital and SEO marketing agency to get found online, Anax Designs is top of the list. Contact us today at (877) 908 8719">
    <meta name="author" content="">
    <meta http-equiv="Cache-control" content="public">
    <!-- Favicon -->
    <link rel="shortcut icon" type="image/x-icon" href="{{asset('images/favicon.png')}}">
    <link rel="stylesheet" type="text/css" href="{{asset('assets/seo-ip/css/default.css')}}"/>
    <link rel="stylesheet" type="text/css" href="{{asset('assets/seo-ip/css/style.css')}}"/>
    <script src="{{asset('assets/seo-ip/js/modernizr-3.6.0.min.js')}}"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.5.0/css/all.min.css" integrity="sha512-QfDd74mlg8afgSqm3Vq2Q65e9b3xMhJB4GZ9OcHDVy1hZ6pqBJPWWnMsKDXM7NINoKqJANNGBuVRIpIJ5dogfA==" crossorigin="anonymous" referrerpolicy="no-referrer" />

</head>


<script type="text/javascript">
    WebFontConfig = {
        google: {
            families: ['Poppins:300,400,500,600,700&display=swap', 'Roboto:300,400,500,700,900&display=swap']
        }
    };
    (function() {
        var wf = document.createElement('script');
        wf.src = 'https://ajax.googleapis.com/ajax/libs/webfont/1/webfont.js';
        wf.type = 'text/javascript';
        wf.async = 'true';
        var s = document.getElementsByTagName('script')[0];
        s.parentNode.insertBefore(wf, s);
    })();
</script>

<body class="sticky-header">

<a href="#wrapper" data-type="section-switch" class="scrollup"> <i class="fas fa-angle-double-up"></i> </a>
<!-- ScrollUp End Here -->
<!-- Preloader Start Here -->
<!-- Preloader End Here -->
<div id="wrapper" class="wrapper">
    <!-- Add your site or application content here -->
    <!-- Header Area Start Here -->
    <header class="header ">
        <div id="rt-sticky-placeholder"></div>
        <div id="header-menu" class="header-menu menu-layout2">
            <div class="container-fluid">
                <div class="row d-flex align-items-center">
                    <div class="col-lg-2">
                        <div class="logo-area">
                            <a href="#" class="temp-logo" id="temp-logo"> <img src="{{asset('assets/seo-ip/images/logo.png')}}" alt="logo" class="img-fluid"> </a>
                            <a href="#" class="temp-logo-b" id="temp-logo-b"> <img src="{{asset('assets/seo-ip/images/logo.png')}}" alt="logo" class="img-fluid"> </a>
                        </div>
                    </div>
                    <div class="col-lg-10 d-flex justify-content-end possition-static">
                        <nav id="dropdown" class="template-main-menu">
                            <ul>

                                <li class="header_btn"> <a href="https://www.anaxdesigns.com/contact-us/">Contact Us</a> </li>
                                <li class="header_btn"> <a href="tel:(877) 908 8719">(877) 908 8719</a> </li>
                            </ul>
                        </nav>
                    </div>
                </div>
            </div>
        </div>
    </header>
    <!-- Header Area End Here -->

    <!-- Banner Area Start Here -->
    <section class="slide-banner-wrap  bg-common" id="homebannersec">
        <div class="fullscreen-bg">
            <!--<video loop muted autoplay class="fullscreen-bg__video"> <source src="https://ik.imagekit.io/anaxdesigns/video/video-compress-3_1__jupKnKuxs.mp4" type="video/mp4"> </video>-->
            <!--<div id="overlay"></div>-->
            <video loop muted autoplay class="fullscreen-bg__video">
                <source src="{{asset('assets/seo-ip/images/video/video-compress-3_1__jupKnKuxs.mp4')}}" type="video/mp4">
                <!--<source src="https://ik.imagekit.io/logodigitals/anaxdesigns.mp4?updatedAt=1633112511838" type="video/mp4">-->
            </video>
        </div>
        <div class="container slide-banner-center-con">
            <div class="row">
                <div class="col-lg-12 col-12">
                    <div class="banner-content">
                        <h1 class="banner-title">Get Your Business Up by 10X</h1>
                        <h2 class="banner-subtitle">Build Website Traffic, and Boost SERP Ranking With Exceptional SEO and Digital Marketing Strategies. <br>Trust Anax Designs and Witness an Exponential Growth of Your Digital Business. </h2>
                        <!--<div class="banner-form-box">
                            <form class="contact-form-box" id="analyze-now-form" action="#" method="post">
                                <div class="row no-gutters justify-content-center">
                                    <div class="col-lg-12 col-12 form-group multi-form-group justify-content-center">
                                        <div class="logo-design-field-area">
                                            <input id="domainUrl" autofocus type="text" pattern="^(http:\/\/www\.|https:\/\/www\.|http:\/\/|https:\/\/)?[a-z0-9]+([\-\.]{1}[a-z0-9]+)*\.[a-z]{2,5}(:[0-9]{1,5})?(\/.*)?$" title="Input should be URL. For example: .com, .org, .net" placeholder="Enter Your Business Website URL" style="text-transform:lowercase" class="form-control" name="url" data-error="Website field is required" required>

                                            <div class="help-block with-errors"></div>
                                            <button type="submit" class="item-btn">Analyze Now</button>
                                        </div>
                                    </div>
                                </div>
                                <div class="form-response"></div>
                            </form>
                        </div>-->
                        <h5 class="analyzer-form-b-txt">Confused? Discuss your project with our <a href="javascript:void(0)" onclick="$zopim.livechat.window.show()" style="text-decoration:none; color: #2ca24c; ">Consultant</a></h5>
                        <!--<h5 class="analyzer-form-b-txt">Enter your website address and see its PERFORMANCE REPORT. Absolutely for FREE!</h5>--></div>
                </div>
            </div>
        </div>
        <div class="container absolute-bottom">
            <div class="rc-carousel nav-control-layout4" data-loop="true" data-items="10" data-margin="50" data-autoplay="true" data-autoplay-timeout="3000" data-smart-speed="1000" data-dots="false" data-nav="true" data-nav-speed="false" data-r-x-small="1" data-r-x-small-nav="true" data-r-x-small-dots="false" data-r-x-medium="2" data-r-x-medium-nav="true" data-r-x-medium-dots="false" data-r-small="3" data-r-small-nav="true" data-r-small-dots="false" data-r-medium="4" data-r-medium-nav="true" data-r-medium-dots="false" data-r-large="4" data-r-large-nav="true" data-r-large-dots="false" data-r-extra-large="5" data-r-extra-large-nav="true" data-r-extra-large-dots="false">
                <div class="brand-box-layout1">
                    <div class="item-img"> <img loading="lazy" src="{{asset('assets/seo-ip/images/brand1.png')}}" alt="brand"> </div>
                </div>
                <div class="brand-box-layout1">
                    <div class="item-img"> <img loading="lazy" src="{{asset('assets/seo-ip/images/brand2.png')}}" alt="brand"> </div>
                </div>
                <div class="brand-box-layout1">
                    <div class="item-img"> <img loading="lazy" src="{{asset('assets/seo-ip/images/brand3.png')}}" alt="brand"> </div>
                </div>
                <div class="brand-box-layout1">
                    <div class="item-img"> <img loading="lazy" src="{{asset('assets/seo-ip/images/brand4.png')}}" alt="brand"> </div>
                </div>
                <div class="brand-box-layout1">
                    <div class="item-img"> <img loading="lazy" src="{{asset('assets/seo-ip/images/brand5.png')}}" alt="brand"> </div>
                </div>
            </div>
        </div>
    </section>
    <!-- Contact Info Area Start Here -->
    <section class="contact-info-wrap-layout1 p-0">
        <div class="container-fluid">
            <div class="row">
                <div class="col-md-3 col-12 blue-div">
                    <div class="contact-info-box-layout1">
                        <div class="media media-none--md">
                            <div class="item-icon">
                                <!-- <i class="flaticon-call-answer"></i> --><img loading="lazy" src="{{asset('assets/seo-ip/images/satisfy.png')}}" alt="Satisfied Customer"> </div>
                            <div class="media-body space-md">
                                <h3 class="item-title">Satisfied Customer</h3>
                                <div class="item-subtitle">Over 500+ Satisfied Customers</div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-md-3 col-12 dark-blue-div">
                    <div class="contact-info-box-layout1">
                        <div class="media media-none--md">
                            <div class="item-icon">
                                <!-- <i class="flaticon-mail"></i> --><img loading="lazy" src="{{asset('assets/seo-ip/images/affordable.png')}}" alt="Affordable pricing"> </div>
                            <div class="media-body space-md">
                                <h3 class="item-title">Affordable pricing</h3>
                                <div class="item-subtitle">Reasonable Pricing for Business</div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-md-3 col-12 purple-div">
                    <div class="contact-info-box-layout1">
                        <div class="media media-none--md">
                            <div class="item-icon">
                                <!-- <i class="flaticon-maps-and-flags"></i> --><img loading="lazy" src="{{asset('assets/seo-ip/images/specialist.png')}}" alt="Our Seo Specialist"> </div>
                            <div class="media-body space-md">
                                <h3 class="item-title">Our Seo Specialist</h3>
                                <div class="item-subtitle">Any Query about your Business</div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-md-3 col-12 orange-div">
                    <div class="contact-info-box-layout1">
                        <div class="media media-none--md">
                            <div class="item-icon">
                                <!-- <i class="flaticon-maps-and-flags"></i> --><img loading="lazy" src="{{asset('assets/seo-ip/images/24hours.png')}}" alt="24/7 Support"> </div>
                            <div class="media-body space-md">
                                <h3 class="item-title">24/7 Support</h3>
                                <div class="item-subtitle">Provides 24/7 Customer Support</div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- Why Choose Area Start Here -->
    <section class="why-chose-wrap-layout1 pb-0">
        <div class="container">
            <div class="row align-items-center">
                <div class="col-lg-6 order-lg-2">
                    <div class="why-chose-box-layout1 pb-0-mob">
                        <div class="item-img">
                            <img loading="lazy" src="{{asset('assets/seo-ip/images/aboutpic.png')}}" alt="image"> </div>
                    </div>
                </div>
                <div class="col-lg-6 order-lg-1">
                    <div class="why-chose-box-layout1">
                        <!--<h2 class="item-title">A USA Based Innovative <br>SEO Company</h2>-->
                        <h2 class="item-title">A USA Based Digital <br> Marketing Agency</h2>
                        <p class="text-justify">Anax Designs is a highly professional company offering clients a wide range of digital marketing services to meet all your business and marketing needs. We believe in generating long-term and customer-focused advanced digital marketing solutions. Anax Designs concentrates on developers and marketers to meet all your business and marketing needs The ultimate goal is to encourage startups to grow with us. Believe in us because every business venture needs the best digital marketing services to build its image. </p>
                        <p>Anax Designs helps you in:</p>
                        <ul class="single-item">
                            <li>Comprehensive website audit and campaign customization</li>
                            <li>Providing scalable, smart branding</li>
                            <li>Designing logos pertaining to your business</li>
                            <li>Curating digital marketing strategies according to your business module </li>
                            <li>Boosting sales with e-commerce services</li>
                        </ul> <a href="#" class="btn-fill gradient-accent mg-t-20">Let’s Develop Your Business!<i class="fas fa-arrow-circle-right"></i></a> </div>
                </div>
            </div>
        </div>
    </section>
    <!-- Banner Area End Here -->
    <section class="service-wrap-layout3 section-padd lap-ver">
        <div class="container">
            <div class="row gutters-50">
                <div class="heading-layout1">
                    <h2>What You Can Get From Us?</h2>
                    <p>If you are looking for a digital marketing platform to take your business to the next level, Anax Designs is all set to elevate your brand’s presence by developing a smart website, designing an impressive logo, placing the right keywords, generating catchy social media posts, and more. Our team of design specialists follow a strategic approach with your input, to build an aesthetic visual identity of your business. Get the most out of your marketing budget by working with us. </p>
                </div>
                <div class="col-12">
                    <div class="home-laptop-slider"> <img loading="lazy" src="{{asset('assets/seo-ip/images/pc.png')}}" loading="lazy" alt="PC Banner"> </div>
                    <!--<div class="home-lap-mockup-slider"> <img loading="lazy" src="https://www.anaxdesigns.com/assets/img/mac-inner.png"> <video loop muted autoplay> <source src="https://www.anaxdesigns.com/assets/video/pc-video.mp4" type="video/mp4"> </video> </div>-->
                    <div class="home-lap-mockup-slider owl-carousel">
                        <div class="item"> <img loading="lazy" src="{{asset('assets/seo-ip/images/laptop1.jpg')}}" alt="Laptop1" loading="lazy"> </div>
                        <div class="item"> <img loading="lazy" src="{{asset('assets/seo-ip/images/laptop2.jpg')}}" alt="Laptop2" loading="lazy"> </div>
                    </div>
                </div>
                <div class="col-12 mt-5">
                    <div class="heading-layout1 mb-0">
                        <h2 class="mb-0">Perks of Joining Us</h2> </div>
                </div>
                <div class="col-12 service-box-layout5">
                    <div class="row">
                        <div class="col-lg-6">
                            <div class="media media-none--xs">
                                <div class="item-icon gradient-accent blue-div"> <i class="flaticon-website"></i> </div>
                                <div class="media-body">
                                    <h3 class="item-title">Proven Results</h3>
                                    <p>We have been in the industry for a decade and the testimonials and reviews of our clients prove it. Anax Designs is all about originality, authenticity, and credibility and our clients think the same of us.</p>
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-6">
                            <div class="media media-none--xs">
                                <div class="item-icon gradient-accent dark-blue-div"> <i class="flaticon-analytics"></i> </div>
                                <div class="media-body">
                                    <h3 class="item-title">Well-versed Professionals</h3>
                                    <p>Anax Designs has a panel of certified SEO experts, and digital marketers, who take the responsibility of delivering 100% results. </p>
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-6">
                            <div class="media media-none--xs">
                                <div class="item-icon gradient-accent purple-div helptoachievediv">
                                    <!--<i class="flaticon-website"></i>--><img loading="lazy" src="{{asset('assets/seo-ip/images/seo-report_NVN5ikJeE.png')}}"> </div>
                                <div class="media-body">
                                    <h3 class="item-title">Authenticity</h3>
                                    <p>Anax Designs has a quality assurance team onboard ensuring that the clients get the best without any delays and disruptions. </p>
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-6">
                            <div class="media media-none--xs">
                                <div class="item-icon gradient-accent orange-div helptoachievediv organiclisting">
                                    <!--<i class="flaticon-analytics"></i>--><img loading="lazy" src="{{asset('assets/seo-ip/images/organic-listing_lr9-a_yq9.png')}}"> </div>
                                <div class="media-body">
                                    <h3 class="item-title">Transparency</h3>
                                    <p style="margin-bottom: 0;">Our modus operandi to brief clients makes us stand out from the crowd. We update and report to you after every six months so you can get first-hand knowledge of your brand’s growth. </p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <section class="service-wrap-layout3 section-padd mob-ver-s">
        <div class="container">
            <div class="row gutters-50">
                <div class="heading-layout1">
                    <!--<h2>What You Can <br class="displayOnSM">Get From Us?</h2>-->
                    <h2>What You Can Get From Us?</h2>
                    <p>If you are looking for a digital marketing platform to take your business to the next level, Anax Designs is all set to elevate your brand’s presence by developing a smart website, designing an impressive logo, placing the right keywords, generating catchy social media posts, and more. Our team of design specialists follow a strategic approach with your input, to build an aesthetic visual identity of your business. Get the most out of your marketing budget by working with us. </p>
                </div>
                <div class="col-xl-4 col-12 offset-xl-1 max-390">
                    <div class="welcome-mockup right wow fadeInRight"> <img loading="lazy" src="{{asset('assets/seo-ip/images/home-phone-mockup_u6Y5lSXAEa.png')}}" alt="Phone Mockup" loading="lazy">
                        <div class="home-mobile-mockup-slider owl-carousel">
                            <div class="single-mockups"> <img loading="lazy" src="{{asset('assets/seo-ip/images/mobile1_Qc5RUygrjO.jpg')}}" alt="Mobile1" loading="lazy"> </div>
                            <div class="single-mockups"> <img loading="lazy" src="{{asset('assets/seo-ip/images/mobile2_nxQx1P5QO.jpg')}}" alt="Mobile2" loading="lazy"> </div>
                            <div class="single-mockups"> <img loading="lazy" src="{{asset('assets/seo-ip/images/mobile3_fOPb72O2M.jpg')}}" alt="Mobile3" loading="lazy"> </div>
                        </div>
                    </div>
                </div>
                <div class="col-12 mt-5">
                    <div class="heading-layout1 mb-0">
                        <!--<h2 class="mb-0">Here are some of <br class="displayOnSM">the reasons:</h2>-->
                        <h2 class="mb-0">Perks of Joining Us</h2> </div>
                </div>
                <div class="col-xl-6 col-12 offset-xl-1">
                    <div class="service-box-layout5 relative-center">
                        <div class="media media-none--xs">
                            <div class="item-icon gradient-accent blue-div"> <i class="flaticon-website"></i> </div>
                            <div class="media-body">
                                <h3 class="item-title">Proven Results</h3>
                                <p>We have been in the industry for a decade and the testimonials and reviews of our clients prove it. Anax Designs is all about originality, authenticity, and credibility and our clients think the same of us. </p>
                            </div>
                        </div>
                        <div class="media media-none--xs">
                            <div class="item-icon gradient-accent dark-blue-div"> <i class="flaticon-analytics"></i> </div>
                            <div class="media-body">
                                <h3 class="item-title">Well-versed Professionals</h3>
                                <p>Anax Designs has a panel of certified SEO experts, and digital marketers, who take the responsibility of delivering 100% results.</p>
                            </div>
                        </div>
                        <div class="media media-none--xs">
                            <div class="item-icon gradient-accent purple-div helptoachievediv">
                                <!--<i class="flaticon-website"></i>--><img loading="lazy" src="{{asset('assets/seo-ip/images/seo-report_NVN5ikJeE.png')}}"> </div>
                            <div class="media-body">
                                <h3 class="item-title">Authenticity</h3>
                                <p>Anax Designs has a quality assurance team onboard ensuring that the clients get the best without any delays and disruptions. </p>
                            </div>
                        </div>
                        <div class="media media-none--xs">
                            <div class="item-icon gradient-accent orange-div helptoachievediv organiclisting">
                                <!--<i class="flaticon-analytics"></i>--><img loading="lazy" src="{{asset('assets/seo-ip/images/organic-listing_lr9-a_yq9.png')}}"> </div>
                                <h3 class="item-title">Transparency</h3>
                                <p style="margin-bottom: 0;">Our modus operandi to brief clients makes us stand out from the crowd. We update and report to you after every six months so you can get first-hand knowledge of your brand’s growth.</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- Pricing Area End Here -->
    <div class="white-section price-section-new" id="pricing">
        <div class="container">
            <div class="heading-layout1">
                <!--<h2>Unbeatable SEO Pricing Plans Designed <br class="displayOnSM">By Experts</h2>-->
                <h2>Unbeatable Pricing Plans Designed By Experts</h2>
                <p>We offer first-rank digital marketing services in the most competitive pricing that you can’t find anywhere else.</p>
            </div>
            <div class="row">
                @foreach($packages as $package)
                    {!! $package->description !!}
                @endforeach
            </div>
        </div>
    </div>
    <div class="blue-gr-section">
        <div class="container">
            <div class="row">
                <div class="col-lg-6">
                    <h3> Want a custom-built package?<br> Let’s connect to discuss <br class="displayOnSM">your project! </h3> </div>
                <div class="col-lg-6"> <a href="javascript:void(0)" onclick="$zopim.livechat.window.show()" class="get-started-blue float-right">Discuss Now</a> </div>
            </div>
        </div>
    </div>
    <div class="grey-section listsec img-ver">
        <div class="container">
            <div class="heading-layout1 mb-0">
                <h2>Result-Oriented SEO Services For Businesses Globally</h2> </div>
            <div class="wrap">
                <ul>
                    <li class="bb br"> <img loading="lazy" src="{{asset('assets/seo-ip/images/b2b/1.png')}}" alt="Financial advisors" loading="lazy">
                        <p>Financial advisors</p>
                    </li>
                    <li class="bb br"> <img loading="lazy" src="{{asset('assets/seo-ip/images/b2b/2.png')}}" alt="Fortune 500 companies" loading="lazy">
                        <p>Fortune 500 companies</p>
                    </li>
                    <li class="bb"> <img loading="lazy" src="{{asset('assets/seo-ip/images/b2b/3.png')}}" alt="Retail" loading="lazy">
                        <p>Retail</p>
                    </li>
                    <li class="bb br"> <img loading="lazy" src="{{asset('assets/seo-ip/images/b2b/4.png')}}" alt="Tech companies" loading="lazy">
                        <p>Tech companies</p>
                    </li>
                    <li class="bb br"> <img loading="lazy" src="{{asset('assets/seo-ip/images/b2b/5.png')}}" alt="Consultants" loading="lazy">
                        <p>Consultants</p>
                    </li>
                    <li class="bb"> <img loading="lazy" src="{{asset('assets/seo-ip/images/b2b/6.png')}}" alt="Small businesses" loading="lazy">
                        <p>Small businesses</p>
                    </li>
                    <li class="bb br"> <img loading="lazy" src="{{asset('assets/seo-ip/images/b2b/7.png')}}" alt="Real-estate agents" loading="lazy">
                        <p>Real-estate agents</p>
                    </li>
                    <li class="bb br"> <img loading="lazy" src="{{asset('assets/seo-ip/images/b2b/8.png')}}" alt="Service based" loading="lazy">
                        <p>Service based</p>
                    </li>
                    <li class="bb"> <img loading="lazy" src="{{asset('assets/seo-ip/images/b2b/9.png')}}" alt="Start ups" loading="lazy">
                        <p>Start ups</p>
                    </li>
                    <li class="bb br"> <img loading="lazy" src="{{asset('assets/seo-ip/images/b2b/10.png')}}" alt="Nonprofits" loading="lazy">
                        <p>Nonprofits</p>
                    </li>
                    <li class="bb br"> <img loading="lazy" src="{{asset('assets/seo-ip/images/b2b/11.png')}}" alt="Restaurants" loading="lazy">
                        <p>Restaurants</p>
                    </li>
                    <li class="bb"> <img loading="lazy" src="{{asset('assets/seo-ip/images/b2b/12.png')}}" alt="Manufacturers" loading="lazy">
                        <p>Manufacturers</p>
                    </li>
                    <li class=" br"> <img loading="lazy" src="{{asset('assets/seo-ip/images/b2b/13.png')}}" alt="Medical professionals" loading="lazy">
                        <p>Medical professionals</p>
                    </li>
                    <li class="br"> <img loading="lazy" src="{{asset('assets/seo-ip/images/b2b/14.png')}}" alt="Government agencies" loading="lazy">
                        <p>Government agencies</p>
                    </li>
                    <li> <img loading="lazy" src="{{asset('assets/seo-ip/images/b2b/15.png')}}" alt="Banks" loading="lazy">
                        <p>Banks</p>
                    </li>
                </ul>
            </div>
        </div>
    </div>
    <section class="why-chose-wrap-layout1 pb-0">
        <div class="container">
            <div class="row align-items-center">
                <div class="col-lg-6 col-12 order-lg-2">
                    <div class="why-chose-box-layout1 pb-0-mob pb-0">
                        <div class="item-img"> <img loading="lazy" src="{{asset('assets/seo-ip/images/seo-2.png')}}" alt="image"> </div>
                    </div>
                </div>
                <div class="col-lg-6 col-12 order-lg-1">
                    <div class="why-chose-box-layout1 heading-layout1 pb-0 text-left full-text-head mb-0">
                        <h2>Offering Solutions That Drive Website Visibility and Elevate Customer Engagement</h2>
                        <p class="item-title text-justify">You might know what a powerful web presence is capable of doing but aren't sure how to achieve it. This is a concern for many of our clients. At Anax Designs, we are familiar with the uncertainty and confusion a customer experiences.</p>
                        <p>You might know what a powerful web presence is capable of doing but aren't sure how to achieve it. This is a concern for many of our clients. At Anax Designs, we are familiar with the uncertainty and confusion a customer experiences.</p>
                        <p>If you are contacting us, then you might be facing online brand presence concerns. Here is what our experts can assist you with:</p>
                        <p>Here is how our experts can assist you:</p>
                        <ul class="single-item">
                            <li>You have low website visibility, and it is difficult to find.</li>
                            <li>The traffic on your website has dropped, and you don't know why.</li>
                            <li>The number of leads and incoming calls has also dropped.</li>
                            <li>You are beginning a new business and want to launch a website for it.</li>
                        </ul>
                        <p class="text-justify"> Does any of it sound familiar? If so, then you are at the right place. Our platform offers SEO-oriented solutions to boost your website visibility and generate more leads. Anax Designs stays abreast of the changing Google algorithm and promises customized solutions to clients. </p>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <section class="why-chose-wrap-layout1 pb-0">
        <div class="container">
            <div class="row align-items-center">
                <div class="col-lg-6 col-12">
                    <div class="why-chose-box-layout1 pb-0-mob pb-0">
                        <div class="item-img"> <img loading="lazy" src="{{asset('assets/seo-ip/images/seo-4.png')}}" alt="image"> </div>
                    </div>
                </div>
                <div class="col-lg-6 col-12">
                    <div class="why-chose-box-layout1 heading-layout1 pb-0 text-left full-text-head mb-0">
                        <h2> Why Anax Designs Services Expand Your Web Presence Through Digital Marketing and Outperform The Competition? </h2>
                        <!--<p class="item-title">We've proven that our SEO solutions <br class="displayOnSM">work again and again</p>-->
                        <p class="mb-0 text-justify">Our track record speaks for itself. We are a full-fledged digital marketing house based in the U.S.A. We offer SEO solutions along with a complete framework of digital solutions, such as:</p>
                        <p>Search engine optimization (SEO), pay-per-click (PPC) ads, Amazon shop optimization, conversion rate optimization (CRO), and other online marketing methods. Our packages are amicably priced to give every type of client the leverage they need in the industry. We also offer B2B firms and eCommerce businesses professional web design and development services.</p>
                        <!--<a href="#" class="btn-fill gradient-accent mg-t-20">Let’s Develop Your Business!<i class="fas fa-arrow-circle-right"></i></a>--></div>
                </div>
            </div>
        </div>
    </section>
    <section class="service-wrap-layout1">
        <div class="container">
            <div class="heading-layout1">
                <h2>What Makes Us <br class="displayOnSM"> Stand Out?</h2>
                <p>We deliver robust SEO protocols and digital marketing solutions to expand your web presence and reach. The goal is to get improved site rankings, search visibility, and increased organic traffic that maximizes your brand’s online presence.</p>
            </div>
            <div class="row">
                <div class="col-lg-6 col-md-6 col-12">
                    <div class="service-box-layout1">
                        <div class="item-icon dark-blue-div"> <i class="flaticon-digital-marketing"></i> </div>
                        <div class="item-content">
                            <h3 class="item-title"><a href="javascript:void()">SEO Services</a></h3>
                            <p>We are Search Engine Optimization specialists who work with search engine algorithms to obtain profitable metrics. These results are advantageous both in terms of visibility and online growth of the business, from setting goals to organizing a full long-term campaign.</p>
                        </div>
                    </div>
                </div>
                <div class="col-lg-6 col-md-6 col-12">
                    <div class="service-box-layout1">
                        <div class="item-icon purple-div"> <i class="flaticon-website"></i> </div>
                        <div class="item-content">
                            <!--<h3 class="item-title"><a href="javascript:void()">Advanced SEO Services</a></h3>-->
                            <h3 class="item-title"><a href="javascript:void()">Web Development</a></h3>
                            <p>Do you exist online? Almost 90% of customers search for their products online hence, it’s crucial to build your brand online. Anax Designs designs subtle and simple interface websites to ensure that your clients can get easy access to you. We examine and evaluate competitors' websites and develop a great website that helps you surpass your competition in expanding your consumer base.</p>
                        </div>
                    </div>
                </div>
                <div class="col-lg-6 col-md-6 col-12">
                    <div class="service-box-layout1">
                        <div class="item-icon orange-div"> <i class="flaticon-note"></i> </div>
                        <div class="item-content">
                            <h3 class="item-title"><a href="javascript:void()">Social Media Marketing</a></h3>
                            <p>Creating interactive technologies that promote the curation and sharing of ideas, content, and business information for our clients. A complete social media strategy is created to build a conversation around your brand and improve visibility.</p>
                        </div>
                    </div>
                </div>
                <div class="col-lg-6 col-md-6 col-12">
                    <div class="service-box-layout1">
                        <div class="item-icon blue-div" style="background: #f1b500;"> <i class="flaticon-note"></i> </div>
                        <div class="item-content">
                            <!--<h3 class="item-title"><a href="javascript:void()">Reputation Management</a></h3>-->
                            <h3 class="item-title"><a href="javascript:void()">Local Search Marketing</a></h3>
                            <p>Make the appearance of your brand on the map prominent using the efficient local search marketing service of Anax Designs. With local search marketing, you will be able to attract customers to your business in your desired geographical area. </p>
                        </div>
                    </div>
                </div>
                <div class="col-lg-6 col-md-6 col-12">
                    <div class="service-box-layout1">
                        <div class="item-icon purple-div"> <i class="flaticon-website"></i> </div>
                        <div class="item-content">
                            <!--<h3 class="item-title"><a href="javascript:void()">Advanced SEO Services</a></h3>-->
                            <h3 class="item-title"><a href="javascript:void()">Link-Building Services</a></h3>
                            <p>The link-building service of Anax Designs is provided by our SEO experts. This service will help you increase the inbound links in terms of quality and quantity. Our backlinking services will highlight your online presence and attract quality traffic to your business. </p>
                        </div>
                    </div>
                </div>
                <div class="col-lg-6 col-md-6 col-12">
                    <div class="service-box-layout1">
                        <div class="item-icon dark-blue-div"> <i class="flaticon-digital-marketing"></i> </div>
                        <div class="item-content">
                            <h3 class="item-title"><a href="javascript:void()">E-commerce Services</a></h3>
                            <p>Do you want to increase sales of your product? Anax Designs got you covered. Our e-commerce services will help you list your brand on top e-commerce platforms and will help you make your desired sales. The e-commerce services we are providing can boost the revenue of your business in a short period. </p>
                        </div>
                    </div>
                </div>
                <div class="col-lg-6 col-md-6 col-12 mx-auto">
                    <div class="service-box-layout1">
                        <div class="item-icon blue-div" style="background: #f1b500;"> <i class="flaticon-note"></i> </div>
                        <div class="item-content">
                            <!--<h3 class="item-title"><a href="javascript:void()">Reputation Management</a></h3>-->
                            <h3 class="item-title"><a href="javascript:void()">Logo Design</a></h3>
                            <p>As a digital marketing agency, we build a solid reputation for your brand through strong visuals, effective design, and impressive patterns. Our logo designing services encompass all design elements to build a positive narrative for your brand.</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <div class="grey-section testimonial-2">
        <div class="container">
            <div class="row">
                <div class="col-lg-4">
                    <div class="heading-layout1 text-left">
                        <h2>Things You Should Know - Digital Marketing Proof</h2>
                        <p>We offer complete Web-solutions that aim to deliver organic traffic, measurable visibility, sales, lead generation, optimized conversions, and ROI to your brand. We build a complete online presence through data-driven web development, internet marketing, Application development, and creative design. Here are a few recent examples:</p>
                        <a href="javascript:void(0)" onclick="$zopim.livechat.window.show()" class="get-started-blue float-left">Discuss Now</a> </div>
                </div>
                <div class="col-lg-8">
                    <div class="testimonial-caro owl-carousel">
                        <div class="item">
                            <div class="testimonial-inner"> <i class="fas fa-quote-right"></i>
                                <div class="testimonial-excerpt">
                                    <p>I can't believe I finally have a working digital presence. The team at Anax Designs created our social media platforms and calendars. I couldn't be happier after trying to work with four different digital houses that claimed to know what they were doing.</p>
                                </div>
                                <div class="testimonial-thumb"> <img width="80" height="80" src="{{asset('assets/seo-ip/images/046.jpg')}}" class="img-fluid rounded-circle wp-post-image" alt="" loading="lazy"> </div>
                                <div class="testimonial-info">
                                    <p><a href="#" class="client-name">Lauren Philips</a><span class="client-designation">eCommerce Business</span></p>
                                </div>
                            </div>
                        </div>
                        <div class="item">
                            <div class="testimonial-inner"> <i class="fas fa-quote-right"></i>
                                <div class="testimonial-excerpt">
                                    <p>Anax Designs certainly delivered on what they promised. Our web presence and brand visibility were close to negligible when we first began working with them. Today, our website shows up on the 1st page!</p>
                                </div>
                                <div class="testimonial-thumb"> <img width="80" height="80" src="{{asset('assets/seo-ip/images/031.jpg')}}" class="img-fluid rounded-circle wp-post-image" alt="" loading="lazy"> </div>
                                <div class="testimonial-info">
                                    <p><a href="#" class="client-name">Joseph Emmit</a><span class="client-designation">Real Estate</span></p>
                                </div>
                            </div>
                        </div>
                        <div class="item">
                            <div class="testimonial-inner"> <i class="fas fa-quote-right"></i>
                                <div class="testimonial-excerpt">
                                    <p>What impressed me the most about team Anax Designs was their responsiveness. We weren't sure how we were going to get local traffic and lead because they made it happen. It's no BS with these people!</p>
                                </div>
                                <div class="testimonial-thumb"> <img width="80" height="80" src="{{asset('assets/seo-ip/images/testi1.jpg')}}" class="img-fluid rounded-circle wp-post-image" alt="" loading="lazy"> </div>
                                <div class="testimonial-info">
                                    <p><a href="#" class="client-name">James McKire</a><span class="client-designation">Construction company</span></p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <section class="why-chose-wrap-layout1">
        <div class="container">
            <div class="row">
                <div class="col-12">
                    <div class="why-chose-box-layout1 heading-layout1 pb-0">
                        <!--<h2>Are You On The First <br class="displayOnSM">Page Of SERPs?</h2>-->
                        <h2>Looking Forward To See Your Business Growing?</h2>
                        <p style="max-width: 630px;">We won't let you lose critical leads by not showing up on the search engine results pages (SERPs) or any relevant platforms</p>
                    </div>
                </div>
            </div>
            <div class="row align-items-center">
                <div class="col-lg-6 col-12 order-lg-2">
                    <div class="why-chose-box-layout1 pb-0-mob pb-0 pt-0">
                        <div class="item-img"> <img loading="lazy" src="{{asset('assets/seo-ip/images/seo-3')}}.png" alt="image"> </div>
                    </div>
                </div>
                <div class="col-lg-6 col-12 order-lg-1">
                    <div class="why-chose-box-layout1 heading-layout1 pb-0 text-left full-text-head pt-0 mb-0 pt-add-onMob">
                        <p>Without a viable digital strategy, no brand can survive. We work on creating a memorable face for your brand through SEO, Social media management, and web development. These are essential components of any strategy for marketing products or services and increasing quality leads and sales.</p>
                        <h3 class="item-title h3">You Have Finally Found The Right Digital Marketing Platform For Your Start-Up </h3>
                        <p>Anax Designs is a complete Digital Marketing solution for small, medium, and large business operations. We strategize, build and execute contemporary designs to build brand reach and accessibility for you.</p>
                        <p>SEO tools are used to create algorithm-compliant accessibility and visibility for your brand on all search engines, social media platforms, and unconventional marketing avenues.</p>
                        <p class="mb-0">Our packages cover all the necessary bases that a brand needs to garner the attention of its target audience and convert leads. From determining the objectives to selecting the appropriate equipment, we manage all the details for you!</p>
                        <!--<a href="#" class="btn-fill gradient-accent mg-t-20">Let’s Develop Your Business!<i class="fas fa-arrow-circle-right"></i></a>--></div>
                </div>
            </div>
        </div>
    </section>
    <div class="pb-0 home-v2">
        <div class="container">
            <div class="heading-layout1" style=" padding-bottom: 30px;">
                <h2>Digital Case Study</h2> </div>
        </div>
        <div class="firstcs">
            <div class="container">
                <div class="row">
                    <div class="col-lg-6">
                        <div class="txtarea">
                            <!--<figure>--><img loading="lazy" src="{{asset('assets/seo-ip/images/all-logos-04.png')}}" alt="content-writing-services" title="Finest-content-writing">
                            <!--</figure>-->
                            <ul>
                                <li>
                                    <h5>MARKETING GOALS</h5>
                                    <p>Maintaining a SERP-visible website by using relevant keyword optimization protocols and creating a noticeable online presence.</p>
                                </li>
                                <li>
                                    <h5>SERVICE</h5>
                                    <p>Providing SEO, digital design, and marketing strategies.</p>
                                </li>
                                <li>
                                    <h5>STRATEGY</h5>
                                    <p>We planned, strategized, and built a complete digital framework around SEO protocols to boost online visibility.</p>
                                </li>
                                <!-- <li> <h5>KEYWORDS IN RANK</h5> <p>LTO Tapes California, Best Ultrium Media Drives California, Best Media Tapes California, Data Tape California, LTO Tapes California, Tape Media Drives & Cartridge</p> </li> -->
                            </ul>
                        </div>
                    </div>
                    <div class="col-lg-6">
                        <div class="figarea">
                            <ul>
                                <li>
                                    <figure> <img loading="lazy" src="{{asset('assets/seo-ip/images/icons-of-graph-01.png')}}"> </figure>
                                    <div class="tx">
                                        <h3>increase in contracted sales</h3> </div>
                                </li>
                                <li>
                                    <figure> <img loading="lazy" src="{{asset('assets/seo-ip/images/icons-of-graph-04.png')}}"> </figure>
                                    <div class="tx">
                                        <h3>targeted keywords in rank</h3> </div>
                                </li>
                                <li>
                                    <figure> <img loading="lazy" src="{{asset('assets/seo-ip/images/icons-of-graph-07.png')}}"> </figure>
                                    <div class="tx">
                                        <h3>increase in unique pageviews</h3> </div>
                                </li>
                            </ul>
                            <div class="single-test"> <span class="far fa-comment"></span>
                                <h4>"I haven't worried about my company’s online presence since the day we started working with Anax Designs. They get things done."</h4>
                                <h5>Dewey Andrew<span>Clouds Frontier</span></h5> </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="firstcs scndcs">
            <div class="container">
                <div class="row">
                    <div class="col-lg-6">
                        <div class="figarea">
                            <ul>
                                <li>
                                    <figure> <img loading="lazy" src="{{asset('assets/seo-ip/images/icons-of-graph-02.png')}}"> </figure>
                                    <div class="tx">
                                        <h3>increase in appointment bookings</h3> </div>
                                </li>
                                <li>
                                    <figure> <img loading="lazy" src="{{asset('assets/seo-ip/images/icons-of-graph-05.png')}}"> </figure>
                                    <div class="tx">
                                        <h3>targeted keywords in rank</h3> </div>
                                </li>
                                <li>
                                    <figure> <img loading="lazy" src="{{asset('assets/seo-ip/images/icons-of-graph-08.png')}}"> </figure>
                                    <div class="tx">
                                        <h3> increase in unique pageviews</h3> </div>
                                </li>
                            </ul>
                            <div class="single-test"> <span class="far fa-comment"></span>
                                <h4>"Super satisfied with the work Anax Designs did for my business. Sales have increased, our website gets inquiries every day, and we are showing up!"</h4>
                                <h5>Michael Ryan<span>DHA Filter</span></h5> </div>
                        </div>
                    </div>
                    <div class="col-lg-6">
                        <div class="txtarea">
                            <!--<figure>--><img loading="lazy" src="{{asset('assets/seo-ip/images/all-logos-06.png')}}">
                            <!--</figure>-->
                            <ul>
                                <li>
                                    <h5>MARKETING GOALS</h5>
                                    <p>Creating a high-quality presence online using SEO and digital marketing systems.</p>
                                </li>
                                <li>
                                    <h5>SERVICE</h5>
                                    <p>Built social media platforms with engaging content and an SEO Website.</p>
                                </li>
                                <li>
                                    <h5>STRATEGY</h5>
                                    <p>User-friendly designs were created by our Digital marketing experts to deliver SEO content on all digital profiles.</p>
                                </li>
                                <!-- <li> <h5>KEYWORDS IN RANK</h5> <p>LTO Tapes California, Best Ultrium Media Drives California, Best Media Tapes California, Data Tape California, LTO Tapes California, Tape Media Drives & Cartridge</p> </li> -->
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="firstcs scndcss">
            <div class="container">
                <div class="row">
                    <div class="col-lg-6">
                        <div class="txtarea">
                            <!--<figure>--><img loading="lazy" class="shineylogo" src="{{asset('assets/seo-ip/images/all-logos-05.png')}}" alt="content-writing-services" title="Finest-content-writing">
                            <!--</figure>-->
                            <ul>
                                <li>
                                    <h5>MARKETING GOALS</h5>
                                    <p>Increase organic traffic by using SEO content, and high-traffic keywords</p>
                                </li>
                                <li>
                                    <h5>SERVICE</h5>
                                    <p>Delivered an SEO-based system to optimize their website, social media content, and Pay-per-click strategies</p>
                                </li>
                                <li>
                                    <h5>STRATEGY</h5>
                                    <p>Increased visibility through industry-specific keyword optimization and social media posting schedules</p>
                                </li>
                            </ul>
                        </div>
                    </div>
                    <div class="col-lg-6">
                        <div class="figarea">
                            <ul>
                                <li>
                                    <figure> <img loading="lazy" src="{{asset('assets/seo-ip/images/icons-of-graph-03.png')}}"> </figure>
                                    <div class="tx">
                                        <h3> increase in contracted sales</h3> </div>
                                </li>
                                <li>
                                    <figure> <img loading="lazy" src="{{asset('assets/seo-ip/images/icons-of-graph-06.png')}}"> </figure>
                                    <div class="tx">
                                        <h3>targeted keywords in rank</h3> </div>
                                </li>
                                <li>
                                    <figure> <img loading="lazy" src="{{asset('assets/seo-ip/images/icons-of-graph-09.png')}}"> </figure>
                                    <div class="tx">
                                        <h3>increase in unique pageviews</h3> </div>
                                </li>
                            </ul>
                            <div class="single-test"> <span class="far fa-comment"></span>
                                <h4>"Finally! A digital marketing resource that has changed my company’s accessibility online. Very impressive work."</h4>
                                <h5>Steve Miller<span>Shiney Media Group</span></h5> </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <section class="why-chose-wrap-layout1 pb-0">
        <div class="container">
            <div class="row align-items-center">
                <div class="col-lg-12 col-12">
                    <div class="why-chose-box-layout1 pb-0 text-left heading-layout1 mb-0">
                        <h2 class="item-title">Not Sure Whether You Need the Assistance of a Digital Marketing Agency?</h2>
                        <p style="width: 100%;">Did you know that search engines account for 68 percent of all website traffic? Our digital marketing solutions weaponize the power of a robust online presence to create the reach your brand deserves.</p>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <div class="white-section contact-sec">
        <div class="container">
            <div class="row">
                <div class="col-lg-5">
                    <div class="heading-layout1 text-left">
                        <h2>How Does It Work?</h2>
                        <p>After you submit your information on our contact form, one of our digital experts will contact you to set up an introductory consultation.</p>
                        <p>During this discovery call, we'll talk about your goals and provide customized best practice suggestions that you can use right away.</p>
                        <p class="mb-0">We'll take what we learned during the call and design a plan to assist you in achieving your particular web design and presence goals while staying within your budget.</p>
                    </div>
                </div>
                <div class="col-lg-7">
                    <form id="contact_form" action="https://anaxdesigns.com/code/anax/signupSubmitAPI" method="POST">
                        <div class="row">
                            <div class="col-sm-6 plr-7">
                                <input type="text" id="name" name="name" placeholder="Enter Your Name" class="contact-textfield" required> </div>
                            <div class="col-sm-6 plr-7">
                                <input type="email" id="email" name="email" placeholder="Enter Email Here" class="contact-textfield" required> </div>
                            <div class="col-sm-6 plr-7">
                                <input type="text" id="phone" name="phone" placeholder="Phone Number" class="contact-textfield" required> </div>
                            <div class="col-sm-6 plr-7">
                                <select class="contact-textfield" name="pkg" id="contact_field">
                                    <option value="SEO">SEO</option>
                                    <option value="Logo Design">Logo Design</option>
                                    <option value="Website Design & Development">Website Design & Development</option>
                                    <option value="Digital Marketing">Digital Marketing</option>
                                    <option value="Animation">Animation</option>
                                    <option value="Website Maintenance">Website Maintenance</option>
                                    <option value="Mobile Application">Mobile Application</option>
                                </select>
                            </div>
                            <div class="col-12 plr-7">
                                <textarea id="message" name="message_discount" placeholder="Enter Message Here" class="contact-textarea" required></textarea>
                            </div>
                            <div class="col-12 plr-7">
                                <input type="submit" id="submit_contacts" value="Submit" class="contact-submit">
                                <input type="hidden" id="lead_area"  name="lead_area" value="" />
                                <input type="hidden" name="type" value="Seo LP">
                                <input type="hidden" id="lead_area_popup" name="price_he_saw" value="">
                                <input type="hidden" name="payment_url" id="payment_url" value="https://www.anaxdesigns.com/seo-lp/">
                                <input type="hidden" name="return_url" class="return_url" value="https://www.anaxdesigns.com/seo-lp/">
                                <input type="hidden" name="page_url" value="https://www.anaxdesigns.com/seo-lp/">
                            </div>
                        </div>
                        <div class="success-box" style="display:none">
                            <div class="alert alert-success">Congratulations. Your message has been sent successfully.</div>
                        </div>
                        <div class="error-box" style="display:none">
                            <div class="alert alert-warning">Error, please retry. Your message has not been sent.</div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
    <!-- Contact Info Area Start Here -->
    <!--<section class="contact-info-wrap-layout1">
        <div class="container">
            <div class="row align-items-center justify-content-center">
                <div class="col-md-4 col-12">
                    <div class="contact-info-box-layout1">
                        <div class="media media-none--md">
                            <div class="item-icon"> <i class="flaticon-call-answer"></i> </div>
                            <div class="media-body space-md">
                                <h3 class="item-title"><a href="tel:646 503 1963">646 503 1963</a></h3>
                                <div class="item-subtitle">Mon-Fri : 9.00 am - 6.00 pm</div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-md-4 col-12">
                    <div class="contact-info-box-layout1">
                        <div class="media media-none--md">
                            <div class="item-icon"> <i class="flaticon-mail"></i> </div>
                            <div class="media-body space-md">
                                <h3 class="item-title"><a href="mailto:info@anaxdesigns.com">info@anaxdesigns.com</a></h3>
                                <div class="item-subtitle">15 Hours Real Time Support</div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-md-4 col-12">
                    <div class="contact-info-box-layout1">
                        <div class="media media-none--md">
                            <div class="item-icon"> <i class="flaticon-maps-and-flags"></i> </div>
                            <div class="media-body space-md">
                                <h3 class="item-title">Mailing Address</h3>
                                <div class="item-subtitle">3 E Evergreen Road # 1009, New City, NY 10956</div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>-->
    <!-- Footer Area Start Here -->
    <!--<footer class="footer-wrap-layout1">
        <div class="footer-top-wrap-layout1">
            <div class="container">
                <div class="row">
                    <div class="col-lg-4">
                        <div class="footer-box-layout1">
                            <div class="footer-logo">
                                <a href="#"><img loading="lazy" src="assets/images/logo.png" alt="logo"></a>
                            </div>
                            <p>Generating leads is a time-sensitive process. Your audience needs clean aesthetics supported by a strong concept and a functional web presence. We understand this to create digital magic!</p>

                        </div>
                    </div>
                    <div class="col-lg-5">
                        <div class="row">
                            <div class="col-lg-6">
                                <div class="footer-box-layout1">
                                    <div class="footer-title">
                                        <h3>Marketing</h3> </div>
                                    <div class="footer-menu-box">
                                        <ul class="footer-menu-list">
                                            <li><a href="#">SEO</a></li>
                                            <li><a href="#">Social Media</a></li>
                                            <li><a href="#">Local Search Marketing</a></li>
                                            <li><a href="#">Link Building Services</a></li>
                                            <li><a href="#">E-Commerce Services</a></li>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg-6">
                                <div class="footer-box-layout1">
                                    <div class="footer-title">
                                        <h3>Website</h3> </div>
                                    <div class="footer-menu-box">
                                        <ul class="footer-menu-list">
                                            <li><a href="#">Website Development</a></li>
                                            <li><a href="#">Web Hosting</a></li>
                                            <li><a href="#">Content Writing</a></li>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-3">
                        <div class="footer-box-layout1">
                            <div class="footer-title">
                                <h3>Quick Links</h3> </div>
                            <div class="footer-menu-box">
                                <ul class="footer-menu-list">
                                    <li> <a href="#">anaxdesigns New York</a> </li>
                                    <li> <a href="#">anaxdesigns Texas</a> </li>
                                    <li> <a href="#">anaxdesigns California</a> </li>
                                    <li> <a href="#">anaxdesigns Florida</a> </li>

                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="footer-bottom-wrap-layout1" style="padding-left: 0; padding-right: 0;">
            <div class="container">
                <div class="row">
                    <div class="col-md-6">
                        <div class="copyright">Copyright © 2022 Anax Designs .
                            <br class="displayOnSM">All Rights Reserved.</div>
                    </div>
                    <div class="col-md-6">
                        <div class="footer-bottom-links"> <a href="https://www.anaxdesigns.com/terms-and-conditions/">Terms & Conditions</a> | <a href="https://www.anaxdesigns.com/privacy-policy/">Privacy Policy</a> </div>
                    </div>
                </div>
            </div>
        </div>
    </footer>
    <div id="header-search" class="header-search">
        <button type="button" class="close">×</button>
        <form class="header-search-form">
            <input type="search" value="" placeholder="Type here........" />
            <button type="submit" class="search-btn"> <i class="flaticon-magnifying-glass"></i> </button>
        </form>
    </div>
</div>-->

    <footer class="site-footer footer-sec clb-section-dark">
        <div class="page-container">
            <div class="widgets row">
                <div class="col-lg-3 col-md-3 col-sm-6">
                    <div class="theme-logo">
                        <a href="#"><img loading="lazy" srcset="{{asset('assets/seo-ip/images/logo.png')}}" src="{{asset('assets/seo-ip/images/logo.png')}}" class="main-logo svg-logo" alt="ANAX LOGO"></a>
                    </div>
                </div>
                <div class="col-lg-3 col-md-3 col-sm-6">
                    <ul>
                        <!--<li class="widget">
                            <h3 class="widget-title">Loactaion</h3>
                            <p>200 Continental Dr #3744, <br> Newark, DE 19713, USA</p>
                        </li>-->
                        <li class="widget">
                            <h3 class="widget-title">WORK INQUIRIES</h3>
                            <p>Interested in working with us?
                                <br class="vc_hidden-xs"> <b>sales@anaxdesigns.com</b></p>
                        </li>
                    </ul>
                </div>
                <div class="col-lg-3 col-md-3 col-sm-6">
                    <ul>
                        <li class="widget">
                            <h3 class="widget-title">PHONE NUMBER</h3>
                            <p>Contact with us?
                                <br class="vc_hidden-xs"> <b>(877) 908 8719</b></p>
                        </li>
                    </ul>
                </div>
                <div class="col-lg-3 col-md-3 col-sm-6  " >
                    <ul>
                        <li class="widget">
                            <p></p>
                            <figure><img loading="lazy" srcset="https://www.anaxdesigns.com/assets/images/card-img.png" src="https://www.anaxdesigns.com/assets/images/card-img.png"></figure>
                            <p></p>
                            <figure><img loading="lazy" srcset="https://www.anaxdesigns.com/assets/images/positivessl_trust.png" src="https://www.anaxdesigns.com/assets/images/positivessl_trust.png"></figure>
                        </li>
                    </ul>
                    <!--<div class="payment-sec">
                        <figure><img loading="lazy" srcset="https://www.anaxdesigns.com/assets/images/card-img.png" src="https://www.anaxdesigns.com/assets/images/card-img.png"></figure>
                    </div>
                    <div class="widget">
                        <h3 class="widget-title">Sign up for the newsletter</h3>
                        <div class="subscribe-form">
                                <input type="text" name="your-email" value="" size="40" placeholder="Name" />
                                <input type="email" name="your-email" value="" size="40" placeholder="Email address" />
                                <input type="tel" name="your-email" value="" size="40" placeholder="Phone" />
                                <select>
                                    <option>I AM INTERESTED IN</option>
                                    <option>I AM NOT INTERESTED IN</option>
                                </select>
                            <br>
                            <input type="submit" value="Sign Up" class="wpcf7-form-control wpcf7-submit" />
                        </div>
                    </div>--></div>
            </div>
        </div>
        <div class="site-info">
            <div class="page-container">
                <div class="site-info-holder">
                    <div class="left"> Copyright © 2022 Anaxdesigns.com </div>
                    <div class="right"> <a href="https://www.anaxdesigns.com/privacy-policy/">Privacy Policy</a> | <a href="https://www.anaxdesigns.com/terms-and-conditions/">Terms of Service</a> </div>
                </div>
            </div>
        </div>
    </footer>


    <div class="popupform-main-new-popup " style="display: none;">
        <div class="form-bg-box">
            <a href="javascript:;" class="close-btn ta-center">X</a>
            <div class="popup-main-box">
                <div class="pop-box-2-new-pop">
                    <!-- <h3>Fill This Form To Avail Special Discounts Of</h3>
                    <span>Up To 50%!</span>
                    -->
                    <img loading="lazy" src="assets/images/auto-pop-bg-2.png">
                </div>
                <div class="pop-form-new-popp ta-center-new-pop">

                    <h3>LIMITED TIME OFFER! <br> <span>SIGN UP NOW & AVAIL SPECIAL DISCOUNT </span></h3>

                    <!-- <p>Lorem ipsum dolor sit amet, consectetur adipiscing accumsan lacus vel facilisis. </p> -->
                    <div id="pop-form-new-popp" class="col-sm-12">
                        <form action="https://anaxdesigns.com/code/anax/signupSubmitAPI" method="POST">
                            <div class="form-popup-box">
                                <i class="fa fa-user" aria-hidden="true"></i>
                                <input onkeypress="return ((event.charCode >= 65 &amp;&amp; event.charCode <= 90) || (event.charCode >= 97 &amp;&amp; event.charCode <= 122) || (event.charCode == 32))" type="text" name="name" placeholder="Enter Name" required="">
                            </div>
                            <div class="form-popup-box">
                                <i class="fa fa-envelope" aria-hidden="true"></i>
                                <input type="email" name="email" placeholder="Enter Email" required="">
                            </div>
                            <div class="form-popup-box">
                                <i class="fa fa-phone" aria-hidden="true"></i>
                                <input onkeypress='return event.charCode >= 48 && event.charCode <= 57' minlength="10" maxlength="12"type="text" name="phone" placeholder="Enter Phone" required="">
                            </div>
                            <div class="form-popup-box">
                                <i class="fa fa-user" aria-hidden="true"></i>
                                <textarea name="message_discount" placeholder="Tell us about your project" required=""></textarea>
                            </div>
                            <!-- <div class="form-pera">
                                <p>Creating an Account means you are okay with our Terms of <span> service, privacy policy and our Notification Setting.</span></p>
                            </div> -->
                            <button type="submit">Submit
                                <input type="hidden" id="lead_area"  name="lead_area" value="" />
                                <input type="hidden" name="type" value="Seo LP">
                                <input type="hidden" id="pkg-name" name="pkg" value="Banner Form">
                                <input type="hidden" id="lead_area_popup" name="price_he_saw" value="">
                                <input type="hidden" name="payment_url" id="payment_url" value="https://www.anaxdesigns.com/seo-lp/">
                                <input type="hidden" name="return_url" class="return_url" value="https://www.anaxdesigns.com/seo-lp/">
                                <input type="hidden" name="page_url" value="/seo-lp/">
                            </button>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>


</div>


    <script src="{{asset('assets/seo-ip/js/jquery-3.6.0.min.js')}}"></script>
    <script src="{{asset('assets/seo-ip/js/plugins.js')}}"></script>
    <script src="{{asset('assets/seo-ip/js/popper.min.js')}}"></script>
    <script src="{{asset('assets/seo-ip/js/bootstrap.min.js')}}"></script>

    <script src="{{asset('assets/seo-ip/js/jquery.fancybox.min.js')}}"></script>
    <script src='https://www.google.com/recaptcha/api.js'></script>
    <script src="{{asset('assets/seo-ip/js/owl.carousel.min.js')}}"></script>
    <script src="{{asset('assets/seo-ip/js/validator.min.js')}}"></script>
    <script src="{{asset('assets/seo-ip/js/jquery.magnific-popup.min.js')}}assets/js/jquery.magnific-popup.min.js"></script>
    <script src="{{asset('assets/seo-ip/js/jquery.meanmenu.min.js')}}"></script>
    <script src="{{asset('assets/seo-ip/js/main.js')}}assets/js/main.js"></script>
    <script>
        $('.home-lap-mockup-slider').owlCarousel({
            items: 1,
            animateOut: 'fadeOut',
            loop: true,
            margin: 10,
            autoplay: true,
            autoplayTimeout: 3000,
            autoplayHoverPause: true
        });
        $('.home-mobile-mockup-slider').owlCarousel({
            items: 1,
            animateOut: 'fadeOut',
            loop: true,
            margin: 10,
            autoplay: true,
            autoplayTimeout: 3000,
            autoplayHoverPause: true
        });
        $('.testimonial-caro').owlCarousel({
            loop: true,
            margin: 15,
            autoplay: true,
            autoplayTimeout: 3000,
            autoplayHoverPause: true,
            responsiveClass: true,
            responsive: {
                0: {
                    items: 1
                },
                768: {
                    items: 2
                }
            }
        });
        $('.testimonial-caro2').owlCarousel({
            loop: true,
            items: 1,
            margin: 15,
            autoplay: true,
            autoplayTimeout: 3000,
            autoplayHoverPause: true,
            responsiveClass: true,
        });
    </script>

    <script>
        $(".signupformclose").click(function() {
            localStorage.setItem("signupForm", "seen");
            sessionStorage.setItem("signupForm", "seen");
            $(".homepageformoverlay").hide();
            $(".homepagesignupform").hide();
            signUpForm();
        });

        function closePopup() {
            $(document).find(".homepageformoverlay").hide();
            $(document).find(".homepagesignupform").hide();
        }

        $("#domainUrl").keyup(function() {
            let domainUrl = $(this).val();
            $(this).val(domainUrl.toLowerCase());
        });
    </script>
    <script>
        window.$zopim||(function(d,s){var z=$zopim=function(c){z._.push(c)},$=z.s=
            d.createElement(s),e=d.getElementsByTagName(s)[0];z.set=function(o){z.set.
        _.push(o)};z._=[];z.set._=[];$.async=!0;$.setAttribute('charset','utf-8');
            $.src='//v2.zopim.com/?5bVrNGJNkgZr37DlzItm8NoFhA7de7ei';z.t=+new Date;$.
                type='text/javascript';e.parentNode.insertBefore($,e)})(document,'script');
        $zopim( function() { });

        function setButtonURL() {
            $zopim.livechat.window.show();
        }
        function toggleChat() {
            $zopim.livechat.window.show();
        }

    </script>




    <script>
        $(document).on("click", ".popup-btn", function(e) {
            e.preventDefault();
            e.stopPropagation();
            var price = $(this).data('price'),
                pgname = $(this).data('pgname');
            $('#pop-form-new-popp #lead_area_popup').val(price);
            $('#pop-form-new-popp #pkg-name').val(pgname);
            $('.popupform-main-new-popup').addClass('active');
            $('body').addClass('o-hidden');
            $('.overlay-bg-new-popup').fadeIn(500);
            $('.close-btn').on('click', function() {
                $('.popupform-main-new-popup').removeClass('active');
                $('body').removeClass('o-hidden');
                $('.overlay-bg-new-popup').fadeOut(500);
            });
            $('.form-bg-box').click(function(e){
                e.stopPropagation();
            });
            $('.overlay-bg-new-popup').click(function() {
                $('.popupform-main-new-popup').removeClass('active');
                $('body').removeClass('o-hidden');
                $('.overlay-bg-new-popup').fadeOut(500);
            });
            $(document).click(function() {	$('.popupform-main-new-popup').removeClass('active');	$('body').removeClass('o-hidden');	$('.overlay-bg-new-popup').fadeOut(500);});
        });

    </script>




</body>

</html>
