@extends('layouts.app')
@section('page-title','Create Employee')

@push('css')
    <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
@endpush

@section('content')

    <div id="content" class="pmd-content admin section">
        <!-- Title -->
        <h1>@yield('page-title')</h1>
        <!-- End Title -->
        <!--breadcrumb start-->
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb pmd-breadcrumb">
                <li class="breadcrumb-item">
                    <a href="{{route('dashboard')}}">Dashboard</a>
                </li>
                <li class="breadcrumb-item">Employees</li>
                <li class="breadcrumb-item active" aria-current="page">@yield('page-title')</li>
            </ol>
        </nav>
        <!--breadcrumb end-->

        <div class="row">
            <div class="col-md-12">
                <div class="card pmd-card">
                    <form method="post" autocomplete="off" action="{{route('insert.user')}}" id="user_form" enctype="multipart/form-data">
                        @csrf
                        <div class="card-body">
                            <!-- Upload Picture -->
                            <div class="details-tab">
                                <h3 class="card-title mb-3">Profile Picture</h3>
                                <div data-provides="fileinput" class="fileinput fileinput-new">
                                    <div data-trigger="fileinput" class="fileinput-preview thumbnail img-fluid rounded-circle mb-0">
                                        <img src="{{ asset('themes/images/dummy.png') }}" width="200" alt="profile avatar">
                                    </div>
                                    <div class="action-button">
                                        <span class="btn btn-secondary pmd-btn-fab btn-sm pmd-btn-raised btn-file pmd-ripple-effect">
                                            <span class="fileinput-new"><i class="material-icons pmd-xs">add</i></span>
                                            <span class="fileinput-exists"><i class="material-icons pmd-xs">mode_edit</i></span>
                                            <input type="file" name="file">
                                        </span>
                                        <a data-dismiss="fileinput" class="btn btn-danger btn-sm pmd-btn-fab pmd-ripple-effect pmd-btn-raised btn-file fileinput-exists" href="javascript:void(0);"><i class="material-icons pmd-sm">close</i></a>
                                    </div>
                                </div>
                            </div>

                            <!-- Basic Information -->
                            <div class="details-tab">
                                <h3 class="card-title">Employee Information</h3>
                                <div class="row">
                                    <div class="col-12 col-sm-6 col-md-3">
                                        <div class="form-group pmd-textfield pmd-textfield-floating-label ">
                                            <label for="fn" class="col-form-label control-label">First Name</label>
                                            <input type="text" class="form-control" name="firstname"
                                               aria-describedby="emailHelp" id="fn" value="{{$data['firstname']??old('firstname')}}" required>
                                            @error('firstname')
                                            <span>
                                                <strong class="text-danger">{{$message}}</strong>
                                            </span>
                                            @enderror()
                                        </div>
                                    </div>
                                    <div class="col-12 col-sm-6 col-md-3">
                                        <div class="form-group pmd-textfield pmd-textfield-floating-label ">
                                            <label for="ln" class="col-form-label control-label">Last Name</label>
                                            <input type="text" class="form-control" name="lastname" id="ln"
                                                   aria-describedby="emailHelp" value="{{$data['lastname']??old('lastname')}}" required>
                                            @error('lastname')
                                            <span>
                                                <strong class="text-danger">{{$message}}</strong>
                                            </span>
                                            @enderror()
                                        </div>
                                    </div>
                                    <div class="col-12 col-sm-6 col-md-3">
                                        <div class="form-group pmd-textfield pmd-textfield-floating-label ">
                                            <label for="client_display_name" class="col-form-label control-label">Client Display Name</label>
                                            <input type="text" class="form-control" name="client_display_name"
                                                   aria-describedby="emailHelp"
                                                   value="{{old('client_display_name')}}" id="mn" required>
                                            @error('client_display_name')
                                            <span>
                                                <strong class="text-danger">{{$message}}</strong>
                                            </span>
                                            @enderror()
                                        </div>
                                    </div>
                                    <div class="col-12 col-sm-6 col-md-3">
                                        <div class="form-group pmd-textfield pmd-textfield-floating-label ">
                                            <label for="phone" class="col-form-label control-label">Phone</label>
                                            <input type="text" class="form-control" name="phone"
                                                   aria-describedby="emailHelp" id="phone" value="{{$data['phone']??old('phone')}}">
                                            @error('phone')
                                            <span>
                                                <strong class="text-danger">{{$message}}</strong>
                                            </span>
                                            @enderror()
                                        </div>
                                    </div>
                                    <div class="col-12 col-sm-6 col-md-3">
                                        <div class="form-group pmd-textfield pmd-textfield-floating-label ">
                                            <label for="personal-email" class="col-form-label control-label">Email</label>
                                            <input type="email" class="form-control" name="email" id="personal-email"
                                                   aria-describedby="emailHelp" value="{{$data['email']??old('email')}}" required>

                                            @error('email')
                                            <span>
                                                <strong class="text-danger">{{$message}}</strong>
                                            </span>
                                            @enderror()
                                        </div>
                                    </div>
                                    <div class="col-12 col-sm-6 col-md-2">
                                        <div class="form-group pmd-textfield pmd-textfield-floating-label">
                                            <label for="password" class="col-form-label control-label">Password</label>
                                            <input type="password" class="form-control" name="password"
                                                   aria-describedby="emailHelp" value="{{old('password')}}" required>
                                            @error('password')
                                            <span>
                                                <strong class="text-danger">{{$message}}</strong>
                                            </span>
                                            @enderror()
                                        </div>
                                    </div>
                                    <div class="col-12 col-sm-6 col-md-2">
                                        <label for="email" class="d-block title-label">Gender</label>
                                        <div class="custom-control custom-radio pmd-radio custom-control-inline">
                                            <input type="radio" id="male" name="gender" class="custom-control-input" value="Male" @if($data['gender']??'' == 'Male') checked @endif required>
                                            <label class="custom-control-label pmd-radio-ripple-effect" for="male">Male</label>
                                        </div>
                                        <div class="custom-control custom-radio pmd-radio custom-control-inline">
                                            <input type="radio" id="female" name="gender" class="custom-control-input" value="Female" @if($data['gender']??'' == 'Female') checked @endif>
                                            <label class="custom-control-label pmd-radio-ripple-effect" for="female">Female</label>
                                        </div>
                                    </div>
                                    <div class="col-12 col-sm-6 col-md-3">
                                        <label for="marital" class="d-block title-label">Marital Status</label>
                                        <div class="custom-control custom-radio pmd-radio custom-control-inline">
                                            <input type="radio" id="married" name="marital_status" class="custom-control-input" value="married" @if($data['married']??'' == 'Female') checked @endif required>
                                            <label class="custom-control-label pmd-radio-ripple-effect" for="married">Married</label>
                                        </div>
                                        <div class="custom-control custom-radio pmd-radio custom-control-inline">
                                            <input type="radio" id="unmarried" name="marital_status" class="custom-control-input" value="unmarried" @if($data['unmarried']??'' == 'Female') checked @endif>
                                            <label class="custom-control-label pmd-radio-ripple-effect" for="unmarried">Unmarried</label>
                                        </div>
                                    </div>

                                    <div class="col-12 col-sm-6 col-md-2">
                                        <div class="form-group pmd-textfield pmd-textfield-floating-label ">
                                            <label for="dob" class="col-form-label control-label">Date of Birth</label>
                                            <input type="text" class="form-control datepicker" name="dob" id="dob"
                                                   aria-describedby="emailHelp" required>
                                            @error('dob')
                                            <span>
                                                <strong class="text-danger">{{$message}}</strong>
                                            </span>
                                            @enderror()
                                        </div>
                                    </div>

                                    <div class="col-12 col-md-6 col-lg-6">
                                        <div class="form-group pmd-textfield pmd-textfield-floating-label">
                                            <label for="designation_id">Department</label>
                                            <select name="designation_id" id="designation_id" class="form-control " required>
                                                <option value="" hidden></option>
                                                @forelse($designations as $designation)
                                                    <option value="{{$designation->id}}" @if(($data['designation_id']??'') == $designation->id) selected @endif>{{$designation->title}}</option>
                                                @empty
                                                @endforelse
                                            </select>
                                            @error('designation')
                                            <span>
                                                <strong class="text-danger">{{$message}}</strong>
                                            </span>
                                            @enderror()
                                        </div>
                                    </div>

                                    <div class="col-12 col-md-6 col-lg-6">
                                        <div class="form-group pmd-textfield pmd-textfield-floating-label">
                                            <label for="job_title_id">Job Title</label>
                                            <select name="job_title_id" id="job_title_id" class="form-control" required>
                                                <option value="" hidden></option>
                                                @forelse($job_titles as $job_title)
                                                    <option value="{{$job_title->id}}" @if(($data['job_title_id']??'') == $job_title->id) selected @endif>{{$job_title->title}}</option>
                                                @empty
                                                @endforelse
                                            </select>
                                            @error('job_title')
                                            <span>
                                                <strong class="text-danger">{{$message}}</strong>
                                            </span>
                                            @enderror()
                                        </div>
                                    </div>

                                    <div class="col-12 col-md-6 col-lg-6">
                                        <div class="form-group pmd-textfield pmd-textfield-floating-label">
                                            <label for="datepickerjoin" class="col-form-label control-label">Join Date</label>
                                            <input type="text" class="form-control" name="join_date" min="0"
                                                   aria-describedby="emailHelp" id="datepickerjoin" value="{{$data['join_date']??old('join_date')}}" required>
                                            @error('join_date')
                                            <span><strong class="text-danger">{{$message}}</strong></span>
                                            @enderror()
                                        </div>
                                    </div>

                                    <div class="col-12 col-md-6 col-lg-6">
                                        <div class="form-group pmd-textfield pmd-textfield-floating-label ">
                                            <label for="role">Role Permission</label>
                                            <select name="role_id" id="role_id" class="form-control " required>
                                                <option value="" hidden></option>
                                                @forelse($roles as $role)
                                                    <option value="{{$role->id}}">{{$role->name}}</option>
                                                @empty
                                                @endforelse
                                            </select>
                                            @error('role_id')
                                            <span>
                                                <strong class="text-danger">{{$message}}</strong>
                                            </span>
                                            @enderror()
                                        </div>
                                    </div>

                                    <div class="col-12 col-md-6 col-lg-6">
                                        <div class="form-group  pmd-textfield pmd-textfield-floating-label">
                                            <label for="shift">Shift</label>
                                            <select name="shift_id" id="shift_id" class="form-control " required >
                                                <option value="" hidden> </option>
                                                @foreach($shifts as $shift)
                                                    @php
                                                        $start_time = date('g:i a',strtotime($shift->start_time));
                                                        $end_time = date('g:i a',strtotime($shift->end_time));
                                                    @endphp

                                                    <option value="{{$shift->id}}">
                                                        {{' '.$start_time.' to '.$end_time.' - '.$shift->title}}
                                                    </option>
                                                @endforeach
                                            </select>
                                            @error('shift_id')
                                            <span>
                                                <strong class="text-danger">{{$message}}</strong>
                                            </span>
                                            @enderror()
                                        </div>
                                    </div>

                                    <div class="col-12 col-md-6 col-lg-6">
                                        <div class="form-group  pmd-textfield pmd-textfield-floating-label">
                                            <label for="rank_id">Rank</label>
                                            <select name="rank_id" id="rank_id" class="form-control " required>
                                                <option value="" hidden></option>
                                                @forelse($ranks as $rank)
                                                    <option value="{{$rank->id}}">{{$rank->title}}</option>
                                                @empty
                                                @endforelse
                                            </select>
                                            @error('rank_id')
                                            <span>
                                                <strong class="text-danger">{{$message}}</strong>
                                            </span>
                                            @enderror()
                                        </div>
                                    </div>

                                    <div class="col-12 col-sm-6 col-lg-4">
                                        <label for="team_id">Team Head</label>
                                        <div class="custom-control custom-checkbox pmd-checkbox">
                                            <input class="custom-control-input" type="checkbox" name="is_head" value="1" id="is_head"/>
                                            <label class="custom-control-label" for="is_head">
                                                Is Team Head
                                            </label>
                                        </div>
                                    </div>

                                    <div class="col-12 col-md-6 col-lg-4">
                                        <div class="form-group">
                                            <label for="team_id">Team/Teams</label>
                                            <select name="team_id[]" id="team_id" class="form-control select-two" multiple required>
                                                <option value="" ></option>
                                                @forelse($teams as $team)
                                                    <option value="{{$team->id}}">{{$team->title}}</option>
                                                @empty
                                                @endforelse
                                            </select>
                                            @error('team_id')
                                            <span>
                                                <strong class="text-danger">{{$message}}</strong>
                                            </span>
                                            @enderror()
                                        </div>
                                    </div>

                                </div>
                                <div class="col-12 col-md-6 col-lg-4">
                                    <div class="form-group">
                                        <label for="team_id">Team/Teams</label>
                                        <select name="team_id[]" id="af" class="form-control select-two" multiple required>
                                            <option value="" ></option>
                                            @foreach($status as $st)
                                                <option value="{{$st->id}}">{{$st->title}}</option>
                                            @endforeach
                                        </select>
                                        @error('team_id')
                                        <span>
                                                <strong class="text-danger">{{$message}}</strong>
                                            </span>
                                        @enderror()
                                    </div>
                                </div>
                                <div class="col-12 col-md-6 col-lg-4">
                                    <div class="form-group">
                                        <label for="team_id">Team/Teams</label>
                                        <select name="packages[]" id="afs" class="form-control select-two" multiple required>
                                            <option value="" >Select Package</option>
                                            @foreach($status as $st)
                                                <option value="{{$st->id}}">{{$st->title}}</option>
                                            @endforeach
                                        </select>
                                        @error('packages')
                                        <span>
                                                <strong class="text-danger">{{$message}}</strong>
                                            </span>
                                        @enderror()
                                    </div>
                                </div>
                            </div>

                            <!-- Salary Details -->
                            <div class="details-tab">
                                <h3 class="card-title">Salary Details</h3>
                                <div class="row">
                                    <div class="col-12 col-sm-6 col-md-3">
                                        <div class="form-group pmd-textfield pmd-textfield-floating-label">
                                            <label for="total_salary" class="col-form-label control-label">Total Salary</label>
                                            <input type="number" class="form-control" name="total_salary" id="total_salary"
                                                   aria-describedby="emailHelp" value="{{old('total_salary')}}" min="0" required>
                                            @error('total_salary')
                                            <span>
                                                <strong class="text-danger">{{$message}}</strong>
                                            </span>
                                            @enderror()
                                        </div>
                                    </div>

                                   @foreach($allowances as $allowance)
                                        <div class="col-12 col-sm-6 col-md-3">
                                            <div class="form-group pmd-textfield pmd-textfield-floating-label">
                                                <label for="allowance_id_{{$allowance->id}}" class="col-form-label control-label">{{$allowance->title}}</label>
                                                <input type="hidden" name="allowance_ids[]"
                                                       value="{{$allowance->id}}">
                                                <input type="hidden" name="allowance_{{$allowance->id}}_percentage"
                                                       id="allowance_{{$allowance->id}}_percentage"
                                                       value="{{$allowance->percentage}}">
                                                <input type="number"
                                                       name="allowance_{{$allowance->id}}_amount"
                                                       class="form-control allowance sum_up" id="allowance_{{$allowance->id}}"
                                                       min="0">
                                            </div>
                                        </div>
                                    @endforeach

                                    <div class="col-12 col-sm-6 col-md-3">
                                        <div class="form-group pmd-textfield pmd-textfield-floating-label">
                                            <label for="basic_salary" class="col-form-label control-label">Basic Salary</label>
                                            <input type="number" class="form-control sum_up" name="basic_salary" id="basic_salary"
                                                   aria-describedby="emailHelp" value="{{old('basic_salary')}}" min="0" required>
                                            @error('basic_salary')
                                            <span>
                                                <strong class="text-danger">{{$message}}</strong>
                                            </span>
                                            @enderror()
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <!-- Other Details -->
                            <div class="details-tab">
                                <h3 class="card-title">Other Details</h3>
                                <div class="row">

                                    <div class="col-12 col-sm-6 col-md-4">
                                        <div class="form-group pmd-textfield pmd-textfield-floating-label ">
                                            <label for="bank" class="col-form-label control-label">Bank</label>
                                            <input type="text" class="form-control" name="bank"
                                                   aria-describedby="emailHelp" id="bank" value="{{old('bank')}}" required>
                                            @error('bank')
                                            <span>
                                                <strong class="text-danger">{{$message}}</strong>
                                            </span>
                                            @enderror()
                                        </div>
                                    </div>

                                    <div class="col-12 col-sm-6 col-md-4">
                                        <div class="form-group pmd-textfield pmd-textfield-floating-label ">
                                            <label for="account_title" class="col-form-label control-label">Account Title</label>
                                            <input type="text" class="form-control" name="account_title"
                                                   aria-describedby="emailHelp" id="account_title" value="{{old('account_title')}}" required>
                                            @error('account_title')
                                            <span>
                                                <strong class="text-danger">{{$message}}</strong>
                                            </span>
                                            @enderror()
                                        </div>
                                    </div>

                                    <div class="col-12 col-sm-6 col-md-4">
                                        <div class="form-group pmd-textfield pmd-textfield-floating-label ">
                                            <label for="account_number" class="col-form-label control-label">Account Number</label>
                                            <input type="text" class="form-control" name="account_number"
                                                   aria-describedby="emailHelp" id="account_number" value="{{old('account_number')}}" required>
                                            @error('account_number')
                                            <span>
                                                <strong class="text-danger">{{$message}}</strong>
                                            </span>
                                            @enderror()
                                        </div>
                                    </div>

                                    <div class="col-12 col-sm-6 col-md-3">
                                        <div class="form-group pmd-textfield pmd-textfield-floating-label">
                                            <label for="status_id">Status</label>
                                            <select name="status_id" id="status_id" class="form-control" required>
                                                <option value="" hidden></option>
                                                @foreach($status as $st)
                                                <option value="{{$st->id}}">{{$st->title}}</option>
                                                @endforeach
                                            </select>
                                            @error('status')
                                            <span>
                                                <strong class="text-danger">{{$message}}</strong>
                                            </span>
                                            @enderror()
                                        </div>
                                    </div>

                                </div>
                            </div>
                        </div>

                        <div class="card-footer pmd-card-border">
                            <button class="btn pmd-ripple-effect btn-primary pmd-btn-raised form_submit_btn" type="button">Create</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection

@push('js')
    <script src="{{asset('js/jquery-mask/src/jquery.mask.js')}}"></script>
    <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>

    <script>
        let global_sum = 0;
        $(document).ready(function () {
            $('#phone').mask("00000000000");
            $('.select-two').select2();
        });

        $('#is_head').on('click',function(){
            var is_head = ($(this).prop('checked'))
            if(is_head){
                $('#team_id').attr('multiple',true)
                $('#team_id').select2();
            }else{
                $('#team_id').removeAttr('multiple')
                $('#team_id').select2();
            }
        })

        $('#total_salary').on('keyup',function(){
            var total_salary = $(this).val()
            var basic_salary = total_salary
            var sum_up = 0
            $('.allowance').each(function(){
                var allowance = $(this).attr('id')
                var allowance_pct = $('#'+ allowance + '_percentage').val()
                var allowance_amount = ((total_salary/100)*allowance_pct)
                $(this).focus();
                $(this).val(allowance_amount);
                basic_salary -= allowance_amount
                sum_up += allowance_amount
            })
            $('#basic_salary').focus()
            $('#basic_salary').val(basic_salary)
            $(this).focus()
            global_sum = sum_up+basic_salary
        })


        $('.form_submit_btn').click(function(e){
            var temp = 0
            $('.sum_up').each(function(){
                temp += parseInt($(this).val())
            })
            if(global_sum != temp){
                Swal.fire('Invalid salary calculation. Please verify')
            }else{
                $('#user_form').submit()
            }
        })

        var dateToday = new Date();
        // Add start date date and time picker
        $('#datepickerjoin').datetimepicker({
            minDate: dateToday,
            format: 'DD-MM-YYYY'
        });

        $('.datepicker').datetimepicker({
            format: 'YYYY-MM-DD'
        });


    </script>
@endpush
