@extends('layouts.app')
@section('page-title','Update Employee')

@push('css')
    <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
@endpush

@section('content')

    <div id="content" class="pmd-content admin section">
        <!-- Title -->
        <h1 >@yield('page-title')</h1>
        <!-- End Title -->
        <!--breadcrum start-->
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb pmd-breadcrumb">
                <li class="breadcrumb-item">
                    <a href="{{route('dashboard')}}">Dashboard</a>
                </li>
                <li class="breadcrumb-item">Employees</li>
                <li class="breadcrumb-item active" aria-current="page">@yield('page-title')</li>
            </ol>
        </nav>
        <!--breadcrum end-->

        <div class="row">
            <div class="col-md-12">
                <div class="card pmd-card">
                    <form method="post" autocomplete="off" action="{{route('update.user')}}" id="user_form" enctype="multipart/form-data">
                        @csrf
                        <input type="hidden" name="id" value="{{base64_encode($user->id)}}">
                        <div class="card-body">
                            <!-- Upload Picture -->
                            <div class="details-tab">
                                <h3 class="card-title mb-3">Profile Picture</h3>
                                <div data-provides="fileinput" class="fileinput fileinput-new">
                                    <div data-trigger="fileinput" class="fileinput-preview thumbnail img-fluid rounded-circle mb-0">
                                        @if($user->gender == 'Male')
                                            <img alt="Profile-Pic" src="{{asset(isset($user->image) ? 'employees/images/'.$user->image : 'themes/images/dummy.png')}}" class="profile-pic rounded-circle pmd-z-depth-light-2-1 mr-md-4 mr-sm-0" height="200" width="200">
                                        @else
                                            <img alt="Profile-Pic" src="{{asset(isset($user->image) ? 'employees/images/'.$user->image : 'themes/images/dummy-female.png')}}" class="profile-pic rounded-circle pmd-z-depth-light-2-1 mr-md-4 mr-sm-0" height="200" width="200">
                                        @endif
                                    </div>
                                    <div class="action-button">
                                        <span class="btn btn-secondary pmd-btn-fab btn-sm pmd-btn-raised btn-file pmd-ripple-effect">
                                            <span class="fileinput-new"><i class="material-icons pmd-xs">add</i></span>
                                            <span class="fileinput-exists"><i class="material-icons pmd-xs">mode_edit</i></span>
                                            <input type="file" name="file">
                                        </span>
                                        <a data-dismiss="fileinput" class="btn btn-danger btn-sm pmd-btn-fab pmd-ripple-effect pmd-btn-raised btn-file fileinput-exists" href="javascript:void(0);"><i class="material-icons pmd-sm">close</i></a>
                                    </div>
                                </div>
                            </div>

                            <!-- Basic Information -->
                            <div class="details-tab">
                                <h3 class="card-title">Employee Information</h3>
                                <div class="row">
                                    <div class="col-12 col-sm-6 col-md-3">
                                        <div class="form-group pmd-textfield pmd-textfield-floating-label ">
                                            <label for="fn" class="col-form-label control-label">First Name</label>
                                            <input type="text" class="form-control" name="firstname"
                                                   aria-describedby="emailHelp" id="fn" value="{{$user->firstname ?? old('firstname')}}" required>
                                            @error('firstname')
                                            <span>
                                                <strong class="text-danger">{{$message}}</strong>
                                            </span>
                                            @enderror()
                                        </div>
                                    </div>
                                    <div class="col-12 col-sm-6 col-md-3">
                                        <div class="form-group pmd-textfield pmd-textfield-floating-label ">
                                            <label for="ln" class="col-form-label control-label">Last Name</label>
                                            <input type="text" class="form-control" name="lastname" id="ln"
                                                   aria-describedby="emailHelp" value="{{$user->lastname ?? old('lastname')}}">
                                            @error('lastname')
                                            <span>
                                                <strong class="text-danger">{{$message}}</strong>
                                            </span>
                                            @enderror()
                                        </div>
                                    </div>
                                    <div class="col-12 col-sm-6 col-md-3">
                                        <div class="form-group pmd-textfield pmd-textfield-floating-label ">
                                            <label for="client_display_name" class="col-form-label control-label">Client Display Name</label>
                                            <input type="text" class="form-control" name="client_display_name"
                                                   aria-describedby="emailHelp"
                                                   value="{{$user->client_display_name ?? old('client_display_name')}}" id="mn" >
                                            @error('client_display_name')
                                            <span>
                                                <strong class="text-danger">{{$message}}</strong>
                                            </span>
                                            @enderror()
                                        </div>
                                    </div>
                                    <div class="col-12 col-sm-6 col-md-3">
                                        <div class="form-group pmd-textfield pmd-textfield-floating-label ">
                                            <label for="phone" class="col-form-label control-label">Phone</label>
                                            <input type="text" class="form-control" name="phone"
                                                   aria-describedby="emailHelp" id="phone" value="{{$user->phone ?? old('phone')}}">
                                            @error('phone')
                                            <span>
                                                <strong class="text-danger">{{$message}}</strong>
                                            </span>
                                            @enderror()
                                        </div>
                                    </div>
                                    <div class="col-12 col-sm-6 col-md-3">
                                        <div class="form-group pmd-textfield pmd-textfield-floating-label ">
                                            <label for="personal-email" class="col-form-label control-label">Email</label>
                                            <input type="email" class="form-control" name="email" id="personal-email"
                                                   aria-describedby="emailHelp" value="{{$user->email ?? old('email')}}" >

                                            @error('email')
                                            <span>
                                                <strong class="text-danger">{{$message}}</strong>
                                            </span>
                                            @enderror()
                                        </div>
                                    </div>

                                    <div class="col-12 col-sm-6 col-md-3">
                                        <label for="email" class="d-block title-label">Gender</label>
                                        <div class="custom-control custom-radio pmd-radio custom-control-inline">
                                            <input type="radio" id="male" name="gender" class="custom-control-input" value="Male"
                                                   @if($user->gender == 'Male') checked @endif required>
                                            <label class="custom-control-label pmd-radio-ripple-effect" for="male">Male</label>
                                        </div>
                                        <div class="custom-control custom-radio pmd-radio custom-control-inline">
                                            <input type="radio" id="female" name="gender" class="custom-control-input" value="Female"
                                                   @if($user->gender == 'Female') checked @endif>
                                            <label class="custom-control-label pmd-radio-ripple-effect" for="female">Female</label>
                                        </div>
                                    </div>
                                    <div class="col-12 col-sm-6 col-md-3">
                                        <label for="marital" class="d-block title-label">Marital Status</label>
                                        <div class="custom-control custom-radio pmd-radio custom-control-inline">
                                            <input type="radio" id="married" name="marital_status" class="custom-control-input" value="Married"
                                                   @if($user->marital_status == 'Married') checked @endif required>
                                            <label class="custom-control-label pmd-radio-ripple-effect" for="married">Married</label>
                                        </div>
                                        <div class="custom-control custom-radio pmd-radio custom-control-inline">
                                            <input type="radio" id="unmarried" name="marital_status" class="custom-control-input" value="Unmarried"
                                                   @if($user->marital_status == 'Unmarried') checked @endif>
                                            <label class="custom-control-label pmd-radio-ripple-effect" for="unmarried">Unmarried</label>
                                        </div>
                                    </div>

                                    <div class="col-12 col-sm-6 col-md-3">
                                        <div class="form-group pmd-textfield pmd-textfield-floating-label ">
                                            <label for="dob" class="col-form-label control-label">Date of Birth</label>
                                            <input type="text" class="form-control datepicker" name="dob" id="dob" value="{{$user->dob ?? old('dob')}}"
                                                   aria-describedby="emailHelp" required>
                                            @error('dob')
                                            <span>
                                                <strong class="text-danger">{{$message}}</strong>
                                            </span>
                                            @enderror()
                                        </div>
                                    </div>

                                    <div class="col-12 col-md-6 col-lg-6">
                                        <div class="form-group pmd-textfield pmd-textfield-floating-label ">
                                            <label for="designation_id">Department</label>
                                            <select name="designation_id" id="designation_id" class="form-control" >
                                                <option value=""></option>
                                                @forelse($designations as $designation)
                                                    <option value="{{$designation->id}}" @if($user->designation_id == $designation->id) selected @endif>{{$designation->title}}</option>
                                                @empty
                                                @endforelse
                                            </select>
                                            @error('designation')
                                            <span>
                                                <strong class="text-danger">{{$message}}</strong>
                                            </span>
                                            @enderror()
                                        </div>
                                    </div>

                                    <div class="col-12 col-md-6 col-lg-6">
                                        <div class="form-group pmd-textfield pmd-textfield-floating-label ">
                                            <label for="job_title_id">Job Title</label>
                                            <select name="job_title_id" id="job_title_id" class="form-control" >
                                                <option value=""></option>
                                                @forelse($job_titles as $job_title)
                                                    <option value="{{$job_title->id}}" @if($user->job_title_id == $job_title->id) selected @endif >{{$job_title->title}}</option>
                                                @empty
                                                @endforelse
                                            </select>
                                            @error('job_title')
                                            <span>
                                                <strong class="text-danger">{{$message}}</strong>
                                            </span>
                                            @enderror()
                                        </div>
                                    </div>

                                    <div class="col-12 col-md-6 col-lg-6">
                                        <div class="form-group pmd-textfield pmd-textfield-floating-label ">
                                            <label for="join_date" class="col-form-label control-label">Join Date</label>
                                            <input type="text" class="form-control" name="join_date" min="0"
                                                   aria-describedby="emailHelp" id="join_date" value="{{ $user->join_date??'N/A' }}" required>
                                        </div>
                                    </div>

                                    <div class="col-12 col-md-6 col-lg-6">
                                        <div class="form-group pmd-textfield pmd-textfield-floating-label ">
                                            <label for="leaving_date" class="col-form-label control-label">Leave Date</label>
                                            <input type="text" class="form-control end_date" name="leaving_date" min="0"
                                                   aria-describedby="emailHelp" id="leaving_date" value="{{ $user->leaving_date??'' }}" >
                                        </div>
                                    </div>

                                    <div class="col-12 col-md-6 col-lg-12 reason" style="display: none">
                                        <div class="form-group pmd-textfield pmd-textfield-floating-label ">
                                            <label for="reason" class="col-form-label control-label">Reason</label>
                                            <textarea id="reason" class="form-control" rows="5" name="reason" >{{old('reason')}}</textarea>
                                            @error('reason')
                                            <span><strong class="text-danger">{{$message}}</strong></span>
                                            @enderror()
                                        </div>
                                    </div>

                                    <div class="col-12 col-md-6 col-lg-4">
                                        <div class="form-group pmd-textfield pmd-textfield-floating-label ">
                                            <label for="role">Role Permission</label>
                                            <select name="role_id" id="role_id" class="form-control" >
                                                <option value=""></option>
                                                @forelse($roles as $role)
                                                    <option value="{{$role->id}}"
                                                            @if($user->findRole) @if($user->findRole->name == $role->name) selected @endif @endif>{{$role->name}}</option>
                                                @empty
                                                @endforelse
                                            </select>
                                        </div>
                                    </div>

                                    <div class="col-12 col-md-6 col-lg-4">
                                        <div class="form-group pmd-textfield pmd-textfield-floating-label ">
                                            <label for="shift">Shift</label>
                                            <select name="shift_id" id="shift_id" class="form-control" >
                                                <option value=""></option>
                                                @foreach($shifts as $shift)
                                                    <?php
                                                    $start_time = '';
                                                    $end_time = '';
                                                    if(!empty($shift)){
                                                        $start_time = date('g:i a',strtotime($shift->start_time));
                                                        $end_time = date('g:i a',strtotime($shift->end_time));
                                                    }
                                                    ?>
                                                    <option value="{{$shift->id}}"
                                                            @if($user->findShift)
                                                            @if($user->findShift->title == $shift->title) selected @endif
                                                        @endif>{{$start_time.' to '.$end_time.' - '.$shift->title}}
                                                    </option>
                                                @endforeach
                                            </select>
                                        </div>
                                    </div>

                                    <div class="col-12 col-md-6 col-lg-4">
                                        <div class="form-group pmd-textfield pmd-textfield-floating-label ">
                                            <label for="rank">Rank</label>
                                            <select name="rank_id" id="rank_id" class="form-control" >
                                                <option value=""></option>
                                                @forelse($ranks as $rank)
                                                    <option value="{{$rank->id}}"
                                                            @if($user->findRank) @if($user->findRank->title == $rank->title) selected @endif @endif>{{$rank->title}}</option>
                                                @empty
                                                @endforelse
                                            </select>
                                        </div>
                                    </div>

                                    <div class="col-12 col-sm-6 col-md-3">
                                        <label for="is_head" class="d-block title-label">Is Team Head</label>
                                        <div class="custom-control  custom-control-inline">
                                            <input type="checkbox" id="is_head" name="is_head" class="custom-control-input"
                                                   @if($user->isTeamLead->count() > 0 ) checked @endif value="1">
                                            <label class="custom-control-label pmd-radio-ripple-effect" for="is_head">Yes</label>
                                        </div>
                                    </div>
                                    <div class="col-12 col-md-6 col-lg-4">
                                        <div class="form-group pmd-textfield pmd-textfield-floating-label ">
                                            <label for="team_id">Team</label>
                                            <select name="team_id[]" id="team_id" class="form-control select-two" @if($user->isTeamLead->count() > 0 ) multiple @endif required>
                                                <option value=""></option>
                                                @forelse($teams as $team)
                                                    @if(array_key_exists($team->id,$user_teams))
                                                        <option value="{{$team->id}}" selected >{{$team->title}}</option>
                                                    @else
                                                        <option value="{{$team->id}}" >{{$team->title}}</option>
                                                    @endif
                                                @empty
                                                @endforelse
                                            </select>
                                            @error('team_id')
                                            <span>
                                                <strong class="text-danger">{{$message}}</strong>
                                            </span>
                                            @enderror()
                                        </div>
                                    </div>

                                </div>
                            </div>

                            <!-- Salary Details -->
                            <div class="details-tab">
                                <h3 class="card-title">Salary Details</h3>
                                <div class="row">
                                    <div class="col-12 col-sm-6 col-md-3">
                                        <div class="form-group pmd-textfield pmd-textfield-floating-label">
                                            <label for="total_salary" class="col-form-label control-label">Total Salary</label>
                                            <input type="number" class="form-control" name="total_salary" id="total_salary"
                                                   aria-describedby="emailHelp" value="{{$user->total_salary ?? old('total_salary')}}" min="0" required>
                                            @error('total_salary')
                                            <span>
                                                <strong class="text-danger">{{$message}}</strong>
                                            </span>
                                            @enderror()
                                        </div>
                                    </div>

                                    @foreach($allowances as $allowance)
                                        @if(array_key_exists($allowance->id, $userAllowanceId))
                                            <div class="col-12 col-sm-6 col-md-3">
                                                <div class="form-group pmd-textfield pmd-textfield-floating-label">
                                                    <label for="allowance_id_{{$allowance->id}}" class="col-form-label control-label">{{$allowance->title}}</label>
                                                    <input type="hidden" name="allowance_ids[]"
                                                           value="{{$allowance->id}}">
                                                    <input type="hidden" name="allowance_{{$allowance->id}}_percentage"
                                                           id="allowance_{{$allowance->id}}_percentage"
                                                           value="{{$allowance->percentage}}">
                                                    <input type="number"
                                                           name="allowance_{{$allowance->id}}_amount"
                                                           class="form-control allowance" id="allowance_{{$allowance->id}}"
                                                           min="0" value="{{$userAllowanceId[$allowance->id]}}">
                                                </div>
                                            </div>
                                        @else
                                            <div class="col-12 col-sm-6 col-md-3">
                                                <div class="form-group pmd-textfield pmd-textfield-floating-label">
                                                    <label for="allowance_id_{{$allowance->id}}" class="col-form-label control-label">{{$allowance->title}}</label>
                                                    <input type="hidden" name="allowance_ids[]"
                                                           value="{{$allowance->id}}">
                                                    <input type="hidden" name="allowance_{{$allowance->id}}_percentage"
                                                           id="allowance_{{$allowance->id}}_percentage"
                                                           value="{{$allowance->percentage}}">
                                                    <input type="number"
                                                           name="allowance_{{$allowance->id}}_amount"
                                                           class="form-control allowance" id="allowance_{{$allowance->id}}"
                                                           min="0">
                                                </div>
                                            </div>
                                        @endif
                                    @endforeach
                                    <div class="col-12 col-sm-6 col-md-3">
                                        <div class="form-group pmd-textfield pmd-textfield-floating-label">
                                            <label for="basic_salary" class="col-form-label control-label">Basic Salary</label>
                                            <input type="number" class="form-control" name="basic_salary" id="basic_salary"
                                                   aria-describedby="emailHelp" value="{{$user->basic_salary ?? old('basic_salary')}}" min="0" required>
                                            @error('basic_salary')
                                            <span>
                                                <strong class="text-danger">{{$message}}</strong>
                                            </span>
                                            @enderror()
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <!-- Other Details -->
                            <div class="details-tab">
                                <h3 class="card-title">Other Details</h3>
                                <div class="row">

                                    <div class="col-12 col-sm-6 col-md-4">
                                        <div class="form-group pmd-textfield pmd-textfield-floating-label">
                                            <label for="bank" class="col-form-label control-label">Bank</label>
                                            <input type="text" class="form-control" name="bank"
                                                   aria-describedby="emailHelp" id="bank" value="{{$user->bank ?? old('bank')}}" required>
                                            @error('bank')
                                            <span>
                                                <strong class="text-danger">{{$message}}</strong>
                                            </span>
                                            @enderror()
                                        </div>
                                    </div>

                                    <div class="col-12 col-sm-6 col-md-4">
                                        <div class="form-group pmd-textfield pmd-textfield-floating-label">
                                            <label for="account_title" class="col-form-label control-label">Account Title</label>
                                            <input type="text" class="form-control" name="account_title"
                                                   aria-describedby="emailHelp" id="account_title" value="{{$user->account_title ?? old('account_title')}}" required>
                                            @error('account_title')
                                            <span>
                                                <strong class="text-danger">{{$message}}</strong>
                                            </span>
                                            @enderror()
                                        </div>
                                    </div>

                                    <div class="col-12 col-sm-6 col-md-4">
                                        <div class="form-group pmd-textfield pmd-textfield-floating-label">
                                            <label for="account_number" class="col-form-label control-label">Account Number</label>
                                            <input type="text" class="form-control" name="account_number"
                                                   aria-describedby="emailHelp" id="account_number" value="{{$user->account_number ?? old('account_number')}}" required>
                                            @error('account_number')
                                            <span>
                                                <strong class="text-danger">{{$message}}</strong>
                                            </span>
                                            @enderror()
                                        </div>
                                    </div>

                                    <div class="col-12 col-sm-6 col-md-3">
                                        <div class="form-group pmd-textfield pmd-textfield-floating-label">
                                            <label for="status_id">Status</label>
                                            <select name="status_id" id="status_id" class="form-control">
                                                <option></option>
                                                @foreach($status as $st)
                                                    <option value="{{$st->id}}" @if($user->status_id == $st->id) selected @endif>{{$st->title}}</option>
                                                @endforeach
                                            </select>
                                            @error('status')
                                            <span>
                                                <strong class="text-danger">{{$message}}</strong>
                                            </span>
                                            @enderror()
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="card-footer pmd-card-border">
                            <button class="btn pmd-ripple-effect btn-primary pmd-btn-raised" type="submit">Update</button>
                            <button class="btn pmd-ripple-effect btn-outline-secondary" type="reset">Reset</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection

@push('js')
    <script src="{{asset('js/jquery-mask/src/jquery.mask.js')}}"></script>
    <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
    <script>
        $(document).ready(function () {
            $('#phone').mask("00000000000");
            $('.select-two').select2();
        });

        $('#is_head').on('click',function(){
            var is_head = ($(this).prop('checked'))
            if(is_head){
                $('#team_id').attr('multiple',true)
                $('#team_id').select2();
            }else{
                $('#team_id').removeAttr('multiple')
                $('#team_id').select2();
            }
        })

        $('#total_salary').on('keyup',function(){

            var total_salary = $(this).val()
            var basic_salary = total_salary
            var sum_up = 0
            $('.allowance').each(function(){
                var allowance = $(this).attr('id')
                var allowance_pct = $('#'+ allowance + '_percentage').val()
                var allowance_amount = ((total_salary/100)*allowance_pct)
                $(this).focus();
                $(this).val(allowance_amount);
                basic_salary -= allowance_amount
                sum_up += allowance_amount
            })
            $('#basic_salary').focus()
            $('#basic_salary').val(basic_salary)
            $(this).focus()
            global_sum = sum_up+basic_salary
        })

        $('.form_submit_btn').click(function(e){
            var temp = 0
            $('.sum_up').each(function(){
                temp += parseInt($(this).val())
            })
            if(global_sum != temp){
                Swal.fire('Invalid salary calculation. Please verify')
            }else{
                $('#user_form').submit()
            }
        })

    </script>

    <script>
        var dateToday = new Date();

        // Add start date date and time picker
        $('#join_date').datetimepicker({
            // minDate: dateToday,
            format: 'DD-MM-YYYY'
        });

        $('#leaving_date').datetimepicker({
            minDate: dateToday,
            format: 'DD-MM-YYYY'
        });

        $(document).ready(function () {
            $('.end_date').click(function () {
                // alert('working');
                $('.reason').css({"display":"block"});
            });
        });
        $('.datepicker').datetimepicker({
            format: 'YYYY-MM-DD'
        });
    </script>
@endpush
