@extends('layouts.app')
@section('page-title','Leave Requests')

@push('css')
    <!-- DataTables -->
    <link rel="stylesheet" href="{{asset('plugins/datatables-bs4/css/dataTables.bootstrap4.min.css')}}">
    <link rel="stylesheet" href="{{asset('plugins/datatables-responsive/css/responsive.bootstrap4.min.css')}}">

@endpush

@section('content')
    <!--content area start-->
    <div id="content" class="pmd-content inner-page admin">
        <!-- Title -->
        <h1 id="employee" class="text-center">@yield('page-title')</h1>
        <!-- End Title -->
        <!--breadcrumb start-->
        <div class="row">
            <div class="col-md-12">
                <div class="float-right @cannot('create.leave-management') no-btn @endcan">
                    <nav aria-label="breadcrumb">
                        <ol class="breadcrumb pmd-breadcrumb mb-0">
                            <li class="breadcrumb-item">
                                <a href="{{route('dashboard')}}">Dashboard</a>
                            </li>
                            <li class="breadcrumb-item active" aria-current="page">@yield('page-title')</li>
                        </ol>
                    </nav>
                </div>
                <div>
                    @can('create.leave-management')
                        @if(auth()->id() !== 1)
                            <a href="{{route('create.leave-management')}}" class="btn btn-primary">Create</a>
                        @endif
                    @endcan
                </div>
            </div>
        </div>

        <!--breadcrumb end-->
        <div class="row pt-3">
            <div class="col-12">
                <div class="table-bg">
                    <section class="component-section" id="employee">
                        <table id='roles-datatable' class="table pmd-table table-hover pmd-table-card">
                            <thead class="thead-light">
                            <tr>
                                <th>S No.</th>
                                @if(auth()->id() === 1 || auth()->user()->role_id === 12)
                                    <th>Employee Name</th>
                                @endif
                                <th>Leave Type</th>
                                <th>Reason</th>
                                <th>From</th>
                                <th>To</th>
                                <th>Number of Leaves</th>
                                <th>Request Approval</th>
                                <th>Status</th>
                                <th>Actions</th>
                            </tr>
                            </thead>
                            <tbody>
                            @forelse($leave_requests as $leave_request)
                                <tr>
                                    <td>{{$leave_request->id }}</td>
                                    @if(auth()->id() === 1 || auth()->user()->role_id === 12)
                                        <td>{{$leave_request->findUser->name??"" }}</td>
                                    @endif
                                    <td>{{$leave_request->findLeaveType->title}}</td>
                                    <td>{{$leave_request->reason}}</td>
                                    <td>{{$leave_request->leave_from_date->format('D, jS F Y')}}</td>
                                    <td>{{$leave_request->leave_end_date->format('D, jS F Y')}}</td>
                                    <td>{{$leave_request->number_of_days}}</td>
                                    {{--Request Approval--}}
                                    <td class="req_approve_td">
                                        <?php
                                        $hr_approval = '';
                                        $tl_approval = '';
                                        if($leave_request->approved_by_hr) {
                                            $hr_approval = 'HR';
                                        }
                                        if($leave_request->approved_by_team_lead) {
                                            $tl_approval = 'TL';
                                        }
                                        ?>
                                        @if($hr_approval && $tl_approval)
                                            <span class="badge badge-success">{{ $hr_approval }}</span>
                                            <span class="badge badge-success">{{ $tl_approval }}</span>
                                        @elseif((!$hr_approval) && (!$tl_approval))
                                            <span class="badge badge-warning">{{ 'pending' }}</span>
                                            <div class="leave_approval_status">
                                                <button type="submit" class="btn btn-success btn-sm leave_approval_status_btn" data-action="approve" data-id="{{$leave_request->id}}">
                                                    <i class="fa fa-check" aria-hidden="true" title="Approve"></i>
                                                </button>

                                                <button type="submit" class="btn btn-danger btn-sm leave_approval_status_btn" data-action="reject" data-id="{{$leave_request->id}}">
                                                    <i class="fa fa-times" aria-hidden="true" title="Reject"></i>
                                                </button>
                                            </div>
                                        @elseif($hr_approval || $tl_approval)
                                            {{--If Logged in user is Super Admin or HR--}}
                                            <span class="badge badge-warning">{{ 'Pending' }}</span>
                                            @if(!$hr_approval && (auth()->user()->is_admin || auth()->user()->findRole->name == 'HR'))
                                                <div class="leave_approval_status">
                                                    <button type="submit" class="btn btn-success btn-sm leave_approval_status_btn" data-action="approve" data-id="{{$leave_request->id}}">
                                                        <i class="fa fa-check" aria-hidden="true" title="Approve"></i>
                                                    </button>

                                                    <button type="submit" class="btn btn-danger btn-sm leave_approval_status_btn" data-action="reject" data-id="{{$leave_request->id}}">
                                                        <i class="fa fa-times" aria-hidden="true" title="Reject"></i>
                                                    </button>
                                                </div>
                                            @else
                                                <span class="badge badge-success">{{ $hr_approval }}</span>
                                            @endif

                                            {{--If Logged in user is Team Lead--}}
                                            @if(!$tl_approval && !auth()->user()->isTeamLead->isEmpty())
                                                <div class="leave_approval_status">
                                                    <button type="submit" class="btn btn-success btn-sm leave_approval_status_btn" data-action="approve" data-id="{{$leave_request->id}}">
                                                        <i class="fa fa-check" aria-hidden="true" title="Approve"></i>
                                                    </button>

                                                    <button type="submit" class="btn btn-danger btn-sm leave_approval_status_btn" data-action="reject" data-id="{{$leave_request->id}}">
                                                        <i class="fa fa-times" aria-hidden="true" title="Reject"></i>
                                                    </button>
                                                </div>
                                            @else
                                                <span class="badge badge-success">{{ $tl_approval }}</span>
                                            @endif
                                        @endif
                                    </td>
                                    {{--Status--}}
                                    <td>
                                        @if($leave_request->status == 'Rejected')
                                            <span class="badge badge-danger">{{'Rejected'}}</span>
                                        @elseif($leave_request->status == 'Approved')
                                            <span class="badge badge-success">{{'Approved'}}</span>
                                        @else
                                            <span class="badge badge-warning">{{'Pending'}}</span>
                                        @endif
                                    </td>
                                    <td class="d-flex">
                                        @if(($leave_request->status == 'Pending' && $leave_request->user_id == auth()->id()) || auth()->id() == 1)
                                            <div class="btn-group">
                                                @can('edit.leave-management')
                                                    <a class="btn btn-primary btn-style" href="{{route('edit.leave-management',base64_encode($leave_request->id))}}" title="Edit"><i class="fa fa-edit"></i> </a>
                                                @endcan
                                                @can('delete.leave-management')
                                                    <button class="btn btn-danger delete-btn" data-id="{{base64_encode($leave_request->id)}}" title="Delete"><i class="fa fa-trash"></i> </button>
                                                @endcan
                                            </div>
                    @endif
                </div>
                </tr>
                @empty
                    @if(auth()->id() === 1 || (isset(auth()->user()->findRole->name) && auth()->user()->findRole->name == 'HR'))
                        <tr>
                            <td colspan="10" class="text-center">No Requests Made</td>
                        </tr>
                    @else
                        <tr>
                            <td colspan="9" class="text-center">No Requests Made</td>
                        </tr>
                        @endif
                        @endforelse
                        </tbody>
                        </table>
                        </section>
                </div>
            </div>
        </div>

</div>
<!-- content area end -->
@endsection

@push('js')
<script>
$(document).ready( function () {
    $('#roles-datatable').DataTable({
        "order": [[ 0, "desc" ]]
    });
});

$(document).on('click','.delete-btn',function(){
    var id = $(this).attr('data-id');

    Swal.fire({
        title: 'Are you sure?',
        text: "You won't be able to revert this!",
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#3085d6',
        cancelButtonColor: '#d33',
        confirmButtonText: 'Yes, delete it!'
    }).then((result) => {
        if (result.isConfirmed) {
            $.ajax({
                url: '{{URL::to('site/leave-management/delete')}}' +"/"+ id,
                type: 'get',
                success: function(response){
                    Swal.fire(
                        'Deleted!',
                        response,
                        'success'
                    );
                    location.reload();
                }
            });
        }
    });
});

$(document).on('click','.leave_approval_status_btn',function(){
    var action = $(this).attr('data-action');
    var id = $(this).attr('data-id');
    var $this = $(this);

    Swal.fire({
        title: 'Are you sure?',
        text: "You want to "+action+" this request?",
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#3085d6',
        cancelButtonColor: '#d33',
        confirmButtonText: 'Yes!'
    }).then((result) => {
        if (result.isConfirmed) {
            $.ajax({
                url: '{{URL::to('site/leave-management/update-hr-status')}}',
                type: 'POST',
                data: {
                    'action':action,
                    'id': id,
                },
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                },
                success: function(response){
                    if(response.error) {
                        Swal.fire(
                            response.message,
                            '',
                            'error'
                        );
                    }else {
                        Swal.fire(
                            response.message,
                            '',
                            'success'
                        );
                        $this.parent('.leave_approval_status').hide();

                        var res_by = '';
                        if(response.action == 'approved_by_hr') {
                            res_by = 'HR';
                        }else if(response.action == 'approved_by_team_lead') {
                            res_by = 'TL';
                        }
                        $this.parent('td').html('<span class="badge badge-success">'+res_by+'</span>');
                    }
                }
            });
        }
    });
});
</script>
@endpush
