@extends('layouts.app')
@section('page-title','Edit Loan Request')

@push('css')
    <link href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-datepicker/1.2.0/css/datepicker.min.css" rel="stylesheet">
@endpush

@section('content')

    <div id="content" class="pmd-content admin section">
        <!-- Title -->
        <h1>@yield('page-title')</h1>
        <!-- End Title -->
        <!--breadcrumb start-->
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb pmd-breadcrumb">
                <li class="breadcrumb-item">
                    <a href="{{route('dashboard')}}">Dashboard</a>
                </li>
                <li class="breadcrumb-item">Loans</li>
                <li class="breadcrumb-item active" aria-current="page">@yield('page-title')</li>
            </ol>
        </nav>
        <!--breadcrumb end-->

        <div class="row">
            <div class="col-md-12">
                <div class="card pmd-card">
                    {{--Details Tab--}}
                    <div class="row">
                        <div class="col-md-12">
{{--                            <div class="card pmd-card">--}}
                                <h3 class="mt-2">Loan Request Details</h3>
                                <div class="row mb-2">
                                    <div class="col-md-3 col-sm-6">
                                        Requested By : <b>{{$loan->findUser->name??''}}</b>
                                    </div>

                                    <div class="col-md-3 col-sm-6">
                                        Requested Amount : <b>{{$loan->amount_requested}}</b>
                                    </div>

                                    <div class="col-md-3 col-sm-6">
                                        Request Date : <b>{{\Carbon\Carbon::make($loan->created_at)->format('m-d-Y')}}</b>
                                    </div>

                                    <div class="col-md-12 col-sm-12">
                                        Description : <b>{{unserialize($loan->description)}}</b>
                                    </div>
                                </div>
{{--                            </div>--}}
                        </div>
                    </div>
                    <hr>

                    <form method="post" autocomplete="off" action="{{route('admin.update.loan')}}" enctype="multipart/form-data">
                        @csrf
                        <input type="hidden" name="id" value="{{$loan->id}}">
                        <div class="card-body">

                            <div class="details-tab">
                                <div class="row">
                                    <div class="offset-sm-3 offset-md-3 col-12 col-sm-6 col-md-6">
                                        <div class="form-group pmd-textfield pmd-textfield-floating-label ">
                                            <label for="amount_accepted" class="col-form-label control-label">Amount Approved</label>
                                            <input type="number" class="form-control" name="amount_accepted"
                                                   aria-describedby="emailHelp" id="amount_accepted" value="{{$loan->amount_accepted??old('amount_accepted')}}">
                                            @error('amount_accepted')
                                            <span><strong class="text-danger">{{$message}}</strong></span>
                                            @enderror()
                                        </div>
                                    </div>
                                </div>

                                <div class="row">
                                    <div class="offset-sm-3 offset-md-3 col-12 col-sm-6 col-md-6">
                                        <div class="form-group pmd-textfield pmd-textfield-floating-label">
                                            <label for="number_of_installments_total" class="col-form-label control-label">No. of Installments</label>
                                            <input type="number" class="form-control" name="number_of_installments_total" min="1"
                                                   aria-describedby="emailHelp" id="number_of_installments_total" value="{{$loan->number_of_installments_total??old('number_of_installments_total')}}">
                                            @error('number_of_installments_total')
                                            <span><strong class="text-danger">{{$message}}</strong></span>
                                            @enderror()
                                            <p><small>Number of months required to return loan</small></p>
                                        </div>
                                    </div>
                                </div>

                                <div class="row">
                                    <div class="offset-sm-3 offset-md-3 col-12 col-sm-6 col-md-6">
                                        <div class="form-group">
                                            <label for="disbursement_date" class="col-form-label control-label">Disbursement Date</label>
                                            <input type="text" class="form-control datepicker" name="disbursement_date" min="0"
                                                   aria-describedby="emailHelp" id="disbursement_date" value="">
                                            @error('disbursement_date')
                                            <span><strong class="text-danger">{{$message}}</strong></span>
                                            @enderror()
                                        </div>
                                    </div>
                                </div>

                                <div class="row">
                                    <div class="offset-sm-3 offset-md-3 col-12 col-sm-6 col-md-6">
                                        <div class="form-group">
                                            <label for="" class="col-form-label control-label">Loan Deduction Month/Year</label>
                                            <div class="row">
                                                <div class="col-md-6">
                                                    <select name="deduction_month" id="deduction_month" class="form-control">
                                                        <option value="">Select Month</option>
                                                        <option value="01" @if(isset($loan_deduction_month[0]) && $loan_deduction_month[0] == '01') selected @endif>January</option>
                                                        <option value="02" @if(isset($loan_deduction_month[0]) && $loan_deduction_month[0] == '02') selected @endif>February</option>
                                                        <option value="03" @if(isset($loan_deduction_month[0]) && $loan_deduction_month[0] == '03') selected @endif>March</option>
                                                        <option value="04" @if(isset($loan_deduction_month[0]) && $loan_deduction_month[0] == '04') selected @endif>April</option>
                                                        <option value="05" @if(isset($loan_deduction_month[0]) && $loan_deduction_month[0] == '05') selected @endif>May</option>
                                                        <option value="06" @if(isset($loan_deduction_month[0]) && $loan_deduction_month[0] == '06') selected @endif>June</option>
                                                        <option value="07" @if(isset($loan_deduction_month[0]) && $loan_deduction_month[0] == '07') selected @endif>July</option>
                                                        <option value="08" @if(isset($loan_deduction_month[0]) && $loan_deduction_month[0] == '08') selected @endif>August</option>
                                                        <option value="09" @if(isset($loan_deduction_month[0]) && $loan_deduction_month[0] == '09') selected @endif>September</option>
                                                        <option value="10" @if(isset($loan_deduction_month[0]) && $loan_deduction_month[0] == '10') selected @endif>October</option>
                                                        <option value="11" @if(isset($loan_deduction_month[0]) && $loan_deduction_month[0] == '11') selected @endif>November</option>
                                                        <option value="12" @if(isset($loan_deduction_month[0]) && $loan_deduction_month[0] == '12') selected @endif>December</option>
                                                    </select>
                                                </div>
                                                <div class="col-md-6">
                                                    <select name="deduction_year" id="deduction_year" class="form-control">
                                                        <option value="">Select Year</option>
                                                        <option value="{{now()->format('Y')}}" @if(isset($loan_deduction_month[1]) && $loan_deduction_month[1] == (now()->format('Y'))) selected @endif>{{now()->format('Y')}}</option>
                                                        <option value="{{now()->format('Y') + 1}}" @if(isset($loan_deduction_month[1]) && $loan_deduction_month[1] == (now()->format('Y') + 1)) selected @endif>{{now()->format('Y') + 1}}</option>
                                                    </select>
                                                </div>
                                            </div>
                                            @error('deduction_month')
                                            <span><strong class="text-danger">{{$message}}</strong></span>
                                            @enderror()
                                            @error('deduction_year')
                                            <br>
                                            <span><strong class="text-danger">{{$message}}</strong></span>
                                            @enderror()
                                        </div>
                                    </div>
                                </div>

                                <div class="offset-sm-3 offset-md-3 col-12 col-sm-6 col-md-6">
                                    <div class="form-group pmd-textfield pmd-textfield-floating-label ">
                                        <label for="status" class="col-form-label control-label">Status</label>
                                        <select name="status" id="status" class="form-control" required>
                                        {{--<option value="Pending"  @if($loan->status == 'Pending')  selected @endif>Pending</option>--}}
                                            <option value="Accepted" @if($loan->status == 'Accepted') selected @endif>Accept</option>
                                            <option value="Rejected" @if($loan->status == 'Rejected') selected @endif>Reject</option>
                                            <option value="Disbursed" @if($loan->status == 'Disbursed') selected @endif>Disbursed</option>
                                            <option value="In-Process" @if($loan->status == 'In-Process') selected @endif>In-Process</option>
                                            <option value="Returned" @if($loan->status == 'Returned') selected @endif>Returned</option>
                                        </select>
                                        @error('status')
                                        <span><strong class="text-danger">{{$message}}</strong></span>
                                        @enderror()
                                    </div>
                                </div>

                            </div>
                        </div>

                        <div class="card-footer pmd-card-border">
                            <button class="btn pmd-ripple-effect btn-primary pmd-btn-raised" type="submit">Update</button>
{{--                            <button class="btn pmd-ripple-effect btn-outline-secondary" type="reset">Reset</button>--}}
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection

@push('js')
    <script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-datepicker/1.2.0/js/bootstrap-datepicker.min.js"></script>
    <script>
        $(document).ready(function () {
            // Add start date date and time picker
            $('#disbursement_date').datetimepicker({
                @if($loan->disbursement_date)
                defaultDate: new Date('{{\Carbon\Carbon::make($loan->disbursement_date)->format('m-d-Y')}}'),
                @endif
                format: 'DD-MM-YYYY',
            });
        })
    </script>
@endpush
