@extends('layouts.app')
@section('page-title','Project Status')

@push('css')
    <!-- DataTables -->
    <link rel="stylesheet" href="{{asset('plugins/datatables-bs4/css/dataTables.bootstrap4.min.css')}}">
    <link rel="stylesheet" href="{{asset('plugins/datatables-responsive/css/responsive.bootstrap4.min.css')}}">
    <link rel="stylesheet" href="https://cdn.datatables.net/1.12.1/css/jquery.dataTables.min.css">

    <style>
        .change-position{
            cursor: pointer;
        }
    </style>

@endpush

@section('content')
    <!--content area start-->
    <div id="content" class="pmd-content inner-page admin">
        <!-- Title -->
        <h1 id="employee" class="text-center">@yield('page-title')</h1>
        <!-- End Title -->
        <!--breadcrumb start-->
        <div class="float-right @cannot('create.project-status') no-btn @endcan">
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb pmd-breadcrumb mb-0">
                    <li class="breadcrumb-item">
                        <a href="{{route('dashboard')}}">Dashboard</a>
                    </li>
                    <li class="breadcrumb-item active" aria-current="page">@yield('page-title')</li>
                </ol>
            </nav>
        </div>

        <div>
            @can('create.project-status')
                <a href="{{route('create.project-status')}}" class="btn btn-primary">Create</a>
            @endcan
        </div>

        <!--breadcrumb end-->
        <div class="row pt-3">
            <div class="col-12">
                <div class="table-bg">
                    <div id="accordion">
                        @foreach($data as $key => $datum)
                            <div class="card">
                                <div class="card-header" id="heading{{$datum[0]}}">
                                    <h5 class="mb-0">
                                        <button class="btn btn-link" data-toggle="collapse" data-target="#collapse{{$datum[0]}}" aria-expanded="true" aria-controls="collapse{{$datum[0]}}">
                                            {{$key}}
                                        </button>
                                    </h5>
                                </div>

                                <div id="collapse{{$datum[0]}}" class="collapse" aria-labelledby="heading{{$datum[0]}}" data-parent="#accordion">
                                    <div class="card-body">
                                        <table class="table pmd-table table-hover pmd-table-card datatable-project" id="TABLE_{{$datum[0]}}">
                                            <thead class="thead-light">
                                            <tr>
                                                <th>S No.</th>
                                                <th>Title</th>
                                                <th>Project Type</th>
                                                <th>Sort Order</th>
                                                <th>Status</th>
                                                <th>Actions</th>
                                            </tr>
                                            </thead>
                                            <tbody>
                                            @php $i = 1; @endphp
                                            @forelse($datum[1] as $status)
                                                <tr>
                                                    <td>{{ $i++ }}</td>
                                                    <td>{{$status->title}}</td>
                                                    <td>{{$status->findType->title??""}}</td>
                                                    <td>
                                                        <span class="badge badge-warning" >Sort:
                                                            <b size="4">{{$status->sort_order}}</b>
                                                        </span>
                                                        <i class="fas fa-edit change-position" data-type="{{$status->project_type_id}}" data-id="{{$status->id}}" data-sort="{{$status->sort_order}}"></i></td>
                                                    <td>
                                                        @if($status->status == 1)
                                                            <span class="badge badge-success">Active</span>
                                                        @else
                                                            <span class="badge badge-danger">In-Active</span>
                                                        @endif
                                                    </td>
                                                    <td>
                                                        <div class="btn-group">
                                                            @can('edit.project-status')
                                                                <a class="btn btn-primary btn-style" href="{{route('edit.project-status',base64_encode($status->id))}}" title="Edit"><i class="fa fa-edit"></i> </a>
                                                            @endcan
                                                            @can('delete.project-status')
                                                                <button class="btn btn-danger delete-btn" data-id="{{base64_encode($status->id)}}" title="Delete"><i class="fa fa-trash"></i> </button>
                                                            @endcan
                                                        </div>
                                                    </td>
                                                </tr>
                                            @empty
                                                <tr>
                                                    <td colspan="5" class="text-center">No Project Status Available</td>
                                                </tr>
                                            @endforelse
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        @endforeach
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- content area end -->
@endsection

@push('js')
    <script>

        $(document).ready(function() {
            $("table[id^='TABLE']").DataTable();
        } );

        $(document).on('click','.delete-btn',function(){
            var id = $(this).attr('data-id');

            Swal.fire({
                title: 'Are you sure?',
                text: "You won't be able to revert this!",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: 'Yes, delete it!'
            }).then((result) => {
                if (result.isConfirmed) {
                    $.ajax({
                        url: '{{URL::to('site/project-status/delete')}}' +"/"+ id,
                        type: 'get',
                        success: function(response){
                            Swal.fire(
                                'Deleted!',
                                 response,
                                'success'
                            );
                            location.reload();
                        }
                    });
                }
            });

        });

        $(document).on('click','.change-position',function (e) {
            var id = $(this).attr('data-id');
            var sort = $(this).attr('data-sort');
            var project_type_id = $(this).attr('data-type');
            Swal.fire({
                title: '<strong>Update Position</strong>',
                html:
                    ' <form role="form" action="{{route('status.sort.position')}}" id="position-form" method="post" style="width: 100%">'+
                    '@csrf
                        <div class="form-group col-md-12"><input type="number" class="form-control" id="position" name="position" required value="'+sort+'" placeholder="Enter Position Number"><input type="hidden" name="id" value="'+id+'"><input type="hidden" name="project_type_id" value="'+project_type_id+'"></div>'+
                    '</form>',
                showCloseButton: true,
                confirmButtonText: 'Upload',
                preConfirm: () => {
                    if (document.getElementById('position').value) {
                        // Handle return value
                    } else {
                        Swal.showValidationMessage('Position number is missing')
                    }
                }
            })
                .then((result) => {
                    if (result.isConfirmed)
                    {
                        $('#position-form').submit();
                    }
                })
        })
    </script>
@endpush
