@extends('team-work.layout.master')

@section('project-type-title', $project_type->title ? ($project_type->title." Projects") : "")

@section('content')
    <section id="content-wrapper">
        <div class="row">
            <div class="col-lg-12">
                <div class="tab-content">
                    <div class="tab-pane" id="tabs-1" role="tabpanel">
                        <p>First Panel</p>
                    </div>
                    <div class="tab-pane active" id="tabs-2" role="tabpanel">

                        <div class="row-coloumns">
                            @foreach($project_status as $status)
                                <div class="col-md-4">
                                    <div class="column-card">
                                        <div class="coloumn-head">
                                            <div class="dropdown">
                                                <a href="javascript:;">{{$status->title}}</a>
                                                <i class="fas fa-ellipsis-h"
                                                   data-toggle="dropdown"
                                                   aria-haspopup="true"
                                                   aria-expanded="false"></i>
                                                <div class="dropdown-menu" aria-labelledby="dropdownMenuButton">
                                                    <a class="dropdown-item" href="#"><i class="fas fa-pen"></i> Edit</a>
                                                    <a class="dropdown-item" href="#"><i class="fas fa-filter"></i>
                                                        Filter</a>
                                                    <a class="dropdown-item" href="#"><i class="fas fa-trash-alt"></i>
                                                        Delete</a>
                                                    <a class="dropdown-item" href="#"><i class="fas fa-plus"></i> Add
                                                        Multiple Task</a>
                                                </div>
                                            </div>
                                            <div class="addcard-btn">
                                                <a href="javascript:;" id="addRow2" class="quick-add">
                                                    {{--<i class="fas fa-plus"></i>--}}
                                                </a> <span class="count-card">{{$status->findProjects->count()??''}}</span>
                                            </div>
                                        </div>
                                        <div class="coloumn-body-sec column-card-id-{{$status->id}}" id="{{str_replace(' ', '-', $status->title)}}" data-id="{{$status->id}}" ondrop="drop(event)"
                                             ondragover="allowDrop(event)">
                                            <i class="fa fa-spinner fa-pulse fa-3x fa-fw loader-animation"></i>
                                            <div id="inputFormRow2">
                                                <div id="newRow2"></div>
                                            </div>
                                            <div id="inputFormRow3">
                                                <div id="newRow3"></div>
                                            </div>
                                        </div>
                                    </div>
                                    {{--<div class="column-footer">
                                        <a href="javascript:;" id="addRow3" class="quick-add"><i class="fas fa-plus"></i>Add
                                            a Card</a>
                                    </div>--}}
                                </div>
                            @endforeach
                        </div>
                    </div>
                    <div class="tab-pane" id="tabs-3" role="tabpanel">
                        <p>Third Panel</p>
                    </div>
                    <div class="tab-pane" id="tabs-4" role="tabpanel">
                        <p>Fourth Panel</p>
                    </div>
                    <div class="tab-pane" id="tabs-5" role="tabpanel">
                        <p>Fifth Panel</p>
                    </div>
                    <div class="tab-pane" id="tabs-6" role="tabpanel">
                        <p>sixth Panel</p>
                    </div>
                    <div class="tab-pane" id="tabs-7" role="tabpanel">
                        <p>seventh Panel</p>
                    </div>
                    <div class="tab-pane" id="tabs-8" role="tabpanel">
                        <p>eighth Panel</p>
                    </div>
                </div>
            </div>
        </div>
    </section>
@endsection

@section('modals')
    <div class="modal fade right" id="sidebar-right" tabindex="-1" role="dialog">
        <div class="modal-dialog modal-sm" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title" id="project-title" data-id=""></h4>
                    <div class="edit-sec">
                        {{--<button type="button" class="start-time"><span class="fa fa-play mr"></span>Start Timer</button>
                        <button type="button" class="edit-task  js-toggleForm" onclick="myFunction()">
                            <span class="fa fa-pen"></span>Edit Task
                        </button>
                        <div class="dropdown">
                            <i class="fas fa-ellipsis-h" data-toggle="dropdown" aria-haspopup="true"
                               aria-expanded="false"></i>
                            <div class="dropdown-menu" aria-labelledby="dropdownMenuButton">
                                <a class="dropdown-item" href="#">Action</a>
                                <a class="dropdown-item" href="#">Another action</a>
                                <a class="dropdown-item" href="#">Something else here</a>
                            </div>
                        </div>--}}
                        <button type="button" class="close" data-dismiss="modal">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                </div>
                <div class="modal-body">
                    <div class="task-edit">
                        <div class="form">
                            <div id="edit-panel" class="tabs-list">
                                <ul class="nav nav-tabs" role="tablist">
                                    <li class="nav-item">
                                        <a class="nav-link active" data-toggle="tab" href="#task-1" role="tab">
                                            <i class="fas fa-check"></i>Task details
                                        </a>
                                    </li>
                                    <li class="nav-item">
                                        <a class="nav-link" data-toggle="tab" href="#task-2" role="tab">
                                            <i class="fas fa-paperclip"></i>Files
                                        </a>
                                    </li>
                                    <li class="nav-item">
                                        <a class="nav-link" data-toggle="tab" href="#task-3" role="tab">
                                            <i class="fas fa-exclamation-circle"></i>Priority
                                        </a>
                                    </li>
                                    <li class="nav-item">
                                        <a class="nav-link" data-toggle="tab" href="#task-4" role="tab">
                                            <i class="far fa-clock"></i>Progress & Time
                                        </a>
                                    </li>
                                    <li class="nav-item">
                                        <a class="nav-link" data-toggle="tab" href="#task-5" role="tab">
                                            <i class="fas fa-plus"></i>More
                                        </a>
                                    </li>
                                </ul>
                                <!-- Tab panes -->
                                <div class="tab-content">
                                    <div class="tab-pane active" id="task-1" role="tabpanel">
                                        <form action="/" method="/">
                                            <div class="row">
                                                <div class="col-md-4">
                                                    <label>Who Should do this ?</label>
                                                    <select name="admin-name">
                                                        <option value="1"><img
                                                                src="{{ asset("team-work/images/avatar.png")}}"> Admin
                                                        </option>
                                                        <option value="2"><i class="fas fa-user"></i> Anyone</option>
                                                        <option value="3">Admin</option>
                                                        <option value="4">Task Name</option>
                                                    </select>
                                                </div>
                                                <div class="col-md-4">
                                                    <label>Start Date</label>
                                                    <input type="date" name="start-date">
                                                </div>
                                                <div class="col-md-4">
                                                    <label>Due Date</label>
                                                    <input type="date" name="due-date">
                                                </div>
                                                <div class="col-md-12 summernote-sec">
                                                    <label>Provide a detailed description for this task
                                                        <span>(optional)</span></label>
                                                    <textarea name="project-desc"></textarea>
                                                    <!-- <div id="summernote"></div> -->
                                                </div>
                                            </div>
                                        </form>
                                    </div>
                                    <div class="tab-pane" id="task-2" role="tabpanel">
                                        <p>2 Panel</p>
                                    </div>
                                    <div class="tab-pane" id="task-3" role="tabpanel">
                                        <p>3 Panel</p>
                                    </div>
                                    <div class="tab-pane" id="task-4" role="tabpanel">
                                        <p>4 Panel</p>
                                    </div>
                                    <div class="tab-pane" id="task-5" role="tabpanel">
                                        <p>5 Panel</p>
                                    </div>
                                </div>
                                <div class="close-save-btn">
                                    <button type="button" class="btn-primary btn-save">Save Changes</button>
                                    <span>or</span>
                                    <button type="button" class="btn-primary btn-close" onclick="closeBtn()">close</button>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="files-sec">
                        <h5 class="modal-title">Files</h5>
                        <div id="edit-panel" class="tabs-list" style="display: block">
                            <ul class="nav nav-tabs" role="tablist">
                                <li class="nav-item">
                                    <a class="nav-link attachment active" data-toggle="tab" href="#client-files" role="tab">
                                        Client Files
                                    </a>
                                </li>
                                <li class="nav-item">
                                    <a class="nav-link attachment" data-toggle="tab" href="#concept-files" role="tab">
                                        Concept Files
                                    </a>
                                </li>
                                <li class="nav-item">
                                    <a class="nav-link attachment" data-toggle="tab" href="#final-files" role="tab">
                                        Final Files
                                    </a>
                                </li>
                            </ul>
                            <!-- Tab panes -->
                            <div class="tab-content">
                                <div class="tab-pane active" id="client-files" role="tabpanel">
                                    <div class="row">
                                        <div class="col-md-12" id="client-files-div">
                                            <table class="table table-striped">
                                                <tr>
                                                    <td colspan="2">No Files Found</td>
                                                </tr>
                                            </table>
                                            <p>
                                                <a href="javascript:;" class="upload-modal" data-type="client-files" data-toggle="modal">Attach client files</a>
                                            </p>
                                        </div>
                                    </div>
                                </div>
                                <div class="tab-pane" id="concept-files" role="tabpanel">
                                    <div class="row">
                                        <div class="col-md-12" id="concept-files-div">
                                            <table class="table table-striped">
                                                <tr>
                                                    <td colspan="2">No Files Found</td>
                                                </tr>
                                            </table>
                                            <p>
                                                <a href="javascript:;" class="upload-modal" data-type="concept_files" data-toggle="modal">Attach concept files</a>
                                            </p>
                                        </div>
                                    </div>
                                </div>
                                <div class="tab-pane" id="final-files" role="tabpanel">
                                    <div class="row">
                                        <div class="col-md-12" id="final-files-div">
                                            <table class="table table-striped">
                                                <tr>
                                                    <td colspan="2">No Files Found</td>
                                                </tr>
                                            </table>
                                            <p>
                                                <a href="javascript:;" class="upload-modal" data-type="final_files" data-toggle="modal">Attach final files</a>
                                            </p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="timelog-sec">
                        <h5 class="modal-title">Time Logs</h5>
                        <p>No time entries have been logged against this task -
                            <a href="javascript:;">Log time on this task </a>
                        </p>
                    </div>
                    <div class="comments-sec">
                        <div class="add-comments">
                            <img src="{{ asset("team-work/images/avatar.png")}}" class="avatar">
                            <textarea class="your-comment summernote" placeholder="Add Your Comment Here"></textarea>
                        </div>
                        <div class="add-comments">
                            <div class="users-div mt-5 border-left border-blue p-3">
                                {{--<div class="users-div-inner"><span class="users">Brian Fisk</span></div>
                                <div class="users-div-inner"><span class="users">Oscar Steve</span></div>--}}
                                <div class="btn-div-inner">
                                    <span class="add-users" data-toggle="modal" data-target="#exampleModalCenter"><i class="fa fa-plus"></i> Add People</span>
                                </div>
                            </div>
                        </div>
                        <div class="add-comments">
                            <div class="users-div mt-5 border-left border-blue p-3">
                                <button class="btn btn-bordred-light"><i class="fa fa-paperclip"></i> Attach File</button>
                            </div>
                        </div>
                        <div class="add-comments">
                            <div class="users-div mt-5 border-left border-blue p-3">
                                <form method="post" action="{{ route('form.submit') }}" class="dropzone" id="dropzone" enctype="multipart/form-data">
                                    @csrf
                                </form>
                            </div>
                        </div>
                        <div class="add-comments">
                            <div class="users-div mt-5 border-left border-blue p-3">
                                <div class="btn-group">
                                    <button class="btn btn-danger cancel-comment"> Cancel</button>
                                    <button class="btn btn-success save-comment" data-id="" disabled> Save Comment</button>
                                </div>
                            </div>
                        </div>
                        <div class="dropdown sorting-dropdown">
                            <h5 class="modal-title">Comments</h5>
                            <i class="fas fa-sort-amount-down" data-toggle="dropdown" aria-haspopup="true"
                               aria-expanded="false"></i>
                            <div class="dropdown-menu" aria-labelledby="dropdownMenuButton">
                                <a class="dropdown-item" href="#">Sort By</a>
                                <a class="dropdown-item" href="#">Date Posted (Asc) <i class="fas fa-check"></i></a>
                                <a class="dropdown-item" href="#">Date Posted (Desc) <i class="fas fa-check"></i></a>
                            </div>
                        </div>
                        <div class="comments">
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Modal -->
    <div class="modal fade files-modal" id="myModal" tabindex="-1" role="dialog" data-backdrop="false" aria-labelledby="myModalLabel"
         aria-hidden="true" data-type="">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                    <h4 class="modal-title" id="myModalLabel">Attach Files</h4>
                    <p class="text-danger" id="no-file-error" style="display: none">Please upload file first</p>
                    <p class="text-success" id="file-uploaded-mesg" style="display: none">File(s) uploaded successfully.</p>
                </div>
                <div class="modal-body">
                    {{--<h6>Task: <span>Task Name</span></h6>--}}
                    <div class="form-group inputDnD">
                        <label class="sr-only" for="inputFile">File Upload</label>
                        <form action="" id="attachment-form">
                            <input type="file" class="form-control-file text-primary font-weight-bold" id="inputFile"
                                   onchange="/*readUrl(this)*/" data-title="Drop files here" multiple>
                        </form>
                        <div class="add-btn">
                            <button type="button" class="btn-primary btn-block"
                                    onclick="document.getElementById('inputFile').click()">
                                <i class="fas fa-plus"></i>Add Files
                            </button>
                            {{--<button type="button" class="btn-primary existing-btn">Select From Existing Files</button>--}}
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary close-btn" data-dismiss="modal">Close</button>
                    <button type="button" class="btn btn-primary save-btn">Save changes</button>
                </div>
            </div>
        </div>
    </div>

    <!-- Modal Users-->
    <div class="modal fade" data-backdrop="static" id="exampleModalCenter" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLongTitle">Add Users</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <p class="p-2 user-p outer_crcl">
                        {{--<span class="user-circle" data-id="u1">U1</span>
                        <span class="user-circle" data-id="u1">U2</span>
                        <span class="user-circle" data-id="u1">U3</span>--}}
                    </p>
                    <input type="text" name="" id="search-user" class="form-control" placeholder="Search">
                    <ul class="list-group outer-ul" style="height: 400px; overflow: auto">
                        @foreach($users as $user)
                            <li class="list-group-item">
                                <label for="">
                                    <input type="checkbox" class="u" name=""
                                           data-short="{{$user->firstname[0].$user->lastname[0]}}"
                                           data-id="{{$user->id}}" value="{{$user->name}}">{{$user->name}}
                                </label>
                            </li>
                        @endforeach
                    </ul>
                </div>
                <div class="modal-footer">
                    <span class="saved text-lg-center text-success" style="display: none;">Changes Saved</span>
                    <button type="button" class="btn btn-danger close-modal-btn" data-dismiss="modal">Close</button>
                    <button type="button" class="btn btn-primary save-notify-users">Save changes</button>
                </div>
            </div>
        </div>
    </div>

    <div id="dropzone-files"></div>
    <div id="notify-users"></div>
@endsection

@push('css')
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/@fancyapps/ui@4.0/dist/fancybox.css">
    <link rel="stylesheet" href="{{asset('team-work/dropzone/dist/dropzone.css')}}">
    <style>
        #myModal {
            overflow-y: hidden;
            overflow-x: hidden;
        }
        .modal-header {
            cursor: move;
        }
        .add-users{
            cursor: pointer;
        }
        .users{
            border-radius: 30%;
            padding: 3px;
        }
        .users-div{
            display: flex;
            flex-wrap: wrap;
            border: 1px dotted #eee;
            background-color: #fff;
            border-radius: 3px;
            padding: 12px 5px 12px 5px;
            min-height: 20px;
            border-left: 4px solid #4696EC;
            margin-top: 12px;
            min-width: 100%;
            margin-bottom: 5px;
        }
        .users-div-inner{
            display: flex;
            align-items: center;
            border: 1px solid #ddd;
            border-radius: 20px;
            padding: 4px 4px 4px 6px;
            cursor: pointer;
            margin-right: 5px;
            margin-bottom: 5px;
            font-size: 13px;
            background: #5bd6ff;
            color: black;
            font-weight: 700;
        }

        .user-circle{
            background: coral;
            border-radius: 50%;
            padding: inherit;
            font-size: 13px;
            color: white; display: inline-block; width: 35px;
            text-align: center;
            height: 35px;
        }

        .btn-div-inner{
            display: flex;
            align-items: center;
            padding: 4px 4px 4px 6px;
            cursor: pointer;
            margin-right: 5px;
            margin-bottom: 5px;
            color: #888;
            font-size: 13px;
        }
        .outer-ul label { font-weight:700; margin:0; }
        .outer-ul li  { padding:5px 10px; }
        .outer-ul label input { margin-right:5px; }
        .user-p{ background: aquamarine; border-radius: 5px; min-height: 52px;}
    </style>
@endpush

@push('js')
    <script src="{{asset('team-work/dropzone/dist/dropzone.js')}}"></script>
    <script src="https://cdn.jsdelivr.net/npm/@fancyapps/ui@4.0/dist/fancybox.umd.js"></script>

    <script type="text/javascript">
        {{--Dropzone Script--}}
            dropZone = Dropzone.options.dropzone = {
            addRemoveLinks: true,
            success: function (file, response) {
                let html = "<input type='hidden' name='comment_file[]' value='"+file.name+"'>";
                $('#dropzone-files').append(html)
            },
            removedfile: function( file ){

                $.ajax({
                    url: '{{URL::to('remove-file')}}' +"/"+ file.name,
                    type: 'get',
                    success: function( res ){

                        $('#dropzone-files input[value="'+res+'"]').each(function () {
                            if ($(this).val() === res) $(this).remove();
                        });

                        var fileRef;
                        return (fileRef = file.previewElement) != null ?
                            fileRef.parentNode.removeChild(file.previewElement) : void 0;
                    },
                    error: function ( error ){
                        console.log('Could not remove file');
                    }
                });
            },
        }

        const $button = document.querySelector('#sidebar-toggle');
        const $wrapper = document.querySelector('#wrapper');

        $button.addEventListener('click', (e) => {
            e.preventDefault();
            $wrapper.classList.toggle('toggled');
        });

        $(document).ready(function () {

            $(".modal").draggable({
                handle: ".modal-header"
            });

            $('.summernote').summernote({
                height: 170,
                tooltip: false,
                callbacks: {
                    onKeyup: function(e) {
                        summerNoteCallback(e)
                    }
                }
            });

            //Fetch Projects according to their status
            var project_status = {{$project_status_array}}

            function ajaxRequest (project_status) {
                if (project_status.length > 0) {
                    var project_id = project_status.pop();
                    $.ajax({
                        method: 'GET',
                        url: '{{\Illuminate\Support\Facades\URL::to('fetch-project')}}' + '/' + project_id
                    })
                        .done(function (result) {
                            if(result !== ""){
                                $(document).find('.column-card-id-'+project_id+' .loader-animation').addClass('d-none')
                                $(document).find('.column-card-id-'+project_id).append(result)
                            }
                            ajaxRequest(project_status);
                        });
                }
            }

            ajaxRequest(project_status);

            /*$(".modal a").not(".dropdown-toggle").on("click", function () {
                $(".modal").modal("hide");
            });*/
        });

        function drag(ev) {
            ev.dataTransfer.setData("text", ev.target.id);
        }

        function allowDrop(ev) {
            ev.preventDefault();
        }

        function drop(ev) {
            ev.preventDefault();
            var data = ev.dataTransfer.getData("text");
            ev.currentTarget.appendChild(document.getElementById(data));

            let project_status = ev.target.id;
            let task_id = document.getElementById(data).id;

            //Ajax Request
            $.ajax({
                url: '{{\Illuminate\Support\Facades\URL::to('update-project-status')}}',
                type: 'post',
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                },
                data: {
                    project_status:project_status,
                    task_id:task_id,
                },
                success:function(res){
                    // console.log(res)
                }
            })
            //Ajax Request end
        }

        // add row
        $("#addRow").click(function () {
            var html = '';
            html += '<div id="inputFormRow">';
            html += '<div class="input-group column-card">';
            html += '<input type="text" name="title[]" class="form-control m-input" placeholder="Coloumn Name" autocomplete="off">';
            html += '<div class="input-group-append">';
            html += '<button id="removeRow" type="button" class="btn btn-danger">Cancel</button>';
            html += '<button id="saveRow" type="button" class="btn btn-primary">Save</button>';
            html += '</div>';
            html += '</div>';

            $('#newRow').append(html);
        });

        $("#addRow1").click(function () {
            var html = '';
            html += '<div id="inputFormRow">';
            html += '<div class="input-group column-card">';
            html += '<input type="text" name="title[]" class="form-control m-input" placeholder="Coloumn Name" autocomplete="off">';
            html += '<div class="input-group-append">';
            html += '<button id="removeRow" type="button" class="btn btn-danger">Cancel</button>';
            html += '<button id="saveRow" type="button" class="btn btn-primary">Save</button>';
            html += '</div>';
            html += '</div>';

            $('#newRow').append(html);
        });

        $("#addRow2").click(function () {
            var html = '';
            html += '<div id="inputFormRow">';
            html += '<div class="input-textarea">';
            html += '<textarea type="textarea" name="title[]" class="form-control"></textarea>';
            html += '<div class="input-group-append">';
            html += '<button id="removeRow" type="button" class="btn btn-danger card-cancel">Cancel</button>';
            html += '<button id="saveRow" type="button" class="btn btn-primary card-save">Save</button>';
            html += '</div>';
            html += '</div>';

            $('#newRow2').append(html);
        });

        $("#addRow3").click(function () {
            var html = '';
            html += '<div id="inputFormRow">';
            html += '<div class="input-textarea">';
            html += '<textarea type="textarea" name="title[]" class="form-control"></textarea>';
            html += '<div class="input-group-append">';
            html += '<button id="removeRow" type="button" class="btn btn-danger card-cancel">Cancel</button>';
            html += '<button id="saveRow" type="button" class="btn btn-primary card-save">Save</button>';
            html += '</div>';
            html += '</div>';

            $('#newRow3').append(html);
        });

        // remove row
        $(document).on('click', '#removeRow', function () {
            $(this).closest('#inputFormRow').remove();
        });

        $(document).on('click', '#removeRow', function () {
            $(this).closest('#inputFormRow2').remove();
        });

        function readUrl(input) {

            if (input.files && input.files[0]) {
                let reader = new FileReader();
                reader.onload = (e) => {
                    let imgData = e.target.result;
                    let imgName = input.files[0].name;
                    input.setAttribute("data-title", imgName);
                    //console.log(e.target.result);
                }
                reader.readAsDataURL(input.files[0]);
            }
        }

        var form_ele = '.form';

        // make everything disabled
        var disableFormEdit = function (selector) {
            $(selector).removeClass('form--enabled').addClass('form--disabled');
            $(selector + ' input[type="text"] ').prop('disabled', true);
        }

        // make everything enabled
        var enableFormEdit = function (selector) {
            $(selector + ' input[type="text"]').prop('disabled', false);
            $(selector).removeClass('form--disabled').addClass('form--enabled');
        }

        disableFormEdit(form_ele);

        $('.js-toggleForm').click(function () {
            // get the status of form
            var form_status = $(form_ele).hasClass('form--disabled') ? 'disabled' : 'enabled';

            // check if disabled or enabled
            switch (form_status) {
                case 'disabled':
                    enableFormEdit(form_ele);
                    $(this).addClass('fa fa-pen').text('Edit Task');
                    break;
                case 'enabled':
                    disableFormEdit(form_ele);
                    $(this).addClass('fa fa-pen').text('Edit Task');
                    break;
            }
        });

        function myFunction() {
            var x = document.getElementById("edit-panel");
            if (x.style.display === "none") {
                x.style.display = "block";
            } else {
                x.style.display = "block";
            }
        }

        function closeBtn() {
            var x = document.getElementById("edit-panel");
            if (x.style.display === "none") {
                // x.style.display = "block";
            } else {
                x.style.display = "none";
            }
        }

        $(document).on('click', '.pull-left', function(){
            let project_id = $(this).attr('id').replace('task', '')
            let project_name = $(this).attr('data-title')

            $('#project-title').text(project_name)
            $('#project-title').attr('data-id', project_id)
            $('.save-comment').attr('data-id', project_id)

            /*Get all project relates files*/
            $.ajax({
                url: '{{route('get-project-files')}}',
                type: 'post',
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                },
                data: {
                    id:project_id,
                },
                success:function(res){
                    $('#client-files-div > table').html('')
                    $('#concept-files-div > table').html('')
                    $('#final-files-div > table').html('')

                    $('#client-files-div > table').prepend(res.client_files)
                    $('#concept-files-div > table').prepend(res.concept_files)
                    $('#final-files-div > table').prepend(res.final_files)
                }
            })

            $('#sidebar-right').modal('show')

            $.ajax({
                url: '{{\Illuminate\Support\Facades\URL::to('get-project-comments')}}' + '/' + project_id,
                type: 'get',
                success:function(res){
                    $('.comments').html("")
                    $('.comments').append(res)
                }
            })
        })

        $(document).on('click', '.upload-modal', function(){
            let data_type = $(this).attr('data-type')
            $('#myModal').attr('data-type', data_type).modal('show')
        })

        $(document).on('click', '.close-btn', function () {
            $('#inputFile').val('')
            $('#file-uploaded-mesg').hide()
            $('#myModal').hide();
        })

        $(document).on('click', '.save-btn', function(){
            let file_type  = $(this).closest('#myModal').attr('data-type')
            var fileInput  = $('#inputFile');
            var project_id = $('#project-title').attr('data-id');

            if(!fileInput.length > 0){
                $('#no-file-error').show()
            }else{
                $('#no-file-error').hide()

                var data = new FormData();

                data.append("_token", "{{ csrf_token() }}");
                data.append("file_type",file_type);
                data.append("project_id",project_id);

                let TotalFiles = $('#inputFile')[0].files.length; //Total files
                let files = $('#inputFile')[0];
                for (let i = 0; i < TotalFiles; i++) {
                    data.append('files[]', files.files[i]);
                }

                $.ajax({
                    cache:false,
                    contentType: false,
                    processData: false,
                    type:'POST',
                    url:"{{ route('store-project-files') }}",
                    data:data,
                    success:function(data){
                        $('#inputFile').val('')
                        $('#file-uploaded-mesg').show()

                        setTimeout(function(){
                            $('.close-btn').trigger('click')
                        }, 3000)
                    }

                });
            }
        })

        $(document).on('click', '.remove-file', function() {
            let ele = $(this)
            let project_id = ele.attr('data-id')
            let file_type  = ele.attr('data-type')
            let file_name  = ele.attr('data-name')

            Swal.fire({
                title: 'Are you sure?',
                text: "You won't be able to revert this!",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: 'Yes, delete it!'
            }).then((result) => {
                if (result.isConfirmed) {
                    $.ajax({
                        url: '{{route('delete-project-file')}}',
                        type: 'post',
                        headers: {
                            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                        },
                        data: {
                            'project_id' : project_id,
                            'file_type'  : file_type,
                            'file_name'  : file_name,
                        },
                        success:function(res){
                            if(res){
                                ele.closest('tr').remove()
                                Swal.fire({
                                    position: 'top-end',
                                    icon: 'success',
                                    title: 'File deleted successfully',
                                    showConfirmButton: false,
                                    timer: 1500
                                })
                            }else{
                                Swal.fire({
                                    position: 'top-end',
                                    icon: 'error',
                                    title: 'Could not delete file',
                                    showConfirmButton: false,
                                    timer: 1500
                                })
                            }
                        }
                    })
                }
            })
        })

        /*$(document).on('click', '.add-users', function() {
            alert('working')
        })*/

        $(document).on('click', '.u', function(){
            let ele = $(this)
            let id = ele.data('id')
            let short = ele.data('short')
            let checked = ele.is(":checked")
            let name = ele.val()

            if(checked){
                $('.user-p').append("<span class='user-circle' id='"+id+"'>"+short+"</span>");
                let html = "<div class='users-div-inner d-"+id+"'><span class='users' data-id='"+id+"'>"+name+" <i class='fa fa-times remove'></i></span></div>";
                $(html).insertBefore('.btn-div-inner');

                $('#notify-users').append("<input type='hidden' id='user-"+id+"' name='users_to_notify[]' value='"+id+"'>")
            }else{
                $('.user-p').find('#'+id).remove()
                $('.users-div').find('.d-'+id).remove()
                $('#notify-users').find('#user-'+id).remove()
            }
        })

        $('#search-user').keyup(function() {
            let search = $(this).val()
            let matches = $( 'ul.outer-ul' ).find( 'li:containsIN('+search+')' );
            $( 'li', 'ul.outer-ul' ).not( matches ).slideUp();
            matches.slideDown();
        })

        $(document).on('click', '.remove', function() {
            let id = $(this).closest('.users').attr('data-id')
            $('#notify-users #user-'+id).remove()
            $(this).closest('.users-div-inner').remove()
        })

        $(document).on('click', '.save-notify-users', function() {
            let project_id = $('#project-title').attr('data-id');
            $('.saved').show();
        })

        $(document).on('click', '.close-modal-btn', function() {
            $('.saved').hide();
        })

        $(document).on('click', '.save-comment', function() {
            let project_id = $(this).attr('data-id')
            let description = $('.your-comment').val()
            let comment_files = []
            let notification_users = []

            $('#dropzone-files input').each(function(){
               comment_files.push($(this).val())
            })

            $('#notify-users input').each(function(){
                notification_users.push($(this).val())
            })

            $.ajax({
                url: '{{route('save-project-comment')}}',
                type: 'post',
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                },
                data: {
                    'project_id' : project_id,
                    'description' : description,
                    'comment_files' : comment_files,
                    'notification_users' : notification_users,
                },
                success:function(res){
                    if(res.status === true){
                        $('.save-comment').attr('disabled', true)
                        $('.summernote').summernote('reset');
                        $('#dropzone-files').html('')
                        $('#notify-users').html('')
                        $('.user-p').html('')
                        $('.u').each(function () {
                            $(this).prop("checked", false);
                        })
                        $('.users-div-inner').remove()
                        Dropzone.forElement("#dropzone").removeAllFiles(true);

                        $('.comments').prepend(res.comment)
                    }
                }
            })
        })

        $(document).on('click', '.delete-comment', function() {
            let ele = $(this)
            let comment_id = ele.data('id')

            Swal.fire({
                title: 'Are you sure?',
                text: "You won't be able to revert this!",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: 'Yes, delete it!'
            }).then((result) => {
                if (result.isConfirmed) {
                    $.ajax({
                        url: '{{route('delete-project-comment')}}',
                        type: 'post',
                        headers: {
                            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                        },
                        data: {
                            id:comment_id,
                        },
                        success:function(res){
                            if(res){
                                ele.closest('#comment-'+comment_id).remove()
                                Swal.fire(
                                    'Deleted!',
                                    'Comment has been deleted.',
                                    'success'
                                )
                            }else{
                                Swal.fire(
                                    'Error!',
                                    'Could not delete.',
                                    'error'
                                )
                            }
                        }
                    })
                }
            })
        })

        function summerNoteCallback(e){
            if(! $('.summernote').summernote('isEmpty')){
                $('.save-comment').attr('disabled', false)
            }else{
                $('.save-comment').attr('disabled', true)
            }
            let code = e.keyCode || e.which;
            if(code === 50) {
                console.log('Pressed @')
            }
        }

    </script>
@endpush
