@extends('layouts.app')
@section('page-title','Teams')

@push('css')
    <!-- DataTables -->
    <link rel="stylesheet" href="{{asset('plugins/datatables-bs4/css/dataTables.bootstrap4.min.css')}}">
    <link rel="stylesheet" href="{{asset('plugins/datatables-responsive/css/responsive.bootstrap4.min.css')}}">

@endpush

@section('content')
    <!--content area start-->
    <div id="content" class="pmd-content inner-page admin">
        <!-- Title -->
        <h1 id="employee" class="text-center">@yield('page-title')</h1>
        <!-- End Title -->
        <!--breadcrumb start-->
        <div class="float-right @cannot('create.team') no-btn @endcan">
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb pmd-breadcrumb mb-0">
                    <li class="breadcrumb-item">
                        <a href="{{route('dashboard')}}">Dashboard</a>
                    </li>
                    <li class="breadcrumb-item active" aria-current="page">@yield('page-title')</li>
                </ol>
            </nav>
        </div>
        <div>
            @can('create.team')
                <a href="{{route('create.team')}}" class="btn btn-primary">Create</a>
            @endcan
        </div>

        <!--breadcrumb end-->
        <div class="row pt-3">
            <div class="col-12">
                <div class="table-bg">
                    <section class="component-section" id="employee">
                        <table id='roles-datatable' class="table pmd-table table-hover pmd-table-card">
                            <thead class="thead-light">
                            <tr>
                                <th>S No.</th>
                                <th>Title</th>
                                <th>Team head</th>
                                <th>Status</th>
                                <th>Actions</th>
                            </tr>
                            </thead>
                            <tbody>
                            {{--@php $i = 1; @endphp
                            @forelse($teams as $team)
                                <tr>
                                    <td>{{ $i++ }}</td>
                                    <td>{{$team->title}}</td>
                                    <td>{{$team->findUser->name}}</td>
                                    <td>
                                        @if($team->status == 1)
                                            <span class="badge badge-success">Active</span>
                                        @else
                                            <span class="badge badge-danger">In-Active</span>
                                        @endif
                                    </td>
                                    <td>
                                        @can('show.team')
                                            --}}{{--<a class="btn btn-success btn-style" href="{{route('show.team',base64_encode($team->id))}}" title="View"><i class="fa fa-eye"></i> </a>--}}{{--
                                        @endcan
                                        @can('edit.team')
                                            <a class="btn btn-primary btn-style" href="{{route('edit.team',base64_encode($team->id))}}" title="Edit"><i class="fa fa-edit"></i> </a>
                                        @endcan
                                        @can('delete.team')
                                            <button class="btn btn-danger delete-btn" data-id="{{base64_encode($team->id)}}" title="Delete"><i class="fa fa-trash"></i> </button>
                                        @endcan
                                    </td>
                                </tr>
                            @empty
                                <tr>
                                    <td colspan="5" align="center">No Teams Available</td>
                                </tr>
                            @endforelse--}}
                            </tbody>
                        </table>
                    </section>
                </div>
            </div>
        </div>

    </div>
    <!-- content area end -->
@endsection

@push('js')
    <script>
        $(document).ready( function () {
           /* $('#roles-datatable').DataTable();*/

            $('#roles-datatable').DataTable({
                "serverSide": true,
                "processing": true,
                "responsive": true,
                "autoWidth": false,
                "ajax": {
                    "url": "{{ route('shows.team') }}",
                    "dataType": "json",
                    "type": "POST",
                    "data": {_token: "{{csrf_token()}}"}
                },
                "columns": [
                    {"data": "id",sortable:false},
                    {"data": "title",sortable:false},
                    {"data": "team_head_user_id",sortable:false},
                    {"data": "status",sortable:false},
                    {"data": "options",sortable:false}
                ]
            });
        } );

        $(document).on('click','.delete-btn',function(){
            var id = $(this).attr('data-id');

            Swal.fire({
                title: 'Are you sure?',
                text: "You won't be able to revert this!",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: 'Yes, delete it!'
            }).then((result) => {
                if (result.isConfirmed) {
                    $.ajax({
                        url: '{{URL::to('site/team/delete')}}' +"/"+ id,
                        type: 'get',
                        success: function(response){
                            Swal.fire(
                                'Deleted!',
                                response,
                                'success'
                            );
                            location.reload();
                        }
                    });
                }
            });

        });
    </script>
@endpush
