<?php

use App\Http\Controllers\HomeController;
use App\Http\Controllers\PackageController;
use App\Http\Controllers\PageController;
use App\Http\Controllers\AttendanceController;
use App\Http\Controllers\ClientsController;
use App\Http\Controllers\LeadController;
use App\Http\Controllers\LoanController;
use App\Http\Controllers\Website\MainController;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\ClientController;
use App\Http\Controllers\InterviewController;
use App\Http\Controllers\JobTitleController;
use App\Http\Controllers\ProjectController;
use App\Http\Controllers\ProjectStatusController;
use App\Http\Controllers\ProjectTypeController;
use App\Http\Controllers\SalaryController;
use App\Http\Controllers\TeamWorkController;
use App\Http\Controllers\UserDesignationController;
use App\Http\Controllers\UserStatusController;
use App\Http\Controllers\DashboardController;
use \App\Http\Controllers\PermissionController;
use \App\Http\Controllers\RoleController;
use \App\Http\Controllers\UserController;
use \App\Http\Controllers\IPController;
use \App\Http\Controllers\ShiftController;
use \App\Http\Controllers\LeaveTypeController;
use \App\Http\Controllers\TeamController;
use \App\Http\Controllers\RankController;
use \App\Http\Controllers\AllowanceController;
use \App\Http\Controllers\TaxSlabController;
use \App\Http\Controllers\TestController;
use \App\Http\Controllers\LeaveRequestController;
use \App\Http\Controllers\NotificationController;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
*/

Route::get('slacksetup', [TestController::class, 'slacksetup'])->name('slacksetup');

Route::get('/', function () {
    if (auth()->check())
        return redirect()->route('dashboard');

    return redirect()->route('login');
});

Auth::routes();

Route::get('/', [HomeController::class, 'index'])->name('home');
//Route::get('/home', [HomeController::class,'index']);


Route::get('/dashboard', [DashboardController::class, 'index'])->name('dashboard');

Route::middleware(['role_permission', 'auth'])->group(function () {

    Route::prefix('site')->group(function () {

        Route::prefix('permission')->group(function () {
            Route::get('/', [PermissionController::class, 'index'])->name('permission');
            Route::get('create', [PermissionController::class, 'create'])->name('create.permission');
            Route::post('store', [PermissionController::class, 'store'])->name('insert.permission');
            Route::get('edit/{id}', [PermissionController::class, 'edit'])->name('edit.permission');
            Route::post('update', [PermissionController::class, 'update'])->name('update.permission');
            Route::get('delete/{id}', [PermissionController::class, 'delete'])->name('delete.permission');
        });

        Route::prefix('user')->group(function () {
            Route::get('/', [UserController::class, 'index'])->name('user');
            Route::post('/showAllEmployees', [UserController::class, 'showAllEmployees'])->name('show.employees');
            Route::get('create', [UserController::class, 'create'])->name('create.user');
            Route::post('store', [UserController::class, 'store'])->name('insert.user');
            Route::get('show/{id}', [UserController::class, 'show'])->name('show.user');
            Route::get('edit/{id}', [UserController::class, 'edit'])->name('edit.user');
            Route::post('update', [UserController::class, 'update'])->name('update.user');
            Route::get('delete/{id}', [UserController::class, 'delete'])->name('delete.user');
            Route::get('user-activity', [UserController::class, 'activity'])->name('user.activity');
            Route::post('show-all-employee-team', [UserController::class, 'showAllEmployeeTeam'])->name('show.employee.teams');
            Route::get('show-team-member/{id}', [UserController::class, 'showTeamMember'])->name('show.team.members');
            Route::post('show-specific-employee-team-member', [UserController::class, 'showSpecificEmployeeTeamMember'])->name('show.specific.team.employee.activity');
            Route::get('show-specific-employee/{id}/{date}', [UserController::class, 'showSpecificEmployee'])->name('show.specific.employee.activity');
            Route::post('show-all-employee-activity', [UserController::class, 'showAllEmployeeActivity'])->name('show.all.specific.employee.activity');
            Route::get('show-specific-employee-date-activity/{id}/{date}', [UserController::class, 'showSpecificEmployeeDateActivity'])->name('user.date.login.activity');
            Route::post('show-all-specific-employee-date-activity', [UserController::class, 'showAllSpecificEmployeeDateActivity'])->name('all.date.user.login.activity');
            Route::post('user-check-in-time', [UserController::class, 'userCheckInTime'])->name('userCheckInTime.user');
//            Route::post('user-check-in-date-time', [UserController::class, 'userCheckInDateTime'])->name('userCheckInDateTime');

        });

        Route::prefix('attendance')->group(function () {
            Route::post('check_in', [AttendanceController::class, 'check_in'])->name('check_in.attendance');
            Route::post('check_out', [AttendanceController::class, 'check_out'])->name('check_out.attendance');
//            Route::post('check_in_out', [AttendanceController::class, 'checkInOut'])->name('check_in_out.attendance');
        });


        Route::prefix('employee-salary')->group(function () {
            Route::get('/',[SalaryController::class,'index'])->name('employee-salary');
            Route::post('/show-salary', [SalaryController::class, 'showSalary'])->name('show.salary');
            Route::get('show/{id}', [SalaryController::class, 'show'])->name('show.user.salary');
            Route::post('team-wise-salary', [SalaryController::class, 'teamSalary'])->name('show.team.employee.salary');
            Route::post('generated-salary', [SalaryController::class, 'generatedSalary'])->name('generated.salary');
            Route::get('show-generated-salary/{id}', [SalaryController::class, 'showGeneratedSalary'])->name('show.generated.salary');
            Route::post('disburse-salary', [SalaryController::class, 'disburseSalary'])->name('disburse.salary');
            Route::post('disbursed-status', [SalaryController::class, 'disbursedStatus'])->name('disbursed.status');
            Route::get('update-disburse-status', [SalaryController::class, 'updateDisburse'])->name('update.disbursed.status');
            Route::get('show-disbursed/{id}', [SalaryController::class, 'showDisbursed'])->name('show.disbursed');
            Route::post('disbursed-history', [SalaryController::class, 'disbursedHistory'])->name('disbursed.history');
        });

        Route::prefix('user-status')->group(function () {
            Route::get('/', [UserStatusController::class, 'index'])->name('user-status');
            Route::get('create', [UserStatusController::class, 'create'])->name('create.user-status');
            Route::post('store', [UserStatusController::class, 'store'])->name('insert.user-status');
            Route::get('edit/{id}', [UserStatusController::class, 'edit'])->name('edit.user-status');
            Route::post('update', [UserStatusController::class, 'update'])->name('update.user-status');
            Route::get('delete/{id}', [UserStatusController::class, 'delete'])->name('delete.user-status');
        });

        Route::prefix('user-department')->group(function () {
            Route::get('/', [UserDesignationController::class, 'index'])->name('user-department');
            Route::get('create', [UserDesignationController::class, 'create'])->name('create.user-department');
            Route::post('store', [UserDesignationController::class, 'store'])->name('insert.user-department');
            Route::get('edit/{id}', [UserDesignationController::class, 'edit'])->name('edit.user-department');
            Route::post('update', [UserDesignationController::class, 'update'])->name('update.user-department');
            Route::get('delete/{id}', [UserDesignationController::class, 'delete'])->name('delete.user-department');
        });

        Route::prefix('job-title')->group(function () {
            Route::get('/', [JobTitleController::class, 'index'])->name('job-title');
            Route::get('create', [JobTitleController::class, 'create'])->name('create.job-title');
            Route::post('store', [JobTitleController::class, 'store'])->name('insert.job-title');
            Route::get('edit/{id}', [JobTitleController::class, 'edit'])->name('edit.job-title');
            Route::post('update', [JobTitleController::class, 'update'])->name('update.job-title');
            Route::get('delete/{id}', [JobTitleController::class, 'delete'])->name('delete.job-title');
        });

//        Leads
        Route::prefix('leads')->group(function () {
            Route::get('/', [LeadController::class, 'index'])->name('leads');
            Route::post('/showAllLeads', [LeadController::class, 'showAllLeads'])->name('show.leads');
            Route::get('lead-info/{id}', [LeadController::class, 'leadInformation'])->name('view-info.leads');
            Route::post('update-status', [LeadController::class,'updateStatus'])->name('update-status.leads');


//            Route::get('/create', [LeadController::class, 'createLead'])->name('create-new.leads');

        });

        Route::prefix('clients')->group(function () {
            Route::get('/', [ClientsController::class, 'index'])->name('clients');
            Route::post('/showClients', [ClientsController::class, 'showClients'])->name('show-all.clients');
            Route::get('/create', [ClientsController::class, 'createClient'])->name('create-new.clients');
            Route::post('store', [ClientsController::class, 'store'])->name('insert-new.clients');
            Route::get('get-states/{id}',[ClientsController::class,'getStates'])->name('get-states');
            Route::get('get-cities/{id}',[ClientsController::class,'getCities'])->name('get-cities');
            Route::get('show/{id}', [ClientsController::class, 'show'])->name('view.clients');
            Route::get('client-info/{id}', [ClientsController::class, 'clientInformation'])->name('view-info.clients');
            Route::get('edit/{id}', [ClientsController::class, 'edit'])->name('edit.clients');
            Route::post('store-payment', [ClientsController::class, 'storePayment'])->name('store-payment.clients');
            Route::Post('save-comment', [ClientsController::class, 'saveComment'])->name('comment.clients');

        });


//        pages
        Route::prefix('page')->group(function () {
            Route::get('/', [PageController::class ,'index'])->name('page');
            Route::get('create', [PageController::class ,'createPage'])->name('create.page');
            Route::post('insert', [PageController::class ,'postCreate'])->name('insert.page');
            Route::get('edit/{id}', [PageController::class ,'editPage'])->name('edit.page');
            Route::post('update', [PageController::class ,'updatePage'])->name('update.page');
            Route::post('delete', [PageController::class ,'deletePage'])->name('delete.page');
        });

//        packages
        Route::prefix('package')->group(function () {
            Route::get('/', [PackageController::class ,'index'])->name('package');
            Route::get('create', [PackageController::class ,'createPackage'])->name('create.package');
            Route::post('insert', [PackageController::class ,'postCreate'])->name('insert.package');
            Route::get('edit/{id}', [PackageController::class ,'editPackage'])->name('edit.package');
            Route::post('update', [PackageController::class ,'updatePackage'])->name('update.package');
            Route::post('delete', [PackageController::class ,'deletePackage'])->name('delete.package');
        });


        Route::prefix('client')->group(function () {
            Route::get('/', [ClientController::class, 'index'])->name('client');
            Route::post('/showAllClients', [ClientController::class, 'showAllClients'])->name('show.clients');
            Route::get('create', [ClientController::class, 'create'])->name('create.client');
            Route::post('store', [ClientController::class, 'store'])->name('insert.client');
            Route::post('store-ajax', [ClientController::class, 'storeAjax'])->name('insert.client.ajax');
            Route::get('show/{id}', [ClientController::class, 'show'])->name('show.client');
            Route::get('edit/{id}', [ClientController::class, 'edit'])->name('edit.client');
            Route::post('update', [ClientController::class, 'update'])->name('update.client');
            Route::get('delete/{id}', [ClientController::class, 'delete'])->name('delete.client');
        });

        Route::prefix('role')->group(function () {
            Route::get('/', [RoleController::class, 'index'])->name('role');
            Route::get('create', [RoleController::class, 'create'])->name('create.role');
            Route::post('store', [RoleController::class, 'store'])->name('insert.role');
            Route::get('show/{id}', [RoleController::class, 'show'])->name('show.role');
            Route::get('edit/{id}', [RoleController::class, 'edit'])->name('edit.role');
            Route::post('update', [RoleController::class, 'update'])->name('update.role');
            Route::get('delete/{id}', [RoleController::class, 'delete'])->name('delete.role');
        });

        Route::prefix('ip')->group(function () {
            Route::get('/', [IPController::class, 'index'])->name('ip');
            Route::post('/showAllIps', [IPController::class, 'showAllIps'])->name('show.ip');
            Route::get('create', [IPController::class, 'create'])->name('create.ip');
            Route::post('store', [IPController::class, 'store'])->name('insert.ip');
            //    Route::get('show/{id}',[IPController::class, 'show'])->name('show.role');
            Route::get('edit/{id}', [IPController::class, 'edit'])->name('edit.ip');
            Route::post('update', [IPController::class, 'update'])->name('update.ip');
            Route::get('delete/{id}', [IPController::class, 'delete'])->name('delete.ip');
        });

        Route::prefix('shift')->group(function () {
            Route::get('/', [ShiftController::class, 'index'])->name('shift');
            Route::post('/showAllShifts', [ShiftController::class, 'showAllShifts'])->name('show.shift');
            Route::get('create', [ShiftController::class, 'create'])->name('create.shift');
            Route::post('store', [ShiftController::class, 'store'])->name('insert.shift');
            //    Route::get('show/{id}',[ShiftController::class, 'show'])->name('show.shift');
            Route::get('edit/{id}', [ShiftController::class, 'edit'])->name('edit.shift');
            Route::post('update', [ShiftController::class, 'update'])->name('update.shift');
            Route::get('delete/{id}', [ShiftController::class, 'delete'])->name('delete.shift');
        });

        Route::prefix('leave')->group(function () {
            Route::get('/', [LeaveTypeController::class, 'index'])->name('leave');
            Route::get('create', [LeaveTypeController::class, 'create'])->name('create.leave');
            Route::post('store', [LeaveTypeController::class, 'store'])->name('insert.leave');
            //    Route::get('show/{id}',[LeaveTypeController::class, 'show'])->name('show.leave');
            Route::get('edit/{id}', [LeaveTypeController::class, 'edit'])->name('edit.leave');
            Route::post('update', [LeaveTypeController::class, 'update'])->name('update.leave');
            Route::get('delete/{id}', [LeaveTypeController::class, 'delete'])->name('delete.leave');
        });

        Route::prefix('team')->group(function () {
            Route::get('/', [TeamController::class, 'index'])->name('team');
            Route::post('/showAllTeams', [TeamController::class, 'showAllTeams'])->name('shows.team');
            Route::get('create', [TeamController::class, 'create'])->name('create.team');
            Route::post('store', [TeamController::class, 'store'])->name('insert.team');
            Route::get('show/{id}', [TeamController::class, 'show'])->name('show.team');
            Route::get('edit/{id}', [TeamController::class, 'edit'])->name('edit.team');
            Route::post('update', [TeamController::class, 'update'])->name('update.team');
            Route::get('delete/{id}', [TeamController::class, 'delete'])->name('delete.team');
        });

        Route::prefix('rank')->group(function () {
            Route::get('/', [RankController::class, 'index'])->name('rank');
            Route::get('create', [RankController::class, 'create'])->name('create.rank');
            Route::post('store', [RankController::class, 'store'])->name('insert.rank');
            //    Route::get('show/{id}',[RankController::class, 'show'])->name('show.rank');
            Route::get('edit/{id}', [RankController::class, 'edit'])->name('edit.rank');
            Route::post('update', [RankController::class, 'update'])->name('update.rank');
            Route::get('delete/{id}', [RankController::class, 'delete'])->name('delete.rank');
        });

        Route::prefix('allowance')->group(function () {
            Route::get('/', [AllowanceController::class, 'index'])->name('allowance');
            Route::post('/showAllAllownces', [AllowanceController::class, 'showAllAllownces'])->name('show.allowance');
            Route::get('create', [AllowanceController::class, 'create'])->name('create.allowance');
            Route::post('store', [AllowanceController::class, 'store'])->name('insert.allowance');
            //    Route::get('show/{id}',[AllowanceController::class, 'show'])->name('show.allowance');
            Route::get('edit/{id}', [AllowanceController::class, 'edit'])->name('edit.allowance');
            Route::post('update', [AllowanceController::class, 'update'])->name('update.allowance');
            Route::get('delete/{id}', [AllowanceController::class, 'delete'])->name('delete.allowance');
        });

        Route::prefix('taxslab')->group(function () {
            Route::get('/', [TaxSlabController::class, 'index'])->name('taxslab');
            Route::post('/showAllTaxSlabs', [TaxSlabController::class, 'showAllTaxSlabs'])->name('show.taxslab');
            Route::get('create', [TaxSlabController::class, 'create'])->name('create.taxslab');
            Route::post('store', [TaxSlabController::class, 'store'])->name('insert.taxslab');
            //    Route::get('show/{id}',[TaxSlabController::class, 'show'])->name('show.taxslab');
            Route::get('edit/{id}', [TaxSlabController::class, 'edit'])->name('edit.taxslab');
            Route::post('update', [TaxSlabController::class, 'update'])->name('update.taxslab');
            Route::get('delete/{id}', [TaxSlabController::class, 'delete'])->name('delete.taxslab');
        });

        Route::prefix('leave-management')->group(function () {
            Route::get('/', [LeaveRequestController::class, 'index'])->name('leave-management');
            Route::get('create', [LeaveRequestController::class, 'create'])->name('create.leave-management');
            Route::post('store', [LeaveRequestController::class, 'store'])->name('insert.leave-management');
            //    Route::get('show/{id}',[LeaveRequestController::class, 'show'])->name('show.leave-management');
            Route::get('edit/{id}', [LeaveRequestController::class, 'edit'])->name('edit.leave-management');
            Route::post('update', [LeaveRequestController::class, 'update'])->name('update.leave-management');
            Route::get('delete/{id}', [LeaveRequestController::class, 'delete'])->name('delete.leave-management');
            Route::post('update-hr-status', [LeaveRequestController::class, 'updateHRStatus'])->name('update-hr-leave-status');
        });

        Route::prefix('notification')->group(function () {
            Route::get('/', [NotificationController::class, 'index'])->name('notification');
            Route::get('/sent', [NotificationController::class, 'sentNotification'])->name('sent.notification');
            Route::get('/received', [NotificationController::class, 'receivedNotification'])->name('received.notification');
            Route::get('/show_send_notification/{id}', [NotificationController::class, 'show_send_notification'])->name('view.notification');
            Route::get('create', [NotificationController::class, 'create'])->name('create.notification');
            Route::post('store', [NotificationController::class, 'store'])->name('insert.notification');
            //    Route::get('show/{id}',[NotificationController::class, 'show'])->name('show.notification');
            Route::get('edit/{id}', [NotificationController::class, 'edit'])->name('edit.notification');
            Route::post('update', [NotificationController::class, 'update'])->name('update.notification');
            Route::get('delete/{id}', [NotificationController::class, 'delete'])->name('delete.notification');
            Route::get('mark-as-read/{id}', [NotificationController::class, 'markAsRead'])->name('mark-as-read.notification');
            Route::get('mark-as-read-general-notification/{id}', [NotificationController::class, 'markAsReadGeneralNotification'])->name('mark-as-read-general.notification');
            Route::get('redirect/{id}', [NotificationController::class, 'markAsReadAndRedirect'])->name('read.redirect.notification');
        });

        /*Team Work Projects*/
        Route::prefix('project')->group(function () {
            Route::get('/', [ProjectController::class, 'index'])->name('project');
            Route::post('/showAllProjects', [ProjectController::class, 'showAllProjects'])->name('show.projects');
            Route::post('/showAllProjects2', [ProjectController::class, 'showAllProjects2'])->name('show.projects.two');
            Route::get('create', [ProjectController::class, 'create'])->name('create.project');
            Route::post('store', [ProjectController::class, 'store'])->name('insert.project');
            Route::get('show/{id}', [ProjectController::class, 'show'])->name('show.project');
            Route::get('edit/{id}', [ProjectController::class, 'edit'])->name('edit.project');
            Route::post('update', [ProjectController::class, 'update'])->name('update.project');
            Route::get('delete/{id}', [ProjectController::class, 'delete'])->name('delete.project');
        });

        /*Team Work Projects Status*/
        Route::prefix('project-status')->group(function () {
            Route::get('/', [ProjectStatusController::class, 'index'])->name('project-status');
            Route::get('create', [ProjectStatusController::class, 'create'])->name('create.project-status');
            Route::post('store', [ProjectStatusController::class, 'store'])->name('insert.project-status');
            Route::get('edit/{id}', [ProjectStatusController::class, 'edit'])->name('edit.project-status');
            Route::post('update', [ProjectStatusController::class, 'update'])->name('update.project-status');
            Route::get('delete/{id}', [ProjectStatusController::class, 'delete'])->name('delete.project-status');
        });

        Route::prefix('project-type')->group(function () {
            Route::get('/', [ProjectTypeController::class, 'index'])->name('project-type');
            Route::get('create', [ProjectTypeController::class, 'create'])->name('create.project-type');
            Route::post('store', [ProjectTypeController::class, 'store'])->name('insert.project-type');
            Route::get('edit/{id}', [ProjectTypeController::class, 'edit'])->name('edit.project-type');
            Route::post('update', [ProjectTypeController::class, 'update'])->name('update.project-type');
            Route::get('delete/{id}', [ProjectTypeController::class, 'delete'])->name('delete.project-type');
        });

        Route::prefix('team-work')->group(function () {
            Route::get('/{project_type?}', [TeamWorkController::class, 'index'])->name('team-work');
            Route::get('/tasks/{task_id}', [TeamWorkController::class, 'task'])->name('team-work.tasks');
            Route::get('fetch-project/{id}', [TeamWorkController::class, 'fetchProject'])->name('fetch-project');
            Route::post('update-project-status', [TeamWorkController::class, 'updateProjectStatus'])->name('update-project-status');
            Route::post('store-project-files', [TeamWorkController::class, 'storeProjectFiles'])->name('store-project-files');
            Route::post('store-project-filesdrop', [TeamWorkController::class, 'storeProjectFilesDrop'])->name('store-project-filesdrop');
            Route::post('get-project-files', [TeamWorkController::class, 'getProjectFiles'])->name('get-project-files');
            Route::post('delete-project-file', [TeamWorkController::class, 'deleteProjectFile'])->name('delete-project-file');
            Route::post('delete-project-filesdrop', [TeamWorkController::class, 'deleteProjectFileDrop'])->name('delete-project-filesdrop');

            Route::get('get-project-comments/{id}', [TeamWorkController::class, 'getProjectComments'])->name('get-project-comments');
            Route::post('save-project-comment', [TeamWorkController::class, 'saveProjectComment'])->name('save-project-comment');
            Route::post('delete-project-comment', [TeamWorkController::class, 'deleteProjectComment'])->name('delete-project-comment');
            Route::post('upload-form', [TeamWorkController::class, 'storeCommentFile'])->name('form.submit');
            Route::get('remove-file/{file_name}', [TeamWorkController::class, 'deleteCommentFile'])->name('file.delete');

            //Get Project status based on project type
            Route::get('get-project-status/{id}', [ProjectStatusController::class, 'getProjectStatus'])->name('get-project-status');
            Route::post('sort-position', [ProjectStatusController::class, 'sortPosition'])->name('status.sort.position');
        });

        Route::prefix('interview')->group(function () {
            Route::get('/', [InterviewController::class, 'index'])->name('interview');
            Route::get('create', [InterviewController::class, 'create'])->name('create.interview');
            Route::post('store', [InterviewController::class, 'store'])->name('insert.interview');
            Route::post('/show-all-interview-list', [InterviewController::class, 'showAllInterviewList'])->name('show.interview.list');
            Route::get('edit/{id}', [InterviewController::class, 'edit'])->name('edit.interview');
            Route::post('update', [InterviewController::class, 'update'])->name('update.interview');
            Route::get('delete/{id}', [InterviewController::class, 'delete'])->name('delete.interview');
            Route::get('show/{id}/{email}', [InterviewController::class, 'show'])->name('show.interview');
            Route::post('interview-detail', [InterviewController::class, 'interviewDetail'])->name('detail.interview');
        });

        Route::prefix('loan')->group(function () {
            Route::get('/', [LoanController::class, 'index'])->name('loan');
            Route::get('/requests', [LoanController::class, 'indexPending'])->name('loan.pending');
            //    Route::post('/showAllLoans', [LoanController::class, 'showAllLoans'])->name('show.loan');
            Route::get('create', [LoanController::class, 'create'])->name('create.loan');
            Route::post('store', [LoanController::class, 'store'])->name('insert.loan');
            Route::get('edit/{id}', [LoanController::class, 'edit'])->name('edit.loan');
            Route::post('update', [LoanController::class, 'update'])->name('update.loan');
            Route::post('update-admin', [LoanController::class, 'updateByAdmin'])->name('admin.update.loan');
            Route::get('delete/{id}', [LoanController::class, 'delete'])->name('delete.loan');
            Route::get('loan-details/{id}', [LoanController::class, 'loanDetails'])->name('loan.details');
        });

//        Route::prefix('team-work-site')->group(function () {
//
//        });

    });
});

Route::post('check_in_out', [AttendanceController::class, 'checkInOut'])->name('check_in_out.attendance');

Route::middleware(['role_permission', 'auth'])->group(function (){

 });

Route::get('error', function () {
    return view('templates.error');
})->name('error');

//Route::get('modulo', [TestController::class, 'modulo']);
//Route::get('temp', [TestController::class, 'temp']);

Route::get('config-cache', function () {
    \Illuminate\Support\Facades\Artisan::call('config:cache');
    return "cache cleared";
});

Route::get('view-clear', function () {
    \Illuminate\Support\Facades\Artisan::call('view:clear');
    return "view cleared";
});

//Route::get('login_details',[TestController::class,'login_details']);
//Route::get('logout_details',[TestController::class,'logout_details']);
//Route::get('difference',[TestController::class,'difference']);
Route::get('test',[TestController::class,'test']);

Route::get('insert-data', function () {

    $start_month = Carbon\Carbon::now()->subMonth()->startOfMonth();
    for ($i = 1; $i <= 32; $i++){
        $data = [
            'user_id' => 6,
            'login_date_time' => $start_month->addHours(16)->format('Y/m/d h:i:s'),
            'logout_date_time' => $start_month->addHours(9)->addMinutes(15)->format('Y/m/d h:i:s'),
            'user_login_ip' => '127.0.0.1',
            'user_attendance_date' => $start_month->subDay()->subMinutes(15),
            'marked_as_late' => 0,
            'marked_as_early_out' => 0,
            'working_hours' => 33300,
            'overtime' => 900,
        ];

        if ($start_month->isSunday() || $start_month->isSaturday()){
            echo $i." - ";
        }else{
            $rec = \App\Models\UserLoginDetails::create($data);
            echo $rec->id;
            echo "</br>";
        }
        $start_month->addDay();
        $start_month->subHour();
    }
});

Route::get('test-email', [TestController::class, 'testMail']);

/*Route::get('test', function () {
   dd(\route('team-work.tasks', [21, 'c' => 1212]));
});*/


Route::get('service/{name?}', [MainController::class, 'showFrontEndView']);
Route::get('{name?}', [MainController::class, 'index']);
