<?php $__env->startSection('page-title','Edit Role'); ?>

<?php $__env->startPush('css'); ?>
    <style>
        .outer-ul li {
            list-style: none;
            font-weight: bolder;
            color: #797979;
        }
        .outer-ul > li {
            margin-bottom: 2px;
        }
        .outer-div {
            background-color: #e6e6e6;
            border-radius: 5px;
            padding: 20px 0px 0px 10px;
            margin-bottom: 10px;
            margin-right: 10px;
        }
    </style>
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>

    <div id="content" class="pmd-content admin section">
        <!-- Title -->
        <h1><?php echo $__env->yieldContent('page-title'); ?></h1>
        <!-- End Title -->
        <!--breadcrumb start-->
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb pmd-breadcrumb">
                <li class="breadcrumb-item">
                    <a href="<?php echo e(route('dashboard')); ?>">Dashboard</a>
                </li>
                <li class="breadcrumb-item">Roles</li>
                <li class="breadcrumb-item active" aria-current="page"><?php echo $__env->yieldContent('page-title'); ?></li>
            </ol>
        </nav>
        <!--breadcrumb end-->

        <div class="row">
            <div class="col-md-12">
                <div class="card pmd-card">
                    <form method="post" autocomplete="off" action="<?php echo e(route('update.role')); ?>" enctype="multipart/form-data">
                        <?php echo csrf_field(); ?>
                        <input type="hidden" name="id" value="<?php echo e(base64_encode($role->id)); ?>">
                        <div class="card-body">

                            <div class="details-tab">
                                <div class="row">
                                    <div class="col-sm-12">
                                        <div class="form-group pmd-textfield pmd-textfield-floating-label ">
                                            <label for="name" class="col-form-label control-label">Role Title</label>
                                            <input type="text" class="form-control" name="name"
                                                   aria-describedby="emailHelp" id="name" value="<?php echo e($role->name ?? old('name')); ?>" required>
                                            <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <span><strong class="text-danger"><?php echo e($message); ?></strong></span>
                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                        </div>
                                    </div>
                                </div>

                                <div class="row">
                                    <div class="col-sm-12">
                                        <div class="form-group pmd-textfield pmd-textfield-floating-label ">
                                            <label for="status" class="col-form-label control-label">Status</label>
                                            <select name="status" id="status" class="form-control" required>
                                                <option></option>
                                                <option value="1" <?php if($role->status == 1): ?> selected <?php endif; ?>>Active</option>
                                                <option value="0" <?php if($role->status == 0): ?> selected <?php endif; ?>>Inactive</option>
                                            </select>
                                            <?php $__errorArgs = ['status'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <span><strong class="text-danger"><?php echo e($message); ?></strong></span>
                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                        </div>
                                    </div>
                                </div>

                                <?php $permissions = json_decode($role->permissions) ?>
                                <div class="row">
                                    <div><input type="checkbox" class="mr-1 check-all-boxes" <?php if(count($permissions) == count($allowed_permissions)): ?> checked <?php endif; ?>>Check All</div>
                                    <div class="col-sm-12">
                                        <div class="form-group pmd-textfield pmd-textfield-floating-label ">
                                            <div class="row">
                                                <?php $__errorArgs = ['permissions'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                <div class="col-sm-12">
                                                    <span><strong class="text-danger">Please define permissions for role.</strong></span>
                                                </div>
                                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

                                                <?php $__currentLoopData = $groupRoutes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $route): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <div class="col-md-3 outer-div" style="flex: 0 0 25%; max-width: 23%">
                                                        <ul class="outer-ul">
                                                            <li style="margin: 0px -20px 0 -45px; padding: 10px">
                                                                <input type="checkbox" class="check-permission mr-1 check-all" id="check-all-child-boxes" <?php $__currentLoopData = $route; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?> <?php if(in_array($val,$permissions)): ?> checked <?php endif; ?> <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>><?php echo e(ucfirst($key)); ?>

                                                                <ul>
                                                                    <?php $__currentLoopData = $route; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                        <?php if(!in_array($value,$allowed_permissions)): ?> <?php continue; ?> <?php endif; ?>
                                                                        <li><input type="checkbox" name="permissions[]" value="<?php echo e($value); ?>" class="check-permission mr-1" <?php if(in_array($value,$permissions)): ?> checked <?php endif; ?>><?php echo e($value); ?></li>
                                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                                </ul>
                                                            </li>
                                                        </ul>
                                                    </div>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="card-footer pmd-card-border">
                            <button class="btn pmd-ripple-effect btn-primary pmd-btn-raised" type="submit">Update</button>
                            <button class="btn pmd-ripple-effect btn-outline-secondary" type="reset">Reset</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('js'); ?>
    <script>

        // Check and Uncheck all
        $(document).ready(function () {
            $(".check-all-boxes").change(function(){
                var checked = $(this).is(':checked'); // Checkbox state
                // Check all
                if(checked){
                    $('#check-all-child-boxes').each(function() {
                        var child_checked = $(this).prop('checked',true);
                        if(child_checked){
                            $('.check-permission').each(function () {
                                $(this).prop('checked',true);
                            });
                        }
                    });
                }else{
                    // Uncheck All
                    $('#check-all-child-boxes').each(function() {
                        var child_checked = $(this).prop('checked',false);
                        if(child_checked){
                            $('.check-permission').each(function () {
                                $(this).prop('checked',false);
                            });
                        }
                    });
                }
            });

            /*$(".check-all").change(function () {
                // alert('working');
               if($(this).prop('checked',true)){
                    // $(this).parents('li').find('.check-permission').prop('checked',true);
                    $(this).find('ul li').each(function () {
                        $(this).prop('checked',false);
                    });
                }else{
                    $(this).parents('li').find('.check-permission').prop('checked',false);
                }
            });
*/
        });

        $(document).on('click','#check-all-child-boxes',function(){

            if($(this).prop('checked')){
                $(this).parents('li').find('.check-permission').prop('checked',true);
            }else{
                $(this).parents('li').find('.check-permission').prop('checked',false);
            }
        });


        $(document).on('click','.check-permission',function(){

            if($(this).prop('checked')){

                var count = 0
                $(this).parents('ul:eq(0)').find('.check-permission').each(function(){
                    if($(this).prop('checked')){
                        count++;
                    }
                })

                if(count){
                    $(this).parents('ul:eq(0)').find('.check-permission:eq(0)').prop('checked',true)
                    // $(this).parents('ul:eq(0)').find('.check-permission:eq(0)').prop('disabled',true)
                }else{
                    $(this).parents('ul:eq(0)').find('.check-permission:eq(0)').prop('checked',false)
                    // $(this).parents('ul:eq(0)').find('.check-permission:eq(0)').prop('disabled',false)
                }

            }else{

                var count = 0
                $(this).parents('ul:eq(0)').find('.check-permission').each(function(){
                    if($(this).prop('checked')){
                        count++;
                    }
                })

                if(count > 1){
                    $(this).parents('ul:eq(0)').find('.check-permission:eq(0)').prop('checked',true)
                    // $(this).parents('ul:eq(0)').find('.check-permission:eq(0)').prop('disabled',true)

                }else{
                    $(this).parents('ul:eq(0)').find('.check-permission:eq(0)').prop('checked',false)
                    // $(this).parents('ul:eq(0)').find('.check-permission:eq(0)').prop('disabled',false)
                }
            }
        });
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\projects\xampp-7.4\htdocs\laravel\teamwork\resources\views/roles/edit.blade.php ENDPATH**/ ?>